#!/usr/bin/env python

"""
Copyright 2000-2022 Citrix Systems, Inc. All rights reserved.
This software and documentation contain valuable trade
secrets and proprietary property belonging to Citrix Systems, Inc.
None of this software and documentation may be copied,
duplicated or disclosed without the express
written permission of Citrix Systems, Inc.
"""

from glob import glob
from os.path import basename
from os.path import splitext
from os import environ

from setuptools import find_packages
from setuptools import setup

environ["COPYFILE_DISABLE"] = "true"
environ["DISTUTILS_DEBUG"] = "true"


setup(
    # Application name:
    name="AzureAutoConfig",

    version="1.3",

    author="Citrix Systems Inc",
    author_email="support@citrix.com",

    packages=find_packages('src'),
    package_dir={'': 'src'},
    py_modules=[splitext(basename(path))[0] for path in glob('src/*.py')],
    include_package_data=True,

    # Details
    url="http://www.citrix.com",

    # license="LICENSE.txt",
    description="AzureAutoConfig: Auto config Citrix ADC when deployed using solution template in Azure",

    entry_points={
        'console_scripts': [
            'azureautocfg = azureautocfg:main'
        ]
    },
    # Dependent packages (distributions)
    install_requires=[
    ],
)
