import os
import util
import sys
from logger import logger

LICENSE_DIR = "/nsconfig"
path_svm = "/mpsconfig"
# Checking for svm
if os.path.exists(path_svm):
    LICENSE_DIR = path_svm 
    
INTERNAL_FILENAME = LICENSE_DIR + "/.internal"

def is_internal_ns_from_license():
    # '.internal' file creates at the time of pooled license configuration
    # Checking if '.internal' file exists to find internal    
    try:
        if os.path.exists(INTERNAL_FILENAME):
            # Checking '.internal' file exists to detect internal system from pooled license
            return 1
        else :
            logger.debug('Checking for local license') 
            _, is_internal_ns = util.get_local_license_sno_notice()
            #checking internal system through local license
            if is_internal_ns == False:
                return 0
            elif is_internal_ns == True:
                logger.debug('Internal local license')
                return 1
            else :
                logger.error('License file error')
                return 2
        
    except Exception as e:
        logger.debug(e);
        return 2
        
def force_enable_autoconnect_for_internal():
    is_internal = is_internal_ns_from_license()
    if is_internal==0:
        sys.exit(0)
    elif is_internal==1:
        logger.info("Internal system")
        sys.exit(1)
    else:
        sys.exit(2)
        
        
if __name__ == "__main__":
    force_enable_autoconnect_for_internal()
    
