#!/usr/bin/env python

# Copyright 2004-2025 Citrix Systems, Inc. All rights reserved.
# This software and documentation contain valuable trade
# secrets and proprietary property belonging to Citrix Systems, Inc.
# None o1f this software and documentation may be copied,
# duplicated or disclosed without the express
# written permission of Citrix Systems, Inc.

class Error(Exception):
    """Base class for other exceptions"""
    pass

# Request Exceptions
class RequestError(Error):
    def __init__(self, message):
        self.message = message

    def __str__(self):
        return self.message

class RequestHttpError(Error):
    def __init__(self, message, code):
        self.message = message
        self.status_code = code

    def __str__(self):
        return self.message

class RequestCommunicationError(Error):
    def __init__(self, message):
        self.message = message

# Probe Exceptions
class ProbeError(Error):
    def __init__(self, message):
        self.message = message

    def __str__(self):
        return self.message

class ProbeCommunicationError(ProbeError):
    def __init__(self, message):
        ProbeError.__init__(self, message)

class ProbeRequestError(ProbeError):
    def __init__(self, message):
        ProbeError.__init__(self, message)

class ProbeResponseError(ProbeError):
    def __init__(self, message):
        ProbeError.__init__(self, message)
