import json
import traceback
import xmltodict
try:
    import ConfigParser
except ImportError:
    import configparser as ConfigParser
import time
import subprocess
import shlex
import util
import sys
import platform
import httplib2
import constant as cons
from logger import logger
import os, base64
import requests
import copy
import re
import string
import random

sys.path.append('/var/mastools/scripts/')

MANAGED_DEVICE_URI_FILTER_BY_PROFILE_NAME = '/nitro/v1/config/managed_device?filter=profile_name:'
MANAGED_DEVICE_URI_FILTER_BY_TRUST_ID = '/nitro/v1/config/managed_device?filter=trust_id:'
MANAGED_DEVICE_URI_FILTER_BY_IP_ADDRESS = '/nitro/v1/config/managed_device?filter=ip_address:'
MANAGED_DEVICE_URI = '/nitro/v1/config/managed_device/'
ACTIVITY_STATUS_URI = '/nitro/v1/config/activity_status/'
DEVICE_PROFILE_URI_FILTER_BY_NAME = '/nitro/v1/config/ns_device_profile?filter=name:'
DEVICE_PROFILE_URI = '/nitro/v1/config/device_profile/'
AGENT_CONFIG_FILE = '/var/mastools/conf/agent.conf'
AGENT_CONF_DICT = {}
MASTOOLS_CWS_SERVICE_NAME = 'netappliance'
auth_request_header = 'CWSAuth service='
CERT_BUNDLE_PATH='/var/mastools/cert/cacert.pem'
LEGATUS_AGENT_REQ_COOKIE = 'legatus_agent_request'
MGMT_TENANT_COOKIE = '_MGMT_TENANT'

def is_python_3_running():
    if platform.python_version().startswith('3.'):
        return True
    return False


is_python_3 = is_python_3_running()

if is_python_3:
    from urllib.parse import quote_plus
    from urllib.parse import quote
else:
    from urllib import quote_plus
    from urllib import quote

def set_internal_ns_registration_state(registration_status):
    state = ConfigParser.RawConfigParser()
    state.read(util.get_autoreg_state_file())
    state.set(cons.ADM_AUTOREG_SECTION, cons.ADM_NS_INTERNAL_REGISTRATION_FLAG, registration_status)
    with open(util.get_autoreg_state_file(), 'w') as configfile:
        state.write(configfile)

def set_internal_ns_ip(nsip):
    state = ConfigParser.RawConfigParser()
    state.read(util.get_autoreg_state_file())
    state.set(cons.ADM_AUTOREG_SECTION, cons.ADM_NS_INTERNAL_REGISTRATION_NSIP, nsip)
    with open(util.get_autoreg_state_file(), 'w') as configfile:
        state.write(configfile)

def set_internal_deployment_type(deployment_type):
    state = ConfigParser.RawConfigParser()
    state.read(util.get_autoreg_state_file())
    state.set(cons.ADM_AUTOREG_SECTION, cons.DEPLOYMENT_TYPE, deployment_type)
    with open(util.get_autoreg_state_file(), 'w') as configfile:
        state.write(configfile)

def set_clip(clip):
    state = ConfigParser.RawConfigParser()
    state.read(util.get_autoreg_state_file())
    state.set(cons.ADM_AUTOREG_SECTION, cons.CLIP, clip)
    with open(util.get_autoreg_state_file(), 'w') as configfile:
        state.write(configfile)

def set_internal_ns(is_internal):
    if is_internal is None:
        is_internal = False
    state = ConfigParser.RawConfigParser()
    state.read(util.get_autoreg_state_file())
    state.set(cons.ADM_AUTOREG_SECTION, cons.ADM_IS_NS_INTERNAL, is_internal)
    with open(util.get_autoreg_state_file(), 'w') as configfile:
        state.write(configfile)

def set_internal_ns_registration_start_time(value=None):
    state = ConfigParser.RawConfigParser()
    state.read(util.get_autoreg_state_file())
    if value:
        state.set(cons.ADM_AUTOREG_SECTION, cons.ADM_NS_INTERNAL_REGISTRATION_START_TIME, value)
    else:
        state.set(cons.ADM_AUTOREG_SECTION, cons.ADM_NS_INTERNAL_REGISTRATION_START_TIME, str(time.time()))
    with open(util.get_autoreg_state_file(), 'w') as configfile:
        state.write(configfile)

def get_internal_ns_registration_state():
    state = ConfigParser.RawConfigParser()
    state.read(util.get_autoreg_state_file())
    return state.get(cons.ADM_AUTOREG_SECTION, cons.ADM_NS_INTERNAL_REGISTRATION_FLAG)

def get_internal_nsip():
    state = ConfigParser.RawConfigParser()
    state.read(util.get_autoreg_state_file())
    return state.get(cons.ADM_AUTOREG_SECTION, cons.ADM_NS_INTERNAL_REGISTRATION_NSIP)

def get_internal_deployment_type():
    state = ConfigParser.RawConfigParser()
    state.read(util.get_autoreg_state_file())
    return state.get(cons.ADM_AUTOREG_SECTION, cons.DEPLOYMENT_TYPE)

def get_internal_ns_registration_start_time():
    state = ConfigParser.RawConfigParser()
    state.read(util.get_autoreg_state_file())
    return state.get(cons.ADM_AUTOREG_SECTION, cons.ADM_NS_INTERNAL_REGISTRATION_START_TIME)

def get_test_lodestone_state():
    state = ConfigParser.RawConfigParser()
    state.read(util.get_autoreg_state_file())
    return state.getboolean(cons.ADM_AUTOREG_SECTION, cons.TEST_LODESTONE)

def get_update_nsip_deployment_type():
    state = ConfigParser.RawConfigParser()
    state.read(util.get_autoreg_state_file())
    return state.getboolean(cons.ADM_AUTOREG_SECTION, cons.UPDATE_NSIP_DEPLOYMENT_TYPE)

def get_clip_from_config_file():
    state = ConfigParser.RawConfigParser()
    state.read(util.get_autoreg_state_file())
    return state.get(cons.ADM_AUTOREG_SECTION, cons.CLIP)

def get_is_internal():
    try:
        state = ConfigParser.RawConfigParser()
        state.read(util.get_autoreg_state_file())
        return state.getboolean(cons.ADM_AUTOREG_SECTION, cons.ADM_IS_NS_INTERNAL)
    except Exception:
        return False

def get_clean_up():
    try:
        state = ConfigParser.RawConfigParser()
        state.read(util.get_autoreg_state_file())
        return state.getboolean(cons.ADM_AUTOREG_SECTION, cons.CLEAN_UP)
    except Exception:
        logger.error("Failed to get clean up parameter from config file.")
        return False

def set_clean_up_to_false():
    try:
        state = ConfigParser.RawConfigParser()
        state.read(util.get_autoreg_state_file())
        state.set(cons.ADM_AUTOREG_SECTION, cons.CLEAN_UP, False)
        with open(util.get_autoreg_state_file(), 'w') as configfile:
            state.write(configfile)
    except Exception as e:
        logger.error("Failed to set clean up parameter to False in config file with error: {}".format(repr(e)))
        pass

def set_update_nsip_deployment_type_to_false():
    try:
        state = ConfigParser.RawConfigParser()
        state.read(util.get_autoreg_state_file())
        state.set(cons.ADM_AUTOREG_SECTION, cons.UPDATE_NSIP_DEPLOYMENT_TYPE, False)
        with open(util.get_autoreg_state_file(), 'w') as configfile:
            state.write(configfile)
    except Exception as e:
        logger.error("Failed to set update nsip deployment type parameter to False in config file with error: {}".format(repr(e)))
        pass

def get_is_zero_touch_registration_allowed():
    try:
        state = ConfigParser.RawConfigParser()
        state.read(util.get_autoreg_state_file())
        return state.getboolean(cons.ADM_AUTOREG_SECTION, cons.IS_ZERO_TOUCH_REGISTRATION_ALLOWED)
    except Exception:
        logger.error("Failed to get is_zero_touch_registration_allowed parameter from config file.")
        return False

def set_is_zero_touch_registration_allowed_to_true():
    try:
        state = ConfigParser.RawConfigParser()
        state.read(util.get_autoreg_state_file())
        state.set(cons.ADM_AUTOREG_SECTION, cons.IS_ZERO_TOUCH_REGISTRATION_ALLOWED, True)
        with open(util.get_autoreg_state_file(), 'w') as configfile:
            state.write(configfile)
    except Exception as e:
        logger.error("Failed to set is_zero_touch_registration_allowed parameter to True in config file with error: {}".format(repr(e)))
        pass

def set_is_zero_touch_registration_allowed_to_false():
    try:
        state = ConfigParser.RawConfigParser()
        state.read(util.get_autoreg_state_file())
        state.set(cons.ADM_AUTOREG_SECTION, cons.IS_ZERO_TOUCH_REGISTRATION_ALLOWED, False)
        with open(util.get_autoreg_state_file(), 'w') as configfile:
            state.write(configfile)
    except Exception as e:
        logger.error("Failed to set is_zero_touch_registration_allowed parameter to False in config file with error: {}".format(repr(e)))
        pass

def get_adm_ns_unique_id():
    try:
        state = ConfigParser.RawConfigParser()
        state.read(util.get_autoreg_state_file())
        value = state.get(cons.ADM_AUTOREG_SECTION, cons.ADM_NS_UNIQUE_ID)
        if value == 'None':
            return None
        return value
    except Exception as e:
        logger.error("Failed to get ns_unique_id from config file with error: {}".format(repr(e)))
        return None

def set_adm_ns_unique_id(adm_ns_unique_id):
    try:
        state = ConfigParser.RawConfigParser()
        state.read(util.get_autoreg_state_file())
        state.set(cons.ADM_AUTOREG_SECTION, cons.ADM_NS_UNIQUE_ID, adm_ns_unique_id)
        with open(util.get_autoreg_state_file(), 'w') as configfile:
            state.write(configfile)
    except Exception as e:
        logger.error("Failed to set ns_unique_id parameter in config file with error: {}".format(repr(e)))
        pass

def get_random_password_string(length=16):
    lowercase = string.ascii_lowercase
    uppercase = string.ascii_uppercase
    digits = string.digits
    special_characters = "@#$&"
    password = [
        random.choice(lowercase),
        random.choice(uppercase),
        random.choice(digits),
        random.choice(special_characters)
    ]
    all_characters = lowercase + uppercase + digits + special_characters
    while len(password) < length:
        password.append(random.choice(all_characters))
    random.shuffle(password)
    return ''.join(password)

def get_user_credentials():
    username = cons.CLOUD_CONNECT_USER
    password = get_random_password_string()
    return username, password

def remove_cloud_connect_user_if_exists(cloud_user=None):
    if not cloud_user:
        cloud_user = cons.CLOUD_CONNECT_USER
    logger.info("Removing user {} for cleanup..".format(cloud_user))
    try:
        rm_user_cmd = "rm system user " + cloud_user
        is_cluster, _ = is_cluster_cco()
        logger.debug("remove_cloud_connect_user_if_exists is_cluster:{}".format(is_cluster))
        if is_cluster:
            clip = get_clip()
            cmd = "nsremotexec " + clip + " -exec " + ' "' + rm_user_cmd + '"'
        else:
            cmd = cons.NSCLI_CMD + ' "' + rm_user_cmd + '"'
        logger.debug("remove_cloud_connect_user_if_exists cmd:{}".format(cmd))
        try:
            cliNitroOutput = subprocess.check_output(shlex.split(cmd), stderr=subprocess.STDOUT)
            if is_python_3:
                cliNitroOutput = cliNitroOutput.decode("utf-8")
        except subprocess.CalledProcessError as e:
            cliNitroOutput = e.output
            if is_python_3:
                cliNitroOutput = cliNitroOutput.decode("utf-8")
        logger.debug("cliNitroOutput response:{}".format(cliNitroOutput))
        nitroJson = util.get_nitroresp_from_clicmdnitro_op(cliNitroOutput)
        logger.debug("nitroJson response:{}".format(nitroJson))
    except Exception:
        logger.error("Removing cloud connect user failed, resource does not exist")
        logger.error(traceback.format_exc())

def add_cloud_connect_user():
    username, random_password = get_user_credentials()
    logger.info("Creating new user {} with superuser privileges...".format(username))
    remove_cloud_connect_user_if_exists()
    add_user_cmd = "add system user " + username + " '" + random_password + "'"
    is_cluster, _ = is_cluster_cco()
    if is_cluster:
        clip = get_clip()
        cmd = "nsremotexec " + clip + " -exec " +  ' "' + add_user_cmd + '"'
    else:
        cmd = cons.NSCLI_CMD + ' "' + add_user_cmd + '"'
    try:
        cliNitroOutput = subprocess.check_output(shlex.split(cmd), stderr=subprocess.STDOUT)
        if is_python_3:
            cliNitroOutput = cliNitroOutput.decode("utf-8")
    except subprocess.CalledProcessError as e:
        cliNitroOutput = e.output
        if is_python_3:
            cliNitroOutput = cliNitroOutput.decode("utf-8")
    if "error" in cliNitroOutput.lower():
        raise Exception("Failed to add system user admuser with error: {}".format(cliNitroOutput))

    bind_user_cmd = "bind systemuser " + username + " superuser 0"
    if is_cluster:
        clip = get_clip()
        cmd = "nsremotexec " + clip + " -exec " +  ' "' + bind_user_cmd + '"'
    else:
        cmd = cons.NSCLI_CMD + ' "' + bind_user_cmd + '"'
    try:
        cliNitroOutput = subprocess.check_output(shlex.split(cmd), stderr=subprocess.STDOUT)
        if is_python_3:
            cliNitroOutput = cliNitroOutput.decode("utf-8")
    except subprocess.CalledProcessError as e:
        cliNitroOutput = e.output
        if is_python_3:
            cliNitroOutput = cliNitroOutput.decode("utf-8")
    if "error" in cliNitroOutput.lower():
        raise Exception("Failed to bind privileges to system user admuser with error: {}".format(cliNitroOutput))
    logger.info("Created new user {} with superuser privileges.".format(username))

    is_cluster, _ = is_cluster_cco()
    save_config_cmd = "save config"
    if is_cluster:
        clip = get_clip()
        cmd = "nsremotexec " + clip + " -exec " + ' "' + save_config_cmd + '"'
    else:
        cmd = cons.NSCLI_CMD + ' "' + save_config_cmd + '"'
    cliNitroOutput = ""
    try:
        cliNitroOutput = subprocess.check_output(shlex.split(cmd), stderr=subprocess.STDOUT)
        if is_python_3:
            cliNitroOutput = cliNitroOutput.decode("utf-8")
    except subprocess.CalledProcessError as e:
        cliNitroOutput = e.output
        if is_python_3:
            cliNitroOutput = cliNitroOutput.decode("utf-8")
    except Exception as e:
        logger.error("Failed to save config with error: {}".format(repr(e)))
    if "error" in cliNitroOutput.lower():
        logger.error("Failed to save config with error: {}".format(cliNitroOutput))
    return username, random_password

def check_and_add_nameserver_in_resolv_conf():
    """
    Checks if a nameserver IP address is present in the file, and if not, adds it as the last entry.
    """
    file_path = cons.RESOLV_CONF_FILE
    nameserver = cons.INTERNAL_AUTOREG_NAMESERVER
    try:
        # Read the file to check if the nameserver is already present
        with open(file_path, 'r') as file:
            lines = file.readlines()
        is_nameserver_already_present = False
        for line in lines:
            split_line = re.split(r'[ \t\n]+', line)
            if len(split_line) > 1 and split_line[0] == 'nameserver' and split_line[1] == nameserver:
                logger.info("The nameserver {} is already present in the {}.".format(nameserver, file_path))
                is_nameserver_already_present = True
                break
        # Check if the nameserver is present
        if not is_nameserver_already_present:
            # Add the nameserver as the last entry
            with open(file_path, 'a') as file:
                file.write("nameserver {}\n".format(nameserver))
            logger.info("The nameserver {} has been added to the file {}.".format(nameserver, file_path))

    except FileNotFoundError:
        logger.error("Error: The file {} does not exist.".format(file_path))
    except Exception as e:
        logger.error("util_internal_reg: check_and_add_nameserver: An error occurred: {}".format(repr(e)))

def add_nameserver():
    try:
        if os.path.exists("/nsconfig/.nameserverexception"):
            raise Exception("Adding nameserver 8.8.8.8 skipped.")
        add_nameserver = False
        sh_nameserver_cmd = "sh nameserver"
        is_cluster, _ = is_cluster_cco()
        if is_cluster:
            clip = get_clip()
            cmd = "nsremotexec " + clip + " -exec " + ' "' + sh_nameserver_cmd + '"'
        else:
            cmd = cons.NSCLI_CMD + ' "' + sh_nameserver_cmd + '"'
        cliNitroOutput = subprocess.check_output(shlex.split(cmd), stderr=subprocess.STDOUT)
        if is_python_3:
            cliNitroOutput = cliNitroOutput.decode("utf-8")
        if not ("8.8.8.8" in cliNitroOutput):
            add_nameserver = True
            logger.info("Nameserver 8.8.8.8 does not exists adding it...")
        else:
            logger.info("Nameserver 8.8.8.8 already exists.")

        if add_nameserver:
            add_nameserver_cmd = "add nameserver 8.8.8.8"
            is_cluster, _ = is_cluster_cco()
            if is_cluster:
                clip = get_clip()
                cmd = "nsremotexec " + clip + " -exec " + ' "' + add_nameserver_cmd + '"'
            else:
                cmd = cons.NSCLI_CMD + ' "' + add_nameserver_cmd + '"'
            try:
                cliNitroOutput = subprocess.check_output(shlex.split(cmd), stderr=subprocess.STDOUT)
                if is_python_3:
                    cliNitroOutput = cliNitroOutput.decode("utf-8")
            except subprocess.CalledProcessError as e:
                cliNitroOutput = e.output
                if is_python_3:
                    cliNitroOutput = cliNitroOutput.decode("utf-8")
            if "error" in cliNitroOutput.lower():
                raise Exception("Failed to add nameserver 8.8.8.8 with error: {}".format(cliNitroOutput))
            logger.info("Added nameserver 8.8.8.8.")
    except Exception as e:
        logger.error("Adding nameserver 8.8.8.8 if not exists failed with error: {}".format(repr(e)))
        logger.error(traceback.format_exc())
    try:
        if not os.path.exists("/nsconfig/.nameserverexception"):
            check_and_add_nameserver_in_resolv_conf()
    except Exception as e:
        logger.error("Adding nameserver 8.8.8.8 to reslov.conf failed with error: {}".format(repr(e)))
        logger.error(traceback.format_exc())

def rm_snmp_mgr(ip_address):
    try:
        is_cluster, is_cco = is_cluster_cco()
        is_ha, is_primary = is_ha_vpx_primary()
        if is_cluster and is_cco:
            clip_and_member_node_ips_list = get_clip_and_member_node_ips(get_active_nodes=False)
            for ip_address in clip_and_member_node_ips_list:
                rm_snmp_manager(ip_address)
        elif is_ha and is_primary:
            primary_mgmt_ip = ip_address
            _, secondary_mgmt_ip = get_ha_info()
            rm_snmp_manager(primary_mgmt_ip)
            rm_snmp_manager(secondary_mgmt_ip)
        elif not (is_cluster or is_ha):
            mgmt_ip = ip_address
            rm_snmp_manager(mgmt_ip)
    except Exception as e:
        logger.error("util_internal_reg: remove_snmp_mgr: Failed to remove snmp manager with error: {}".format(repr(e)))

def rm_snmp_manager(ip_address):
    try:
        sh_snmp_manager_cmd = "sh snmp manager"
        is_cluster, _ = is_cluster_cco()
        if is_cluster:
            clip = get_clip()
            cmd = "nsremotexec " + clip + " -exec " + ' "' + sh_snmp_manager_cmd + '"'
        else:
            cmd = cons.NSCLI_CMD + ' "' + sh_snmp_manager_cmd + '"'
        cliNitroOutput = subprocess.check_output(shlex.split(cmd), stderr=subprocess.STDOUT)
        if is_python_3:
            cliNitroOutput = cliNitroOutput.decode("utf-8")
        if (ip_address in cliNitroOutput and "IPv4 Address".lower() in cliNitroOutput.lower()):
            rm_snmp_manager_cmd = "rm snmp manager {}".format(ip_address)
            is_cluster, _ = is_cluster_cco()
            if is_cluster:
                clip = get_clip()
                cmd = "nsremotexec " + clip + " -exec " + ' "' + rm_snmp_manager_cmd + '"'
            else:
                cmd = cons.NSCLI_CMD + ' "' + rm_snmp_manager_cmd + '"'
            try:
                cliNitroOutput = subprocess.check_output(shlex.split(cmd), stderr=subprocess.STDOUT)
                if is_python_3:
                    cliNitroOutput = cliNitroOutput.decode("utf-8")
            except subprocess.CalledProcessError as e:
                cliNitroOutput = e.output
                if is_python_3:
                    cliNitroOutput = cliNitroOutput.decode("utf-8")
            if "error" in cliNitroOutput.lower():
                raise Exception("Failed to remove snmp manager with error: {}".format(cliNitroOutput))
            logger.info("Removed snmp manager {}.".format(ip_address))
    except Exception as e:
        logger.error("Removing snmp manager {} if not exists failed with error: {}".format(ip_address, repr(e)))
        logger.error(traceback.format_exc())

def add_snmp_manager(ip_address):
    try:
        add_snmp_manager = False
        sh_snmp_manager_cmd = "sh snmp manager"
        is_cluster, _ = is_cluster_cco()
        if is_cluster:
            clip = get_clip()
            cmd = "nsremotexec " + clip + " -exec " + ' "' + sh_snmp_manager_cmd + '"'
        else:
            cmd = cons.NSCLI_CMD + ' "' + sh_snmp_manager_cmd + '"'
        cliNitroOutput = subprocess.check_output(shlex.split(cmd), stderr=subprocess.STDOUT)
        if is_python_3:
            cliNitroOutput = cliNitroOutput.decode("utf-8")
        if not (ip_address in cliNitroOutput and "IPv4 Address".lower() in cliNitroOutput.lower()):
            add_snmp_manager = True
            logger.info("Snmp manager {} does not exists adding it...".format(ip_address))
        else:
            logger.info("Snmp manager {} already exists.".format(ip_address))

        if add_snmp_manager:
            add_snmp_manager_cmd = "add snmp manager {}".format(ip_address)
            is_cluster, _ = is_cluster_cco()
            if is_cluster:
                clip = get_clip()
                cmd = "nsremotexec " + clip + " -exec " + ' "' + add_snmp_manager_cmd + '"'
            else:
                cmd = cons.NSCLI_CMD + ' "' + add_snmp_manager_cmd + '"'
            try:
                cliNitroOutput = subprocess.check_output(shlex.split(cmd), stderr=subprocess.STDOUT)
                if is_python_3:
                    cliNitroOutput = cliNitroOutput.decode("utf-8")
            except subprocess.CalledProcessError as e:
                cliNitroOutput = e.output
                if is_python_3:
                    cliNitroOutput = cliNitroOutput.decode("utf-8")
            if "error" in cliNitroOutput.lower():
                raise Exception("Failed to add snmp manager with error: {}".format(cliNitroOutput))
            logger.info("Added snmp manager {}.".format(ip_address))
    except Exception as e:
        logger.error("Adding snmp manager {} if not exists failed with error: {}".format(ip_address, repr(e)))
        logger.error(traceback.format_exc())

def fetch_type_of_deployment():
    try:
        deployment_type = 0
        if "linux" in sys.platform.lower():
            deployment_type = int(os.environ.get("VPX_ON_CLOUD", 0))
        else:
            cmd = cons.SYSCTL_CMD + ' ' + cons.NS_CLOUD
            sysctlOutput = subprocess.check_output(shlex.split(cmd))
            if is_python_3:
                sysctlOutput = sysctlOutput.decode("utf-8")
            deployment_type = int(sysctlOutput.strip())
        # If deployment is Openstack(2), considering it as an On-prem(0) deployment
        if deployment_type == 2:
            deployment_type = 0
        return deployment_type
    except Exception:
        logger.error("Failed to fetch deployment type for internal netscaler.")
        logger.error(traceback.format_exc())
        return -1

def is_ha_vpx_primary():
    is_ha = False
    is_primary = False
    cmd_str = "show ns config | grep 'Node:' "
    node_ha_state = util.cli_exec(cmd_str)
    ha_state = node_ha_state.split(cons.VPX_HA_STATE_PREFIX)[1]
    if ha_state.strip().startswith(cons.VPX_HA_STATE_PRIMARY):
        is_ha = True
        is_primary = True
    elif ha_state.strip().startswith(cons.VPX_HA_STATE_SECONDARY):
        is_ha = True
        is_primary = False
    logger.debug("is_ha:{}, is_primary:{}".format(is_ha, is_primary))
    return is_ha, is_primary

def is_cluster_cco():
    is_cco = False
    is_cluster = False
    try:
        # Check for cluster deployment
        nitroJson = util.clinitro_exec(cons.SHOW_CLUSTER_NODE)
        if nitroJson != None and 'clusternode' in nitroJson:
            is_cluster = True
            clusternodes = nitroJson['clusternode']
            for node in clusternodes:
                if node['islocalnode'] == True:
                    if node['isconfigurationcoordinator'] == True:
                        is_cco = True
        else:
            logger.debug("Device is not a cluster")
    except Exception as e:
        logger.error("In get_all_cluster_nodes, exception:" + repr(e))
    logger.debug("is_cluster:{}, is_cco:{}".format(is_cluster, is_cco))
    return is_cluster, is_cco

def copy_admautoreg_config_file_to_tmp_location():
    try:
        file_copy_cmd = "cp /nsconfig/admautoreg.state /var/tmp/"
        _ = subprocess.check_output(shlex.split(file_copy_cmd), stderr=subprocess.STDOUT)
        logger.info("Copied /nsconfig/admautoreg.state to /var/tmp/.")
    except Exception as e:
        logger.error("Failed to copy /nsconfig/admautoreg.state to /var/tmp/, with error: {}".format(repr(e)))

def set_ns_unique_id_to_none_in_tmp_admautoreg_state_file():
    try:
        state = ConfigParser.RawConfigParser()
        state.read("/var/tmp/admautoreg.state")
        state.set(cons.ADM_AUTOREG_SECTION, cons.ADM_NS_UNIQUE_ID, None)
        with open("/var/tmp/admautoreg.state", 'w') as configfile:
            state.write(configfile)
        logger.info("Set ns_unique_id to None in /var/tmp/admautoreg.state")
    except Exception as e:
        logger.error("Failed to set ns_unique_id to None in /var/tmp/admautoreg.state, with error: {}".format(repr(e)))

def remove_config_file_at_tmp_location():
    try:
        cmd = "rm -rf /var/tmp/admautoreg.state"
        _ = subprocess.check_output(shlex.split(cmd), stderr=subprocess.STDOUT)
        logger.info("Removed /var/tmp/admautoreg.state if present.")
    except Exception as e:
        logger.error("Failed to remove /var/tmp/admautoreg.state if present, with error: {}".format(repr(e)))

def sync_admautreg_config_file_for_ha_cluster(username, password):
    is_cluster, is_cco = is_cluster_cco()
    is_ha, is_primary = is_ha_vpx_primary()
    if is_ha and is_primary:
        copy_admautoreg_config_file_to_tmp_location()
        set_ns_unique_id_to_none_in_tmp_admautoreg_state_file()
        logger.info("It is HA primary, syncing with secondary...")
        import mastools_ha
        try:
            mastools_ha.mastools_sync_admautoreg_config(logger, username, password)
            logger.info("Syncing with HA secondary completed.")
        except Exception as e:
            logger.error("Syncing with HA secondary failed with error: {}".format(repr(e)))
        remove_config_file_at_tmp_location()
    elif is_cluster and is_cco:
        logger.info("It is cluster cco, syncing with non-cco nodes...")
        copy_admautoreg_config_file_to_tmp_location()
        set_ns_unique_id_to_none_in_tmp_admautoreg_state_file()
        import mastools_cluster
        try:
            mastools_cluster.mastools_sync_admautoreg_config(logger, username, password)
            logger.info("Syncing with non cco nodes is completed.")
        except Exception as e:
            logger.error("Syncing with non cco nodes failed with error: {}".format(repr(e)))
        remove_config_file_at_tmp_location()
    else:
        logger.info("NetScaler is standalone, sync of admautoreg config file is not required.")

def check_if_admcloudconnectuser_present():
    show_user_cmd = "sh system user " + cons.CLOUD_CONNECT_USER
    cmd = cons.NSCLI_CMD + ' "' + show_user_cmd + '"'
    try:
        cliNitroOutput = subprocess.check_output(shlex.split(cmd), stderr=subprocess.STDOUT)
        if is_python_3:
            cliNitroOutput = cliNitroOutput.decode("utf-8")
        if "Done" in cliNitroOutput:
            return True
    except Exception:
        return False
    return False


def get_clip():
    sh_clip_command = "sh nsip -type clip"
    try:
        nitroJson = util.clinitro_exec(sh_clip_command)
        if nitroJson != None and "nsip" in nitroJson:
            return nitroJson["nsip"][0]["ipaddress"]
    except Exception:
        logger.error("Failed to get CLIP.")
        logger.error(traceback.format_exc())
    return None


def remove_prev_inst():
    try:
        cmd = cons.REMOVE_PREV_INST_CMD
        _ = subprocess.check_output(shlex.split(cmd), stderr=subprocess.STDOUT)
        logger.info("Removed /var/mastools/conf/prev_inst if present, as part of auto-registration retry.")
    except Exception as e:
        logger.error("Failed to remove /var/mastools/conf/prev_inst if present, as part of auto-registration retry, with error: {}".format(repr(e)))
        pass


def remove_mastools_init_status():
    try:
        cmd = cons.REMOVE_MASTOOL_INIT_STATUS_CMD
        _ = subprocess.check_output(shlex.split(cmd), stderr=subprocess.STDOUT)
        logger.info("Removed /var/mastools/conf/mastools_init.status if present, as part of auto-registration retry.")
    except Exception as e:
        logger.error("Failed to remove agent.conf if present, as part of auto-registration retry, with error: {}".format(repr(e)))
        pass

def is_registartion_in_progress_timedout():
     if (time.time() - float(get_internal_ns_registration_start_time())) > cons.ADM_NS_INTERNAL_REGISTRATION_TIMEOUT:
        return True
     else:
        return False

def check_config_file_state_suitable_for_reg():
    # Reattempting internal NS registration if either the state is NOT APPLICABLE OR
    # previous attempt was failed
    # If disabled from Safehaven Frontend, state in config file will be "DISABLED", which does not trigger
    # internal auto registration
    is_config_file_state_suitable = get_internal_ns_registration_state() == cons.NOT_APPLICABLE or \
                                    get_internal_ns_registration_state() == cons.FAILURE or \
                                    get_internal_ns_registration_state() == cons.ENABLED

    return is_config_file_state_suitable


def is_cluster_layer3():
    try:
        cmd = "sh cluster instance"
        nitroJson = util.clinitro_exec(cmd)
        if "clusterinstance" in nitroJson and len(nitroJson["clusterinstance"])>0:
            if nitroJson["clusterinstance"][0]["inc"] and nitroJson["clusterinstance"][0]["inc"].lower()=="enabled":
                logger.info("Cluster is Layer3, skip internal auto-registration.")
                return True
    except Exception as e:
        logger.error("Failed to check if cluster is layer3 with error: {}".format(repr(e)))
    return False


def check_device_type_suitable_for_reg():
    is_cluster, is_cco = is_cluster_cco()
    is_ha, is_primary = is_ha_vpx_primary()
    is_standalone = False

    if not is_cluster and not is_ha:
        is_standalone = True
    logger.debug("is_cluster:{}, is_ha:{}, is_standalone:{}".format(is_cluster, is_ha, is_standalone))
    is_device_type_suitable_for_auto_reg = False
    # Should add internal device info in probe payload only if it is primary node in ha or
    # cco node in cluster or a standalone netscaler
    if is_standalone or (is_ha and is_primary) or (is_cluster and is_cco):
        if is_cluster:
            if not is_cluster_layer3():
                is_device_type_suitable_for_auto_reg = True
            else:
                is_device_type_suitable_for_auto_reg = False
        else:
            is_device_type_suitable_for_auto_reg = True
    return is_device_type_suitable_for_auto_reg


def check_if_nsip_is_changed(current_nsip):
    # TODO: Need to specially handle for HA and Cluster
    is_cluster, is_cco = is_cluster_cco()
    is_ha, is_primary = is_ha_vpx_primary()
    if not is_cluster and not is_ha:
        if get_internal_nsip() != cons.NOT_APPLICABLE and \
                current_nsip != get_internal_nsip() and \
                get_internal_ns_registration_state() != cons.INPROGRESS:
            # IP has been changed, need to pass old IP in payload to remove from managed_device
            logger.info("Internal NS IP has changed from :{} to:{}.".format(get_internal_nsip(), current_nsip))
            return True
    return False


def check_if_deployement_type_is_changed():
    is_cluster, _ = is_cluster_cco()
    is_ha, _ = is_ha_vpx_primary()
    if is_cluster:
        current_deployment_type = cons.DEPLOYMENT_TYPE_CLUSTER
    elif is_ha:
        current_deployment_type = cons.DEPLOYMENT_TYPE_HA
    else:
        current_deployment_type = cons.DEPLOYMENT_TYPE_STANDALONE
    deployment_type_in_config_file = get_internal_deployment_type()
    if deployment_type_in_config_file != cons.NOT_APPLICABLE and \
            current_deployment_type != deployment_type_in_config_file and \
            get_internal_ns_registration_state() != cons.INPROGRESS:
            logger.info("Internal NS deployment has changed from :{} to:{}.".format(deployment_type_in_config_file, current_deployment_type))
            return True
    return False

def is_internal_registration_required(is_internal_ns, nsip):
    if is_internal_ns:
        if get_is_zero_touch_registration_allowed() is False:
            return False
        if get_test_lodestone_state() is True:
            return False
        is_config_file_state_suitable = check_config_file_state_suitable_for_reg()
        is_device_type_suitable_for_auto_reg = check_device_type_suitable_for_reg()
        is_nsip_changed = check_if_nsip_is_changed(nsip)
        is_deployment_type_changed = check_if_deployement_type_is_changed()
        if is_config_file_state_suitable and is_device_type_suitable_for_auto_reg:
            return True
        elif is_nsip_changed and is_device_type_suitable_for_auto_reg:
            return True
        elif is_deployment_type_changed and is_device_type_suitable_for_auto_reg:
            return True
    return False


def get_agent_conf():
    global AGENT_CONF_DICT
    try:
        with open(AGENT_CONFIG_FILE, "r+") as agent_conf_file:
            CONTENT= agent_conf_file.read()
            agent_conf_file.close()
        AGENT_CONF_DICT = xmltodict.parse(CONTENT)['mps_agent']
    except Exception:
        logger.debug("agent.conf not found")

def get_customerid():
    if 'customerid' not in AGENT_CONF_DICT.keys():
        customer_id = "none"
    else:
        customer_id = AGENT_CONF_DICT['customerid']
    return customer_id

def get_instanceid():
    if 'instanceid' not in AGENT_CONF_DICT.keys():
        instance_id = "none"
    else:
        instance_id = AGENT_CONF_DICT['instanceid']
    return instance_id

def get_profile_name():
    if 'profile' not in AGENT_CONF_DICT.keys():
        profile_name = None
    else:
        profile_name = AGENT_CONF_DICT['profile']
    return profile_name


def get_apigw_url():
    if 'url' not in AGENT_CONF_DICT.keys():
        apigw_url = "none"
    else:
        apigw_url = AGENT_CONF_DICT['url']
    return apigw_url


def get_managed_device_url_filter_by_profile_name():
    profile_name = AGENT_CONF_DICT['profile']
    url = "https://" + AGENT_CONF_DICT['url'] + "/" + AGENT_CONF_DICT['customerid'] + "/" + MASTOOLS_CWS_SERVICE_NAME + MANAGED_DEVICE_URI_FILTER_BY_PROFILE_NAME + profile_name
    return url

def get_managed_device_url_by_trust_id(trust_id):
    url = "https://" + AGENT_CONF_DICT['url'] + "/" + AGENT_CONF_DICT['customerid'] + "/" + MASTOOLS_CWS_SERVICE_NAME + MANAGED_DEVICE_URI_FILTER_BY_TRUST_ID + trust_id
    return url

def get_managed_device_url_by_ip_address(nsip):
    url = "https://" + AGENT_CONF_DICT['url'] + "/" + AGENT_CONF_DICT['customerid'] + "/" + MASTOOLS_CWS_SERVICE_NAME + MANAGED_DEVICE_URI_FILTER_BY_IP_ADDRESS + nsip
    return url

def get_managed_device_url_by_id(id):
    url = "https://" + AGENT_CONF_DICT['url'] + "/" + AGENT_CONF_DICT['customerid'] + "/" + MASTOOLS_CWS_SERVICE_NAME + MANAGED_DEVICE_URI + id
    return url

def get_device_profile_url_filter_by_name(device_profile_name=None):
    if device_profile_name:
        url = "https://" + AGENT_CONF_DICT['url'] + "/" + AGENT_CONF_DICT['customerid'] + "/" + MASTOOLS_CWS_SERVICE_NAME + DEVICE_PROFILE_URI_FILTER_BY_NAME + device_profile_name
        return url
    else:
        profile_name = AGENT_CONF_DICT['profile']
        url = "https://" + AGENT_CONF_DICT['url'] + "/" + AGENT_CONF_DICT['customerid'] + "/" + MASTOOLS_CWS_SERVICE_NAME + DEVICE_PROFILE_URI_FILTER_BY_NAME + profile_name
    return url

def get_device_profile_url_by_id(id):
    url = "https://" + AGENT_CONF_DICT['url'] + "/" + AGENT_CONF_DICT['customerid'] + "/" + MASTOOLS_CWS_SERVICE_NAME + DEVICE_PROFILE_URI + id
    return url

def get_managed_device_url():
    url = "https://" + AGENT_CONF_DICT['url'] + "/" + AGENT_CONF_DICT['customerid'] + "/" + MASTOOLS_CWS_SERVICE_NAME + MANAGED_DEVICE_URI
    url = url[:len(url)-1]
    return url

def get_activity_status_url(activity_id):
    url = "https://" + AGENT_CONF_DICT['url'] + "/" + AGENT_CONF_DICT['customerid'] + "/" + MASTOOLS_CWS_SERVICE_NAME + ACTIVITY_STATUS_URI + activity_id
    return url

def update_device_profile_payload(password):
    device_profile_payload = {
        "ns_device_profile": {
            "username": cons.CLOUD_CONNECT_USER,
            "password": password
        }
    }
    device_profile_payload_str = quote(json.dumps(device_profile_payload))
    return device_profile_payload_str


def send_request(url, method, payload='', time_out=30):
    from mastools_reg import sign_request, get_mastools_proxy_httplib2
    service_token = sign_request(url, MASTOOLS_CWS_SERVICE_NAME, AGENT_CONF_DICT['instanceid'])

    proxy_httplib2 = get_mastools_proxy_httplib2()
    if proxy_httplib2:
        httpConnection = httplib2.Http(".cache",proxy_info=proxy_httplib2,ca_certs=CERT_BUNDLE_PATH, timeout=time_out)
    else:
        httpConnection=httplib2.Http(".cache",ca_certs=CERT_BUNDLE_PATH, timeout=time_out)
    headers_conn = {'Content-Type':'application/json'}
    headers_conn['Authorization'] = auth_request_header+service_token
    logger.info("url: " + url + ";method: " + method)
    content = None
    try:
        if payload == '':
            responseStatus, content = httpConnection.request(url, method, headers=headers_conn)
        else:
            responseStatus, content = httpConnection.request(url, method, headers=headers_conn, body=payload)
        if is_python_3:
            content = content.decode("utf-8")
        resp_str = 'responseStatus='+str(responseStatus)+' content='+content
        if "status" in responseStatus:
            if responseStatus["status"] == '200' or responseStatus["status"] == '204':
                return True, responseStatus["status"], content
        logger.info("resp_str: "+resp_str)
        response_code = None
        if "status" in responseStatus:
            response_code = responseStatus["status"]
        return False, response_code, content
    except Exception as e:
        logger.error("Exception: "+repr(e))
        logger.error(traceback.format_exc())
        return False, None, content


def track_registration_on_adm(ns_ip):
    def poll_on_managed_device():
        try:
            managed_device_url = get_managed_device_url_filter_by_profile_name()
            status, _, response = send_request(managed_device_url, "GET")
            if status:
                response = json.loads(response)
                return response
        except Exception:
            logger.debug("Get on managed_device failed: {}".format(traceback.format_exc()))

    get_agent_conf()
    if AGENT_CONF_DICT:
        instance_id = AGENT_CONF_DICT['instanceid']
        instance_id = "".join(instance_id.split('-'))
        is_cluster, _ = is_cluster_cco()
        if is_cluster:
            expected_ip_address = get_clip()
        else:
            expected_ip_address = ns_ip + '~' + instance_id
        logger.debug("Expected ip_address: {}".format(expected_ip_address))
        is_reg_complete = False
        start_time = time.time()
        while not is_reg_complete:
            logger.debug("Polling managed_device...")
            if time.time() - start_time > cons.MANAGED_DEVICE_POLL_TIMEOUT:  # if registration taking more than 15 mins
                logger.debug("Poll on managed_device has timed out, registration failed")
                return False
            managed_device_response = poll_on_managed_device()
            if managed_device_response and "managed_device" in managed_device_response:
                devices = managed_device_response["managed_device"]
                for device in devices:
                    if expected_ip_address in device["ip_address"] and device["instance_state"].lower() == "Up".lower():
                        logger.debug("Found match")
                        is_reg_complete = True
                        break;
            time.sleep(20)
        return is_reg_complete


def get_on_managed_device_by_trust_id(trust_id):
    try:
        managed_device_url = get_managed_device_url_by_trust_id(trust_id)
        status, _, response = send_request(managed_device_url, "GET")
        if status:
            response = json.loads(response)
            return response
    except Exception:
        logger.debug("Failed get on managed_device by url: {}".format(traceback.format_exc()))

def get_on_managed_device_by_id(managed_device_id):
    try:
        managed_device_url = get_managed_device_url_by_id(managed_device_id)
        status, _, response = send_request(managed_device_url, "GET")
        if status:
            response = json.loads(response)
            return response
    except Exception:
        logger.debug("Failed get on managed_device by url: {}".format(traceback.format_exc()))


def get_trust_id_profile_name_from_managed_device(nsip):
    trust_id = None
    profile_name = None
    try:
        managed_device_url = get_managed_device_url_by_ip_address(nsip)
        status, _, response = send_request(managed_device_url, "GET")
        if status:
            response = json.loads(response)
            if response and "managed_device" in response and len(response["managed_device"]) > 0:
                trust_id = response["managed_device"][0]["trust_id"]
                profile_name = response["managed_device"][0]["profile_name"]
        return trust_id, profile_name
    except Exception:
        logger.error("Failed to get trust_id from managed_device by ip_address: {}".format(traceback.format_exc()))
        return trust_id, profile_name


def delete_on_managed_device_by_trust_id(trust_id):
    managed_device_url = None
    try:
        response = get_on_managed_device_by_trust_id(trust_id)
        time.sleep(10)
        if response and "managed_device" in response :
            for device in response["managed_device"]:
                managed_device_id = device["id"]
                managed_device_url = get_managed_device_url_by_id(managed_device_id)
                _, _, _ = send_request(managed_device_url, "DELETE", time_out=120)
                time.sleep(20)
    except Exception:
        logger.error("Failed to delete managed_device by url: {} with error:{}".format(managed_device_url, traceback.format_exc()))


def get_device_profile_by_name(device_profile_name=None):
    url = None
    try:
        get_agent_conf()
        url = get_device_profile_url_filter_by_name(device_profile_name)
        status, _, response = send_request(url, 'GET')
        if status:
            response = json.loads(response)
            return response
    except Exception:
        logger.debug("Failed to delete device_profile by url: {} with error:{}".format(url, traceback.format_exc()))


def delete_device_profile(device_profile_name=None):
    url = None
    response = None
    try:
        if device_profile_name:
            response = get_device_profile_by_name(device_profile_name)
            logger.debug("Get on device_profile by name: {} response: {}".format(get_profile_name(), response))
        else:
            get_agent_conf()
            if AGENT_CONF_DICT:
                response = get_device_profile_by_name()
                logger.debug("Get on device_profile by name: {} response: {}".format(get_profile_name(), response))
        if response and "device_profile" in response and len(response["device_profile"]) > 0:
            time.sleep(10)
            device_profile_id = response["device_profile"][0]["id"]
            url = get_device_profile_url_by_id(device_profile_id)
            _, _, _ = send_request(url, 'DELETE')
            logger.debug("Deleted device_profile by name: {} response: {}".format(device_profile_name, response))
    except Exception:
        logger.debug("Failed to delete device_profile by url: {} with error:{}".format(url, traceback.format_exc()))


def delete_core_dump():
    try:
        cmd = cons.REMOVE_CORE_DUMP_CMD
        _ = subprocess.check_output(cmd, shell=True)
    except Exception:
        logger.debug("Unable to delete core dumps")
        pass


def fetch_aws_info():
    '''
        Sample return value:
        "cloud_details": {
            "aws_account_id": "154598613981",
            "aws_availability_zone": "us-east-1a",
            "aws_region" : "us-east-1",
            "aws_instance_id" : "i-0a525e23ffad745ab"
         }
    '''
    url = cons.AWS_METADATA_URL
    res = requests.get(url)
    res = res.json()
    cloud_details = {
        'aws_account_id': res['accountId'],
        'aws_availability_zone': res['availabilityZone'],
        'aws_region' : res['region'],
        'aws_instance_id' : res['instanceId']
    }
    return cloud_details


def fetch_azure_info():
    '''
        Sample return value:
        "cloud_details": {
            "azure_subscription_id": "bc06c133-dfaa-48f3-9bf2-79be53e6371a",
            "azure_region" : "westus2",
            "azure_resourcegroup_name": "EATS_WestUS2",
            "azure_instance_name": "ADC-KP"
         }
    '''
    url = cons.AZURE_METADATA_URL
    res = requests.get(url, headers=cons.AZURE_METADATA_HEADER)
    res = res.json()
    cloud_details = {
        "azure_subscription_id": res['compute']['subscriptionId'],
        "azure_region": res['compute']['location'],
        "azure_resourcegroup_name": res['compute']['resourceGroupName'],
        "azure_instance_name": res['compute']['name'],
    }
    return cloud_details

def fetch_gcp_info():
    '''
        Sample return value:
        "cloud_details": {
            "gcp_numeric_project_id": "92892525809",
            "gcp_project_id": "cluster-gcp"
            "gcp_availability_zone": "us-central1-a",
            "gcp_region": "us-central1",
            "gcp_instance_id": "3418966009954035109"
         }
    '''
    url = cons.GCP_METADATA_URL
    res = requests.get(url, headers=cons.GCP_METADATA_HEADER)
    res = res.json()
    availability_zone = res['instance']['zone'].split('/')[-1]  # eg: 'asia-northeast2-a'
    region = availability_zone[:len(availability_zone)-2]  # eg: 'asia-northeast2'
    cloud_details = {
        'gcp_numeric_project_id': str(res['project']['numericProjectId']),
        'gcp_project_id': res['project']['projectId'],
        'gcp_availability_zone': availability_zone,
        'gcp_region': region,
        'gcp_instance_id': str(res['instance']['id'])
    }

    return cloud_details

def fetch_cloud_info():
    cloud_type = fetch_type_of_deployment()
    cloud_details = {}
    if cloud_type == cons.AWS_CLOUD_TYPE:
        cloud_details = fetch_aws_info()
    elif cloud_type == cons.AZURE_CLOUD_TYPE:
        cloud_details = fetch_azure_info()
    elif cloud_type == cons.GCP_CLOUD_TYPE:
        cloud_details = fetch_gcp_info()
    return cloud_details

def run_command(cmd):
    args = shlex.split(cmd)
    FNULL = open(os.devnull, 'w')
    subprocess.call(args,stdout=FNULL,stderr=FNULL)
    FNULL.close()

def cleanup_internal_auto_registration():
    # remove_cloud_connect_user_if_exists(cons.OLD_CLOUD_CONNECT_USER_1)
    # remove_cloud_connect_user_if_exists(cons.OLD_CLOUD_CONNECT_USER_2)
    # remove_cloud_connect_user_if_exists(cons.CLOUD_CONNECT_USER)
    try:
        cmd = cons.STOP_MASTOOLS_CMD
        run_command(cmd)
        logger.info("Stopped mastools as part of cleanup to remove auto-registration configurations.")
    except Exception as e:
        logger.error("Unable to stop mastools as part of cleanup to remove auto-registration configurations, with error: {}".format(repr(e)))
        pass
    try:
        cmd = cons.REMOVE_AGENT_CONF_CMD
        _ = subprocess.check_output(cmd, shell=True)
        logger.info("Removed agent.conf as part of cleanup to remove auto-registration configurations.")
    except Exception as e:
        logger.error("Failed to remove agent.conf as part of cleanup to remove auto-registration configurations, with error: {}".format(repr(e)))
        pass
    try:
        cmd = cons.RESTART_MASTOOLS_CMD
        run_command(cmd)
        logger.info("Restarted mastools as part of cleanup to remove auto-registration configurations.")
    except Exception as e:
        logger.error("Unable to restart mastools, with error: {}".format(repr(e)))
        pass

def prepare_managed_device_update_tags_payload(tags):
    entity_tag_list = []
    for tag_key in tags:
        entity_tag = {
            "prop_key": tag_key.lower(), "prop_value": tags[tag_key].lower()
        }
        entity_tag_list.append(entity_tag)
    managed_device_update_tags_payload = {
        "managed_device": {
            "profile_name": AGENT_CONF_DICT['profile'],
            "entity_tag": entity_tag_list
        }
}
    return managed_device_update_tags_payload


def is_identical(tag_list_current, tag_list_to_update):
    if len(tag_list_current) != len(tag_list_to_update):
        return False
    tag_list_current_dict = {}
    tag_list_to_update_dict = {}
    for tag in tag_list_current:
        tag_list_current_dict[tag["prop_key"]] = tag["prop_value"]
    for tag in tag_list_to_update:
        tag_list_to_update_dict[tag["prop_key"]] = tag["prop_value"]
    return tag_list_current_dict == tag_list_to_update_dict


def update_device_profile(password, retries=3):
    get_agent_conf()
    url = get_device_profile_url_filter_by_name()
    payload = update_device_profile_payload(password)
    status, _, response = send_request(url, 'PUT', payload)
    if status:
        response = json.loads(response)
        logger.info("Response for put on device profile: {}".format(response))
        logger.info("Updated of device profile")
    else:
        if retries > 0:
            time.sleep(5)
            update_device_profile(password=password, retries=retries-1)


def update_device_profile_save_config():
    username, password = add_cloud_connect_user()
    update_device_profile(password)
    return username, password


def update_tags_in_managed_device(tags, update_tag_retries=5):
    def poll_on_activity_status(activity_id):
        try:
            activity_status_url = get_activity_status_url(activity_id)
            status, _, response = send_request(activity_status_url, "GET")
            if status:
                response = json.loads(response)
                return response
        except Exception:
            logger.error("Get on managed_device failed: {}".format(traceback.format_exc()))

    if update_tag_retries > 0:
        managed_device_url = None
        managed_device_update_tags_payload = {}
        try:
            instance_id = AGENT_CONF_DICT['instanceid']
            response = get_on_managed_device_by_trust_id(instance_id)
            managed_device_update_tags_payload = prepare_managed_device_update_tags_payload(tags)
            if response and "managed_device" in response:
                for device in response["managed_device"]:
                    managed_device_id = device["id"]
                    current_managed_device_tags = get_on_managed_device_by_id(managed_device_id)["managed_device"][0]["entity_tag"]
                    if not is_identical(current_managed_device_tags, managed_device_update_tags_payload['managed_device']['entity_tag']):
                        managed_device_update_tags_payload["managed_device"]["id"] = managed_device_id
                        managed_device_url = get_managed_device_url()
                        status, _, response = send_request(managed_device_url, 'PUT', payload=quote(json.dumps(managed_device_update_tags_payload)))
                        if status:
                            response = json.loads(response)
                            activity_id = response["managed_device"][0]["act_id"]
                            is_task_complete = False
                            activity_status_poll_count = 5
                            while not is_task_complete and activity_status_poll_count > 0:
                                time.sleep(10)
                                activity_poll_response = poll_on_activity_status(activity_id)
                                activity_status_tasks = activity_poll_response["activity_status"]

                                for activity_status_task in activity_status_tasks:
                                    if activity_status_task["is_last"].lower() == "true":
                                        if activity_status_task["status"].lower() == "Completed".lower():
                                            logger.info(
                                                "Status completed, breaking from for loop, setting is_task_complete to True")
                                            is_task_complete = True
                                            logger.info("Value of is_task_complete : %s" % repr(is_task_complete))
                                            break

                                    if activity_status_task["status"] == "Failed":
                                        is_task_complete = True
                                        logger.error("PUT on managed_device with tags failed with error: {}".format(activity_status_task.get('message')))
                                activity_status_poll_count = activity_status_poll_count - 1
                    else:
                        logger.info("Tags already updated.")
        except Exception:
            logger.error("Failed put on managed_device with tags by url: {}, payload: {} with error: {}".format(
                managed_device_url, managed_device_update_tags_payload, traceback.format_exc()))
        time.sleep(10)
        update_tags_in_managed_device(tags, update_tag_retries-1)


def check_if_internal():
    licenseSnoNotice = []
    is_internal_ns_from_local_license = None
    is_internal_ns_from_pooled_license = None
    try:
        localLicenseSno, is_internal_ns_from_local_license = util.get_local_license_sno_notice()
        for sno in localLicenseSno:
            info = {}
            info['lic_sno'] = sno
            info['lic_type'] = cons.LOCAL_TYPE
            licenseSnoNotice.append(info)
    except Exception as e:
        logger.error(str(e))
        logger.debug("{}".format(traceback.format_exc()))
    cluster_node_id = ''
    deployment, ip, nodeid = util.get_deployment_info()
    if deployment == cons.CLUSTER_CCO or deployment == cons.CLUSTER_NONCCO:
        cluster_node_id = nodeid
    try:
        pooledLicenseSno, is_internal_ns_from_pooled_license = util.get_pooled_license_sno_notice(cluster_node_id)
        for sno in pooledLicenseSno:
            info = {}
            info['lic_sno'] = sno
            info['lic_type'] = cons.POOLED_TYPE
            licenseSnoNotice.append(info)
    except Exception as e:
        logger.error(str(e))
        logger.debug("{}".format(traceback.format_exc()))
    logger.info("is_internal_ns_from_local_license:{}\n is_internal_ns_from_pooled_license:{}"
                .format(is_internal_ns_from_local_license,
                        is_internal_ns_from_pooled_license))
    if is_internal_ns_from_local_license is None and is_internal_ns_from_pooled_license is None:
        # Neither licensed by local license nor through ADM
        is_internal_ns = False
    elif is_internal_ns_from_pooled_license is None and is_internal_ns_from_local_license is not None:
        # Not licensed through ADM
        # Licensed by local license
        is_internal_ns = is_internal_ns_from_local_license
    elif is_internal_ns_from_local_license is None and is_internal_ns_from_pooled_license is not None:
        # Licensed through ADM
        # Not Licensed by local license
        is_internal_ns = is_internal_ns_from_pooled_license
    else:
        # Licensed by both local license and through ADM
        # If any of these licenses have a Notice which is not Citrix Systems, Inc, NS not considered as Internal
        is_internal_ns = is_internal_ns_from_pooled_license and is_internal_ns_from_local_license
    if os.path.isfile(cons.ADM_AUTOREG_INTERNAL_FILE):
        is_internal_ns = True
    return is_internal_ns


def mark_for_re_registration_if_agent_conf_not_found():
    try:
        if (not os.path.isfile(cons.MASTOOLS_AGENT_CONF_FILE) and get_internal_ns_registration_state() == cons.SUCCESS):
            set_is_zero_touch_registration_allowed_to_false()
            set_internal_ns_registration_state(cons.NOT_APPLICABLE)
            logger.info("Internal NS agent.conf not found, set internal_registration_status to NA.")
    except Exception as e:
        logger.error("Failed to mark internal registration status for retry, if agent.conf is missing and marked internal registration status as Success with error: {}".format(repr(e)))


def get_all_cluster_nodes(get_active_nodes=True):
    is_cluster = False
    is_cco  = False
    node_list = []
    try:
        # Check for cluster deployment
        nitroJson = util.clinitro_exec('sh cluster node')
        if nitroJson != None and 'clusternode' in nitroJson:
            is_cluster = True
            clusternodes = nitroJson['clusternode']
            for node in clusternodes:
                if node['islocalnode'] == True:
                    nodeid = node['nodeid']
                    if node['isconfigurationcoordinator'] == True:
                        is_cco = True
                        node_list.append(copy.deepcopy(node['ipaddress']))
                else:
                    if get_active_nodes:
                        if node['masterstate'] == 'ACTIVE' and node['state'] == 'ACTIVE':
                            node_list.append(copy.deepcopy(node['ipaddress']))
                    else:
                        node_list.append(copy.deepcopy(node['ipaddress']))
    except Exception as e:
        logger.error("In get_all_cluster_nodes, exception:" + repr(e))

    return is_cluster, is_cco, node_list


def get_clip_and_member_node_ips(get_active_nodes=True):
    clip_and_member_node_ips = []
    try:
        _, _, member_node_list = get_all_cluster_nodes(get_active_nodes)
        logger.info("get_clip_and_member_node_ips: member_node_list: {}".format(member_node_list))
        clip = get_clip()
        logger.info("get_clip_and_member_node_ips: clip: {}".format(clip))

        clip_and_member_node_ips = member_node_list + [clip]
        logger.info("get_clip_and_member_node_ips: clip_and_member_node_ips: {}".format(clip_and_member_node_ips))
        return clip_and_member_node_ips
    except Exception as e:
        logger.error("Failed to get_clip_and_member_node_ips with error:{} traceback: {}".format(repr(e), traceback.format_exc()))
        return clip_and_member_node_ips


def get_ha_info():
    ha_state = ''
    secondary_ip = ''
    try:
        nitroJson = util.clinitro_exec('sh ha node')
        if nitroJson != None and 'hanode' in nitroJson:
            hanodes = nitroJson['hanode']
            nodeCount = len(hanodes)
            if nodeCount == 2:
                for node in hanodes:
                    # Id uniquely identifies the node.
                    # For self node, it will always be 0
                    if node['id'] == '0':
                        if node['state'] == 'Primary':
                            ha_state = 'Primary'
                        else:
                            ha_state = 'Secondary'
                    else:
                        # HA peer node ip
                        secondary_ip = copy.deepcopy(node['ipaddress'])
        else:
            logger.error("util_internal_reg: Failed to HA node")
    except Exception as e:
        logger.error("util_internal_reg: Exception in get_HA_info:" + repr(e))
    return ha_state, secondary_ip


def generate_otp(ip_address, retries=3):
    try:
        otp_server_url = cons.HTTP + cons.OTP_SERVICE + cons.CREATE_OTP_URL
        headers = {'Content-Type': 'application/json'}
        payload = {'ip_address': ip_address}
        otp_response = util.request(cons.HTTP_POST, otp_server_url, headers=headers, payload=json.dumps(payload))
        otp_response_json = otp_response.json()
        return otp_response_json["otp"]
    except Exception as e:
        logger.error("util_internal_reg: Exception in generate_otp:" + repr(e))
        if retries > 0:
            time.sleep(5)
            return generate_otp(ip_address, retries-1)
