import subprocess
import shlex
import re
import zlib
import base64
import os
import time
import psutil
from shutil import copy2
from datetime import datetime
try:
    import ConfigParser
except ImportError:
    import configparser as ConfigParser
import logging
import util

from logger import logger
import constant as cons

import os
import sys

current = os.path.dirname(os.path.realpath(__file__))
parent = os.path.dirname(current)
sys.path.append(parent)

from cwcUtil import cwcUtil

SVM_MPS_LIB = '/mps/lib'
if os.path.exists(SVM_MPS_LIB):
    import psycopg2

SVM_PYTHON = "/usr/local/bin/python"
MASTOOLS_UTIL = "/var/mastools/scripts/mastools_util.py"

STATE_TRUE_EXIT_CODE = 1
STATE_FALSE_EXIT_CODE = 2

SVM_DB_HOST = "localhost"
SVM_DB_PORT = "5454"
SVM_DB_NAME = "mpsdb"
SVM_DB_USER = "mpspostgres"
SVM_DB_TIMEOUT = 5
SVM_DB_SELECT_KEY_WORD = "select "
SET_SDX_SCEHMA = "SET SCHEMA 'Owner';"
SVM_DB_FROM_KEY_WORD = " from "

SVM_DB_TABLENAME_LICENSESERVER = 'license_server'
SVM_DB_COLUMNNAME_SERVER = 'server'
SVM_DB_COLUMNNAME_PORT = 'port'
SVM_DB_TABLENAME_DEVICE_PROFILE_DETAILS = "device_profile_details"
SVM_DB_TABLENAME_DEVICE_PROFILE = "device_profile"
SVM_DB_TABLE_NAME_MPS_PROPERTIES = "mps_properties"
SVM_DB_PROP_VALUE = "prop_value"
DEFAULT_SCHEMA = "Owner"




STATE_SUCCESS = 0
STATE_GENERIC_FAILURE = 1
STATE_DB_FAILURE = 2

MAX_DB_RETRY = 3
DB_RETRY_INTERVAL = 10

def run_command_with_exit_code(cmd):
    args = shlex.split(cmd)
    FNULL = open(os.devnull, 'w')
    process = subprocess.Popen(args, stdout=subprocess.PIPE, stderr=FNULL)
    FNULL.close()
    process.communicate()
    return process.returncode

def get_is_banner_displayed():
    cmd = SVM_PYTHON + " " + MASTOOLS_UTIL + " -get_cli_banner"
    ret_code = run_command_with_exit_code(cmd)
    logger.debug("Returned code: {}".format(ret_code))
    if ret_code == STATE_TRUE_EXIT_CODE:
        return True
    return False
        

def get_initial_wait_time():
    logger.debug("In get_initial_wait_time from svm")
    if get_is_banner_displayed():
        return 0
    return 1800

def get_value_from_svmdb_basic(table_name, column_names):
    ret_value = STATE_DB_FAILURE
    db_value = None
    conn = None
    try:
        logger.debug("DB request: TableName={}, ColumnNames: {}".format(table_name, column_names))
        conn = psycopg2.connect(host=SVM_DB_HOST,port=SVM_DB_PORT, database=SVM_DB_NAME, user=SVM_DB_USER, connect_timeout=SVM_DB_TIMEOUT)
        if conn is None:
            logger.error("Failed to connect SVM DB")
            return ret_value, db_value
        cur = conn.cursor()
        set_role_schema_query=(SET_SDX_SCEHMA)
        select_query = SVM_DB_SELECT_KEY_WORD + column_names + SVM_DB_FROM_KEY_WORD + table_name + ';'
        query= set_role_schema_query + select_query
        cur.execute(query)
        db_value = cur.fetchone()
        cur.close()
        ret_value = STATE_SUCCESS
    except psycopg2.Error as e:
        logger.exception("SVM DB error: {}".format(repr(e)))
        ret_value = STATE_DB_FAILURE
    except Exception as e:
        logger.exception("SVM DB generic error: {}".format(repr(e)))
        ret_value = STATE_GENERIC_FAILURE
    finally:
        if conn is not None:
            conn.close()

    return ret_value, db_value

def get_device_profile_details(profile_name):

    ret_value = STATE_DB_FAILURE
    db_value = None
    creds ={}
    conn = None
    try:
        logger.debug("DB request: get device profile details for profile name " +profile_name)
        conn = psycopg2.connect(host=SVM_DB_HOST,port=SVM_DB_PORT, database=SVM_DB_NAME, user=SVM_DB_USER, connect_timeout=SVM_DB_TIMEOUT)
        if conn is None:
            logger.error("Failed to connect SVM DB")
            return ret_value, db_value
        cur = conn.cursor()
        set_role_schema_query=(SET_SDX_SCEHMA)
        select_query = "select device_profile_details.prop_key, device_profile_details.prop_value from device_profile_details inner join device_profile on device_profile_details.device_profile_id =device_profile.id where name ='"+ profile_name + "' ;"
        query= set_role_schema_query + select_query
        cur.execute(query)
        db_value = cur.fetchall()
        cur.close()
        ret_value = STATE_SUCCESS
        ret_value, enc_key = get_encryption_key()
        for (prop_key, prop_value) in db_value:
            if prop_key == "username" :
                ret_usernme  = cwcUtil().decrypt(DEFAULT_SCHEMA, prop_value,enc_key)   
                creds["username"] = ret_usernme[0]
            if prop_key == "password" :
                ret_passwd = cwcUtil().decrypt(DEFAULT_SCHEMA, prop_value,enc_key)
                creds["password"] = ret_passwd[0]
    except psycopg2.Error as e:
        logger.exception("SVM DB error: {}".format(repr(e)))
        ret_value = STATE_DB_FAILURE
    except Exception as e:
        logger.exception("SVM DB generic error: {}".format(repr(e)))
        ret_value = STATE_GENERIC_FAILURE
    finally:
        if conn is not None:
            conn.close()
    return creds

def get_encryption_key():
    ret_value = STATE_DB_FAILURE
    db_value = []
    conn = None
    key = None 
    try:
        conn = psycopg2.connect(host=SVM_DB_HOST,port=SVM_DB_PORT, database=SVM_DB_NAME, user=SVM_DB_USER, connect_timeout=SVM_DB_TIMEOUT)
        if conn is None:
            logger.error("Failed to connect SVM DB")
            return ret_value, db_value
        cur = conn.cursor()
        set_role_schema_query=(SET_SDX_SCEHMA)
        select_query = SVM_DB_SELECT_KEY_WORD + SVM_DB_PROP_VALUE+ SVM_DB_FROM_KEY_WORD + SVM_DB_TABLE_NAME_MPS_PROPERTIES + " WHERE prop_key ='MSP_SERVER_DB_KEY';"
        query= set_role_schema_query + select_query
        cur.execute(query)
        db_value = cur.fetchone()
        if db_value:
            key = db_value[0]
        cur.close()
        ret_value = STATE_SUCCESS
    except psycopg2.Error as e:
        logger.exception("SVM DB error: {}".format(repr(e)))
        ret_value = STATE_DB_FAILURE
    except Exception as e:
        logger.exception("SVM DB generic error: {}".format(repr(e)))
        ret_value = STATE_GENERIC_FAILURE
    finally:
        if conn is not None:
            conn.close()
    return ret_value, key


def get_values_conditional_query(table_name, column_names_list, cond):
    retry_counter = 1
    db_value = None
    column_names = ""

    for column in column_names_list:
        if column_names == "" :
            column_names = column
        else:
            column_names += ", " + column

    while retry_counter <= MAX_DB_RETRY:
        ret_value, db_value = get_value_from_svmdb_all(table_name, column_names, cond)
        if ret_value != STATE_DB_FAILURE:
            return db_value
        retry_counter += 1
        time.sleep(DB_RETRY_INTERVAL)
    return db_value

def get_value_from_svmdb_all( table_name, column_names, cond= None):

    ret_value = STATE_DB_FAILURE
    db_value = None
    conn = None
    try:
        logger.debug("DB request: TableName={}, ColumnNames: {}".format(table_name, column_names))
        conn = psycopg2.connect(host=SVM_DB_HOST,port=SVM_DB_PORT, database=SVM_DB_NAME, user=SVM_DB_USER, connect_timeout=SVM_DB_TIMEOUT)
        if conn is None:
            logger.error("Failed to connect SVM DB")
            return ret_value, db_value
        cur = conn.cursor()
        set_role_schema_query=(SET_SDX_SCEHMA)
        if cond is None:
            select_query = SVM_DB_SELECT_KEY_WORD + column_names + SVM_DB_FROM_KEY_WORD + table_name + ';'
        else:
            select_query = SVM_DB_SELECT_KEY_WORD + column_names + SVM_DB_FROM_KEY_WORD + table_name + " "+ cond + ';'
        query= set_role_schema_query + select_query
        cur.execute(query)
        db_value = cur.fetchall()
        cur.close()
        ret_value = STATE_SUCCESS
    except psycopg2.Error as e:
        logger.exception("SVM DB error: {}".format(repr(e)))
        ret_value = STATE_DB_FAILURE
    except Exception as e:
        logger.exception("SVM DB generic error: {}".format(repr(e)))
        ret_value = STATE_GENERIC_FAILURE
    finally:
        if conn is not None:
            conn.close()

    return ret_value, db_value

def get_value_from_svmdb(table_name, *args):
    retry_counter = 1
    db_value = None
    column_names = ""

    for arg in args:
        if column_names == "":
            column_names = arg
        else:
            column_names += ", " + arg

    while retry_counter <= MAX_DB_RETRY:
        ret_value, db_value = get_value_from_svmdb_basic(table_name, column_names)
        if ret_value != STATE_DB_FAILURE:
            return db_value
        retry_counter += 1
        time.sleep(DB_RETRY_INTERVAL)
    return db_value

def get_hardware_info():
    logger.debug("In get_hardware_info from svm")
    serialId, encodedSerialId, hostId, netscalerUuid = "", "", "", cons.SVM_NOT_APPLICABLE
    try:
        serialId = util.sysctl_exec(cons.SVM_SERIAL_ID)
        encodedSerialId = serialId
        hostId_str = subprocess.check_output(shlex.split(cons.SVM_HOST_ID_CMD))
        hostId_str = hostId_str.decode()
        hostID_split_list =  hostId_str.split('"')
        if len(hostID_split_list) > 1:
            hostId = hostID_split_list[1]
        else:
            logger.error("could not find hostID, ret str is: " + hostId_str)
    except Exception as e:
        logger.exception(repr(e))
        raise Exception("Failed to get Hardware info from SVM")
    
    return serialId, encodedSerialId, hostId, netscalerUuid

def get_mgmt_ip():
    logger.debug("In get_mgmt_ip from svm")
    mgmt_ip = ""

    try:
        mgmt_ip = subprocess.check_output(shlex.split(cons.SVM_MGMT_IP_CMD))
        mgmt_ip = mgmt_ip.decode()
        mgmt_ip = mgmt_ip.strip('\n')
    except Exception as e:
        logger.exception(repr(e))
        raise Exception("Failed to get Mgmt IP info from SVM")

    return mgmt_ip

def get_hostname():
    logger.debug("In get_hostname from svm")
    hostname = ""

    try:
        hostname = util.sysctl_exec(cons.SVM_HOST_NAME)
    except Exception as e:
        logger.exception(repr(e))
        raise Exception("Failed to get Hostname info from SVM")

    return hostname

def get_version_info():
    logger.debug("In get_version_info")
    version, build, type = "", "", ""
    try:
        # NetScaler NS13.0: Build 55.3001.nc, Date: Mar 27 2020, 14:42:45   (64-bit)
        versionString = util.sysctl_exec(cons.SVM_BUID_INFO)
        version = versionString.split("NS")[1].split(":")[0]
        buildTokens = versionString.split("Build ")[1].split(",")[0].split(".")
        type = buildTokens.pop()
        build = '.'.join(buildTokens)
    except Exception as e:
        logger.exception(repr(e))
        raise Exception("Failed to get SVM Version info")

    return version, build, type

def get_license_server_info():
    logger.debug("In get_license_server_info")
    server, port = "", ""

    db_value = get_value_from_svmdb(SVM_DB_TABLENAME_LICENSESERVER, SVM_DB_COLUMNNAME_SERVER, SVM_DB_COLUMNNAME_PORT)
    if db_value != None:
        server = db_value[0]
        port = db_value[1]
        logger.debug("Pooled license server {}:{}".format(server, port))

    return server, port

def get_license_info():
    return cons.SVM_NOT_APPLICABLE, cons.SVM_NOT_APPLICABLE

def get_hypervisor_info():
    return cons.SVM_NOT_APPLICABLE

def get_cloud_info():
    return cons.SVM_NOT_APPLICABLE

def get_platform_info():
    logger.debug("In get_platform_info from svm")
    sysid, platformDescription, platformType = "", "", cons.SVM_PLATFORM_TYPE

    try:
        sysid = util.sysctl_exec(cons.SVM_SYS_ID)
        platformDescription = util.sysctl_exec(cons.SVM_PLATFORM_DESCR)
    except Exception as e:
        logger.exception(repr(e))
        raise Exception("Failed to get Platform info")

    return sysid, platformDescription, platformType

def get_enabled_features_and_modes():
    return cons.SVM_NOT_APPLICABLE, cons.SVM_NOT_APPLICABLE

def get_nsconf():
    return cons.SVM_NOT_APPLICABLE, cons.SVM_NOT_APPLICABLE

def get_deployment_info():
    return cons.SVM_NOT_APPLICABLE, cons.SVM_NOT_APPLICABLE, cons.SVM_NOT_APPLICABLE

def get_ns_stats():
    logger.debug("In get_ns_stats from svm")
    cpuPercentage, mgmtCpuPercentage, memoryPercentage, rxTput, systemUpTime = "", "", "", cons.SVM_NOT_APPLICABLE, ""

    try:
        cpuPercentage = str(psutil.cpu_percent())
        mgmtCpuPercentage = cpuPercentage
        memoryUsageDict = dict(psutil.virtual_memory()._asdict())
        memoryPercentage = memoryUsageDict.get('percent', cons.SVM_NOT_APPLICABLE)
        if type(memoryPercentage) is not str:
            memoryPercentage = str(memoryPercentage) 
        sys_start_time = time.localtime(psutil.boot_time())
        systemUpTime = time.strftime("%a %B %d %H:%M:%S %Y", sys_start_time)
    except Exception as e:
        logger.exception(repr(e))
        raise Exception("Failed to get NS STATS from svm")

    return cpuPercentage, mgmtCpuPercentage, memoryPercentage, rxTput, systemUpTime

def get_ssl_stats():
    return cons.SVM_NOT_APPLICABLE, cons.SVM_NOT_APPLICABLE, cons.SVM_NOT_APPLICABLE

def update_db_value_internal_flag(ip_address):
    ret_value = STATE_DB_FAILURE
    conn = None
    try:
        conn = psycopg2.connect(host=SVM_DB_HOST,port=SVM_DB_PORT, database=SVM_DB_NAME, user=SVM_DB_USER, connect_timeout=SVM_DB_TIMEOUT)
        if conn is None:
            logger.error("Failed to connect SVM DB")
            return ret_value
        cur = conn.cursor()
        set_role_schema_query=(SET_SDX_SCEHMA)
        update_query =  "update managed_device set device_ownership = 'Internal' where ip_address = '{}' ;".format(ip_address)
        query= set_role_schema_query + update_query
        cur.execute(query)
        conn.commit()
        cur.close()
        ret_value = STATE_SUCCESS
    except psycopg2.Error as e:
        logger.exception("SVM DB error: {}".format(repr(e)))
        ret_value = STATE_DB_FAILURE
    except Exception as e:
        logger.exception("SVM DB generic error: {}".format(repr(e)))
        ret_value = STATE_GENERIC_FAILURE
    finally:
        if conn is not None:
            conn.close()
    return ret_value

def add_column(table_name, column_name):
    ret_value = STATE_DB_FAILURE
    conn = None
    is_exist = None
    try:
        conn = psycopg2.connect(host=SVM_DB_HOST,port=SVM_DB_PORT, database=SVM_DB_NAME, user=SVM_DB_USER, connect_timeout=SVM_DB_TIMEOUT)
        if conn is None:
            logger.error("Failed to connect SVM DB")
            return ret_value
        cur = conn.cursor()
        set_role_schema_query=(SET_SDX_SCEHMA)
        check_query = "select exists (select 1 from information_schema.columns where table_schema='{}' and table_name='{}' and column_name='{}');".format(DEFAULT_SCHEMA,table_name,column_name)
        cur.execute(check_query)
        db_value = cur.fetchone()
        if db_value:
            is_exist =  db_value[0]
        if not is_exist:
            alter_query =  "ALTER TABLE {} ADD COLUMN {} VARCHAR(50);".format(table_name,column_name)
            query= set_role_schema_query + alter_query
            cur.execute(query)
            conn.commit()
        cur.close()
        ret_value = STATE_SUCCESS
    except psycopg2.Error as e:
        logger.exception("SVM DB error: {}".format(repr(e)))
        ret_value = STATE_DB_FAILURE
    except Exception as e:
        logger.exception("SVM DB generic error: {}".format(repr(e)))
        ret_value = STATE_GENERIC_FAILURE
    finally:
        if conn is not None:
            conn.close()
    return ret_value

def get_clip(ip_address):
    ret_value = STATE_DB_FAILURE
    db_value = []
    clip = None
    conn = None
    try:
        #logger.debug("DB request: get device profile details for profile name " +profile_name)
        conn = psycopg2.connect(host=SVM_DB_HOST,port=SVM_DB_PORT, database=SVM_DB_NAME, user=SVM_DB_USER, connect_timeout=SVM_DB_TIMEOUT)
        if conn is None:
            logger.error("Failed to connect SVM DB")
            return ret_value, db_value
        cur = conn.cursor()
        set_role_schema_query=(SET_SDX_SCEHMA)
        select_query = "select ns.clip from ns inner join managed_device on ns.ns_ip_address=managed_device.ip_address where ns.ns_ip_address='"+ ip_address + "' ;"
        query= set_role_schema_query + select_query
        cur.execute(query)
        db_value = cur.fetchone()
        if db_value:
            clip = db_value[0]
        cur.close()
        ret_value = STATE_SUCCESS
    except psycopg2.Error as e:
        logger.exception("SVM DB error: {}".format(repr(e)))
        ret_value = STATE_DB_FAILURE
    except Exception as e:
        logger.exception("SVM DB generic error: {}".format(repr(e)))
        ret_value = STATE_GENERIC_FAILURE
    finally:
        if conn is not None:
            conn.close()
    return clip, ret_value

