import pexpect
import argparse
import subprocess
import shlex
import os
import sys
import re
import copy
import json
import time
import base64
import xmltodict
import httplib2
import encodings
import uuid
import platform
try:
    import ConfigParser
except ImportError:
    import configparser as ConfigParser

from mastools_reg import sign_request, is_python_2_6, auth_request_header, get_mastools_proxy_httplib2

MASTOOLS_CONF_FILE = '/var/mastools/conf/agent.conf'
MASTOOLS_TRUST_DIR = '/var/mastools/trust'
MASTOOLS_CERT_DIR = '/var/mastools/cert'
MASTOOLS_UPGRADE_SCRIPT = '/var/mastools/scripts/mastools_upgrade.py'
MASTOOLS_DAEMON_SCRIPT = '/var/mastools/scripts/mastoolsd'
MASTOOLS_UTIL_SCRIPT = '/var/mastools/scripts/mastools_util.py'
MASTOOLS_FILE = '/var/mastools/mastools_file.tgz'
MASTOOLS_DEST_DIR = '/var/mastools'
MASTOOLS_AUTOREG_CONFIG_FILE = '/nsconfig/admautoreg.state'
MASTOOLS_AUTOREG_TMP_CONFIG_FILE = '/var/tmp/admautoreg.state'
MASTOOLS_CONFIG_FILE_DEST_DIR = '/nsconfig'
MASTOOLS_FILE_NAME = 'mastools_file.tgz'
MASTOOLS_TRUST_KEY_DIR = '/var/mastools/trust/.ssh/'

CERT_BUNDLE_PATH='/var/mastools/cert/cacert.pem'

NS_HS_STATE_COMMAND  = 'show nsconfig'
HA_NODE_COMMAND  = 'show node'
HA_NODE_SEPERATOR = ')'
HA_NODE_PRIMARY = 'Primary'
HA_NODE_SECONDARY = 'Secondary'
HA_NODE_IP = 'IP:'

HA_PRIMARY = 'Primary'
HA_SECONDARY = 'Secondary'
HA_STANDALONE = 'Standalone'

SHOW_CLUSTER_NODE = 'sh cluster node'

CLI_PROMPT = '>'
SHELL_PROMPT = '#'

SECONDARY_LOG = '/var/mastools/logs/secondary.log'

LOCAL_LOOPBACK_IP = '127.0.0.1'

if os.path.exists(MASTOOLS_UTIL_SCRIPT):
    MASTOOLS_ALL_FILES_TO_SECONDARY = (MASTOOLS_CONF_FILE, MASTOOLS_TRUST_DIR, MASTOOLS_CERT_DIR, MASTOOLS_UPGRADE_SCRIPT, MASTOOLS_DAEMON_SCRIPT, MASTOOLS_UTIL_SCRIPT)
else:
    MASTOOLS_ALL_FILES_TO_SECONDARY = (MASTOOLS_CONF_FILE, MASTOOLS_TRUST_DIR, MASTOOLS_CERT_DIR, MASTOOLS_UPGRADE_SCRIPT, MASTOOLS_DAEMON_SCRIPT)

TMP_DIR = '/var/tmp'
MGMT_TENANT_COOKIE = '_MGMT_TENANT'

LEGATUS_AGENT_REQ_COOKIE = 'legatus_agent_request'

MASTOOLS_CWS_SERVICENAME = 'netappliance'

ONE_MINUTE = 60*1

NSCLI_CMD = '/netscaler/nscli -U %%:.:. '
CLICMDNITRO_EXEC = 'clicmdnitro -execute -clicmd '

def is_python_3_running():
    if platform.python_version().startswith('3.'):
        return True
    return False

is_python_3 = is_python_3_running()


#=================For setting up logging ==============================================================================================================
import logging
import logging.handlers

log_file_name_local = os.path.basename(__file__)
LOG_FILENAME = '/var/mastools/logs/' + log_file_name_local + '.log'
LOG_MAX_BYTE = 50*1024*1024
LOG_BACKUP_COUNT = 20

# Set up a specific logger with our desired output level
logger = logging.getLogger(__name__)
logger.setLevel(logging.DEBUG)

# Add the log message handler to the logger
logger_handler = logging.handlers.RotatingFileHandler(LOG_FILENAME, maxBytes=LOG_MAX_BYTE, backupCount=LOG_BACKUP_COUNT)
logger_fortmater = logging.Formatter(fmt='%(asctime)s:%(funcName)s:%(lineno)d: [%(levelname)s] %(message)s', datefmt="%Y-%m-%d %H:%M:%S")
logger_handler.setFormatter(logger_fortmater)
logger.addHandler(logger_handler)

def get_logger_header():
    return '[mastools_cluster]'

def file_transfer_secondary(secondary_host):
    print("file_transfer_cmd starts")
    #run_shell_command('bash')
    file_transfer_cmd = 'rsync %s %s@%s:%s' % (MASTOOLS_FILE, USERNAME, secondary_host,MASTOOLS_DEST_DIR)
    print("file_transfer_cmd = " + file_transfer_cmd)
    args = ["-c",file_transfer_cmd]
    child = pexpect.spawn('bash', args=args)
    logger.info(get_logger_header()+file_transfer_cmd)
    need_password = send_secondary_pwd(child)
    if need_password:
        data = child.read()
        if is_python_3:
            data = data.decode("utf-8")
        logger.info(get_logger_header()+data)
    child.close()
    return

def is_mastools_first_time(child):
    send_cmd_shell(child, "cat /var/mastools/version.txt")
    if '0.0-0.0' in child.before:
        return True
    return False

def send_cmd_shell(child, cmd):
    logger.info(get_logger_header()+cmd)
    child.sendline(cmd)
    child.expect(SHELL_PROMPT)
    logger.info(get_logger_header()+child.before)
    logger.info(get_logger_header()+child.after)
    return

def extract_file_secondary(child):
    send_cmd_shell(child, 'tar -xvzf ' + MASTOOLS_FILE)
    #send_cmd_shell(child, 'rm -rf  ' + MASTOOLS_TRUST_DIR)
    #send_cmd_shell(child, 'rm -rf  /var/mastools/conf')
    send_cmd_shell(child, 'mkdir -p  /var/mastools/conf')
    send_cmd_shell(child, 'mkdir -p  /var/mastools/scripts')
    send_cmd_shell(child, 'mkdir -p  /var/mastools/logs')
    for mastools_file in MASTOOLS_ALL_FILES_TO_SECONDARY:
        send_cmd_shell(child, 'cp -rf ' + MASTOOLS_DEST_DIR+mastools_file + ' ' + mastools_file)
    return
def send_secondary_pwd(child):
    need_password = True
    i = child.expect(['assword:', r"yes/no", CLI_PROMPT, pexpect.EOF])
    if i == 0:
        child.sendline(PASSWORD)
    elif i == 1:
        child.sendline("yes")
        child.expect("assword:", timeout=30)
        child.sendline(PASSWORD)
    else:
        need_password = False
    return need_password




def start_mastools_secondary(child):
    mastools_first_time = is_mastools_first_time(child)
    send_cmd_shell(child, "chmod +x "+MASTOOLS_DAEMON_SCRIPT)
    if not mastools_first_time:
        send_cmd_shell(child, "sh " + MASTOOLS_DAEMON_SCRIPT+ " restart")
    else:
        send_cmd_shell(child, 'nohup python ' + MASTOOLS_UPGRADE_SCRIPT + '&')
    return

def run_mastools(secondary_host):
    run_shell_command('bash')
    connect_cmd = 'ssh -o StrictHostKeyChecking=no -o UserKnownHostsFile=/dev/null '+ USERNAME + '@'+ secondary_host
    if is_python_3:
        child = pexpect.spawnu(connect_cmd, timeout=300)
    else:
        child = pexpect.spawn(connect_cmd, timeout=300)
    logger.info(get_logger_header()+connect_cmd)
    need_password = send_secondary_pwd(child)
    if need_password:
        child.expect([CLI_PROMPT, SHELL_PROMPT])
    secondary_log = open(SECONDARY_LOG, 'w')
    child.logfile = secondary_log
    send_cmd_shell(child, 'shell')
    send_cmd_shell(child, 'cd ' + MASTOOLS_DEST_DIR)
    extract_file_secondary(child)
    start_mastools_secondary(child)
    send_cmd_shell(child, 'rm -rf var' )
    send_cmd_shell(child, 'rm -rf ' + MASTOOLS_FILE )
    time.sleep(1)
    secondary_log.close()
    child.close()

def delete_mastools():
    run_shell_command('rm -rf  ' + MASTOOLS_TRUST_DIR)
    run_shell_command('rm -rf  /var/mastools/conf/agent.conf')
    run_shell_command('sh /var/mastools/scripts/mastoolsd restart')
    return


def gen_all_files_to_secondary():
    all_files = ' '.join(MASTOOLS_ALL_FILES_TO_SECONDARY)
    return all_files

def copy_file_secondary(secondary_ips):
    run_shell_command('tar czvf '+MASTOOLS_FILE+' '+ gen_all_files_to_secondary())
    for secondary_host in secondary_ips:
        file_transfer_secondary(secondary_host)
    run_shell_command('rm -rf '+MASTOOLS_FILE)
    return


def run_mastools_secondary(secondary_ips):
    for secondary_host in secondary_ips:
        run_mastools(secondary_host)
    return

def run_shell_command(cmd):
    args = shlex.split(cmd)
    subprocess.call(args)

def run_local_cli_command(cmd):
    if type(LOCAL_CLI_BASE_COMMAND) != 'str':
        base_cmd = str(LOCAL_CLI_BASE_COMMAND)
    else:
        base_cmd = LOCAL_CLI_BASE_COMMAND
    args = shlex.split(base_cmd)
    args.append(cmd)
    process = subprocess.Popen(args, stdout=subprocess.PIPE, stderr=None)
    output, err = process.communicate()
    return output

def read_command_output(cmd):
    args = shlex.split(cmd)
    process = subprocess.Popen(args, stdout=subprocess.PIPE, stderr=None)
    output = process.communicate()
    return output[0]



def clinitro_exec(clicmd):
    nitroJson = None
    try:
        cmd = NSCLI_CMD + ' "' + CLICMDNITRO_EXEC + " '" + clicmd + "'" + '"'
        cliNitroOutput = subprocess.check_output(shlex.split(cmd), stderr=subprocess.STDOUT)
        if is_python_3:
            cliNitroOutput = cliNitroOutput.decode("utf-8")
        nitroJson = get_nitroresp_from_clicmdnitro_op(cliNitroOutput)
    except subprocess.CalledProcessError as e:
        # nsremotexec returns exit-code=1 in error-scenario (ex: when resource isn't there)
        if e.returncode == 1:
            nitroJson = get_nitroresp_from_clicmdnitro_op(e.output)
            if nitroJson:
                return nitroJson
        raise Exception("Failed to execute clinitro cmd: {}".format(clicmd))
    except Exception as e:
        logger.error(str(e))
        raise Exception("Failed to execute clinitro cmd: {}".format(clicmd))
    return nitroJson

def get_nitroresp_from_clicmdnitro_op(cliNitroOutput):
    try:
        if cliNitroOutput == None:
            return None
        nitroJson = None
        cliNitroOutput = cliNitroOutput.split(" Done\n")[1]
        tokens = cliNitroOutput.split("\n")
        for val in tokens:
            match = re.search(r"^\s*NITRORESP :\s+(.*$)", val.strip())
            if match:
                nitroJson = json.loads(match.group(1))
                break
        return nitroJson
    except Exception as e:
        logger.error(e)
        raise Exception("Failed to get NITRORESP from cliNitroOutput str: {}".format(cliNitroOutput))

def get_param_from_dict(name, conf_dict):
    if name not in conf_dict.keys():
        if name == 'mgmt_tenant' or name == 'type' or name == 'profile':
            return ''
        else:
            logger.error(get_logger_header()+'no ' + name + ' in agent.conf')
            system.exit(-1)
    return conf_dict[name]

def get_agent_conf():
    if not os.path.exists(MASTOOLS_CONF_FILE):
        logger.error(get_logger_header()+'mastools not initialised')
        system.exit(-1)

    with open("/var/mastools/conf/agent.conf", "r+") as agent_conf_file:
        content= agent_conf_file.read()
        agent_conf_file.close()

    agent_conf_dict = xmltodict.parse(content)['mps_agent']
    global CUSTOMER_ID
    global SERVICE_NAME
    global INSTANCE_ID
    global CLOUD_URL
    global IS_MGMT_TENANT
    global DEVICE_PROFILE_NAME
    global IS_VPX

    CUSTOMER_ID = get_param_from_dict('customerid', agent_conf_dict)
    SERVICE_NAME = get_param_from_dict('servicename', agent_conf_dict)
    INSTANCE_ID = get_param_from_dict('instanceid', agent_conf_dict)
    CLOUD_URL = get_param_from_dict('url', agent_conf_dict)
    mgmt_tenant = get_param_from_dict('mgmt_tenant', agent_conf_dict)
    device_type = get_param_from_dict('type', agent_conf_dict)
    device_profile = get_param_from_dict('profile', agent_conf_dict)
    if mgmt_tenant != '':
        IS_MGMT_TENANT = True
    else:
        IS_MGMT_TENANT = False

    if device_type == '':
        IS_VPX = True
    else:
        IS_VPX = False

    if device_profile == '':
        DEVICE_PROFILE_NAME = "mastool_"+INSTANCE_ID+"_profile"
    else:
        DEVICE_PROFILE_NAME = device_profile

    return

def get_all_cluster_nodes():
    is_cluster = False
    is_cco  = False
    node_list = []

    try:
        # Check for cluster deployment
        nitroJson = clinitro_exec(SHOW_CLUSTER_NODE)
        if nitroJson != None and 'clusternode' in nitroJson:
            is_cluster = True
            clusternodes = nitroJson['clusternode']
            for node in clusternodes:
                if node['islocalnode'] == True:
                    nodeid = node['nodeid']
                    if node['isconfigurationcoordinator'] == True:
                        is_cco = True
                else:
                    if node['masterstate'] == 'ACTIVE' and node['state'] == 'ACTIVE':
                        node_list.append(copy.deepcopy(node['ipaddress']))
    except Exception as e:
        logger.error("In get_all_cluster_nodes, exception:" + repr(e))

    return is_cluster, is_cco, node_list


def diff_lists(list_a, list_b):
    return list(set(list_a) - set(list_b))


def send_request(url, method, payload='', time_out=30):
    if is_python_2_6:
        service_token = sign_request(url, SERVICE_NAME, INSTANCE_ID)
    else:
        service_token = sign_request(url, MASTOOLS_CWS_SERVICENAME, INSTANCE_ID)
    proxy_httplib2 = get_mastools_proxy_httplib2()
    if proxy_httplib2:
        httpConnection=httplib2.Http(".cache",proxy_info=proxy_httplib2,ca_certs=CERT_BUNDLE_PATH, timeout=time_out)
    else:
        httpConnection=httplib2.Http(".cache",ca_certs=CERT_BUNDLE_PATH, timeout=time_out)
    headers_conn = {'Content-Type':'application/json'}
    headers_conn['Authorization'] = auth_request_header+service_token
    logger.debug(get_logger_header()+url + ";method: " + method)
    legatus_cookie = LEGATUS_AGENT_REQ_COOKIE+'=true'
    content = ''
    if IS_MGMT_TENANT:
        headers_conn['Cookie'] = legatus_cookie+';'+MGMT_TENANT_COOKIE + ':"yes"'
    else:
        headers_conn['Cookie'] = legatus_cookie
    try:
        if payload == '':
            responseStatus, content = httpConnection.request(url, method, headers=headers_conn)
        else:
            responseStatus, content = httpConnection.request(url, method, headers=headers_conn, body=payload)
        if is_python_3:
            content = content.decode("utf-8")
        resp_str = 'responseStatus='+str(responseStatus)+' content='+content
        #logger.debug(get_logger_header()+resp_str)
        #logger.debug(get_logger_header()+content);
        if "status" in responseStatus:
            if responseStatus["status"] == '200' or responseStatus["status"] == '204':
                return True, content
        logger.debug(get_logger_header()+resp_str)
        logger.debug(get_logger_header()+content)
        return False, content
    except Exception as e:
        logger.debug(get_logger_header()+repr(e))
        return False, content

def gen_clour_req_url(uri):
    if is_python_2_6:
        cloud_uri = '/' + CUSTOMER_ID + '/' + SERVICE_NAME + uri;
    else:
        cloud_uri = '/' + CUSTOMER_ID + '/' + MASTOOLS_CWS_SERVICENAME + uri;
    clour_req_url = "https://"+ CLOUD_URL + cloud_uri
    return clour_req_url

def parse_cloud_detail_response(key_value_lists, keys):
    ret_cred = {}
    for key in keys:
        for key_value in key_value_lists:
            if key_value[MASTOOLS_DEVICE_PROFILE_DETAILS_PROP_KEY] == key:
                ret_cred[key] = key_value[MASTOOLS_DEVICE_PROFILE_DETAILS_PROP_VALUE]
    return  ret_cred

def parse_cloud_response(obj_name, content, keys={}):
    ret = {}
    content_json = json.loads(content)
    obj_lists = content_json[obj_name]
    if len(keys) == 0:
        return obj_lists
    obj_dict = obj_lists[0]
    for key in keys:
        if key in obj_dict:
            ret[key] =  obj_dict[key]
        else:
            ret[key] = ''
    return ret

def get_device_cred(username="", pwd=""):
    global USERNAME
    global PASSWORD
    global LOCAL_CLI_BASE_COMMAND

    USERNAME = username
    PASSWORD = pwd
    LOCAL_CLI_BASE_COMMAND = 'nscli -U '+ LOCAL_LOOPBACK_IP + ':' + USERNAME+':' + PASSWORD
    return
def get_cred(username="", pwd=""):
    get_agent_conf()
    if not IS_MGMT_TENANT:
        get_device_cred(username, pwd)
    return

def get_adc_details():
    try:
        adcInput = sys.stdin.readline()
        adcDetails = base64.b64decode(adcInput.encode('ascii')).decode('ascii')
        return adcDetails
    except Exception as e:
        logger.error('Failed to get ADC details %s' %(str(e)))
        return ""
def run_single_mode(argv):
    adcDetails = get_adc_details()
    adcs_str = adcDetails.split(" ")
    if len(adcs_str) > 1:
        get_device_cred(adcs_str[0], adcs_str[1])
    secondary_ips = []
    secondary_ips.append(argv[1])
    copy_file_secondary(secondary_ips)
    run_mastools_secondary(secondary_ips)
    sys.exit(0)

def run_loop_mode():
    #get_agent_conf()
    logger.debug("Start mastools cluster")
    adcDetails = get_adc_details()
    adcs_str = adcDetails.split(" ")
    if len(adcs_str) > 1:
        get_cred(adcs_str[0], adcs_str[1])

    if not IS_MGMT_TENANT and IS_VPX:
        cco_cluster_nodes = []
        cco_cluster_nodes_prev = []
        is_cluster_prev = False

    while True:
        if IS_MGMT_TENANT or not IS_VPX:
            logger.debug(get_logger_header()+"ADC is GW connecor or SDX")
            time.sleep(ONE_MINUTE*60)
            continue
        is_cluster, is_cco, cco_cluster_nodes = get_all_cluster_nodes()
        if is_cluster:
            if is_cco:
                added_nodes = diff_lists(cco_cluster_nodes,cco_cluster_nodes_prev)
                if added_nodes:
                    logger.debug(get_logger_header()+"In cluster and cco, new added nodes: " + repr(added_nodes))
                    copy_file_secondary(added_nodes)
                    run_mastools_secondary(added_nodes)
                cco_cluster_nodes_prev = cco_cluster_nodes
            is_cluster_prev = True
            time.sleep(ONE_MINUTE)
        else:
            logger.debug(get_logger_header()+"ADC not in cluster")
            if is_cluster_prev:
                logger.debug(get_logger_header()+"ADC removed from cluster, remove mastools related information")
                delete_mastools()
            time.sleep(ONE_MINUTE*60)

def send_non_cco_node_pwd_mastools_reg(child, password):
    need_password = True
    i = child.expect(['assword:', r"yes/no", CLI_PROMPT, pexpect.EOF])
    if i == 0:
        child.sendline(password)
    elif i == 1:
        child.sendline("yes")
        child.expect("assword:", timeout=30)
        child.sendline(password)
    else:
        need_password = False
    return need_password

def file_transfer_admautoreg_config_file_non_cco_node(admautoreg_logger, non_cco_node, username, password):
    try:
        admautoreg_logger.info("Copying mastools config file to non_cco_node {}".format(non_cco_node))

        # For Cluster, sync up admautoreg config file from cco to non-cco nodes
        mastools_config_file_transfer_cmd = 'scp -o StrictHostKeyChecking=no -o UserKnownHostsFile=/dev/null %s %s@%s:%s' % (
            MASTOOLS_AUTOREG_TMP_CONFIG_FILE , username, non_cco_node, MASTOOLS_CONFIG_FILE_DEST_DIR)
        args_mastools_config_file = ["-c", mastools_config_file_transfer_cmd]
        child = pexpect.spawn('bash', args=args_mastools_config_file)
        admautoreg_logger.info('AdmautoReg config file transfer command: {}'.format(mastools_config_file_transfer_cmd))
        need_password = send_non_cco_node_pwd_mastools_reg(child, password)
        if need_password:
            data = child.read()
            if is_python_3:
                data = data.decode("utf-8")
            admautoreg_logger.info('AdmautoReg config file transfer response: {}'.format(data))
        child.close()
    except Exception as e:
        admautoreg_logger.info("Failed to copy mastools config file to non cco nodes with error: {}".format(str(e)))
    return

def set_noncco_ip_admautoreg_state_file(admautoreg_logger, noncco_ip):
    admautoreg_logger.info("Set ns_internal_registration_ns_ip to {} in /var/tmp/admautoreg.state".format(noncco_ip))
    try:
        state = ConfigParser.RawConfigParser()
        state.read("/var/tmp/admautoreg.state")
        state.set("AdmAutoReg", "ns_internal_registration_ns_ip", noncco_ip)
        with open("/var/tmp/admautoreg.state", 'w') as configfile:
            state.write(configfile)
        admautoreg_logger.info("Set ns_internal_registration_ns_ip to {} in /var/tmp/admautoreg.state".format(noncco_ip))
    except Exception as e:
        admautoreg_logger.error("Failed to ns_internal_registration_ns_ip to noncco_ip in /var/tmp/admautoreg.state, with error: {}".format(repr(e)))

def mastools_sync_admautoreg_config(admautoreg_logger, username='', password=''):
    admautoreg_logger.info("in mastools_sync_admautoreg_config()")
    if (username == '') or (password == ''):
        admautoreg_logger.info("In mastools_syncup_non_cco, unable to get login credential")
        return False, "unable to get login credential"
    is_cluster, is_cco, cco_cluster_nodes = get_all_cluster_nodes()
    if is_cluster and is_cco:
        try:
            if not cco_cluster_nodes:
                admautoreg_logger.info('No non cco IP information, skipping')
                return False, "No non cco IP information"
            admautoreg_logger.info('Copying admautreg config file to non cco nodes:' + repr(cco_cluster_nodes))
            for cco_node in cco_cluster_nodes:
                set_noncco_ip_admautoreg_state_file(admautoreg_logger, cco_node)
                file_transfer_admautoreg_config_file_non_cco_node(admautoreg_logger, cco_node, username, password)
            admautoreg_logger.info('Done copying admautoreg config file to non cco nodes:' + repr(cco_node))
            return True, ""
        except Exception as e:
            admautoreg_logger.info('Exception in pushing admautoreg config file on non cco node:' + repr(e))
            return False, repr(e)
    return False, "node is not primary"


def _main(argv):
    if len(argv) > 1:
        run_single_mode(argv)
    else:
        run_loop_mode()
    sys.exit(0)

if __name__ == "__main__":

    sys.exit(_main(sys.argv))