import pexpect
import argparse
import subprocess
import shlex
import os
import sys
import re
import copy
import json
import time
import base64
import xmltodict
import httplib2
import encodings
import uuid
import platform
from mastools_reg import sign_request, is_python_2_6, auth_request_header, get_mastools_proxy_httplib2

try:
    import ConfigParser
except ImportError:
    import configparser as ConfigParser

IS_MGMT_TENANT=False
IS_VPX=False
IS_BLX=False
LEGATUS_AGENT_REQ_COOKIE = 'legatus_agent_request'

MASTOOLS_CONF_FILE = '/var/mastools/conf/agent.conf'
MASTOOLS_PUBLIC_KEY_FILE = '/var/mastools/trust/.ssh/public.pem'
MASTOOLS_PRIVATE_KEY_FILE = '/var/mastools/trust/.ssh/private.pem'
MASTOOLS_CHAIN_CERT_FILE = '/var/mastools/cert/ca-chain.cert.pem'
MASTOOLS_CA_CERT_FILE = '/var/mastools/cert/cacert.pem'
MASTOOLS_TRUST_DIR = '/var/mastools/trust'
MASTOOLS_CERT_DIR = '/var/mastools/cert'
MASTOOLS_UPGRADE_SCRIPT = '/var/mastools/scripts/mastools_upgrade.py'
MASTOOLS_DAEMON_SCRIPT = '/var/mastools/scripts/mastoolsd'
MASTOOLS_UTIL_SCRIPT = '/var/mastools/scripts/mastools_util.py'
MASTOOLS_FILE = '/var/mastools/mastools_file.tgz'
MASTOOLS_AUTOREG_CONFIG_FILE = '/nsconfig/admautoreg.state'
MASTOOLS_AUTOREG_TMP_CONFIG_FILE = '/var/tmp/admautoreg.state'
MASTOOLS_DEST_DIR = '/var/mastools'
MASTOOLS_CONFIG_FILE_DEST_DIR = '/nsconfig'
MASTOOLS_FILE_NAME = 'mastools_file.tgz'
MASTOOLS_TRUST_KEY_DIR = '/var/mastools/trust/.ssh/'

CERT_BUNDLE_PATH='/var/mastools/cert/cacert.pem'

HA_NODE_SEPERATOR = ')'
HA_NODE_PRIMARY = 'Primary'
HA_NODE_SECONDARY = 'Secondary'
HA_NODE_IP = 'IP:'

HA_PRIMARY = 'Primary'
HA_SECONDARY = 'Secondary'
HA_STANDALONE = 'Standalone'
HA_CLUSTER = 'Cluster'

SHOW_HANODE = 'sh ha node'
SHOW_CLUSTER_NODE = 'sh cluster node'

SHOW_SNMP_TRAP_GENERIC  = 'sh snmp trap generic '
SHOW_SNMP_TRAP_SPECIFIC  = 'sh snmp trap specific ' 
ADD_SNMP_TRAP_GENERIC = 'add snmp trap generic '
ADD_SNMP_TRAP_SPECIFIC = 'add snmp trap specific '
REMOVE_SNMP_TRAP_SPECIFIC = 'rm snmp trap specific '
REMOVE_SNMP_TRAP_GENERIC = 'rm snmp trap generic '

CLI_PROMPT = '>'
SHELL_PROMPT = '#'

SECONDARY_LOG = '/var/mastools/logs/secondary.log'

LOCAL_LOOPBACK_IP = '127.0.0.1'

if os.path.exists(MASTOOLS_UTIL_SCRIPT):
    MASTOOLS_ALL_FILES_TO_SECONDARY = (MASTOOLS_CONF_FILE, MASTOOLS_PUBLIC_KEY_FILE, MASTOOLS_PRIVATE_KEY_FILE, MASTOOLS_CHAIN_CERT_FILE, MASTOOLS_CA_CERT_FILE, MASTOOLS_UPGRADE_SCRIPT, MASTOOLS_DAEMON_SCRIPT, MASTOOLS_UTIL_SCRIPT)
else:
    MASTOOLS_ALL_FILES_TO_SECONDARY = (MASTOOLS_CONF_FILE, MASTOOLS_PUBLIC_KEY_FILE, MASTOOLS_PRIVATE_KEY_FILE, MASTOOLS_CHAIN_CERT_FILE, MASTOOLS_CA_CERT_FILE, MASTOOLS_UPGRADE_SCRIPT, MASTOOLS_DAEMON_SCRIPT)

TMP_DIR = '/var/tmp'
MGMT_TENANT_COOKIE = '_MGMT_TENANT'
ONE_MINUTE = 60*1

MASTOOLS_CWS_SERVICENAME = 'netappliance'


NSCLI_CMD = '/netscaler/nscli -U %%:.:. '
CLICMDNITRO_EXEC = 'clicmdnitro -execute -clicmd '

def is_python_3_running():
    if platform.python_version().startswith('3.'):
        return True
    return False

is_python_3 = is_python_3_running()



#=================For setting up logging ==============================================================================================================
import logging
import logging.handlers

log_file_name_local = os.path.basename(__file__)
LOG_FILENAME = '/var/mastools/logs/' + log_file_name_local + '.log'
LOG_MAX_BYTE = 50*1024*1024
LOG_BACKUP_COUNT = 20

# Set up a specific logger with our desired output level
logger = logging.getLogger(__name__)
logger.setLevel(logging.DEBUG)

# Add the log message handler to the logger
logger_handler = logging.handlers.TimedRotatingFileHandler(LOG_FILENAME,when='m', interval=2, backupCount=LOG_BACKUP_COUNT)
logger_fortmater = logging.Formatter(fmt='%(asctime)s:%(funcName)s:%(lineno)d: [%(levelname)s] %(message)s', datefmt="%Y-%m-%d %H:%M:%S")
logger_handler.setFormatter(logger_fortmater)
logger.addHandler(logger_handler)

def get_logger_header():
    return '['+SERVICE_NAME+']'+'['+CUSTOMER_ID+']'+'['+INSTANCE_ID+']:'

def get_logger_header_func():
    return '['+SERVICE_NAME+']'+'['+CUSTOMER_ID+']'+'['+INSTANCE_ID+'][FUNC]:'

def file_transfer_secondary(secondary_host):
    file_transfer_cmd = 'scp -o StrictHostKeyChecking=no -o UserKnownHostsFile=/dev/null %s %s@%s:%s' % (MASTOOLS_FILE, USERNAME, secondary_host,MASTOOLS_DEST_DIR)
    args = ["-c",file_transfer_cmd]
    child = pexpect.spawn('bash', args=args)
    logger.info(get_logger_header()+file_transfer_cmd)
    need_password = send_secondary_pwd(child)
    if need_password:
        data = child.read()
        if is_python_3:
            data = data.decode("utf-8")
        logger.info(get_logger_header()+data)
    child.close()
    return

def file_transfer_admautoreg_config_file_secondary(admautoreg_logger, secondary_host, username, password):
    try:
        admautoreg_logger.info("Copying mastools config file to secondary...")
        # For Cluster, sync up admautoreg config file from cco to non cco nodes
        mastools_config_file_transfer_cmd = 'scp -o StrictHostKeyChecking=no -o UserKnownHostsFile=/dev/null %s %s@%s:%s' % (
            MASTOOLS_AUTOREG_TMP_CONFIG_FILE, username, secondary_host, MASTOOLS_CONFIG_FILE_DEST_DIR)
        args_mastools_config_file = ["-c", mastools_config_file_transfer_cmd]
        child = pexpect.spawn('bash', args=args_mastools_config_file)
        admautoreg_logger.info('AdmautoReg config file transfer command: {}'.format(mastools_config_file_transfer_cmd))
        need_password = send_secondary_pwd_mastools_reg(child, password)
        if need_password:
            data = child.read()
            if is_python_3:
                data = data.decode("utf-8")
            admautoreg_logger.info('AdmautoReg config file transfer response: {}'.format(data))
        child.close()
    except Exception as e:
        admautoreg_logger.info("Failed to copy mastools config file to secondary with error: {}".format(str(e)))
    return

def send_cmd_shell(child, cmd):
    logger.info(get_logger_header()+cmd)
    child.sendline(cmd)
    child.expect(SHELL_PROMPT)
    logger.info(get_logger_header()+child.before)
    logger.info(get_logger_header()+child.after)
    return

def extract_file_secondary(child):
    send_cmd_shell(child, 'tar -xvzf ' + MASTOOLS_FILE)
    time.sleep(10)
    #send_cmd_shell(child, 'rm -rf  ' + MASTOOLS_TRUST_DIR)
    #send_cmd_shell(child, 'rm -rf  /var/mastools/conf')
    send_cmd_shell(child, 'mkdir -p  /var/mastools/conf')
    send_cmd_shell(child, 'mkdir -p  /var/mastools/scripts')
    send_cmd_shell(child, 'mkdir -p  /var/mastools/logs')
    for mastools_file in MASTOOLS_ALL_FILES_TO_SECONDARY:
        send_cmd_shell(child, 'cp -rf ' + MASTOOLS_DEST_DIR+mastools_file + ' ' + mastools_file)
    return

def is_mastools_first_time(child):
    send_cmd_shell(child, "cat /var/mastools/version.txt")
    if '0.0-0.0' in child.before:
        return True
    return False

def start_mastools_secondary(child):
    mastools_first_time = is_mastools_first_time(child)
    send_cmd_shell(child, "chmod +x "+MASTOOLS_DAEMON_SCRIPT)
    if not mastools_first_time:
        send_cmd_shell(child, "sh " + MASTOOLS_DAEMON_SCRIPT+ " restart")
    else:
        send_cmd_shell(child, 'nohup python ' + MASTOOLS_UPGRADE_SCRIPT + '&')
    return

def send_secondary_pwd(child):
    need_password = True
    i = child.expect(['assword:', r"yes/no", CLI_PROMPT, pexpect.EOF])
    if i == 0:
        child.sendline(PASSWORD)
    elif i == 1:
        child.sendline("yes")
        child.expect("assword:", timeout=30)
        child.sendline(PASSWORD)
    else:
        need_password = False
    return need_password

def send_secondary_pwd_mastools_reg(child, password):
    need_password = True
    i = child.expect(['assword:', r"yes/no", CLI_PROMPT, pexpect.EOF])
    if i == 0:
        child.sendline(password)
    elif i == 1:
        child.sendline("yes")
        child.expect("assword:", timeout=30)
        child.sendline(password)
    else:
        need_password = False
    return need_password


def run_mastools(secondary_host):
    connect_cmd = 'ssh -o StrictHostKeyChecking=no -o UserKnownHostsFile=/dev/null '+ USERNAME + '@'+ secondary_host
    if is_python_3:
        child = pexpect.spawnu(connect_cmd, timeout=300)
    else:
        child = pexpect.spawn(connect_cmd, timeout=300)
    logger.info(get_logger_header()+connect_cmd)
    need_password = send_secondary_pwd(child)
    if need_password:
        child.expect([CLI_PROMPT, SHELL_PROMPT])
    secondary_log = open(SECONDARY_LOG, 'w')
    child.logfile = secondary_log
    send_cmd_shell(child, 'shell')
    send_cmd_shell(child, 'cd ' + MASTOOLS_DEST_DIR)
    extract_file_secondary(child)
    start_mastools_secondary(child)
    send_cmd_shell(child, 'rm -rf /var/mastools/var' )
    send_cmd_shell(child, 'rm -rf ' + MASTOOLS_FILE )
    time.sleep(10)
    secondary_log.close()
    child.close()
    return

def gen_all_files_to_secondary():
    all_files = ' '.join(MASTOOLS_ALL_FILES_TO_SECONDARY)
    return all_files

def copy_file_secondary(secondary_ips):
    run_shell_command('tar czvf '+MASTOOLS_FILE+' '+ gen_all_files_to_secondary())
    for secondary_host in secondary_ips:
        file_transfer_secondary(secondary_host)
    run_shell_command('rm -rf '+MASTOOLS_FILE)
    return

def run_mastools_secondary(secondary_ips):
    for secondary_host in secondary_ips:
        run_mastools(secondary_host)
    return

def run_shell_command(cmd):
    args = shlex.split(cmd)
    subprocess.call(args)



def clinitro_exec(clicmd):
    nitroJson = None
    try:
        cmd = NSCLI_CMD + ' "' + CLICMDNITRO_EXEC + " '" + clicmd + "'" + '"'
        cliNitroOutput = subprocess.check_output(shlex.split(cmd), stderr=subprocess.STDOUT)
        if is_python_3:
            cliNitroOutput = cliNitroOutput.decode("utf-8")   
        nitroJson = get_nitroresp_from_clicmdnitro_op(cliNitroOutput)
    except subprocess.CalledProcessError as e:
        # nscli returns exit-code=1 in error-scenario (ex: when resource isn't there)
        if e.returncode == 1:
            nitroJson = get_nitroresp_from_clicmdnitro_op(e.output)
            if nitroJson:
                return nitroJson
        raise Exception("Failed to execute clinitro cmd: {}".format(clicmd))
    except Exception as e:
        logger.error(str(e))
        raise Exception("Failed to execute clinitro cmd: {}".format(clicmd))
    return nitroJson

def get_nitroresp_from_clicmdnitro_op(cliNitroOutput):
    try:
        if cliNitroOutput == None:
            return None
        nitroJson = None
        cliNitroOutput = cliNitroOutput.split(" Done\n")[1]
        tokens = cliNitroOutput.split("\n")
        for val in tokens:
            match = re.search(r"^\s*NITRORESP :\s+(.*$)", val.strip())
            if match:
                nitroJson = json.loads(match.group(1))
                break
        return nitroJson
    except Exception as e:
        logger.error(e)
        raise Exception("Failed to get NITRORESP from cliNitroOutput str: {}".format(cliNitroOutput))

def snmptrap_clinitro_exec(clicmd):
    jsonOutput= None
    try:
        jsonOutput = clinitro_exec(clicmd)
        return jsonOutput
    except:
        logger.error(get_logger_header()+'Exception in snmptrap_clinitro_exec')
        return None    
def read_command_output(cmd):
    args = shlex.split(cmd)
    process = subprocess.Popen(args, stdout=subprocess.PIPE, stderr=None)
    output = process.communicate()
    return output[0]

def get_secondary_ip(ha_node_str):
    secondary_ip = ""
    start_str = HA_NODE_IP
    end_str = '\n'
    regex_str = start_str + '(.*)' + end_str
    secondary_ip_result = re.search(regex_str, ha_node_str)
    if secondary_ip_result is not None:
        secondary_ip =  secondary_ip_result.group(1).strip()
    return secondary_ip

def parse_ha_nodes_info(ha_nodes_info):
    secondary_ips = []
    node_num = 1
    break_cond = False
    while True:
        start_str = str(node_num)+HA_NODE_SEPERATOR
        node_num+=1
        end_str = str(node_num)+HA_NODE_SEPERATOR
        ha_node_split_1_result = ha_nodes_info.split(start_str)
        if len(ha_node_split_1_result) != 2:
            break
        ha_node_result = ha_node_split_1_result[1].split(end_str)
        ha_node_str = ha_node_result[0]
        if len(ha_node_result) == 1:
            break_cond = True
        if HA_NODE_SECONDARY in ha_node_str:
            secondary_ip = get_secondary_ip(ha_node_str)
            if secondary_ip != '':
                secondary_ips.append(copy.deepcopy(secondary_ip))

        if break_cond:
            break

    return secondary_ips

def get_ha_info():
    ha_state, secondary_ips, primary_ip = "", [], ""

    try:
        # Check for cluster deployment
        nitroJson = clinitro_exec(SHOW_CLUSTER_NODE)
        if nitroJson != None and 'clusternode' in nitroJson:
            ha_state = HA_CLUSTER
        else:
            # Check for HA/Standalone deployment
            nitroJson = clinitro_exec(SHOW_HANODE)
            if nitroJson != None and 'hanode' in nitroJson:
                hanodes = nitroJson['hanode']
                nodeCount = len(hanodes)
                if nodeCount == 2:
                    for node in hanodes:
                        # Id uniquely identifies the node.
                        # For self node, it will always be 0
                        if node['id'] == '0':
                            if node['state'] == HA_NODE_PRIMARY:
                                ha_state = HA_PRIMARY
                                primary_ip = node['ipaddress']
                            else:
                                ha_state = HA_SECONDARY
                        else:
                            # HA peer node ip
                            if (node['hastatus'] == 'UP'):
                                secondary_ips.append(copy.deepcopy(node['ipaddress']))
                else:
                    ha_state = HA_STANDALONE
            else:
                logger.error("Failed to HA node")
    except Exception as e:
        logger.error("Exception in get_HA_info:" + repr(e))

    return ha_state, secondary_ips, primary_ip

def check_and_fix_snmp_trap_configuration(secondary_ip, primary_ip):
    try:
        community, destPort = "", ""
        nitroJsonGeneric = snmptrap_clinitro_exec(SHOW_SNMP_TRAP_GENERIC + secondary_ip+ ' -version v2')
        nitroJsonSpecific = snmptrap_clinitro_exec(SHOW_SNMP_TRAP_SPECIFIC + secondary_ip+ ' -version v2')
        nitroJsonSpecificPrimary = snmptrap_clinitro_exec(SHOW_SNMP_TRAP_SPECIFIC + primary_ip+ ' -version v2')
        nitroJsonGenericPrimary = snmptrap_clinitro_exec(SHOW_SNMP_TRAP_GENERIC + primary_ip+ ' -version v2')
        nitroJsonSpecificPrimaryV3 = snmptrap_clinitro_exec(SHOW_SNMP_TRAP_SPECIFIC + primary_ip+ ' -version v3')
        nitroJsonGenericPrimaryV3 = snmptrap_clinitro_exec(SHOW_SNMP_TRAP_GENERIC + primary_ip+ ' -version v3')
        if nitroJsonGenericPrimary == None and nitroJsonSpecificPrimary == None and (nitroJsonGeneric != None or nitroJsonSpecific != None) and (nitroJsonGenericPrimaryV3 == None and nitroJsonSpecificPrimaryV3 == None):
            logger.info(get_logger_header()+'No snmp trap config on primary')
            if nitroJsonGeneric != None:
                if 'snmptrap' in nitroJsonGeneric and len(nitroJsonGeneric['snmptrap']) > 0:
                    snmptrap = nitroJsonGeneric['snmptrap'][0]
                    if 'communityName' in snmptrap:
                        community = snmptrap['communityName']
                    if 'destPort' in snmptrap:
                        destPort = snmptrap['destPort']
                removeCommand = REMOVE_SNMP_TRAP_GENERIC+ secondary_ip
                removeCommand+= ' -version v2'
                rem1=snmptrap_clinitro_exec(removeCommand)
                if rem1 == None:
                    logger.info(get_logger_header()+'Failed to remove snmp trap config on secondary node') 
            if nitroJsonSpecific != None:
                if 'snmptrap' in nitroJsonSpecific and len(nitroJsonSpecific['snmptrap']) > 0:
                    snmptrap = nitroJsonSpecific['snmptrap'][0]
                    if 'communityName' in snmptrap:
                        community = snmptrap['communityName']
                    if 'destPort' in snmptrap:
                        destPort = snmptrap['destPort']
                removeCommand = REMOVE_SNMP_TRAP_SPECIFIC+ secondary_ip
                removeCommand+= ' -version v2'
                rem2=snmptrap_clinitro_exec(removeCommand)
                if rem2 == None:
                    logger.info(get_logger_header()+'Failed to remove snmp trap config on secondary node')
            addSpecific = ADD_SNMP_TRAP_SPECIFIC+ primary_ip
            addGeneric = ADD_SNMP_TRAP_GENERIC+ primary_ip
            if destPort != "":
                addSpecific += ' -destPort '+ destPort
                addGeneric += ' -destPort '+ destPort
            if community != "":
                addSpecific += ' -community '+ community
                addGeneric += ' -community '+ community
            addSpecific+= ' -version v2'
            addGeneric+= ' -version v2'    
            logger.info(get_logger_header()+'traps    '+ addSpecific)
            add1 = snmptrap_clinitro_exec(addGeneric)
            add2 = snmptrap_clinitro_exec(addSpecific)
            if add1 == None or add2 == None:
                logger.info(get_logger_header()+'Failed to add snmp trap config on primary')
    except:
        logger.error(get_logger_header()+'Exception in check_and_fix_snmp_trap_configuration')

def get_param_from_dict(name, conf_dict):
    if name not in conf_dict.keys():
        if name == 'mgmt_tenant' or name == 'type' or name == 'profile':
            return ''
        else:
            logger.error(get_logger_header()+'no ' + name + ' in agent.conf')
            system.exit(-1)
    return conf_dict[name]


def send_request(url, method, payload='', time_out=30):
    if is_python_2_6:
        service_token = sign_request(url, SERVICE_NAME, INSTANCE_ID)
    else:
        service_token = sign_request(url, MASTOOLS_CWS_SERVICENAME, INSTANCE_ID)
    proxy_httplib2 = get_mastools_proxy_httplib2()
    if proxy_httplib2:
        httpConnection=httplib2.Http(".cache",proxy_info=proxy_httplib2,ca_certs=CERT_BUNDLE_PATH, timeout=time_out)
    else:
        httpConnection=httplib2.Http(".cache",ca_certs=CERT_BUNDLE_PATH, timeout=time_out)
    headers_conn = {'Content-Type':'application/json'}
    headers_conn['Authorization'] = auth_request_header+service_token
    logger.debug(get_logger_header()+url + ";method: " + method)
    legatus_cookie = LEGATUS_AGENT_REQ_COOKIE+'=true'
    content = ''
    if IS_MGMT_TENANT:
        headers_conn['Cookie'] = legatus_cookie+';'+MGMT_TENANT_COOKIE + ':"yes"'
    else:
        headers_conn['Cookie'] = legatus_cookie
    try:
        if payload == '':
            responseStatus, content = httpConnection.request(url, method, headers=headers_conn)
        else:
            responseStatus, content = httpConnection.request(url, method, headers=headers_conn, body=payload)
        if is_python_3:
            content = content.decode("utf-8")
        resp_str = 'responseStatus='+str(responseStatus)+' content='+content
        #logger.debug(get_logger_header()+resp_str)
        #logger.debug(get_logger_header()+content);
        if "status" in responseStatus:
            if responseStatus["status"] == '200' or responseStatus["status"] == '204':
                return True, content
        logger.debug(get_logger_header()+resp_str)
        logger.debug(get_logger_header()+content)
        return False, content
    except Exception as e:
        logger.debug(get_logger_header()+repr(e))
        return False, content

def gen_clour_req_url(uri):
    if is_python_2_6:
        cloud_uri = '/' + CUSTOMER_ID + '/' + SERVICE_NAME + uri;
    else:
        cloud_uri = '/' + CUSTOMER_ID + '/' + MASTOOLS_CWS_SERVICENAME + uri;
    clour_req_url = "https://"+ CLOUD_URL + cloud_uri
    return clour_req_url

def get_agent_conf():
    if not os.path.exists(MASTOOLS_CONF_FILE):
        logger.error(get_logger_header()+' mastools not initialised')
        system.exit(-1)

    with open("/var/mastools/conf/agent.conf", "r+") as agent_conf_file:
        content= agent_conf_file.read()
        agent_conf_file.close()

    agent_conf_dict = xmltodict.parse(content)['mps_agent']
    global CUSTOMER_ID
    global SERVICE_NAME
    global INSTANCE_ID
    global CLOUD_URL
    global IS_MGMT_TENANT
    global DEVICE_PROFILE_NAME
    global IS_VPX
    global IS_BLX

    CUSTOMER_ID = get_param_from_dict('customerid', agent_conf_dict)
    SERVICE_NAME = get_param_from_dict('servicename', agent_conf_dict)
    INSTANCE_ID = get_param_from_dict('instanceid', agent_conf_dict)
    CLOUD_URL = get_param_from_dict('url', agent_conf_dict)
    mgmt_tenant = get_param_from_dict('mgmt_tenant', agent_conf_dict)
    device_profile = get_param_from_dict('profile', agent_conf_dict)
    device_type = get_param_from_dict('type', agent_conf_dict)
    if mgmt_tenant != '':
        IS_MGMT_TENANT = True
    else:
        IS_MGMT_TENANT = False
    if device_profile == '':
        DEVICE_PROFILE_NAME = "mastool_"+INSTANCE_ID+"_profile"
    else:
        DEVICE_PROFILE_NAME = device_profile


    if device_type == '':
        IS_VPX = True
    elif device_type.strip().lower() == 'blx':
        IS_BLX = True
    else:
        IS_VPX = False
        IS_BLX = False

    return

def replace_html_tags(str_input):
    str_temp = str_input.replace("&amp;", "&")
    str_temp = str_temp.replace("&lt;", "<")
    str_temp = str_temp.replace("&gt;", ">")
    str_temp = str_temp.replace("&apos;", "'")
    return str_temp

def get_device_cred(username="", pwd=""):
    global USERNAME
    global PASSWORD
    global LOCAL_CLI_BASE_COMMAND

    USERNAME = username
    PASSWORD = pwd
    LOCAL_CLI_BASE_COMMAND = 'nscli -U '+ LOCAL_LOOPBACK_IP + ':' + USERNAME+':' + PASSWORD
    return

def get_cred(username="", pwd=""):
    get_agent_conf()
    if not IS_MGMT_TENANT:
        get_device_cred(username, pwd)
    return

def get_adc_details():
    try:
        adcInput = sys.stdin.readline()
        adcDetails = base64.b64decode(adcInput.encode('ascii')).decode('ascii')
        return adcDetails
    except Exception as e:
        logger.error('Failed to get ADC details %s' %(str(e)))
        return ""

def _main(argv):
    logger.debug("starting mastools_ha.py")
    adcDetails = get_adc_details()
    adcs_str = adcDetails.split(" ")
    if len(adcs_str) > 1:
        get_cred(adcs_str[0], adcs_str[1])

    secondary_ips = []
    secondary_ips_prev = []

    node_prev_ha_state = ''

    while True:
        if IS_MGMT_TENANT or (not IS_VPX and not IS_BLX):
            time.sleep(ONE_MINUTE*60)
            continue
        node_ha_state, secondary_ips, primary_ip = get_ha_info()
        if node_ha_state == HA_PRIMARY:
            if secondary_ips != secondary_ips_prev:
                logger.info('secondary_ips = ' + repr(secondary_ips))
                logger.info (get_logger_header()+'In applying config to secondary')
                try:
                    copy_file_secondary(secondary_ips)
                    run_mastools_secondary(secondary_ips)
                except Exception as e:
                    secondary_ips_prev = []
                    logger.info (get_logger_header()+'Exception in pushing file or run command on secondary:' + repr(e))
                    time.sleep(ONE_MINUTE)
                    continue
                check_and_fix_snmp_trap_configuration(secondary_ips[0], primary_ip)
                secondary_ips_prev =  secondary_ips
        elif node_prev_ha_state == HA_SECONDARY and node_ha_state == HA_STANDALONE:
            #if a ha secondary node is changed into standalone, it will delete the existing
            #mastools configuration, and stop mastoolsd.
            run_shell_command('rm -f ' + MASTOOLS_CONF_FILE)
            run_shell_command(MASTOOLS_DAEMON_SCRIPT + ' stop')
        node_prev_ha_state = node_ha_state
        time.sleep(ONE_MINUTE)
    sys.exit(0)

def mastools_syncup_secondary(username='', pwd=''):
    get_cred(username, pwd)


    if(USERNAME == '') or (PASSWORD == ''):
        logger.info(get_logger_header_func()+"In mastools_syncup_secondary, unable to get login credential")
        return False, "unable to get login credential"

    node_ha_state, secondary_ips, _ = get_ha_info()
    if node_ha_state == HA_PRIMARY:
        try:
            if not secondary_ips:
                logger.info(get_logger_header_func()+'No secondary IP information, skipping')
                return False, "No secondary IP information"
            logger.info (get_logger_header_func()+'Copying files to secondary:' + repr(secondary_ips))
            copy_file_secondary(secondary_ips)
            run_mastools_secondary(secondary_ips)
            logger.info (get_logger_header_func()+'Done copying files to secondary:' + repr(secondary_ips))
            return True, ""
        except Exception as e:
            logger.info(get_logger_header_func()+'Exception in pushing file or run command on secondary:' + repr(e))
            return False, repr(e)
    return False, "node is not primary"

def set_secondary_ip_admautoreg_state_file(admautoreg_logger, secondary_host):
    try:
        state = ConfigParser.RawConfigParser()
        state.read("/var/tmp/admautoreg.state")
        state.set("AdmAutoReg", "ns_internal_registration_ns_ip", secondary_host)
        with open("/var/tmp/admautoreg.state", 'w') as configfile:
            state.write(configfile)
        admautoreg_logger.info("Set ns_internal_registration_ns_ip to secondary ip in /var/tmp/admautoreg.state")
    except Exception as e:
        admautoreg_logger.error("Failed to ns_internal_registration_ns_ip to secondary ip in /var/tmp/admautoreg.state, with error: {}".format(repr(e)))

def mastools_sync_admautoreg_config(admautoreg_logger, username='', password=''):
    admautoreg_logger.info("in mastools_sync_admautoreg_config()..")
    if (username == '') or (password == ''):
        admautoreg_logger.info("In mastools_syncup_secondary, unable to get login credential")
        return False, "unable to get login credential"
    node_ha_state, secondary_ips, _ = get_ha_info()
    if node_ha_state == HA_PRIMARY:
        try:
            if not secondary_ips:
                admautoreg_logger.info('No secondary IP information, skipping')
                return False, "No secondary IP information"
            admautoreg_logger.info('Copying admautreg config file to secondary:' + repr(secondary_ips))
            for secondary_host in secondary_ips:
                set_secondary_ip_admautoreg_state_file(admautoreg_logger, secondary_host)
                file_transfer_admautoreg_config_file_secondary(admautoreg_logger, secondary_host, username, password)
            admautoreg_logger.info('Done copying admautreg config file to secondary:' + repr(secondary_ips))
            return True, ""
        except Exception as e:
            admautoreg_logger.info('Exception in pushing file or run command on secondary:' + repr(e))
            return False, repr(e)
    return False, "node is not primary"



if __name__ == "__main__":
    sys.exit(_main(sys.argv))