#!/usr/bin/env bash

#if first time init(invoke registration)
#argv1 service url
#argv2 activation code
#example: ./mastools_init_sdwan.sh <service_url> "<activation code>"

mastools_stop()
{
    echo "stop monit"
    pid=`ps -axww | awk '/mastools_monit/ && !/awk/ {print $1}'`
    if [ "$pid" != "" ]; then
        kill -9 $pid
    fi
    echo "stop upgrade"
    pid=`pgrep -f "python mastools_upgrade_sdwan.py"`
    if [ "$pid" != "" ]; then
        kill -9 $pid
    fi
    pid=`pgrep -f "python mastools_ha.py"`
    if [ "$pid" != "" ]; then
        kill -9 $pid
    fi
    echo "stop mastools"
    pid=`pgrep -f "/var/mastools/bin/mastools"`
    if [ "$pid" != "" ]; then
        kill -9 $pid
    fi
}

ha_state="Standalone"
#is_node_primary()
#{
    #TODO: SDWAN changes
#}

exec 2>>/var/mastools/logs/mastools_init.log

LOG=/var/mastools/logs/mastools_init.log


if [ $# != 0  ]; then
    #is_node_primary $1 $2
    if [ "$ha_state" = "Secondary" ]
    then
        echo 'Could not do registration on secondary node, please register on priamry node'
        exit
    fi
    cd /var/mastools/scripts
    mastools_stop
    echo "SD-WAN registration"
    registrationcmd='python mastools_reg_sdwan.py -serviceurl '$1' -activationcode '$2' -inter n'
    $registrationcmd
    unset histfile
fi
returnval=$?
if [ $returnval -ne 0  ]; then
    echo "registration failed. check your activation code"
    exit
fi
value=`cat /var/mastools/version.txt`
echo $value
if [ $value = "0.0-0.0" ]; then
    echo "first time registration, upgrade will download the binary"
    cd /var/mastools/scripts
    python mastools_upgrade_sdwan.py &
    echo 'running upgrade'
else
    echo "re-registration, invoke the binary"
    export LD_LIBRARY_PATH='/var/mastools/lib/';
    /var/mastools/bin/mastools > /var/mastools/logs/mastools.log &
    /bin/sh mastools_monit.sh > /dev/null 2>&1 &
fi
