#!/usr/local/bin/python

import platform

def is_python_2_6_running():
    if platform.python_version().startswith('2.6'):
        return True
    return False

def is_python_2_7_running():
    if platform.python_version().startswith('2.7'):
        return True
    return False

def is_python_3_running():
    if platform.python_version().startswith('3.'):
        return True
    return False

is_python_2_6 = is_python_2_6_running()
is_python_2_7 = is_python_2_7_running()
is_python_3 = is_python_3_running()

if is_python_2_6:
    auth_request_header = 'DNBUAuth service='
else:
    auth_request_header = 'CWSAuth service='

import sys
import time
import os
import errno
import subprocess
import optparse
import traceback
import shlex
#from apps.common.IPUtils  import IPUtils
import binascii
import base64
import string
import getpass
import pwd
import grp
import os.path
import shutil
import base64
import random
from xml.dom import minidom
import socket
import httplib2
import json
import re
import base64
import ast
import argparse
import struct
import hashlib
import xmltodict
import datetime
import urllib

if not is_python_2_6:
    from ccauth import newkeypair
    from cwcUtil import cwcUtil
try:
    sys.path.append(os.path.join(os.path.dirname(__file__), 'admautoreg'))
    from admautoreg.probe import ProbeProxySetting
except:
    pass

if is_python_2_6:
    import ConfigParser as configparser
elif is_python_2_7:
    import ConfigParser as configparser
else:
    import configparser

from mastools_util import running_inside_cpx, running_inside_unicon, is_platform_linux
import cloud_constants as const


AGENT_CONFIG_FILE = '/var/mastools/conf/agent.conf'
PREV_INST_FILE = '/var/mastools/conf/prev_inst'
SDX_VPX_TRAP_CONFIG_FILE = '/var/mastools/conf/sdx_vpx_trap.conf'
MANAGED_DEVICE='managed_device'
MANAGED_DEVICE_URI='/nitro/v1/config/managed_device'
SDX_MANAGED_DEVICE_URI='/nitro/v1/config/nssdx'
SDX_DEVICE_PROFILE_URIMANAGED_DEVICE_FILTER='?filter=ip_address:'
TRUST_KEY_DIR = '/var/mastools/trust/.ssh/'
TMP_DIR = '/var/tmp'
SERVICE_URL = 'agent.netscalermgmt.net'
MGMT_TENANT_COOKIE = '_MGMT_TENANT'
MANAGED_DEVICE_FILTER_INSTANCE='?filter=trust_id:'

DEVICE_PARTITION_SEPERATOR = "-"

CERT_BUNDLE_PATH='/var/mastools/cert/cacert.pem'

VPX_HA_STATE_PREFIX = 'Node:'

VPX_HA_STATE_STANDALONE = 'Standalone'
VPX_HA_STATE_PRIMARY = 'Primary'
VPX_HA_STATE_SECONDARY = 'Secondary'

ADM_ADC_DEVICE_TYPE_VPX_MPX = "ns"
ADM_ADC_DEVICE_TYPE_SDX = "nssdx"
ADM_ADC_DEVICE_TYPE_BLX = "blx"

ADM_ADC_DEVICE_TYPE_VPX_MPX_PROFILE = "ns_device_profile"
ADM_ADC_DEVICE_TYPE_SDX_PROFILE = "nssdx_device_profile"
ADM_ADC_DEVICE_TYPE_BLX_PROFILE = "blx_device_profile"



activation_code_hash256 = "None"
prev_instance_id = "None"

is_sdx = False
is_profile = False
is_blx = False

LEGATUS_AGENT_REQ_COOKIE = 'legatus_agent_request'


CWS_AUTH_SERVICE_NAME = 'netappliance'
CWS_TRUST_PVT_KEY = "/var/mastools/trust/.ssh/privatecws.pem"

SVM_MPS_LIB = '/mps/lib'

NSCLI_CMD = '/netscaler/nscli -U %%:.:.'


# Error Exit-Codes (64-113)
# These exit-codes are used by ADC CLI command to show string error message.
# Please Do not change them and use new ones from the range.
# New exit codes if added for which string error message has to be shown in ADC CLI
# have to be added in ADC netsvc/cfe_dispatch.c function: mastools_systemError2Msg
EXIT_CODE_AGENT_NO_CONNECTIVITY=65
EXIT_CODE_SECONDARY_NODE=66
EXIT_CODE_POST_REQ_FAILURE=67
EXIT_CODE_INVALID_ACTIVATION_CODE=68
EXIT_CODE_INVALID_PREAUTH=69
EXIT_CODE_INVALID_DEVICE_PROFILE=70
EXIT_CODE_DEV_PROFILE_ADD_FAILURE=71

ACTVICATION_CODE_URI = '/nitro/v1/config/trust_preauthtoken/'

OS_FREEBSD = 'freebsd'
OS_LINUX = 'linux'
SUPPORTED_OS = (OS_FREEBSD, OS_LINUX)

CLOUD_SERVICE_FILE = '/mpsconfig/cloudService.properties'
DEFAULT_CLOUD_OPTION = "us"
JP_CLOUD_OPTION = "japan"

#=================For setting up logging ==============================================================================================================
import logging
import logging.handlers

log_file_name_local = os.path.basename(__file__)
LOG_FILENAME = '/var/mastools/logs/' + log_file_name_local + '.log'
LOG_MAX_BYTE = 50*1024*1024
LOG_BACKUP_COUNT = 20

# Set up a specific logger with our desired output level
logger = logging.getLogger(__name__)
logger.setLevel(logging.DEBUG)

# Add the log message handler to the logger
logger_handler = logging.handlers.TimedRotatingFileHandler(LOG_FILENAME, when='m', interval=2, backupCount=LOG_BACKUP_COUNT)
logger_fortmater = logging.Formatter(fmt='%(asctime)s:%(funcName)s:%(lineno)d: [%(levelname)s] %(message)s', datefmt="%Y-%m-%d %H:%M:%S")
logger_handler.setFormatter(logger_fortmater)
logger.addHandler(logger_handler)

if running_inside_unicon():
    logger_handler_stdout = logging.StreamHandler(sys.stdout)
    logger_handler_stdout.setFormatter(logger_fortmater)
    logger.addHandler(logger_handler_stdout)

# ======================================================================================================================================================

# =================For safe command execution +==========================================================================================================
import subprocess, threading, signal

#======================================================================================================================================================

import contextlib



class Namespace:
    def __init__(self, **kwargs):
        self.__dict__.update(kwargs)

def cli_exec(clicmd):
    try:
        cmd = NSCLI_CMD + ' "' + clicmd + '"'
        cliOutput = subprocess.check_output(shlex.split(cmd), stderr=subprocess.STDOUT)
        if is_python_3:
            cliOutput = cliOutput.decode("utf-8")
        return cliOutput.split(" Done\n")[1]
    except Exception as e:
        logger.error("Error in using nscli stealth mode executing command:"+clicmd+"exception:%s"+repr(e))
        return ''
        
def shell_exec(shellCmd):
    try:
        cmdOutput = subprocess.check_output(shlex.split(shellCmd), stderr=subprocess.STDOUT)
        if is_python_3:
            cmdOutput = cmdOutput.decode("utf-8")
        return cmdOutput
    except Exception as e:
        logger.error("Error in using nscli stealth mode executing command:"+shellCmd+"exception:%s"+repr(e))
        return ''

def get_os_info():
    return shell_exec("uname -a")
    
def is_supported_os():
    os_info = get_os_info().lower()
    for os_name in SUPPORTED_OS:
        if os_name in os_info:
            return True
    return False
        

def is_platform_sdx():
    if os.path.exists(SVM_MPS_LIB):
        return True
    return False

def is_connector():
    if running_inside_cpx():
        return 0

    if is_platform_linux():
        return 0
        
    cmd = "sysctl -n netscaler.is_ngs_connector"
    try:
        output = subprocess.check_output(shlex.split(cmd))
        if is_python_3:
            output = output.decode("utf-8")
        logger.debug("is_connector, return:" + output)
        return int(output.strip())
    except Exception as e:
        logger.debug("exception in is_connector, error:"+ repr(e))
        return 0

def get_proxy_setting():
    try:
        if (not is_connector()) and (not is_platform_sdx()):
            mastools_proxy_setting = ProbeProxySetting()
            mastools_proxy_setting.refresh_callhome_proxy_settings()
            return mastools_proxy_setting
    except Exception as e:
        logger.debug("exception in get_mastools_setting, error:"+ repr(e))

    return None


def get_mastools_proxy_httplib2():
    try:
        proxy_setting = get_proxy_setting()
        if proxy_setting and proxy_setting.ipaddress and proxy_setting.port:
            logger.debug("get_mastools_proxy_httplib2, proxy ip = " + proxy_setting.ipaddress + ", proxy_port = "+ str(proxy_setting.port))
            return httplib2.ProxyInfo(httplib2.socks.PROXY_TYPE_HTTP_NO_TUNNEL, proxy_setting.ipaddress,proxy_setting.port)
    except Exception as e:
        logger.debug("exception in get_mastools_proxy, error:"+ repr(e))

    return None

def get_mastools_proxy_requests():
    if is_platform_sdx():
        return None
    try:
        proxy_setting = get_proxy_setting()
        if proxy_setting:
            return proxy_setting.get_proxies_dict()
    except Exception as e:
        logger.debug("exception in get_mastools_proxy, error:"+ repr(e))
    return None

def hash_activation_code(service_activation_code):
    global activation_code_hash256
    if (';' in service_activation_code):
        preauth_service = service_activation_code.split(";")
        activation_code = preauth_service[1]
    else:
        activation_code = service_activation_code
    activation_code_hash256 = hashlib.sha256(activation_code.encode('utf-8')).hexdigest()
    return

def get_logger_header():
    logger_str = "[mastools_registration_"+activation_code_hash256+"]"
    return logger_str

@contextlib.contextmanager
def cd_local(newPath):
    savedPath = os.getcwd()
    os.chdir(newPath)
    yield
    os.chdir(savedPath)

def get_date_string():
    rpt_sample_time = int(time.time())
    s = time.strftime("%d%b%Y_%H_%M", time.localtime() )
    if not s :
        s = str(rpt_sample_time)

    return s


def get_auth_service_name(servicename):
    if is_python_2_6:
        return servicename
    return CWS_AUTH_SERVICE_NAME


def run_command(cmd):
    args = shlex.split(cmd)
    FNULL = open(os.devnull, 'w')
    subprocess.call(args, stdout=FNULL, stderr=subprocess.STDOUT)
    FNULL.close()

def run_command_special(basic, cmd):
    args = shlex.split(basic.encode('ascii'))
    args.append(cmd.encode('ascii'))
    FNULL = open(os.devnull, 'w')
    subprocess.call(args, stdout=FNULL, stderr=subprocess.STDOUT)
    FNULL.close()

def read_command_output(cmd, cmd_str = None):
    args = shlex.split(cmd.encode('ascii'))
    if cmd_str:
        args.append(cmd_str.encode('ascii'))
    FNULL = open(os.devnull, 'w')
    process = subprocess.Popen(args, stdout=subprocess.PIPE, stderr=FNULL)
    FNULL.close()
    output = process.communicate()
    return output[0]

def is_vpx_secondary():
    global is_device_ha_primary
    is_device_ha_primary = False

    cmd_str = "show ns config | grep 'Node:' "
    node_ha_state = cli_exec(cmd_str)
    logger.debug(get_logger_header()+"node_ha_state = "+ node_ha_state)
    ha_state = node_ha_state.split(VPX_HA_STATE_PREFIX)[1]
    if ha_state.strip().startswith(VPX_HA_STATE_SECONDARY):
        return True
    if ha_state.strip().startswith(VPX_HA_STATE_PRIMARY):
        is_device_ha_primary = True
        logger.debug("is_device_ha_primary is true")
    return False

def run_mastools_syncup_secondary(user_name='', pwd=''):
    logger.debug("Start running run_mastools_syncup_secondary: ")
    print("Started copying files from primary to secondary")

    import mastools_ha
    try:
        state, err_msg = mastools_ha.mastools_syncup_secondary(user_name, pwd)
    except Exception as e:
        logger.debug("Exceptions in run_mastools_syncup_secondary: " + repr(e))
        return

    if state:
        print("Successfully copied the files to secondary")
        logger.debug("Successfully copied the files to secondary")
    else:
        print("Error in copying the files to secondary, error message:" + err_msg)
        logger.debug("Error in copying the files to secondary, message" + err_msg)
    return

def sign_request(url, servicename, instanceid):
    if is_python_2_6:
        return sign_request_DNBU(url, servicename, instanceid)
    else:
        return sign_request_cc_cloud(url, servicename, instanceid)

def sign_request_cc_cloud(url, servicename, instanceid):
    auth_service_name = get_auth_service_name(servicename)
    cwc_util_args =  Namespace(targetURL=url, serviceName=auth_service_name, instanceid=instanceid, version='v2')
    service_token =  cwcUtil().getCWSServiceKey(cwc_util_args)
    return service_token

def sign_request_DNBU(url, servicename, instanceid):
    tmp_inp_file = TMP_DIR + "inp_comp_url_tmp"
    tmp_sha_file = TMP_DIR + "tmp_sha_output"
    f = open(tmp_inp_file, 'w')
    f.write(url)
    f.close()

    read_command_output("openssl dgst -sha256 -sign " + TRUST_KEY_DIR + "private.pem -out "+ tmp_sha_file +" "+ tmp_inp_file);
    signature = read_command_output("openssl base64 -in "+tmp_sha_file);
    signature = signature.replace("\r\n","")
    signature = signature.replace("\n","")

    if os.path.exists(tmp_inp_file):
        os.remove(tmp_inp_file)
    if os.path.exists(tmp_sha_file):
        os.remove(tmp_sha_file)
    token = signature + ";" + servicename + ";" + instanceid;
    service_token = base64.b64encode(token);
    return service_token



def send_request(url, servicename, instanceid, method, payload, time_out=0,legatus = False):
    service_token = sign_request(url, servicename, instanceid)
    if time_out == 0:
        if mastools_proxies_httplib2:
            httpConnection=httplib2.Http(".cache", proxy_info=mastools_proxies_httplib2, ca_certs=CERT_BUNDLE_PATH)
        else:
            httpConnection=httplib2.Http(".cache",ca_certs=CERT_BUNDLE_PATH)
    else:
        if mastools_proxies_httplib2:
            httpConnection=httplib2.Http(".cache", proxy_info=mastools_proxies_httplib2, ca_certs=CERT_BUNDLE_PATH, timeout=time_out)
        else:
            httpConnection=httplib2.Http(".cache",ca_certs=CERT_BUNDLE_PATH, timeout=time_out)
    headers_conn = {'Content-Type':'application/json'}
    headers_conn['Authorization'] = auth_request_header+service_token
    logger.debug(get_logger_header()+url + ";method: " + method)
    if is_mgmt_tenent:
        headers_conn['Cookie'] = MGMT_TENANT_COOKIE + ':"yes"'
    if is_mgmt_tenent_dev:
        headers_conn['Cookie'] = MGMT_TENANT_COOKIE + ':"dev"'
    if legatus:
        legatus_cookie = LEGATUS_AGENT_REQ_COOKIE+'=true'
        if 'Cookie' in headers_conn:
            headers_conn['Cookie'] = legatus_cookie+';'+headers_conn['Cookie']
        else:
            headers_conn['Cookie'] = legatus_cookie
    try:
        if payload == '':
            responseStatus, content = httpConnection.request(url, method, headers=headers_conn)
        else:
            responseStatus, content = httpConnection.request(url, method, headers=headers_conn, body=payload)
        content = content.decode()
        resp_str = 'responseStatus='+str(responseStatus)+' content='+content
        if not legatus:
            logger.debug(get_logger_header()+resp_str)
    except Exception as e:
        logger.debug(get_logger_header()+ repr(e))
        return repr(e)

    if not legatus:
        logger.debug(get_logger_header()+content)
    return content;

def get_activation_json(ip, customer, service, instance):
    auth_service_name = get_auth_service_name(servicename)
    url = "https://" + ip + "/" + customer + "/" + auth_service_name + ACTVICATION_CODE_URI + customer
    contents = send_request(url, auth_service_name, instance, "GET", "", 180)
    activation_code_json = {}

    try:
        resp_json = json.loads(contents)
        trust_auth_list = resp_json['trust_preauthtoken']
        activation_code_json = trust_auth_list[0]
    except Exception as e:
        logger.debug(get_logger_header()+"Error in get_activation_json")
    return activation_code_json

def print_gen_activation_code(activation_code_json):
    try:
        activation_code_msg = "backup service url:"+activation_code_json["api_gateway_url"]+"\nbackup activation code:"+activation_code_json["token"]
    except Exception as e:
        activation_code_msg = "Not able to generate the backup service url and activation code"
    print (activation_code_msg)
    return

def generate_backup_activation_code(ip, customer, service, instance):
    if is_mgmt_tenent or is_mgmt_tenent_dev:
        return
    activation_code_json = get_activation_json(ip, customer, service, instance)
    print_gen_activation_code(activation_code_json)
    return

def get_region_from_cloudurl(cloudurl):
    if cloudurl.lower().endswith(".jp"):
        return JP_CLOUD_OPTION
    return DEFAULT_CLOUD_OPTION

def create_cloudservice_conf_file(cloudurl):
    try:
        config = configparser.ConfigParser()

        region = get_region_from_cloudurl(cloudurl).lower()
        if region == DEFAULT_CLOUD_OPTION:
            return

        if os.path.exists(CLOUD_SERVICE_FILE):
            config.read(CLOUD_SERVICE_FILE)

        if config.has_section('region'):
            if config.get('region', 'cloudOption', fallback=None) == region:
                return
        else:
            config.add_section('region')
        config.set('region', 'cloudOption', region)

        with open(CLOUD_SERVICE_FILE, 'w') as file:
            config.write(file)
        logger.debug("Cloud service conf file created successfully, region is set to %s" % region)
    except Exception as e:
        logger.error("Failed to create cloud service conf file, error: %s" % str(e))

def create_agent_conf_file(uuid, customerid, instanceid, iscloud, cloudurl, servicename, ads_service_type, download_service_url,
                           docker_host_ip="", device_profile="",):
    logger.debug(get_logger_header()+"In create_agent_conf_file\n")
    if os.path.exists(AGENT_CONFIG_FILE):
        os.remove(AGENT_CONFIG_FILE)
    fileContents='<?xml version="1.0" encoding="UTF-8" standalone="no"?>\n<mps_agent>\n\t'
    fileContents=fileContents+"<uuid>" + uuid + "</uuid>\n\t<ads_service_type>"  + ads_service_type + "</ads_service_type>\n\t<url>"+cloudurl+"</url>\n\t<customerid>"+customerid+"</customerid>\n\t<instanceid>"+instanceid+"</instanceid>\n\t<servicename>"+servicename+"</servicename>"
    fileContents=fileContents+"\n\t<download_service_url>"+download_service_url+"</download_service_url>\n\t<abdp_url>"+cloudurl+"</abdp_url>\n\t<msg_router_url>"+cloudurl+"</msg_router_url>"
    if is_mgmt_tenent:
        fileContents=fileContents+"\n\t<mgmt_tenant> yes </mgmt_tenant>"
    if is_mgmt_tenent_dev:
        fileContents=fileContents+"\n\t<mgmt_tenant> dev </mgmt_tenant>"
    if is_sdx:
        fileContents=fileContents+"\n\t<type> sdx </type>"
    if is_blx:
        fileContents=fileContents+"\n\t<type> blx </type>"
    if is_profile:
        fileContents = fileContents+"\n\t<profile>"+device_profile+"</profile>"
    if docker_host_ip:
        fileContents = fileContents + "\n\t<docker_host_ip>" + docker_host_ip + "</docker_host_ip>"
    fileContents = fileContents + "\n</mps_agent>"
    file = open(AGENT_CONFIG_FILE, "w+")
    file.write(fileContents)
    os.chmod(AGENT_CONFIG_FILE, 0o600)
    os.chown(AGENT_CONFIG_FILE, pwd.getpwnam('root').pw_uid, pwd.getpwnam('root').pw_gid)
    file.close()

    create_cloudservice_conf_file(cloudurl)

def write_sdx_vpx_trap_default_conf():
    file = open(SDX_VPX_TRAP_CONFIG_FILE, "w+")
    file.write("")
    file.close()
    return


def getMyIpAddress(cloudurl):
    s = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)
    try:
        s.connect((cloudurl, 80))
        agentIpAddress=s.getsockname()[0]
        s.close()
        return agentIpAddress
    except:
        agentNoConnectivity = """----------------------------------------------------------------------------
The agent failed to connect server
----------------------------------------------------------------------------"""
        print (agentNoConnectivity)
        sys.exit(EXIT_CODE_AGENT_NO_CONNECTIVITY)

def set_prev_instance_id():
    logger.debug(get_logger_header()+"In set_prev_instance_id ")
    global prev_instance_id

    prev_instance_id = ""
    if not os.path.exists("/var/mastools/conf/agent.conf"):
        return

    with open("/var/mastools/conf/agent.conf", "r+") as agent_conf_file:
        CONTENT= agent_conf_file.read()
        agent_conf_file.close()

    AGENT_CONF_DICT = xmltodict.parse(CONTENT)['mps_agent']
    if 'instanceid' in AGENT_CONF_DICT.keys():
        prev_instance_id = AGENT_CONF_DICT['instanceid']
    if prev_instance_id:
        file = open(PREV_INST_FILE, "w+")
        file.write(prev_instance_id)
        file.close()
    return


def create_sdx_vpx_profile(url, service,instance, payload):
    service = 'netappliance'
    send_request(url, service, instance, "POST", payload, 60)
    return


def encode_to_base64(n):
    data = struct.pack('<Q', n).rstrip('\x00')
    if len(data)==0:
        data = '\x00'
    s = base64.urlsafe_b64encode(data).rstrip('=')
    return s

def get_time_difference():
    epoch = time.time()
    epoch_time_local = datetime.datetime.fromtimestamp(epoch)
    epoch_time_utc = datetime.datetime.utcfromtimestamp(epoch)
    offset = epoch_time_local - epoch_time_utc
    return offset



def agent_time_sync(utc_servert_time_string):
    logger.debug("%s Setting Server Time : %s, for agent", get_logger_header(), utc_servert_time_string)
    offset = get_time_difference()
    utc_server_time = time.strptime(utc_servert_time_string, "%a, %d %b %Y %H:%M:%S GMT")
    utc_server_date_time = datetime.datetime.fromtimestamp(time.mktime(utc_server_time))
    local_time_date_time = utc_server_date_time + offset
    local_time = local_time_date_time.timetuple()
    hour = str(local_time.tm_hour).zfill(2)
    minute = str(local_time.tm_min).zfill(2)
    day = str(local_time.tm_mday).zfill(2)
    month = str(local_time.tm_mon).zfill(2)
    try:
        date_cmd = "date " + str(local_time.tm_year) + month + day + hour + minute + " > /dev/null 2>&1"
        logger.debug(get_logger_header()+"set cmd local time: " + date_cmd)
        subprocess.check_output(date_cmd)
    except Exception as e:
        logger.error(get_logger_header()+"Exception in setting mastools's timestamp to server's time: "+e)
    return

def gen_device_profile_payload(device_profile_name, user_name, pwd, device_type='ns', sdx_vpx_profile_name= ""):
    payload_json = {}
    payload_json['name'] = device_profile_name
    payload_json['type'] = device_type
    payload_json['username'] = user_name
    payload_json['password'] = pwd
    payload_json['is_default'] = 'false'
    payload_json['ssh_port'] = '22'
    payload_json['use_global_setting_for_communication_with_ns'] = "true"
    payload_json['svm_ns_comm'] = "http"
    payload_json['snmpcommunity'] = "public"
    payload_json_object = {}
    if device_type == ADM_ADC_DEVICE_TYPE_VPX_MPX:
        payload_json['snmpversion'] = "v2"
        payload_json['snmpsecurityname'] = ""
        payload_json['snmpsecuritylevel'] = "NoAuthNoPriv"
        payload_json['snmpauthprotocol'] = "MD5"
        payload_json['snmpauthpassword'] = ""
        payload_json['snmpprivprotocol'] = "DES"
        payload_json['snmpprivpassword'] = ""
        payload_json_object[ADM_ADC_DEVICE_TYPE_VPX_MPX_PROFILE] = payload_json
    elif device_type == ADM_ADC_DEVICE_TYPE_SDX:
        payload_json['ns_profile_name'] = sdx_vpx_profile_name
        payload_json_object[ADM_ADC_DEVICE_TYPE_SDX_PROFILE] = payload_json
    elif device_type == ADM_ADC_DEVICE_TYPE_BLX:
        payload_json_object[ADM_ADC_DEVICE_TYPE_BLX_PROFILE] = payload_json
    else:
        logger.error(get_logger_header()+"gen_device_profile_payload: Unknown device type:"+device_type)
    return payload_json_object

def gen_urllib_quote(json_dump_str):
    if is_python_3:
        return urllib.parse.quote(json_dump_str)
    else:
        return urllib.quote(json_dump_str)


def agent_selection_handler(deployment_type,caller_script,args,is_auto_reg_req=False):
    if ((caller_script=='mas')):
        node_name = 'NetScaler Agent'
        public_key_xml = ""
        header_print = """\n------------------------------------------------------------------------------------------------------------------------
""" + node_name + """ Configuration. This menu allows you to specify a cloud url and obtain an instance ID for your device.
------------------------------------------------------------------------------------------------------------------------"""
        if is_auto_reg_req :
            logger.debug(get_logger_header()+header_print)
        else:
            print (header_print)
        servicename = ""
        ip_address = ""
        interMode = args.interactive
        username = args.username
        if (interMode == 'y'):
            password = getpass.getpass('Password:')
        else:
            password = args.password


        global is_mgmt_tenent
        is_mgmt_tenent = False
        global is_mgmt_tenent_dev
        is_mgmt_tenent_dev = False

        if args.ngskey:
            is_mgmt_tenent = True
        if args.ngsdevkey:
            is_mgmt_tenent_dev = True

        if not is_sdx:
            if not is_mgmt_tenent and not is_mgmt_tenent_dev:
                if is_vpx_secondary():
                    error_msg = "Mastools registration could not be done on secondary node, please run the registration command on primary node"
                    logger.debug(get_logger_header()+error_msg)
                    sys.exit(EXIT_CODE_SECONDARY_NODE)



        global mastools_proxies_httplib2
        mastools_proxies_httplib2 = get_mastools_proxy_httplib2()


        while True:
            if is_auto_reg_req:
                if args.serviceurl:
                    ip_address=args.serviceurl
                else:
                    ip_address=SERVICE_URL
            else:
                ip_address = raw_input("""    Enter Service URL: """)
            if ip_address :
                if mastools_proxies_httplib2:
                    http_conn_fetch=httplib2.Http(".cache", proxy_info=mastools_proxies_httplib2, ca_certs=CERT_BUNDLE_PATH)
                else:
                    http_conn_fetch=httplib2.Http(".cache", ca_certs=CERT_BUNDLE_PATH)
                fetch_url = "https://" + ip_address + "/fetch_urls";
                trust_url = ""
                server_time = ""
                download_service_url = ""
                logger.debug("%s fetch_url: %s, trying to fetch trust url", get_logger_header(), fetch_url)
                try:
                    resp_preauth, content_preauth =  http_conn_fetch.request(fetch_url, "GET")
                    content_preauth = content_preauth.decode()
                    if (resp_preauth['status'] == '200'):
                        download_service_url = content_preauth.split(';')[0]
                        download_service_url = download_service_url.strip('\"')
                        trust_url = content_preauth.split(';')[1]
                        trust_url = trust_url.rstrip()
                        trust_url = trust_url.strip('\"')
                        logger.debug("%s Trust URL : %s, got result sucessfull", get_logger_header(), trust_url)
                        logger.debug("%s download_service_url URL : %s, got result sucessfull", get_logger_header(), download_service_url)
                        if (len(content_preauth.split(';')) > 2):
                            server_time = content_preauth.split(';')[2]
                            agent_time_sync(server_time)
                        break;
                    else:
                        invalidpreauth = """----------------------------------------------------------------------------\nFailed to get Trust URL from Gateway\n----------------------------------------------------------------------------"""
                        logger.error(get_logger_header()+invalidpreauth)
                        print (invalidpreauth)
                except KeyboardInterrupt:
                    logger.debug(get_logger_header()+"Keyboard Interrupt Exception occured !!")
                    print("Keyboard Interrupt Exception occured !!")
                    sys.exit(-1)
                except Exception as e:
                    logger.debug("%s Exception occured while post request url %s", get_logger_header(), fetch_url)
                    errMsg="    Please check if the DNS server is configured !! Exception %s" + str(e)
                    logger.error(get_logger_header()+errMsg)
                    print(errMsg)
                    sys.exit(EXIT_CODE_POST_REQ_FAILURE)
        if args.ngskey or args.ngsdevkey:
            print ("generating ngs trust key directory")
            if args.ngskey:
                is_mgmt_tenent = True
            if args.ngsdevkey:
                is_mgmt_tenent_dev = True
            run_command("rm -rf /var/mastools/trust/.ssh/")

            run_command("mkdir -p /var/mastools/trust/.ssh/")
            run_command("cp /nsconfig/ssl/ns-ngsconnector.key /var/mastools/trust/.ssh/private.pem ")
            f = open(TRUST_KEY_DIR + "private.pem","r")
            private_key = f.read()
            f.close()
            #Checking if key is in XML format, if not then change it to XML format
            if private_key.find("BEGIN RSA PRIVATE KEY") >= 0:
                cwcUtil().createCWSPrivateKey()
                time.sleep(5)
            if os.path.exists(CWS_TRUST_PVT_KEY):
                run_command("mv /var/mastools/trust/.ssh/privatecws.pem /var/mastools/trust/.ssh/private.pem")
            pub_key = read_command_output("openssl x509 -inform der -noout -in /nsconfig/ssl/ns-ngsconnector.der -pubkey")
            pubkey_file = open("/var/mastools/trust/.ssh/public.pem", "w")
            print >>pubkey_file, pub_key
            pubkey_file.close()
            output_1 = read_command_output("openssl rsa -pubin -in /var/mastools/trust/.ssh/public.pem -modulus -noout")
            time.sleep(5)
            output_2 = read_command_output("openssl rsa -pubin -in /var/mastools/trust/.ssh/public.pem -modulus -text")
            time.sleep(5)
            modulus = output_1[8:]
            modulus = modulus.strip()
            modulus = binascii.b2a_base64(modulus.decode("hex"))
            array = output_2.split("Exponent: ");
            exponent = array[1].split('(')[0]
            exponent = encode_to_base64(int(exponent))
            public_key_xml = "<RSAKeyValue><Modulus>" + modulus + "</Modulus><Exponent>" + exponent + "</Exponent></RSAKeyValue>"
            public_key_xml = base64.b64encode(public_key_xml)
            pubkey_file = open("/var/mastools/trust/.ssh/public.pem", "w")
            pubkey_file.write(public_key_xml)
            pubkey_file.close()
        else:
            logger.debug (get_logger_header()+"generating trust key directory")
            run_command("rm -rf /var/mastools/trust/.ssh/")
            time.sleep(5)
            run_command("mkdir -p /var/mastools/trust/.ssh/")
            time.sleep(5)
            if is_python_2_6:
                run_command("openssl genrsa -out /var/mastools/trust/.ssh/private.pem 2048 >/dev/null 2>&1")
                time.sleep(5)
                run_command("openssl rsa -in /var/mastools/trust/.ssh/private.pem -outform PEM -pubout -out /var/mastools/trust/.ssh/public.pem")
                time.sleep(5)
                output_1 = read_command_output("openssl rsa -pubin -in /var/mastools/trust/.ssh/public.pem -modulus -noout")
                time.sleep(5)
                output_2 = read_command_output("openssl rsa -pubin -in /var/mastools/trust/.ssh/public.pem -modulus -text")
                time.sleep(5)
                modulus = output_1[8:]
                modulus = modulus.strip()
                modulus = binascii.b2a_base64(modulus.decode("hex"))
                array = output_2.split("Exponent: ");
                exponent = array[1].split('(')[0]
                exponent = encode_to_base64(int(exponent))
                public_key_xml = "<RSAKeyValue><Modulus>" + modulus + "</Modulus><Exponent>" + exponent + "</Exponent></RSAKeyValue>"
                public_key_xml = base64.b64encode(public_key_xml)
            else:
                (public_key, private_key) = newkeypair()
                f_private = open("/var/mastools/trust/.ssh/private.pem", "w")
                f_private.write(private_key)
                f_private.close()
                f_public = open("/var/mastools/trust/.ssh/public.pem", "w")
                f_public.write(public_key)
                f_public.close()
                time.sleep(5)
        try:
            run_command("chmod 600 /var/mastools/trust/.ssh/private.pem")
        except:
            logger.debug(get_logger_header()+"Exception occured while assigning permissions")
        try:
            if not is_python_2_6:
                f = open("/var/mastools/trust/.ssh/public.pem","r")
                public_key_xml = f.read()
                f.close()
        except:
            logger.debug(get_logger_header()+"Exception occured while opening public key file")

        while True:
            servicename = ""
            preauth_service = ""
            preauth_token = ""
            while True:
                if args.activationcode:
                    preauth_token = args.activationcode
                else:
                    preauth_token = raw_input("""    Enter Activation Code : """)
                deployment = "Dev"
                if ip_address == "agent.netscalermgmt.net" or ip_address.endswith(const.NETWORK_TEST_EP) or ip_address.endswith(const.JP_NETWORK_TEST_EP) or ip_address.endswith(const.GOV_NETWORK_TEST_EP):
                    servicename = "MAS"
                    deployment = "Production"
                elif ip_address == "apigw.netscalermgmtstaging.net" or ip_address.endswith(const.STAGING_NETWORK_TEST_EP) or ip_address.endswith(const.JPSTAGING_NETWORK_TEST_EP) or ip_address.endswith(const.GOVSTAGING_NETWORK_TEST_EP):
                    servicename = "MAS"
                    deployment = "Staging"
                if preauth_token and (servicename != "" or ';' in preauth_token):
                    break
                else :
                    invalidcode = """----------------------------------------------------------------------------\nInvalid Activation code. Please try again.\n----------------------------------------------------------------------------"""
                    logger.error(get_logger_header()+invalidcode)
                    print (invalidcode)
                    sys.exit(EXIT_CODE_INVALID_ACTIVATION_CODE)
            if (';' in preauth_token):
                preauth_service = preauth_token.split(";")
                servicename = preauth_service[0]
                preauth_token = preauth_service[1]
            payload_preauth = '{"preauthtoken":"' + preauth_token + '","signingkey":"' + public_key_xml + "\"}";
            if mastools_proxies_httplib2:
                http_conn_preauth=httplib2.Http(".cache",proxy_info=mastools_proxies_httplib2,ca_certs=CERT_BUNDLE_PATH)
            else:
                http_conn_preauth=httplib2.Http(".cache",ca_certs=CERT_BUNDLE_PATH)
            headers_preauth = {'Content-Type':'application/json'}
            url_preauth = "https://" + trust_url + "/root/trust/v1/identity";
            try:
                resp_preauth, content_preauth =  http_conn_preauth.request(url_preauth, "POST", headers=headers_preauth, body=payload_preauth)
                if (resp_preauth['status'] == '200'):
                    logger.debug("%s Server IP: %s, got result successfully", get_logger_header(), ip_address)
                    json_data_preauth = json.loads(content_preauth)
                    logger.debug("%s return = %s", get_logger_header(), str(json_data_preauth))
                    if (json_data_preauth['status'] == "success"):
                        instanceid = json_data_preauth['instanceid']
                        customerid = json_data_preauth['customerid']
                        resourcelocation = json_data_preauth['resourcelocation']
                        break
                    else:
                        invalidpreauth = """----------------------------------------------------------------------------\nFailed to get Instance ID. Please re-enter Activation code.\n----------------------------------------------------------------------------"""
                        logger.error(get_logger_header()+invalidpreauth)
                        print (invalidpreauth)
                        sys.exit(EXIT_CODE_INVALID_PREAUTH)
            except KeyboardInterrupt:
                logger.debug(get_logger_header()+"Keyboard Interrupt Exception occured !!")
                print ("Keyboard Interrupt Exception occured !!")
                sys.exit(-1)
            except Exception as e:
                logger.debug("%s Exception occured while post request url %s, payload %s", get_logger_header(), url_preauth, payload_preauth)
                dnserror="    Please check if the DNS server is configured !! exception string" + str(e)
                logger.error(get_logger_header()+dnserror)
                print(dnserror)
                sys.exit(EXIT_CODE_POST_REQ_FAILURE)

        auth_service_name = get_auth_service_name(servicename)
        ads_service_type = 'ADM'
        try:
            headers_conn = {'Content-Type':'application/json'}
            if is_mgmt_tenent:
                headers_conn['Cookie'] = MGMT_TENANT_COOKIE + ':"yes"'
            if is_mgmt_tenent_dev:
                headers_conn['Cookie'] = MGMT_TENANT_COOKIE + ':"dev"'
            if mastools_proxies_httplib2:
                http_conn_fetch=httplib2.Http(".cache", proxy_info=mastools_proxies_httplib2, ca_certs=CERT_BUNDLE_PATH)
            else:
                http_conn_fetch=httplib2.Http(".cache", ca_certs=CERT_BUNDLE_PATH)
            http_conn_fetch.follow_all_redirects = True
            try:
                fetch_url = "https://" + ip_address + "/" + servicename + "/" + customerid + "/nitro/v1/config/adm_deployment";
                logger.debug("%s fetch_url: %s, trying to fetch ads_service_type url", get_logger_header(), fetch_url)
                resp_fetchurl, content_fetchurl = http_conn_fetch.request(fetch_url, "GET", headers=headers_conn)
                if (resp_fetchurl['status'] == '200'):
                    ads_service_type = json.loads(content_fetchurl)['adm_deployment'][0]['ads_service_type']
            except Exception as e:
                logger.error('Failed to get ads_service_type, message: %s',str(e))
            fetch_url = "https://" + ip_address + "/" + servicename + "/" + customerid + "/fetch_urls";
            logger.debug("%s fetch_url: %s, trying to fetch app server url", get_logger_header(), fetch_url)
            headers_conn.update({'ADS_SERVICE_TYPE':ads_service_type})
            resp_fetchurl, content_fetchurl =  http_conn_fetch.request(fetch_url, "GET", headers=headers_conn)
            if (resp_fetchurl['status'] == '200'):
                app_server_url = ""
                responseData = json.loads(content_fetchurl)
                app_server_url = responseData['service_url']
                logger.debug("%s app server fetchURL : %s, got result sucessfull", get_logger_header(), app_server_url)
                ip_address = app_server_url
            else:
                logger.error(get_logger_header()+"fetch url return error")
        except KeyboardInterrupt:
            logger.debug(get_logger_header()+"Keyboard Interrupt Exception occured !!")
            print ("Keyboard Interrupt Exception occured !!")
            sys.exit(-1)
        except Exception as e:
            logger.debug("%s Exception occured while post request fetch url for app server %s", get_logger_header(), fetch_url)
            logger.debug(str(e))

        if is_profile:
            if not is_sdx:
                if args.ngskey or args.ngsdevkey:
                    PEStr_cmd = 'set cloud parameter -InstanceID '+instanceid+' -CustomerID '+customerid+' -ResourceLocation '+resourcelocation+' -Deployment '+deployment
                else:
                    PEStr_cmd = 'set cloud parameter -InstanceID '+instanceid+' -CustomerID '+customerid+' -Deployment '+deployment
                cli_exec(PEStr_cmd)
            if is_blx:
                create_agent_conf_file("temp_str", customerid, instanceid, "true", ip_address, servicename, ads_service_type,
                                   download_service_url, "", args.profile)
            else:
                create_agent_conf_file("temp_str", customerid, instanceid, "true", ip_address, servicename, ads_service_type,
                                   download_service_url, "", args.profile)
            if (not is_sdx) and is_device_ha_primary:
                if is_blx:
                    logger.debug(get_logger_header()+"File transfer to secondary node will be initiated after registration is complete.")
                    print ("File transfer to secondary node will be initiated after registration is complete.")
                else:
                    time.sleep(15)
                    run_mastools_syncup_secondary()
            footer_print = """----------------------------------------------------------------------------
NetScaler Console Tools successfully registered.
----------------------------------------------------------------------------"""
            logger.debug(get_logger_header()+footer_print)
            print (footer_print)
            return deployment_type
        else:
            if running_inside_cpx():
                create_agent_conf_file("temp_str", customerid, instanceid, "true", ip_address, servicename,ads_service_type,
                                       download_service_url, args.dockerhostip)
            else:
                create_agent_conf_file("temp_str", customerid, instanceid, "true", ip_address, servicename,ads_service_type,
                                       download_service_url)

        if is_blx:
            device_profile_name = 'mastool_blx_'+instanceid+'_profile'
        elif not is_sdx:
            device_profile_name = 'mastool_'+instanceid+'_profile'
        else:
            device_profile_name = 'mastool_sdx_'+instanceid+'_profile'
            device_profile_vpx_name = 'mastool_sdx_vpx_'+instanceid+'_profile'
            vpx_username = getpass.getpass('Vpx Username:')
            print (vpx_username)
            vpx_password = getpass.getpass('Vpx Password:')
            sdx_vpx_device_profile_payload = gen_device_profile_payload(device_profile_vpx_name, vpx_username, vpx_password)
            sdx_vpx_payload = 'object='+gen_urllib_quote(json.dumps(sdx_vpx_device_profile_payload))
            sdx_device_profile_payload = gen_device_profile_payload(device_profile_name, username, password, ADM_ADC_DEVICE_TYPE_SDX, device_profile_vpx_name)

        method = 'POST'
        url = 'https://' + ip_address + "/" + customerid + "/" + auth_service_name + "/nitro/v1/config"
        vpx_url = url + "/ns_device_profile"
        if is_blx:
            url = url + "/blx_device_profile"
            payload_json_object = gen_device_profile_payload(device_profile_name, username, password, ADM_ADC_DEVICE_TYPE_BLX)
            payload = 'object='+gen_urllib_quote(json.dumps(payload_json_object))
        elif not is_sdx:
            url = vpx_url
            payload_json_object = gen_device_profile_payload(device_profile_name, username, password)
            payload = 'object='+gen_urllib_quote(json.dumps(payload_json_object))

        else:
            url = url + "/nssdx_device_profile"
            payload = 'object='+gen_urllib_quote(json.dumps(sdx_device_profile_payload))

            create_sdx_vpx_profile(vpx_url, auth_service_name,instanceid, sdx_vpx_payload)
        if mastools_proxies_httplib2:
            httpConnection=httplib2.Http(".cache",proxy_info=mastools_proxies_httplib2,ca_certs=CERT_BUNDLE_PATH)
        else:
            httpConnection=httplib2.Http(".cache",ca_certs=CERT_BUNDLE_PATH)
        headers_conn = {'Content-Type':'application/json'}
        service_token =  sign_request(url, auth_service_name, instanceid)
        headers_conn['Authorization'] = auth_request_header+service_token
        if is_mgmt_tenent:
            headers_conn['Cookie'] = MGMT_TENANT_COOKIE + ':"yes"'
        if is_mgmt_tenent_dev:
            headers_conn['Cookie'] = MGMT_TENANT_COOKIE + ':"dev"'
        logger.debug(get_logger_header()+url)
        logger.debug(get_logger_header()+method)
        max_retry = 3
        current_retry = 0
        retry_status = False
        while current_retry < max_retry:
            try:
                current_retry += 1
                responseStatus, content = httpConnection.request(url, method, headers=headers_conn, body=payload)
                content = content.decode()
                resp_str = 'responseStatus='+str(responseStatus)+' content='+content
                if responseStatus['status'] != '200':
                    logger.debug(get_logger_header()+resp_str)
                    time.sleep(10)
                else:
                    retry_status = True
                    break

            except Exception as e:
                logger.debug(get_logger_header()+ repr(e))
                time.sleep(10)

        if retry_status == False:
            logger.debug("registration failed.could not add device profile in NetScaler Console")
            print ("registraion failed. could not add device profile in NetScaler Console")
            run_command("rm -rf /var/mastools/conf/agent.conf")
            generate_backup_activation_code(ip_address, customerid, servicename, instanceid)
            sys.exit(EXIT_CODE_DEV_PROFILE_ADD_FAILURE)

        if not is_sdx:
            if args.ngskey or args.ngsdevkey:
                PEStr_cmd = 'set cloud parameter -InstanceID '+instanceid+' -CustomerID '+customerid+' -ResourceLocation '+resourcelocation+' -Deployment '+deployment
            else:
                PEStr_cmd = 'set cloud parameter -InstanceID '+instanceid+' -CustomerID '+customerid+' -Deployment '+deployment
            cli_exec(PEStr_cmd)
            if (not running_inside_cpx()) and is_device_ha_primary:
                run_mastools_syncup_secondary(username, password)
        else:
            write_sdx_vpx_trap_default_conf()

        footer_print = """----------------------------------------------------------------------------
NetScaler Console Tools successfully registered.
----------------------------------------------------------------------------"""
        logger.debug(get_logger_header()+footer_print)
        print (footer_print)

        return deployment_type


def deployment_choice(caller_script,already_deployed,args,is_aws,is_auto_reg_req=False, is_dummy_reg=False):

    deployment_type=1
    if caller_script=='mas':
        choice_selected = False
        choice_selected = agent_selection_handler(deployment_type,caller_script,args,is_auto_reg_req)

        return choice_selected


def _main(argv):


    parser = argparse.ArgumentParser(description='Register agent')
    parser.add_argument("-m","--mas", help="Deployment Setup is NetScaler ADM",action="store_true")
    parser.add_argument('action',nargs='?',help="Available actions : registeragent registeragentdummy")
    parser.add_argument("-serviceurl","--serviceurl", help="Service url is generated by an individual user in NetScaler Application Delivery Management dashboard")
    parser.add_argument("-activationcode","--activationcode", help="Activation code is generated by an individual user in NetScaler Application Delivery Management dashboard")
    parser.add_argument("-sip","--serverip", help="Server IP Address")
    parser.add_argument("-u","--username", help="Username")
    parser.add_argument("-p","--password", help="Password")
    parser.add_argument("-profile","--profile", help="DeviceProfile")
    parser.add_argument("-r","--reboot", help="Reboot the system",action="store_true")
    parser.add_argument("-dockerhostip", "--dockerhostip", help="Docker Host IP Address")
    parser.add_argument("-dbstr", "--dbstr", help="DB connection string")
    parser.add_argument("-key","--ngskey", help="if private key is already generated in ngs connector",action="store_true")
    parser.add_argument("-keydev","--ngsdevkey", help="if private key is already generated in ngs dev connector",action="store_true")
    parser.add_argument("-sdx","--sdx", help="sdx registration",action="store_true")
    parser.add_argument("-blx","--blx", help="blx registration",action="store_true")
    parser.add_argument("-inter","--interactive", help="interactive mode, not showing password")
    parser.add_argument("-read_adc_cred_from_env", "--read_adc_cred_from_env", help="will read adc username & password from environment variables ADC_USER and ADC_PASSWORD", default=False, action="store_true")

    args = parser.parse_args()
    # populate username and password from environment variable if read_adc_cred_from_env is true
    if args.read_adc_cred_from_env:
        try:
            args.username = os.environ['ADC_USER']
            args.password = os.environ['ADC_PASSWORD']
        except KeyError:
            pass
            
    hash_activation_code(args.activationcode)
    logger.debug(get_logger_header()+"------------------------------------- Start -----------------------------")

    caller_script='mas'

    is_auto_reg_req = True

    is_dummy_reg = False


    already_deployed = 0

    is_aws=0
    global is_sdx
    if args.sdx:
        is_sdx = True
    global is_blx
    if args.blx:
        is_blx = True
    global is_profile
    if args.profile:
        is_profile = True
    set_prev_instance_id()
    choice_selected = deployment_choice(caller_script,already_deployed,args,is_aws,is_auto_reg_req, is_dummy_reg)



    logger.debug(get_logger_header()+"------------------------------------- Finished -----------------------------")
    sys.exit(0)

if __name__ == "__main__":
    if not is_supported_os():
        print("Not supported OS, only FreeBSD and Ubuntu are supported in builtin agent registration")         
        sys.exit(0)
    sys.exit(_main(sys.argv))
