#!/usr/local/bin/python
#sudo su
import sys
import time
import os
import errno
import subprocess
import optparse
import traceback
#import pg8000
import shlex
#from apps.common.IPUtils  import IPUtils
import binascii
import httplib2
import base64
import string
import getpass
import pwd
import grp
import os.path
import urllib, urllib3
import shutil
import urllib3, base64
import httplib2, urllib
from urllib.request import urlopen
import random
from xml.dom import minidom
import xml.etree.ElementTree as ET
import socket
import httplib2
import json
import re
import subprocess
import urllib3, base64
import ast
import argparse
import struct
import hashlib
#import xmltodict
import datetime
import requests
import codecs

AGENT_CONFIG_FILE = '/var/mastools/conf/agent.conf'
MANAGED_DEVICE='managed_device'
MANAGED_DEVICE_URI='/nitro/v1/config/managed_device'
MANAGED_DEVICE_FILTER='?filter=ip_address:'
TRUST_KEY_DIR = '/var/mastools/trust/.ssh/'
TMP_DIR = '/var/tmp'
SERVICE_URL = 'agent.netscalermgmt.net'
MGMT_TENANT_COOKIE = '_MGMT_TENANT'
MANAGED_DEVICE_FILTER_INSTANCE='?filter=trust_id:'

DEVICE_PARTITION_SEPERATOR = "-"

activation_code_hash256 = "None"
prev_instance_id = "None"


#=================For setting up logging ==============================================================================================================
import logging
import logging.handlers

log_file_name_local = os.path.basename(__file__)
LOG_FILENAME = '/var/mastools/logs/' + log_file_name_local + '.log'
LOG_MAX_BYTE = 50*1024*1024
LOG_BACKUP_COUNT = 20

# Set up a specific logger with our desired output level
logger = logging.getLogger(__name__)
logger.setLevel(logging.DEBUG)

# Add the log message handler to the logger
logger_handler = logging.handlers.RotatingFileHandler(LOG_FILENAME, maxBytes=LOG_MAX_BYTE, backupCount=LOG_BACKUP_COUNT)
logger_fortmater = logging.Formatter(fmt='%(asctime)s:%(funcName)s:%(lineno)d: [%(levelname)s] %(message)s', datefmt="%Y-%m-%d %H:%M:%S")
logger_handler.setFormatter(logger_fortmater)
logger.addHandler(logger_handler)
#======================================================================================================================================================

#=================For safe command execution +==========================================================================================================
import subprocess, threading, psutil, signal

#======================================================================================================================================================

import contextlib

def hash_activation_code(service_activation_code):
    global activation_code_hash256
    if (';' in service_activation_code):
        preauth_service = service_activation_code.split(";")
        activation_code = preauth_service[1]
    else:
        activation_code = service_activation_code
    activation_code_hash256 = hashlib.sha256(activation_code.encode('utf-8')).hexdigest()
    return

def get_logger_header():
    logger_str = "[mastools_registration_"+activation_code_hash256+"]"
    return logger_str

@contextlib.contextmanager
def cd_local(newPath):
    savedPath = os.getcwd()
    os.chdir(newPath)
    yield
    os.chdir(savedPath)

def get_date_string():
    rpt_sample_time = int(time.time())
    s = time.strftime("%d%b%Y_%H_%M", time.localtime() )
    if not s :
        s = str(rpt_sample_time)

    return s



def run_command(cmd):
    args = shlex.split(cmd)
    subprocess.call(args)

def run_command_special(basic, cmd):
    args = shlex.split(basic)
    args.append(cmd)
    subprocess.call(args)

def read_command_output(cmd):
    args = shlex.split(cmd)
    process = subprocess.Popen(args, stdout=subprocess.PIPE, stderr=None)
    output = process.communicate()
    return output[0]
    
def sign_request(url, servicename, instanceid):
    tmp_inp_file = TMP_DIR + "inp_comp_url_tmp"
    tmp_sha_file = TMP_DIR + "tmp_sha_output"
    f = open(tmp_inp_file, 'w')
    f.write(url)
    f.close()

    read_command_output("openssl dgst -sha256 -sign " + TRUST_KEY_DIR + "private.pem -out "+ tmp_sha_file +" "+ tmp_inp_file);
    signature = read_command_output("openssl base64 -in "+tmp_sha_file);
    signature = signature.decode('utf-8')
    signature = signature.replace("\r\n","")
    signature = signature.replace("\n","")
    if os.path.exists(tmp_inp_file):
        os.remove(tmp_inp_file)
    if os.path.exists(tmp_sha_file):
        os.remove(tmp_sha_file)
    token = signature + ";" + servicename + ";" + instanceid;
    
    service_token = base64.b64encode(token.encode()).decode('utf-8')
    
    return service_token


def send_request(url, servicename, instanceid, method, payload, time_out=0):
    service_token = sign_request(url, servicename, instanceid)
    
    #if time_out == 0:
    #    httpConnection=httplib2.Http(".cache",disable_ssl_certificate_validation=True)
    #else:
    #    httpConnection=httplib2.Http(".cache",disable_ssl_certificate_validation=True, timeout=time_out)
    headers_conn = {'Content-Type':'application/json'}
    headers_conn['Authorization'] = 'DNBUAuth service='+service_token
    logger.debug(get_logger_header()+url + "method: " + method)
    try:
        if payload == '':
            if method == "GET":
              content = requests.get(url,headers=headers_conn,timeout=time_out, verify=False)
            elif  method  == "DELETE":
              content = requests.delete(url,headers=headers_conn,timeout=time_out, verify=False)
            #responseStatus, content = httpConnection.request(url, method, headers=headers_conn)
        else:
            if method == "GET":
              content = requests.get(url,headers=headers_conn,data=payload,timeout=time_out, verify=False)
            elif  method  == "DELETE":
              content = requests.delete(url,headers=headers_conn,data=payload,timeout=time_out, verify=False)
            #responseStatus, content = httpConnection.request(url, method, headers=headers_conn, body=payload)
        content = content.text
        
        resp_str = ' content='+content
        logger.debug(get_logger_header()+resp_str)
    except Exception as e:
        print (str(e))
        return str(e)

    logger.debug(get_logger_header()+content);
    return content;
    

def create_agent_conf_file(uuid, customerid, instanceid, iscloud, cloudurl, servicename, download_service_url):
   
    logger.debug(get_logger_header()+"In create_agent_conf_file\n")
    if os.path.exists(AGENT_CONFIG_FILE):
        os.remove(AGENT_CONFIG_FILE)
    fileContents='<?xml version="1.0" encoding="UTF-8" standalone="no"?>\n<mps_agent>\n\t'
    fileContents=fileContents+"<uuid>"+uuid+"</uuid>\n\t<url>"+cloudurl+"</url>\n\t<customerid>"+customerid+"</customerid>\n\t<instanceid>"+instanceid+"</instanceid>\n\t<servicename>"+servicename+"</servicename>"
    fileContents=fileContents+"\n\t<download_service_url>"+download_service_url+"</download_service_url>\n\t<abdp_url>"+cloudurl+"</abdp_url>\n\t<msg_router_url>"+cloudurl+"</msg_router_url>"
    fileContents=fileContents+"\n</mps_agent>"
    file = open(AGENT_CONFIG_FILE, "w+")
    file.write(fileContents)
    file.close()


def getMyIpAddress(cloudurl):
    s = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)
    try:
        s.connect((cloudurl, 80))
        agentIpAddress=s.getsockname()[0]
        s.close()
        return agentIpAddress
    except:
        agentNoConnectivity = """----------------------------------------------------------------------------
The agent failed to connect server
----------------------------------------------------------------------------"""
        print (agentNoConnectivity)
        sys.exit(-1)

def set_prev_instance_id():
    logger.debug(get_logger_header()+"In set_prev_instance_id ")
    global prev_instance_id
    
    if not os.path.exists("/var/mastools/conf/agent.conf"):
        return
         
    with open("/var/mastools/conf/agent.conf", "r+") as agent_conf_file:
        CONTENT= agent_conf_file.read()
        agent_conf_file.close()
    
    #AGENT_CONF_DICT = xmltodict.parse(CONTENT)['mps_agent']
    #if 'instanceid' in AGENT_CONF_DICT.keys():
    #    prev_instance_id = AGENT_CONF_DICT['instanceid']
    prev_instance_id =  ET.fromstring(CONTENT).find('instanceid').text
    logger.debug(get_logger_header()+"prev_instance_id " + prev_instance_id)
    
    return

def get_prev_device_list(ip, customer, service, instance):
    prev_device_list = []
    logger.debug(get_logger_header()+"prev_instance_id = " + prev_instance_id)
    if prev_instance_id == 'None':
        logger.debug(get_logger_header()+"no prev instance id, return device id None ")
        return prev_device_list

    url = "https://" + ip + "/" + customer + "/" + service + MANAGED_DEVICE_URI + MANAGED_DEVICE_FILTER_INSTANCE + prev_instance_id
    contents = send_request(url, service, instance, "GET", "", 30)
    try:
        resp_json = json.loads(contents)
        prev_device_list= resp_json["managed_device"]
    except Exception as e:
        logger.debug(get_logger_header()+"Error in getting the prev device list")
    return prev_device_list
    
def delete_prev_device_list(ip, customer, service, instance, prev_device_list):
    if prev_device_list == []:
        logger.debug(get_logger_header()+"no prev device to delete ")
        return

    try:
        for device in prev_device_list:
            device_id = device["id"]
            device_ip = device["ip_address"]
            #if we get a device partition, skip it
            if DEVICE_PARTITION_SEPERATOR not in device_ip:
                url = "https://" + ip + "/" + customer + "/" + service + MANAGED_DEVICE_URI + "/" + device_id
                send_request(url, service, instance, "DELETE", "", 15)
    except Exception as e:
        logger.debug(get_logger_header()+"could not delete prev device id " + device_id)

    return

def delete_prev_device(ip, customer, service, instance):
    prev_device_list = get_prev_device_list(ip, customer, service, instance)
    logger.debug(get_logger_header()+"prev_device_list: " + str(prev_device_list))
    delete_prev_device_list(ip, customer, service, instance, prev_device_list)
    return 
    
    

def encode_to_base64(n):
    data = struct.pack('<Q', n).rstrip(b'\x00')
    if len(data)==0:
        data = '\x00'
    s = base64.urlsafe_b64encode(data).decode('utf-8').rstrip('=')
    return s

def get_time_difference():
    epoch = time.time()
    epoch_time_local = datetime.datetime.fromtimestamp(epoch)
    epoch_time_utc = datetime.datetime.utcfromtimestamp(epoch)
    offset = epoch_time_local - epoch_time_utc
    return offset
    
        

def agent_time_sync(utc_servert_time_string):
    logger.debug("%s Setting Server Time : %s, for agent", get_logger_header(), utc_servert_time_string)
    offset = get_time_difference()
    utc_server_time = time.strptime(utc_servert_time_string, "%a, %d %b %Y %H:%M:%S GMT")
    utc_server_date_time = datetime.datetime.fromtimestamp(time.mktime(utc_server_time))
    local_time_date_time = utc_server_date_time + offset
    local_time = local_time_date_time.timetuple()
    hour = str(local_time.tm_hour).zfill(2)
    minute = str(local_time.tm_min).zfill(2)
    day = str(local_time.tm_mday).zfill(2)
    month = str(local_time.tm_mon).zfill(2)
    try:
        date_cmd = "date " + str(local_time.tm_year) + month + day + hour + minute + " > /dev/null 2>&1"
        logger.debug(get_logger_header()+"set cmd local time: " + date_cmd)
        commands.getoutput(date_cmd)
    except Exception as e:
        logger.error(get_logger_header()+"Exception in setting mastools's timestamp to server's time: "+e)
    return
                    
def agent_selection_handler(deployment_type,caller_script,args,is_auto_reg_req=False):
    if ((caller_script=='mas')):
        node_name = 'NetScaler Agent'
        public_key_xml = ""
        header_print = """\n------------------------------------------------------------------------------------------------------------------------
""" + node_name + """ Configuration. This menu allows you to specify a cloud url and obtain an instance ID for your device.
------------------------------------------------------------------------------------------------------------------------"""
        if is_auto_reg_req :
            logger.debug(get_logger_header()+header_print)
        else:
            print (header_print)
        servicename = ""
        ip_address = ""
        interMode = args.interactive
        username = args.username
        if (interMode == 'y'):
            password = getpass.getpass('Password:')
        else:
            password = args.password
        global is_mgmt_tenent
        is_mgmt_tenent = False
                   
        while True:
            if is_auto_reg_req:
                if args.serviceurl:
                    ip_address=args.serviceurl
                else:
                    ip_address=SERVICE_URL
            else:
                ip_address = raw_input("""    Enter Service URL: """)
            if ip_address :
                http_conn_fetch=httplib2.Http(".cache", disable_ssl_certificate_validation=True)
                http_conn_fetch.follow_all_redirects = True
                fetch_url = "https://" + ip_address + "/fetch_urls";
                trust_url = ""
                server_time = ""
                download_service_url = ""
                logger.debug("%s fetch_url: %s, trying to fetch trust url", get_logger_header(), fetch_url)
                try:
                    resp_preauth, content_preauth =  http_conn_fetch.request(fetch_url, "GET")
                    if (resp_preauth['status'] == '200'):
                       content_preauth = content_preauth.decode() 
                       download_service_url = content_preauth.split(';')[0]
                       download_service_url = download_service_url.strip('\"')
                       trust_url = content_preauth.split(';')[1]
                       trust_url = trust_url.rstrip()
                       trust_url = trust_url.strip('\"')
                       logger.debug("%s Trust URL : %s, got result sucessfull", get_logger_header(), trust_url)
                       logger.debug("%s download_service_url URL : %s, got result sucessfull", get_logger_header(), download_service_url)
                       if (len(content_preauth.split(';')) > 2):
                          server_time = content_preauth.split(';')[2]
                          agent_time_sync(server_time)
                       break;
                    else:
                         invalidpreauth = """----------------------------------------------------------------------------\nFailed to get Trust URL from Gateway\n----------------------------------------------------------------------------"""
                         logger.error(get_logger_header()+invalidpreauth)
                         print (invalidpreauth)
                except KeyboardInterrupt:
                    logger.debug(get_logger_header()+"Keyboard Interrupt Exception occured !!")
                    print("Keyboard Interrupt Exception occured !!")
                    sys.exit(-1)
                except Exception as e:
                    logger.debug("%s Exception occured while post request url %s", get_logger_header(), fetch_url)
                    errMsg="    Please check if the DNS server is configured !! Exception %s" + str(e)
                    logger.error(get_logger_header()+errMsg)
                    print(errMsg)
                    sys.exit(-1)
        logger.debug (get_logger_header()+"generating trust key directory")            
        run_command("rm -rf /var/mastools/trust/.ssh/")
        time.sleep(5)
        run_command("mkdir -p /var/mastools/trust/.ssh/")
        time.sleep(5)
        run_command("openssl genrsa -out /var/mastools/trust/.ssh/private.pem 2048 >/dev/null 2>&1")
        time.sleep(5)
        run_command("openssl rsa -in /var/mastools/trust/.ssh/private.pem -outform PEM -pubout -out /var/mastools/trust/.ssh/public.pem")
        time.sleep(5)
        output_1 = read_command_output("openssl rsa -pubin -in /var/mastools/trust/.ssh/public.pem -modulus -noout")
        time.sleep(5)
        output_2 = read_command_output("openssl rsa -pubin -in /var/mastools/trust/.ssh/public.pem -modulus -text")
        time.sleep(5)
        try:
            modulus = output_1[8:]
            modulus = modulus.strip()
            modulus = binascii.b2a_base64(codecs.decode(modulus,'hex'))
            modulus = modulus.decode('utf-8')
            
            output_2 = output_2.decode('utf-8')
            array = output_2.split("Exponent: ")
            exponent = array[1].split('(')[0]
            exponent =  encode_to_base64(int(exponent))
            public_key_xml = "<RSAKeyValue><Modulus>" + modulus + "</Modulus><Exponent>" + exponent + "</Exponent></RSAKeyValue>"
            
        except:
            logger.debug(get_logger_header()+"Exception occured while opening public key file")
        while True:
                servicename = ""
                preauth_service = ""
                preauth_token = ""
                while True:
                    if args.activationcode:
                        preauth_token = args.activationcode
                    else:
                        preauth_token = raw_input("""    Enter Activation Code : """)
                    deployment = "Dev"
                    if ip_address == "agent.netscalermgmt.net" or ip_address.endswith('cloud.com'):
                        servicename = "MAS"
                        deployment = "Production"
                    if ip_address == "apigw.netscalermgmtstaging.net" or ip_address.endswith('cloudburrito.com'): 
                        servicename = "MAS"
                        deployment = "Staging"
                    if preauth_token and (servicename != "" or ';' in preauth_token):
                        break
                    else :
                        invalidcode = """----------------------------------------------------------------------------\nInvalid Activation code. Please try again.\n----------------------------------------------------------------------------"""
                        logger.error(get_logger_header()+invalidcode)
                        print( invalidcode)
                        sys.exit(-1)
                if (servicename == "" and ';' in preauth_token):
                    preauth_service = preauth_token.split(";")
                    servicename = preauth_service[0]
                    preauth_token = preauth_service[1]
                payload_preauth = '{"preauthtoken":"' + preauth_token + '","signingkey":"' + base64.b64encode(public_key_xml.encode()).decode('utf-8') + "\"}";
                
                #http_conn_preauth=httplib2.Http(".cache",disable_ssl_certificate_validation=True)
                url_preauth = "https://" + trust_url + "/root/trust/v1/identity";
                try:
                    response = requests.post(url_preauth, data=payload_preauth, headers={'Content-Type':'application/json'}, timeout=10, verify=False)
                    if response.ok:
                      logger.debug("%s Server IP: %s, got result successful", get_logger_header(), ip_address)
                      json_data_preauth = json.loads(response.text)
                      logger.debug("%s return = %s", get_logger_header(), str(json_data_preauth))
                      if (json_data_preauth['status'] == "success"):
                        instanceid = json_data_preauth['instanceid']
                        customerid = json_data_preauth['customerid']
                        resourcelocation = json_data_preauth['resourcelocation']
                        break
                      else:
                        invalidpreauth = """----------------------------------------------------------------------------\nFailed to get Instance ID. Please re-enter Activation code.\n----------------------------------------------------------------------------"""
                        logger.error(get_logger_header()+invalidpreauth)
                        print( invalidpreauth)
                        sys.exit(-1)
                    
                except KeyboardInterrupt:
                    logger.debug(get_logger_header()+"Keyboard Interrupt Exception occured !!")
                    print( "Keyboard Interrupt Exception occured !!")
                    sys.exit(-1)
                except Exception as e:
                    logger.debug("%s Exception occured while post request url %s, payload %s", get_logger_header(), url_preauth, payload_preauth)
                    dnserror="    Please check if the DNS server is configured !! exception string" + str(e)
                    logger.error(get_logger_header()+dnserror)
                    print(dnserror)
                    sys.exit(-1)
        create_agent_conf_file("temp_str", customerid, instanceid , "true", ip_address, servicename, download_service_url)

        tmp_inp_file = TMP_DIR + "inp_comp_url_tmp"
        tmp_sha_file = TMP_DIR + "tmp_sha_output"
        url = 'https://' + ip_address + "/" + customerid + "/" + servicename + "/nitro/v1/config/sdwanvw_device_profile"
        f = open(tmp_inp_file, 'w')
        f.write(url)
        f.close()
        read_command_output("openssl dgst -sha256 -sign " + TRUST_KEY_DIR + "private.pem -out "+ tmp_sha_file +" "+ tmp_inp_file);
        signature = read_command_output("openssl base64 -in "+tmp_sha_file);
        signature = signature.decode('utf-8')
        signature = signature.replace("\r\n","")
        signature = signature.replace("\n","")

        if os.path.exists(tmp_inp_file):
            os.remove(tmp_inp_file)
        if os.path.exists(tmp_sha_file):
            os.remove(tmp_sha_file)
        token = signature + ";" + servicename + ";" + instanceid;
        
        service_token = base64.b64encode(token.encode('utf-8')).decode('utf-8');

        
        device_profile_name = 'mastool_'+instanceid+'_profile'
        method = 'POST'
        payload = 'object={"sdwanvw_device_profile":{"name":"'+device_profile_name+'", "type":"sdwanvw","is_default":"false","username":"admin","password":"***********","ssh_port":"22"}}'
        httpConnection=httplib2.Http(".cache",disable_ssl_certificate_validation=True)
        headers_conn = {'Content-Type':'application/json'}
        headers_conn['Authorization'] = 'DNBUAuth service='+service_token
        logger.debug(get_logger_header()+url)
        logger.debug(get_logger_header()+method)
        logger.debug(get_logger_header()+payload)
        max_retry = 3
        current_retry = 0
        retry_status = False
        while current_retry < max_retry:
            try:
                current_retry += 1
                #TODO:Review need to incorporate with latest changes
                #responseStatus, content = httpConnection.request(url, method, headers=headers_conn, body=payload)
                #resp_str = 'responseStatus='+str(responseStatus)+' content='+content
                #if responseStatus['status'] != '200':
                #    logger.debug(get_logger_header()+resp_str)
                #    time.sleep(10)
                #else:
                #    retry_status = True
                #    break

                responseStatus  = requests.post(url, data=payload, headers=headers_conn, timeout=10, verify=False)
                resp_str = 'responseStatus='+str(responseStatus.text)
                logger.debug(get_logger_header()+resp_str)
                if responseStatus.ok:
                    retry_status = True
                    break
                else:
                    logger.debug(get_logger_header()+resp_str)
                    time.sleep(10)
                
            except Exception as e:
                print(str(e))
                time.sleep(10)
                
        if retry_status == False:   
            logger.debug("registration failed.could not add device profile in NetScaler Console")
            print ("registraion failed. could not add device profile in NetScaler Console")
            run_command("rm -rf /var/mastools/conf/agent.conf")
            sys.exit(-1)
        
        logger.debug(get_logger_header()+"check and see if we need to delete some stale devices")    
        delete_prev_device(ip_address, customerid, servicename, instanceid)

        #PEStr_basic = 'nscli -U 127.0.0.1:'+username+':'+password
        #PEStr_cmd = 'set cloud parameter -InstanceID '+instanceid+' -CustomerID '+customerid+' -ResourceLocation '+resourcelocation
        #run_command_special(PEStr_basic, PEStr_cmd)

        footer_print = """----------------------------------------------------------------------------
NetScaler Console Tools registration successful.
----------------------------------------------------------------------------"""
        logger.debug(get_logger_header()+footer_print)
        print( footer_print)

        return deployment_type


def deployment_choice(caller_script,already_deployed,args,is_aws,is_auto_reg_req=False, is_dummy_reg=False):

    deployment_type=1
    if caller_script=='mas':
        choice_selected = False
        choice_selected = agent_selection_handler(deployment_type,caller_script,args,is_auto_reg_req)

        return choice_selected


def _main(argv):


    parser = argparse.ArgumentParser(description='Register agent')
    parser.add_argument("-m","--mas", help="Deployment Setup is Citrix ADM",action="store_true")
    parser.add_argument('action',nargs='?',help="Available actions : registeragent registeragentdummy")
    parser.add_argument("-serviceurl","--serviceurl", help="Service url is generated by an individual user in Citrix Application Delivery Management dashboard")
    parser.add_argument("-activationcode","--activationcode", help="Activation code is generated by an individual user in Citrix Application Delivery Management dashboard")
    parser.add_argument("-sip","--serverip", help="Server IP Address")
    parser.add_argument("-u","--username", help="Username")
    parser.add_argument("-p","--password", help="Password")
    parser.add_argument("-r","--reboot", help="Reboot the system",action="store_true")
    parser.add_argument("-dbstr", "--dbstr", help="DB connection string")
    parser.add_argument("-key","--ngskey", help="if private key is already generated in ngs connector",action="store_true")
    parser.add_argument("-inter","--interactive", help="interactive mode, not showing password")
 
    args = parser.parse_args()
    
    hash_activation_code(args.activationcode)
    logger.debug(get_logger_header()+"------------------------------------- Start -----------------------------")
    
    caller_script='mas'

    is_auto_reg_req = True

    is_dummy_reg = False


    already_deployed = 0

    is_aws=0
    set_prev_instance_id()
    choice_selected = deployment_choice(caller_script,already_deployed,args,is_aws,is_auto_reg_req, is_dummy_reg)



    logger.debug(get_logger_header()+"------------------------------------- Finished -----------------------------")
    sys.exit(0)

if __name__ == "__main__":

    sys.exit(_main(sys.argv))

            
