#!/usr/local/bin/python

import sys
import time
import os
import xmltodict
import httplib2
import json
import platform
try:
    from mastools_reg import get_mastools_proxy_httplib2
except:
    pass

#=================For setting up logging ==============================================================================================================
import logging
import logging.handlers

log_file_name_local = os.path.basename(__file__)
LOG_FILENAME = '/var/mastools/logs/' + log_file_name_local + '.log'
LOG_MAX_BYTE = 50*1024*1024
LOG_BACKUP_COUNT = 20

# Set up a specific logger with our desired output level
logger = logging.getLogger(__name__)
logger.setLevel(logging.DEBUG)

# Add the log message handler to the logger
logger_handler = logging.handlers.RotatingFileHandler(LOG_FILENAME, maxBytes=LOG_MAX_BYTE, backupCount=LOG_BACKUP_COUNT)
logger_fortmater = logging.Formatter(fmt='%(asctime)s:%(funcName)s:%(lineno)d: [%(levelname)s] %(message)s', datefmt="%Y-%m-%d %H:%M:%S")
logger_handler.setFormatter(logger_fortmater)
logger.addHandler(logger_handler)
#======================================================================================================================================================

MGMT_TENANT_COOKIE = '_MGMT_TENANT'
AGENT_CONFIG_FILE = '/var/mastools/conf/agent.conf'
AGENT_CONF_DICT= {}

CERT_BUNDLE_PATH='/var/mastools/cert/cacert.pem'


def is_python_3_running():
    if platform.python_version().startswith('3.'):
        return True
    return False


is_python_3 = is_python_3_running()


def get_logger_header():
    if 'customerid' not in AGENT_CONF_DICT.keys():
        customerid = "none"
    else:
        customerid = AGENT_CONF_DICT['customerid']
    if 'instanceid' not in AGENT_CONF_DICT.keys():
        instanceid = "none"
    else:
        instanceid = AGENT_CONF_DICT['instanceid']
        if len(instanceid) > 8:
            instanceid = instanceid[:4] + '****' + instanceid[-4:]
    logger_str = "[updateAgentConfig_"+customerid+"_"+instanceid+"]: "
    return logger_str

def get_agent_conf():
    global AGENT_CONF_DICT
    with open(AGENT_CONFIG_FILE, "r+") as agent_conf_file:
        CONTENT= agent_conf_file.read()
        agent_conf_file.close()

    AGENT_CONF_DICT = xmltodict.parse(CONTENT)['mps_agent']
    return

def get_apigw_url():
    if 'url' not in AGENT_CONF_DICT.keys():
        apigw_url = "none"
    else:
        apigw_url = AGENT_CONF_DICT['url']
    return apigw_url

def get_customerid():
    if 'customerid' not in AGENT_CONF_DICT.keys():
        customer_id = "none"
    else:
        customer_id = AGENT_CONF_DICT['customerid']
    return customer_id

def get_instanceid():
    if 'instanceid' not in AGENT_CONF_DICT.keys():
        instance_id = "none"
    else:
        instance_id = AGENT_CONF_DICT['instanceid']
    return instance_id

def get_servicename():
    if 'servicename' not in AGENT_CONF_DICT.keys():
        service_name = "none"
    else:
        service_name = AGENT_CONF_DICT['servicename']
    return service_name

def get_download_service_url():
    if 'download_service_url' not in AGENT_CONF_DICT.keys():
        dwnld_sevice_url = "none"
    else:
        dwnld_sevice_url = AGENT_CONF_DICT['download_service_url']
    return dwnld_sevice_url

def get_is_mgmt_tenent():
    if 'mgmt_tenant' not in AGENT_CONF_DICT.keys():
        is_mgmt_tenant = "none"
    else:
        is_mgmt_tenant = AGENT_CONF_DICT['mgmt_tenant']
    return is_mgmt_tenant

def get_profile():
    if 'profile' not in AGENT_CONF_DICT.keys():
        profile = "none"
    else:
        profile = AGENT_CONF_DICT['profile']
    return profile
    
def create_agent_conf_file(uuid, customerid, instanceid, iscloud, cloudurl, servicename, download_service_url, profile):
   
    logger.debug(get_logger_header()+"In create_agent_conf_file\n")
    if os.path.exists(AGENT_CONFIG_FILE):
        os.remove(AGENT_CONFIG_FILE)
    fileContents='<?xml version="1.0" encoding="UTF-8" standalone="no"?>\n<mps_agent>\n\t'
    fileContents=fileContents+"<uuid>"+uuid+"</uuid>\n\t<url>"+cloudurl+"</url>\n\t<customerid>"+customerid+"</customerid>\n\t<instanceid>"+instanceid+"</instanceid>\n\t<servicename>"+servicename+"</servicename>"
    fileContents=fileContents+"\n\t<download_service_url>"+download_service_url+"</download_service_url>\n\t<abdp_url>"+cloudurl+"</abdp_url>\n\t<msg_router_url>"+cloudurl+"</msg_router_url>" 
    is_mgmt_tenent = get_is_mgmt_tenent()
    if is_mgmt_tenent != "none":
        is_mgmt_tenent.strip()
        if is_mgmt_tenent != 'dev':
            fileContents=fileContents+"\n\t<mgmt_tenant> yes </mgmt_tenant>"    
        else:
            fileContents=fileContents+"\n\t<mgmt_tenant> dev </mgmt_tenant>"    
    if profile != "none":
        profile.strip()
        fileContents=fileContents+"\n\t<profile>" + profile + "</profile>"    
    fileContents=fileContents+"\n</mps_agent>"
    file = open(AGENT_CONFIG_FILE, "w+")
    file.write(fileContents)
    file.close()


def update_agent_conf():

    try:
        get_agent_conf()
        apigw = get_apigw_url()
        if apigw == "none":
            logger.debug(get_logger_header()+"Could not get apigw url, agent.conf not updated ")
            sys.exit(0)

        headers_conn = {'Content-Type':'application/json'}
        is_mgmt_tenent = get_is_mgmt_tenent()
        if is_mgmt_tenent != "none":
            is_mgmt_tenent.strip()
            if is_mgmt_tenent != 'dev':
                headers_conn['Cookie'] = MGMT_TENANT_COOKIE + ':"yes"'
            else:
                headers_conn['Cookie'] = MGMT_TENANT_COOKIE + ':"dev"'
                
        proxy_httplib2 = get_mastools_proxy_httplib2()
        if proxy_httplib2:
            http_conn_fetch=httplib2.Http(".cache", proxy_info=proxy_httplib2, ca_certs=CERT_BUNDLE_PATH, timeout=30)
        else:
            http_conn_fetch=httplib2.Http(".cache", ca_certs=CERT_BUNDLE_PATH, timeout=30)
        http_conn_fetch.follow_all_redirects = True
        fetch_url = "https://" + apigw + "/" + get_servicename() + "/" + get_customerid() + "/fetch_urls";
        logger.debug("%s fetch_url: %s", get_logger_header(), fetch_url)
        try:
            resp_fetchurl, content_fetchurl =  http_conn_fetch.request(fetch_url, "GET", headers=headers_conn)
            if is_python_3:
                content_fetchurl = content_fetchurl.decode("utf-8")
            logger.debug(get_logger_header()+ "content_fetchurl : "+content_fetchurl)
            logger.debug(get_logger_header()+ "headers_conn : "+str(headers_conn))
            if (resp_fetchurl['status'] == '200'):
                responseData = json.loads(content_fetchurl)
                cloudURL = responseData['service_url']
                logger.debug("%s CloudURL : %s, got result successfully", get_logger_header(), cloudURL)
            else:
                logger.error(get_logger_header()+"fetch url return error")
                return;

            custId = get_customerid()
            instId = get_instanceid()
            service_name = get_servicename()
            download_service_url = get_download_service_url()
            profile = get_profile()
            if cloudURL :
                if cloudURL != apigw:
                    create_agent_conf_file("temp_str", custId,instId,"true",cloudURL,service_name, download_service_url, profile)
        except Exception as e:
            logger.debug("%s Exception occured while post request url in update_agent_conf %s", get_logger_header(), e)
            sys.exit(-1)
    except Exception as e:
        logger.debug("%s Exception occured in update_agent_conf %s", get_logger_header(), e)
        sys.exit(-1)


if __name__ == "__main__":
    update_agent_conf()
    sys.exit(0)

