#!/usr/local/bin/python

import sys
import time
import os
import shutil

NSBEFORE_UPDATED_FILE = "/var/mastools/nsbefore_update.state"
NSBEFORE_FILE = "/nsconfig/nsbefore.sh"
NSBEFORE_TMP_FILE = "/var/mastools/scripts/nsbefore.sh_temp"



#=================For setting up logging ==============================================================================================================
import logging
import logging.handlers

log_file_name_local = os.path.basename(__file__)
LOG_FILENAME = '/var/mastools/logs/' + log_file_name_local + '.log'
LOG_MAX_BYTE = 50*1024*1024
LOG_BACKUP_COUNT = 20

# Set up a specific logger with our desired output level
logger = logging.getLogger(__name__)
logger.setLevel(logging.DEBUG)

# Add the log message handler to the logger
logger_handler = logging.handlers.RotatingFileHandler(LOG_FILENAME, maxBytes=LOG_MAX_BYTE, backupCount=LOG_BACKUP_COUNT)
logger_fortmater = logging.Formatter(fmt='%(asctime)s:%(funcName)s:%(lineno)d: [%(levelname)s] %(message)s', datefmt="%Y-%m-%d %H:%M:%S")
logger_handler.setFormatter(logger_fortmater)
logger.addHandler(logger_handler)
#======================================================================================================================================================
def touch(fname, times=None):
    with open(fname, 'a'):
        os.utime(fname, times)
    return

def update_nsbefore_conf():
    try:
        #if we have already done the update
        if os.path.exists(NSBEFORE_UPDATED_FILE):
            logger.debug("nsbefore has already been done on this ADC")
            return
        if not os.path.exists(NSBEFORE_TMP_FILE):
            logger.debug("no %s in mastools package" %(NSBEFORE_TMP_FILE))
            return
        if not os.path.exists(NSBEFORE_FILE):
            logger.debug(" %s file doesn't exit, generating the file..." %(NSBEFORE_FILE))
            shutil.copy(NSBEFORE_TMP_FILE, NSBEFORE_FILE)
            touch(NSBEFORE_UPDATED_FILE)
            return
        else:
            logger.debug("%s file exists, merging the content" %(NSBEFORE_FILE))
            nsbefore_tmp_file_handler = open(NSBEFORE_TMP_FILE,'r')
            nsbefore_tmp_lines = nsbefore_tmp_file_handler.readlines()
            nsbefore_file_handler = open(NSBEFORE_FILE,'r+')
            nsbefore_lines = nsbefore_file_handler.readlines()
            nsbefore_file_handler.seek(0)
            for line in nsbefore_tmp_lines:
                nsbefore_file_handler.write(line)
            for line in nsbefore_lines:
                nsbefore_file_handler.write(line)
            touch(NSBEFORE_UPDATED_FILE)
            nsbefore_file_handler.close()
            nsbefore_tmp_file_handler.close()
            return    
    except Exception as e:
        logger.debug("Exception occured in update_agent_conf %s", repr(e))
        sys.exit(-1)


if __name__ == "__main__":
    update_nsbefore_conf()
    sys.exit(0)

