#!/usr/local/bin/python

import requests.packages.urllib3
import requests
import base64
import sys
import time
import os
import urllib
#import urllib2
import httplib2
#import httplib
import fileinput
import json
import re
import datetime
import xmltodict
import subprocess
import hashlib
import psutil
#from datetime import datetime
from datetime import timedelta

import shlex

from requests.packages.urllib3.exceptions import InsecurePlatformWarning
from requests.packages.urllib3.exceptions import SNIMissingWarning
requests.packages.urllib3.disable_warnings(category=InsecurePlatformWarning)
requests.packages.urllib3.disable_warnings(category=SNIMissingWarning)

try:
    from mastools_reg import sign_request, is_python_2_6, auth_request_header, get_proxy_setting, get_mastools_proxy_httplib2, get_mastools_proxy_requests
    from mastools_util import running_inside_cpx, running_inside_unicon, checkCloudOption

except:
    pass

import cloud_constants as const

#DEFAULT_SERVICE_URL = "agent.adm.cloud.com"
DEFAULT_SERVICE_URL = None
AGENT_CONF = "/var/mastools/conf/agent.conf"
IS_REGISTERED = os.path.exists(AGENT_CONF)

MASTOOLS_CWS_SERVICENAME = 'netappliance'

#=================For setting up logging ==============================================================================================================
import logging
import logging.handlers

log_file_name_local = os.path.basename(__file__.rstrip('.py'))
LOG_FILENAME = '/var/mastools/logs/' + log_file_name_local + '.log'
LOG_MAX_BYTE = 50*1024*1024
LOG_BACKUP_COUNT = 20

# Set up a specific logger.with our desired output level
logger=logging.getLogger(__name__)
logger.setLevel(logging.DEBUG)

# Add the log message handler to the logger
logger.handler = logging.handlers.TimedRotatingFileHandler(LOG_FILENAME, when='m', interval=2, backupCount=LOG_BACKUP_COUNT)
logger.fortmater = logging.Formatter(fmt='%(asctime)s:%(funcName)s:%(lineno)d: [%(levelname)s] %(message)s', datefmt="%Y-%m-%d %H:%M:%S")
logger.handler.setFormatter(logger.fortmater)
logger.addHandler(logger.handler)

if running_inside_unicon():
    logger_handler_stdout = logging.StreamHandler(sys.stdout)
    logger_handler_stdout.setFormatter(logger.fortmater)
    logger.addHandler(logger_handler_stdout)
#======================================================================================================================================================


#Global Variables
AGENT_POLL_TIME = 3600
RETRY_TIME = 120
RETRY_COUNT = 10
LATEST_IMAGE_PATH= "/var/mastools/images/latest/"
PREV_IMAGE_PATH= "/var/mastools/images/prev/"
TRUST_KEY_DIR = "/var/mastools/trust/.ssh/"
TMP_DIR = "/var/tmp"
CONTENT=''
NEW_IMAGE_MD5CHECKSUM= ''
CERT_BUNDLE_PATH='/var/mastools/cert/cacert.pem'
NS_CERT_BUNDLE_PATH='/nsconfig/ssl/adc-root-certs.crt'
AGENT_CONF_DICT= {}
DOWNLOAD_PATH_PUBLIC = "root/download/v1/public/software?product=mastools&build=latest&model=mastools.tgz"
DOWNLOAD_PATH_AUTH= "root/download/v1/auth/software?product=mastools&build=latest&model=mastools.tgz"
METADATA=''
NEW_VERSION=''
VERSION_FILE_PATH = '/var/mastools/version.txt'
PREV_VERSION_FILE_PATH = '/var/mastools/prev_version.txt'
CA_CERT_CHAIN= '/var/mastools/cert/ca-chain.cert.pem'
APIGW_URL = {}
APIGW_HEADERS = {}
UPGRADE_TIME = "IMMEDIATE"
MGMT_TENANT_COOKIE = '_MGMT_TENANT'
GET_CURR_VER_URI = '/get_current_version'
VERSION = 'version'

SVM_MPS_LIB = '/mps/lib'
def is_platform_sdx():
    if os.path.exists(SVM_MPS_LIB):
        return True
    return False

IS_PLATFORM_SDX = is_platform_sdx()


#=================For safe command execution +==========================================================================================================
import subprocess, threading, signal

def run_command(cmd):
    args = shlex.split(cmd)
    FNULL = open(os.devnull, 'w')
    subprocess.call(args,stdout=FNULL,stderr=FNULL)
    FNULL.close()


def read_command_output(cmd):
    args = shlex.split(cmd)
    process = subprocess.Popen(args, stdout=subprocess.PIPE, stderr=None)
    output = process.communicate()
    return output[0].decode()

def is_platform_linux():
    unameStr = read_command_output("uname -a")
    if 'linux' in unameStr.lower():
        return True
    return False

IS_PLATFORM_LINUX = is_platform_linux()

    
def get_ads_service_type():
    ads_service_type="ADM"
    try:
        ads_service_type = AGENT_CONF_DICT['ads_service_type']
    except Exception as e:
        logger.debug(e)
    return ads_service_type

def get_logger_header():
    if 'customerid' not in AGENT_CONF_DICT.keys():
        customerid = "none"
    else:
        customerid = AGENT_CONF_DICT['customerid']
    if 'instanceid' not in AGENT_CONF_DICT.keys():
        instanceid = "none"
    else:
        instanceid = AGENT_CONF_DICT['instanceid']
    logger_str = "[mastools_upgrade_"+customerid+"_"+instanceid+"]: "
    return logger_str

def get_apigw_url(path):

    global APIGW_URL
    global APIGW_HEADERS
    try:
        if 'url' not in AGENT_CONF_DICT.keys():
            logger.error(get_logger_header()+"url field missing in agent.conf")
            return False

        cloudurl = AGENT_CONF_DICT['url']
        if (cloudurl == None) :
            logger.error(get_logger_header()+"url field in agent.conf is empty")
            return False

        if 'customerid' not in AGENT_CONF_DICT.keys():
            logger.error(get_logger_header()+"customerid field is missing in agent.conf")
            return False

        customerid = AGENT_CONF_DICT['customerid']
        if (customerid == None) :
            logger.error(get_logger_header()+"customerid field in agent.conf is empty")
            return False

        if 'servicename' not in AGENT_CONF_DICT.keys():
            logger.error(get_logger_header()+"servicename field is missing in agent.conf")
            return False

        servicename = AGENT_CONF_DICT['servicename']
        if (servicename == None) :
            logger.error(get_logger_header()+"servicename field in agent.conf is empty")
            return False

        if 'instanceid' not in AGENT_CONF_DICT.keys():
            logger.error(get_logger_header()+"instanceid field is missing in agent.conf")
            return False

        instanceid = AGENT_CONF_DICT['instanceid']
        if (instanceid == None) :
            logger.error(get_logger_header()+"instanceid field in agent.conf is empty")
            return False


        if (path == None):
            logger.error(get_logger_header()+"url path is empty")
            return False

        if is_python_2_6:
            APIGW_URL[path] = 'https://' + cloudurl + "/" + customerid + "/" + servicename + path
        else:
            APIGW_URL[path] = 'https://' + cloudurl + "/" + customerid + "/" + MASTOOLS_CWS_SERVICENAME + path

        logger.debug(get_logger_header()+"Generated APIGW URL is "+APIGW_URL[path])

        if is_python_2_6:
            service_token = sign_request(APIGW_URL[path], servicename, instanceid)
        else:
            service_token = sign_request(APIGW_URL[path], MASTOOLS_CWS_SERVICENAME, instanceid)

        APIGW_HEADERS[path] = {}
        APIGW_HEADERS[path] = {'Content-Type':'application/json'}
        APIGW_HEADERS[path]['Authorization'] = auth_request_header+service_token
        logger.debug(get_logger_header()+"Obtained APIGW_HEADERS")
        return True

    except Exception as e:
        logger.exception(get_logger_header()+"Failed to get api gateway URL")
        return False


def send_post_request(path, payload=None):

    temp = get_apigw_url(path)
    no_of_retries = 0
    while (not temp and no_of_retries < RETRY_COUNT):
        time.sleep(RETRY_TIME)
        temp = get_apigw_url(path)
        no_of_retries = no_of_retries + 1

    if not temp:
        logger.error(get_logger_header()+"Unable to fetch api gateway url, even after %d retries. Aborting upgrade!" ,RETRY_COUNT);
        return False

        try:
            response = requests.post(APIGW_URL[path], data=payload, headers=APIGW_HEADERS[path], proxies=get_mastools_proxy_requests())
            if (response.status_code == requests.codes.ok):
                logger.debug(get_logger_header()+"HTTP POST request to server successful")
                return response
            else:
                logger.error(get_logger_header()+"HTTP POST request to server failed")
                response.raise_for_status()
                return False
        except Exception as e:
            logger.exception(get_logger_header()+"Failed to establish connection to server")
            return False


def send_put_request(path, payload=None):

    temp = get_apigw_url(path)
    no_of_retries = 0
    while (not temp and no_of_retries < RETRY_COUNT):
        time.sleep(RETRY_TIME)
        temp = get_apigw_url(path)
        no_of_retries = no_of_retries + 1

    if not temp:
        logger.error(get_logger_header()+"Unable to fetch api gateway url, even after %d retries. Aborting upgrade!" ,RETRY_COUNT);
        return False

    try:
        response = requests.put(APIGW_URL[path], data=payload, headers=APIGW_HEADERS[path], proxies=get_mastools_proxy_requests())
        if (response.status_code == requests.codes.ok):
            logger.debug(get_logger_header()+"HTTP PUT request to server successful")
            return response
        else:
            logger.error(get_logger_header()+"HTTP PUT request to server failed")
            response.raise_for_status()
            return False
    except Exception as e:
        logger.exception(get_logger_header()+"Failed to establish connection to server")


#Updating agent status
def updateAgentStatus(status):

    return True

def restart_admautoregd():
    logger.debug(get_logger_header()+"restart the admautoregd")
    cmd = "/bin/sh /var/mastools/scripts/admautoreg/admautoregd_ctl restart_if_running"
    output = run_command(cmd)

#untar the image package, and install the build
#Return: False if any command fails
def upgrade_agent(restart=True):

    logger.debug(get_logger_header()+"Upgrading agent...")

    if not os.path.exists(LATEST_IMAGE_PATH +"mastools.tgz"):
        logger.error(get_logger_header()+"%s doesn't exist", LATEST_IMAGE_PATH+"mastools.tgz")
        return False


    cmd = 'cp ' + VERSION_FILE_PATH + ' ' + PREV_VERSION_FILE_PATH
    output = run_command(cmd)
    cmd = "tar -xvzf " + LATEST_IMAGE_PATH +"mastools.tgz -C /var/mastools"
    if (get_disk_usage()==False) :
        logger.error(get_logger_header()+"No disk space available. aborting the upgrade")
        return False
    output = run_command(cmd)
    if IS_PLATFORM_LINUX:
        logger.debug(get_logger_header()+"platform linux, skip restarting the admautoreg")
    else:
        if os.path.exists('/netscaler/sigchk'):
            cmd = "/netscaler/sigchk refreshmas"
            run_command(cmd)
        logger.debug(get_logger_header()+"restart the admautoreg")
        restart_admautoregd()
    if restart:
        logger.debug(get_logger_header()+"restart the mastools")
        cmd = "/var/mastools/scripts/mastoolsd restart"
        output = run_command(cmd)
        time.sleep(5)
        logger.debug(get_logger_header()+"done restarting mastoolsd, exiting")
        sys.exit(0)
    return True


# Download new image from download service
# if able to download successfully then call Upgrade_agent()
# There will be 2 retries
# Return: Empty string for failure
def download_image(interactive_download_url=''):
    run_command('mv ' + LATEST_IMAGE_PATH +'/mastools.tgz ' + LATEST_IMAGE_PATH +'/mastools_old.tgz')

    for retry in range(0,3):
        logger.debug(get_logger_header()+"Get new image, Attempt number " + str(retry+1))
        try:
            global NEW_IMAGE_MD5CHECKSUM
            global AGENT_CONF_DICT
            global CONTENT
            global DOWNLOAD_PATH_PUBLIC
            global DOWNLOAD_PATH_AUTH
            global METADATA
            global ROOT_CERT_HASH

            interactive_download = False

            logger.debug(get_logger_header()+"Download Started")
            if interactive_download_url == '':
                if 'download_service_url' not in AGENT_CONF_DICT.keys():
                    logger.error(get_logger_header()+"download_service_url field doesn't exist in agent.conf")
                    return False
                download_url = AGENT_CONF_DICT['download_service_url']
            else:
                download_url = interactive_download_url
                interactive_download = True

            if (download_url == None) :
                logger.error(get_logger_header()+"download_service_url field in agent.conf is empty")
                return False

            product = 'product=mastools'
            if get_ads_service_type() == 'AUTOMATION':
                product = 'product=adsselfmanagedmastools'
            elif get_ads_service_type() == 'INTENT':
                product = 'product=adscitrixmanagedmastools'

            build_path=  "root/download/v1/public/software?"+product+"&build="+ROOT_CERT_HASH+"&model=mastools.tgz"

            freeBSDVersion = read_command_output("uname -a")

            if 'freebsd 11.4' in freeBSDVersion.lower():
                product = 'product=mastools_11'
                if get_ads_service_type() == 'AUTOMATION':
                    product = 'product=adsselfmanagedmastools_11'
                elif get_ads_service_type() == 'INTENT':
                    product = 'product=adscitrixmanagedmastools_11'
                build_path=  "root/download/v1/public/software?"+product+"&build="+ROOT_CERT_HASH+"&model=mastools.tgz"
                
            
                    

            if running_inside_cpx() or IS_PLATFORM_LINUX:
                build_path = "root/download/v1/public/software?product=mastools_linux&build="+ROOT_CERT_HASH+"&model=mastools.tgz"

            try:
                build_content= requests.get("https://"+download_url +"/"+ build_path, verify=CERT_BUNDLE_PATH, stream=True, timeout=1000, proxies=get_mastools_proxy_requests())
            except requests.exceptions.SSLError as e:
                logger.debug(get_logger_header()+"SSL exception while downloading the image, Error: " + str(e) +" . Retrying with NetScaler cert.")
                if os.path.exists(NS_CERT_BUNDLE_PATH):
                    build_content= requests.get("https://"+download_url +"/"+ build_path, verify=NS_CERT_BUNDLE_PATH, stream=True, timeout=1000, proxies=get_mastools_proxy_requests())

            with open(LATEST_IMAGE_PATH + "mastools.tgz", 'wb') as fw:
                for chunk in build_content.iter_content(chunk_size=1024):
                    if chunk:
                        fw.write(chunk)

            logger.debug(get_logger_header()+"Request completed, Content is written into the file: " + LATEST_IMAGE_PATH + "mastools.tgz")
            metadata_hash = METADATA['HashValue']

            sha=''
            downloaded_build_hash = ''
            hash_build_file = ''
            with open(LATEST_IMAGE_PATH + "mastools.tgz", "rb") as f:
                m  = hashlib.sha256()
                m.update(base64.b64encode(f.read()))
                sha = m.digest()
            downloaded_build_hash = base64.b64encode(sha).decode()
            logger.debug(get_logger_header()+"Comparing downloaded build hash with hash in metadata file")
            hash_build_file = os.popen("cat " + LATEST_IMAGE_PATH + "mastools.tgz | openssl dgst -binary -sha256 | openssl base64").read();
            hash_build_file = hash_build_file.replace("\r\n","")
            hash_build_file = hash_build_file.replace("\n","")
            if((downloaded_build_hash != metadata_hash) and (hash_build_file != metadata_hash)):
                logger.debug("Downloaded build's hash different from hash value in metadata file, Aborting installation")
                run_command('mv ' + LATEST_IMAGE_PATH +'/mastools_old.tgz ' + LATEST_IMAGE_PATH +'/mastools.tgz')
                return False
            logger.debug(get_logger_header()+"Downloaded build's hash matches the hash in metadata file")
            run_command('rm -rf ' + PREV_IMAGE_PATH + '*')
            run_command('mv ' + LATEST_IMAGE_PATH +'* ' + PREV_IMAGE_PATH)
            run_command('rm -rf ' + PREV_IMAGE_PATH + '/mastools.tgz')
            run_command('mv ' + PREV_IMAGE_PATH +'/mastools_old.tgz ' + PREV_IMAGE_PATH +'/mastools.tgz')
            if interactive_download:
                print ("Download completed")
            return True
        except Exception as e:
            logger.exception(get_logger_header()+'Failed to download new image, retrying')

    if interactive_download:
        print ("Failed to download new image from download service")
    logger.error(get_logger_header()+'Failed to download new image from download service')
    return False

def get_local_version():

    default_version = ''
    file_test =os.path.exists(VERSION_FILE_PATH)
    if (file_test == False) :
        logger.error(get_logger_header()+"Version file doesn't exists. Aborting agent upgrade!")
        return default_version
    try:
        f = open(VERSION_FILE_PATH, 'r')
        local_version = f.readline()
        if (local_version == '') :
            logger.error(get_logger_header()+"version is null. Aborting agent upgrade!")
            return default_version

        local_version = local_version.rstrip()
        logger.debug(get_logger_header()+"Local Version: %s", local_version)
        f.close()
        return local_version
    except:
        logger.exception(get_logger_header()+"Exception happen while reading version file. Returning default version %s", default_version)

    return default_version

#Reading agent.conf, if exists
#Fetch the new builds version number from NetScaler Console
#Return: False if version number is empty or agent.conf not present (Agent not initialised)
#True if new version is available in mas service
def probe():

    if not os.path.exists("/var/mastools/conf/agent.conf"):
        logger.error(get_logger_header()+'agent not initialised')
        return False

    global CONTENT
    global AGENT_CONF_DICT

    with open("/var/mastools/conf/agent.conf", "r+") as agent_conf_file:
        CONTENT= agent_conf_file.read()
        agent_conf_file.close()

    AGENT_CONF_DICT = xmltodict.parse(CONTENT)['mps_agent']
    return True



def verify_signature(service_url = ''):

    global METADATA
    global AGENT_CONF_DICT
    global ROOT_CERT_HASH

    interactive_download = False

    if service_url == '':
        if 'download_service_url' not in AGENT_CONF_DICT.keys():
            logger.error(get_logger_header()+"download url field missing in agent.conf")
            return ''

        #compare the version number in NEW_VERSION returned from NetScaler Console with current version number on agent (version returned by NEW_VERSION should be greater)

        if (check_version(DEFAULT_SERVICE_URL) == False):
            logger.debug(get_logger_header()+"New version returned from NetScaler Console is same as compared to current version on Agent. Not downloading metadata file.")
            return ''
        else:
            logger.debug(get_logger_header()+"New version returned from NetScaler Console is not same as current version on Agent.")

        download_url = AGENT_CONF_DICT['download_service_url']
    else:
        download_url = get_download_url(service_url)
        interactive_download = True

    if (get_disk_usage()==False) :
        logger.error(get_logger_header()+"No disk space available. aborting the image download.")
        return ''

    if (download_url == '') :
        logger.error(get_logger_header()+"download_service_url field in agent.conf is empty")
        return ''

    # GENERATE hash value of cert_chain.pem here
    if not os.path.exists(CA_CERT_CHAIN):
        logger.error("%s %s doesn't exist.", get_logger_header(), CA_CERT_CHAIN)
        return ''

    with open(CA_CERT_CHAIN) as f:
        m  = hashlib.sha256()
        m.update((f.read()).encode('utf-8'))
        sha = m.digest()
        ROOT_CERT_HASH = base64.b64encode(sha).decode()

    metadata_path = "root/download/v1/public/software?product=mastools&build="+ROOT_CERT_HASH+"&model=metadata.pem"

    freeBSDVersion = read_command_output("uname -a")

    if 'freebsd 11.4' in freeBSDVersion.lower():
        metadata_path = "root/download/v1/public/software?product=mastools_11&build="+ROOT_CERT_HASH+"&model=metadata.pem"

    if running_inside_cpx() or IS_PLATFORM_LINUX:
        metadata_path = "root/download/v1/public/software?product=mastools_linux&build="+ROOT_CERT_HASH+"&model=metadata.pem"

    logger.debug(get_logger_header()+"Downloading signed metadata file from download site")
    try:
        response= requests.get("https://"+download_url +"/"+ metadata_path, verify=CERT_BUNDLE_PATH, stream=True, timeout=60, proxies=get_mastools_proxy_requests())
    except requests.exceptions.SSLError as e:
        logger.error(get_logger_header()+"get metadata file Exception: " + str(e) + " . Retrying with NetScaler cert.")
        if os.path.exists(NS_CERT_BUNDLE_PATH):
            try:
                response= requests.get("https://"+download_url +"/"+ metadata_path, verify=NS_CERT_BUNDLE_PATH, stream=True, timeout=60, proxies=get_mastools_proxy_requests())
            except requests.exceptions.RequestException as e:
                logger.error(get_logger_header()+"get metadata file Exception: " + str(e))
                return ''
        else :
            return ''
    except Exception as e :
        logger.error(get_logger_header()+"get metadata file Exception: " + str(e))
        return ''

    with open(LATEST_IMAGE_PATH + "signed_metadata.pem", 'wb') as fw:
        for chunk in response.iter_content(chunk_size=1024):
            if chunk:
                try:
                    fw.write(chunk)
                except:
                    logger.error(get_logger_header()+ "error in writing the metadata file")
                    return ''

    logger.debug(get_logger_header()+"Request completed, Content is written into the file: " + LATEST_IMAGE_PATH + "signed_metadata.pem")
    output= read_command_output('openssl cms -verify -in ' + LATEST_IMAGE_PATH + 'signed_metadata.pem -inform PEM -CAfile '+ CA_CERT_CHAIN)

    try:
        METADATA = json.loads(output)
        logger.debug(get_logger_header()+"Signature verification successful")
        if interactive_download:
            print('Download site signature verification successful')

        #compare the version number in metadata file with current version number on agent (version in metadata should be greater)

        if not os.path.exists(VERSION_FILE_PATH):
            logger.error(get_logger_header()+"%s doesn't exist.", VERSION_FILE_PATH)
            if interactive_download:
                print('No embedded agent version file in ADC. Please install your ADC image again')
            return ''

        current_version= read_command_output("cat /var/mastools/version.txt")
        cur_release,cur_build= current_version.split("-")
        metadata_version= METADATA['VersionNumber']
        new_release, new_build =  metadata_version.split("-")
        metadata_version=metadata_version.replace("\n","")
        current_version=current_version.replace("\n","")
        new_build,new_build_version = new_build.split(".")
        cur_build,cur_build_version = cur_build.split(".")
        logger.debug("Comparing agent local version " + current_version + " with metadata version " + metadata_version)
        if (float(new_release) == float(cur_release)) and (float(new_build) == float(cur_build)) and (float(new_build_version) == float(cur_build_version)):
            logger.debug(get_logger_header()+"Downloaded version is same as compared to current version")
            return ''
        else:
            logger.debug(get_logger_header()+"Downloaded version is not same as compared to current version")

        if interactive_download:
            print('Start downloadng image...')
            is_success = download_image(download_url)
        elif not IS_REGISTERED:
            is_success = download_image(download_url)
        else:
            is_success = download_image()

        if not is_success:
            return ''
        logger.debug(get_logger_header()+"Upgrading Embedded Agent now!")
        if interactive_download:
            print('Start upgrading...')
            return_value = upgrade_agent(False)
            print('Upgrade done')
        else:
            return_value = upgrade_agent()
        if not return_value:
            return ''
    except ValueError as e:
        logger.exception(get_logger_header()+"Signature verification failed")
        logger.error(get_logger_header()+"verification output is" + output)
        if interactive_download:
            print('Signature verification failed! Please contact customer support')
        return ''

def get_download_url(service_url):
    fetch_url = "https://" + service_url + "/fetch_urls"
    try:
        response = requests.get(fetch_url, verify=CERT_BUNDLE_PATH, timeout=1000, proxies=get_mastools_proxy_requests())
    except requests.exceptions.SSLError as e:
        logger.debug("Exception occured while fecth url, exception:"+repr(e)+ " . Retrying with NetScaler cert.")
        if os.path.exists(NS_CERT_BUNDLE_PATH):
            try:
                response = requests.get(fetch_url, verify=NS_CERT_BUNDLE_PATH, timeout=1000, proxies=get_mastools_proxy_requests())
            except Exception as e:
                logger.debug("Exception occured while fecth url, exception:"+repr(e))
                print ("Could not get valid download url, please check if you have entered the right service url")
                return ''
        else:
            logger.debug("Exception occured while fecth url, exception:"+repr(e))
            print ("Could not get valid download url, please check if you have entered the right service url")
            return ''
    except Exception as e:
        logger.debug("Exception occured while fecth url, exception:"+repr(e))
        print ("Could not get valid download url, please check if you have entered the right service url")
        return ''

    if response.status_code != requests.codes.ok:
        logger.debug("fetch url response error, response:"+response.content)
        print ("Could not get valid download url, please check if you have entered the right service url")
        return ''

    response_content = response.content.decode()
    download_url = response_content.split(';')[0]
    download_url = download_url.strip('\"')
    if download_url == '':
        logger.debug("download ulr is empty, response:"+response.content)
        print('Could not get valid download url, please check if you have entered the right service url')

    return  download_url

def compare_version(suggest_version):
    try:
        current_version= read_command_output("cat /var/mastools/version.txt")
        cur_release,cur_build= current_version.split("-")
        new_release, new_build =  suggest_version.split("-")
        suggest_version=suggest_version.replace("\n","")
        current_version=current_version.replace("\n","")
        new_build,new_build_version = new_build.split(".")
        cur_build,cur_build_version = cur_build.split(".")
        logger.debug("Comparing MASTools local version " + current_version + " with suggest version " + suggest_version)
        if(float(new_release) == float(cur_release)) and (float(new_build) == float(cur_build)) and (float(new_build_version) == float(cur_build_version)):
            logger.debug(get_logger_header()+"Downloaded version same as current version")
            return False
    except Exception as e:
        logger.debug("Exception occured in compare_version, exception:"+repr(e))
        return False
    return True

def check_version(service_url):
    fetch_url = "https://" + service_url + GET_CURR_VER_URI
    try:
        response = requests.get(fetch_url, verify=CERT_BUNDLE_PATH, timeout=1000, proxies=get_mastools_proxy_requests())
    except requests.exceptions.SSLError as e:
        logger.debug(get_logger_header()+"Exception occured while get_current_version url:"+ fetch_url+", exception:"+repr(e)+ " . Retrying with NetScaler cert.")
        if os.path.exists(NS_CERT_BUNDLE_PATH):
            try:
                response = requests.get(fetch_url, verify=NS_CERT_BUNDLE_PATH, timeout=1000, proxies=get_mastools_proxy_requests())
            except Exception as e:
                logger.debug(get_logger_header()+"Exception occured while get_current_version url:"+ fetch_url+", exception:"+repr(e))
                return False
        else: 
            logger.debug(get_logger_header()+"Exception occured while get_current_version url:"+ fetch_url+", exception:"+repr(e))
            return False
    except Exception as e:
        logger.debug(get_logger_header()+"Exception occured while get_current_version url:"+ fetch_url+", exception:"+repr(e))
        return False

    if response.status_code != requests.codes.ok:
        logger.debug("get_current_version response error, response:"+response.content)
        return False

    try:
        content = json.loads(response.content)
        suggest_version = content.get(VERSION, '')
        if suggest_version == '':
            logger.debug("Could not get the version from NetScaler Console, response is:" + response.content)
            return False
        return compare_version(suggest_version)
    except Exception as e:
        logger.debug("Exception occured while trying to compare version, exception:"+repr(e))
        return False

def get_disk_usage():
    disk_usage = psutil.disk_usage("/var")
    freeDisk = disk_usage[2]
    logger.debug(get_logger_header()+"current available disk space is " + str(freeDisk))
    # If disk space is less than 150 MB , return false to abort the upgrade process
    if freeDisk > 150000000:
        return True
    return False

# main
if __name__ == '__main__':
    run_command('mkdir -p ' + LATEST_IMAGE_PATH)
    run_command('mkdir -p ' + PREV_IMAGE_PATH)

    global interactive_download
    interactive_download = False

    if len(sys.argv) == 2:
        service_url = sys.argv[1]
        interactive_download = True
        verify_signature(service_url)
        sys.exit(0)

    if len(sys.argv) == 3:
        service_url = sys.argv[1]

    # this is to check for Japan cloud 
    cloud_location = checkCloudOption()
    if const.JP_CLOUD_OPTION.lower() == cloud_location.lower():
        DEFAULT_SERVICE_URL = const.JP_ADM_AGENT_EP  #"agent.adm.cloud.jp"
    else:
        DEFAULT_SERVICE_URL = const.ADM_AGENT_EP  #"agent.adm.cloud.com"

    while True:
        if not IS_REGISTERED:
            if check_version(DEFAULT_SERVICE_URL):
                verify_signature(DEFAULT_SERVICE_URL)
        else:
            flag = probe()
            if (flag):
                try:
                    if(AGENT_CONF_DICT['download_service_url'].find("staging")!=-1):
                        DEFAULT_SERVICE_URL = "agent.adm.cloudburrito.com"
                    verify_signature()
                except Exception as e:
                    logger.error("Exception : " + repr(e) + " while upgrading mastools")

        logger.debug(get_logger_header()+"Sleeping for " + str(AGENT_POLL_TIME) +" secs")
        time.sleep(AGENT_POLL_TIME)


