#!/usr/local/bin/python

import requests.packages.urllib3
import requests
import base64
import pg8000
import sys
import time
import os
import urllib
import urllib3
import httplib2
import fileinput
import json
import re
import datetime
import xmltodict
import subprocess
import hashlib
#from datetime import datetime
from datetime import timedelta

import shlex

#=================For setting up logging ==============================================================================================================
import logging
import logging.handlers

log_file_name_local = os.path.basename(__file__.rstrip('.py'))
LOG_FILENAME = '/var/mastools/logs/' + log_file_name_local + '.log'
LOG_MAX_BYTE = 50*1024*1024
LOG_BACKUP_COUNT = 20

# Set up a specific logger.with our desired output level
logger=logging.getLogger(__name__)
logger.setLevel(logging.DEBUG)

# Add the log message handler to the logger
logger.handler = logging.handlers.RotatingFileHandler(LOG_FILENAME, maxBytes=LOG_MAX_BYTE, backupCount=LOG_BACKUP_COUNT)
logger.fortmater = logging.Formatter(fmt='%(asctime)s:%(funcName)s:%(lineno)d: [%(levelname)s] %(message)s', datefmt="%Y-%m-%d %H:%M:%S")
logger.handler.setFormatter(logger.fortmater)
logger.addHandler(logger.handler)
#======================================================================================================================================================


#Global Variables
AGENT_POLL_TIME = 3600
RETRY_TIME = 120
RETRY_COUNT = 10
LATEST_IMAGE_PATH= "/var/mastools/images/latest/"
PREV_IMAGE_PATH= "/var/mastools/images/prev/"
TRUST_KEY_DIR = "/var/mastools/trust/.ssh/"
TMP_DIR = "/var/tmp"
CONTENT=''
NEW_IMAGE_MD5CHECKSUM= ''
CERT_BUNDLE_PATH='/var/mastools/cert/cacert.pem'
AGENT_CONF_DICT= {}
DOWNLOAD_PATH_PUBLIC = "root/download/v1/public/software?product=mastools&build=latest&model=mastools.tgz"
DOWNLOAD_PATH_AUTH= "root/download/v1/auth/software?product=mastools&build=latest&model=mastools.tgz"
METADATA=''
NEW_VERSION=''
VERSION_FILE_PATH = '/var/mastools/version.txt'
CA_CERT_CHAIN= '/var/mastools/cert/ca-chain.cert.pem'
APIGW_URL = {}
APIGW_HEADERS = {}
UPGRADE_TIME = "IMMEDIATE"
MGMT_TENANT_COOKIE = '_MGMT_TENANT'

#=================For safe command execution +==========================================================================================================
import subprocess, threading, psutil, signal

def read_command_output(cmd):
    args = shlex.split(cmd)
    process = subprocess.Popen(args, stdout=subprocess.PIPE, stderr=None)
    output = process.communicate()
    return output[0]

def get_logger_header():
    if 'customerid' not in AGENT_CONF_DICT.keys():
        customerid = "none"
    else:
        customerid = AGENT_CONF_DICT['customerid']
    if 'instanceid' not in AGENT_CONF_DICT.keys():
        instanceid = "none"
    else:
        instanceid = AGENT_CONF_DICT['instanceid']
    logger_str = "[mastools_upgrade_"+customerid+"_"+instanceid+"]: "
    return logger_str

def get_apigw_url(path):

		global APIGW_URL
		global APIGW_HEADERS
		try:
			if 'url' not in AGENT_CONF_DICT.keys():
				logger.error(get_logger_header()+"url field missing in agent.conf")
				return False

			cloudurl = AGENT_CONF_DICT['url']
			if (cloudurl == None) :
				logger.error(get_logger_header()+"url field in agent.conf is empty")
				return False

			if 'customerid' not in AGENT_CONF_DICT.keys():
				logger.error(get_logger_header()+"customerid field is missing in agent.conf")
				return False

			customerid = AGENT_CONF_DICT['customerid']
			if (customerid == None) :
				logger.error(get_logger_header()+"customerid field in agent.conf is empty")
				return False

			if 'servicename' not in AGENT_CONF_DICT.keys():
				logger.error(get_logger_header()+"servicename field is missing in agent.conf")
				return False

			servicename = AGENT_CONF_DICT['servicename']
			if (servicename == None) :
				logger.error(get_logger_header()+"servicename field in agent.conf is empty")
				return False

			if 'instanceid' not in AGENT_CONF_DICT.keys():
				logger.error(get_logger_header()+"instanceid field is missing in agent.conf")
				return False

			instanceid = AGENT_CONF_DICT['instanceid']
			if (instanceid == None) :
				logger.error(get_logger_header()+"instanceid field in agent.conf is empty")
				return False


			if (path == None):
				logger.error(get_logger_header()+"url path is empty")
				return False

			APIGW_URL[path] = 'https://' + cloudurl + "/" + customerid + "/" + servicename + path
			logger.debug(get_logger_header()+"Generated APIGW URL is "+APIGW_URL[path])

			tmp_inp_file = TMP_DIR + "inp_comp_url_tmp"
			tmp_sha_file = TMP_DIR + "tmp_sha_output"

			f = open(tmp_inp_file, 'w')
			f.write(APIGW_URL[path])
			f.close()

			if not os.path.exists(TRUST_KEY_DIR):
				logger.error(get_logger_header()+"%s doesn't exist",TRUST_KEY_DIR)
				return False

			read_command_output("openssl dgst -sha256 -sign " + TRUST_KEY_DIR + "private.pem -out "+ tmp_sha_file +" "+ tmp_inp_file);
			signature = read_command_output("openssl base64 -in "+tmp_sha_file)
			signature = signature.replace("\r\n","")
			signature = signature.replace("\n","")

			if os.path.exists(tmp_inp_file):
				os.remove(tmp_inp_file)
			if os.path.exists(tmp_sha_file):
				os.remove(tmp_sha_file)
			token = signature + ";" + servicename + ";" + instanceid;
			service_token = base64.b64encode(token.encode()).decode('utf-8');

			APIGW_HEADERS[path] = {}
			APIGW_HEADERS[path] = {'Content-Type':'application/json'}
			APIGW_HEADERS[path]['Authorization'] = 'DNBUAuth service='+service_token
			logger.debug(get_logger_header()+"Obtained APIGW_HEADERS")
			return True

		except Exception as e:
			logger.exception(get_logger_header()+"Failed to get api gateway URL")
			return False
			
	
def send_post_request(path, payload=None):
	
	 temp = get_apigw_url(path)
	 no_of_retries = 0
	 while (not temp and no_of_retries < RETRY_COUNT):
	  time.sleep(RETRY_TIME)
	  temp = get_apigw_url(path)
	  no_of_retries = no_of_retries + 1
		
	 if not temp:
	   logger.error(get_logger_header()+"Unable to fetch api gateway url, even after %d retries. Aborting upgrade!" ,RETRY_COUNT);
	   return False
	 try:
            response = requests.post(APIGW_URL[path], data=payload, headers=APIGW_HEADERS[path])
            if (response.status_code == requests.codes.ok):
                logger.debug(get_logger_header()+"HTTP POST request to server successful")
                return response
            else:
                logger.error(get_logger_header()+"HTTP POST request to server failed")
                response.raise_for_status()
                return False
	 except Exception as e:
            logger.exception(get_logger_header()+"Failed to establish connection to server")
            return False
	 

def send_put_request(path, payload=None):

         temp = get_apigw_url(path)
         no_of_retries = 0
         while (not temp and no_of_retries < RETRY_COUNT):
                time.sleep(RETRY_TIME)
                temp = get_apigw_url(path)
                no_of_retries = no_of_retries + 1
                
         if not temp:
                 logger.error(get_logger_header()+"Unable to fetch api gateway url, even after %d retries. Aborting upgrade!" ,RETRY_COUNT);
                 return False
                        
         try:
            response = requests.put(APIGW_URL[path], data=payload, headers=APIGW_HEADERS[path])
            if (response.status_code == requests.codes.ok):
                logger.debug(get_logger_header()+"HTTP PUT request to server successful")
                return response
            else:
                logger.error(get_logger_header()+"HTTP PUT request to server failed")
                response.raise_for_status()
                return False
         except Exception as e:
            logger.exception(get_logger_header()+"Failed to establish connection to server")


#Updating agent status
def updateAgentStatus(status):

    return True  



#untar the image package, and install the build
#Return: False if any command fails  
def upgrade_agent():
    
    logger.debug(get_logger_header()+"Upgrading agent...")
    
    if not os.path.exists(LATEST_IMAGE_PATH +"mastools.tgz"):
     logger.error(get_logger_header()+"%s doesn't exist", LATEST_IMAGE_PATH+"mastools.tgz")
     return False
	
	
    updateAgentStatus("Upgrading") 
    cmd = "tar -xvzf " + LATEST_IMAGE_PATH +"mastools.tgz -C /var/mastools"
    output = os.system(cmd)
    logger.debug(get_logger_header()+"restart the mastools")
    cmd = "/var/mastools/scripts/mastoolsd restart"
    output = os.system(cmd)
    return True

#Get the maintenance window chosen by the customer from server
def get_maintenance_window():

		logger.debug(get_logger_header()+"Getting maintenance window ...")
		global UPGRADE_TIME
		
		if 'customerid' not in AGENT_CONF_DICT.keys():
	           logger.error(get_logger_header()+"customerid field is missing in agent.conf")
	           return False

		customerid = AGENT_CONF_DICT['customerid']
		if (customerid == None) :
                   logger.error(get_logger_header()+"customerid field in agent.conf is empty")
                   return False
	
		path = "/nitro/v1/config/agent_maintenance_wndw"
		
	
		payload = 'object={"params":{"action":"GET_MAINTENANCE_WNDW"},"agent_maintenance_wndw":{"cust_id":"'+str(customerid)+'"}}'
		try:
			response = send_post_request(path, payload)
			if not response:
				return False
			contentDictionary = json.loads(response.content)
			if  contentDictionary['message'] == "Done":
				resourceData=contentDictionary['agent_maintenance_wndw']
				for props in resourceData:
					if('agent_upgrade_time' in props):
						UPGRADE_TIME=props['agent_upgrade_time']
						UPGRADE_TIME=UPGRADE_TIME.replace("\n","")
						return True
					else:
				       		logger.error (get_logger_header()+"Getting New version from MA service failed.Exiting!")
				       		return False
			elif response.status_code == '401':
				logger.error(get_logger_header()+"Unable to get successful response from MA service. Exiting!")
				return False
		except Exception as e:
				cloudServiceIsDownFooter = """----------------------------------------------------------------------------
			Unable to connect Mgmt-Service. Please try after some time.
			----------------------------------------------------------------------------"""
				logger.exception (get_logger_header()+cloudServiceIsDownFooter)
				return False
    
	

# Download new image from download service
# if able to download successfully then call Upgrade_agent() 
# There will be 2 retries
# Return: Empty string for failure        
def download_image():
    os.system('rm -rf ' + PREV_IMAGE_PATH + '*')
    os.system('mv ' + LATEST_IMAGE_PATH +'* ' + PREV_IMAGE_PATH) 
    
    for retry in range(0,3):
        logger.debug(get_logger_header()+"Get new image, Attempt number " + str(retry+1)) 
        try:   
            global NEW_IMAGE_MD5CHECKSUM 
            global AGENT_CONF_DICT
            global CONTENT
            global DOWNLOAD_PATH_PUBLIC
            global DOWNLOAD_PATH_AUTH
            global METADATA
            global NEW_VERSION
            global ROOT_CERT_HASH

           
           # This code is not used, as download service doesnt demand authentication
            if (len(sys.argv) ==2 and (sys.argv[1].lower() == "auth")): 
                ''' 
                key = get_encryption_key()
                if (key==-1):
                    logger.error(get_logger_header()+"Failed to get the encryption key while downloading image")
                    return ''
                customerid = read_command_output("/mps/mpsutil -decrypt -str "+AGENT_CONF_DICT['customerid']+" -key "+key+" -randomsalt true")
                servicename = read_command_output("/mps/mpsutil -decrypt -str "+AGENT_CONF_DICT['servicename']+" -key "+key+" -randomsalt true")
                instanceid = read_command_output("/mps/mpsutil -decrypt -str "+AGENT_CONF_DICT['instanceid']+" -key "+key)
                url = 'https://' + download_url + "/" + customerid + "/" + servicename + DOWNLOAD_PATH_AUTH 
                tmp_inp_file = TMP_DIR + "inp_comp_url_tmp"
                tmp_sha_file = TMP_DIR + "tmp_sha_output"

                f = open(tmp_inp_file, 'w')
                f.write(url)
                f.close() 

		if not os.path.exists(TRUST_KEY_DIR):
        	    logger.error(get_logger_header()+"%s doesn't exist",TRUST_KEY_DIR)
            	    return -1	

                read_command_output("openssl dgst -sha256 -sign " + TRUST_KEY_DIR + "private.pem -out "+ tmp_sha_file +" "+ tmp_inp_file);
                signature = read_command_output("openssl base64 -in "+tmp_sha_file)
                signature = signature.replace("\r\n","")
                signature = signature.replace("\n","")
   
                if os.path.exists(tmp_inp_file):
                    os.remove(tmp_inp_file)
                if os.path.exists(tmp_sha_file):
                    os.remove(tmp_sha_file)
                token = signature + ";" + servicename + ";" + AGENT_CONF_DICT['instanceid'];
                service_token = base64.b64encode(token);
             
                httpConnection=httplib2.Http(".cache",ca_certs=CERT_BUNDLE_PATH)
                headers_conn = {'Content-Type':'application/json'}
                headers_conn['Authorization'] = 'DNBUAuth service='+service_token
                logger.debug(get_logger_header()+"Download Started") 
                responseStatus, build_content = httpConnection.request(url, "GET", headers=headers_conn)
                logger.debug(get_logger_header()+"Request completed, now writing the contents into a file: " + LATEST_IMAGE_PATH + "mastools.tgz")
                with open(LATEST_IMAGE_PATH + "mastools.tgz", 'wb') as fw:
                   fw.write(build_content)
                downloadedImage_md5checksum = os.system('md5 '+ LATEST_IMAGE_PATH + 'mastools.tgz')
                if (NEW_IMAGE_MD5CHECKSUM != downloadedImage_md5checksum):
                    logger.error(get_logger_header()+'md5checksums don\'t match after downlaod') 
                    return '' 
                logger.debug(get_logger_header()+'Retrieved new image successfully')
                return_value = upgrade_agent()
                if not return_value:
                    return ''
	    '''
            else:
                logger.debug(get_logger_header()+"Download Started")
                if 'download_service_url' not in AGENT_CONF_DICT.keys():
                    logger.error(get_logger_header()+"download_service_url field doesn't exist in agent.conf")
                    return False
                download_url = AGENT_CONF_DICT['download_service_url']
                if (download_url == None) :
                    logger.error(get_logger_header()+"download_service_url field in agent.conf is empty")
                    return False
				
                build_path=  "root/download/v1/public/software?product=mastools&build="+ROOT_CERT_HASH+"&model=mastools.tgz"
                build_content= requests.get("https://"+download_url +"/"+ build_path, verify=CERT_BUNDLE_PATH, stream=True, timeout=1000)   
                with open(LATEST_IMAGE_PATH + "mastools.tgz", 'wb') as fw:
                    for chunk in build_content.iter_content(chunk_size=1024):
                        if chunk:
                            fw.write(chunk)
                
                logger.debug(get_logger_header()+"Request completed, Content is written into the file: " + LATEST_IMAGE_PATH + "mastools.tgz") 
				
                metadata_hash = METADATA['HashValue']
                
                sha=''
                with open(LATEST_IMAGE_PATH + "mastools.tgz","rb") as f:
                      m  = hashlib.sha256()
                      m.update(f.read())
                      sha = m.digest()
                downloaded_build_hash = base64.b64encode(sha).decode()
                logger.debug(get_logger_header()+"Comparing downloaded build hash with hash in metadata file")
                if(downloaded_build_hash != metadata_hash):
                    logger.debug(get_logger_header()+"Downloaded build's hash different from hash value in metadata file, Aborting installation")
                    return False 
                logger.debug(get_logger_header()+"Downloaded build's hash matches the hash in metadata file") 
                return True
        except Exception as e:
            logger.exception(get_logger_header()+'Failed to download new image, retrying')
    
    logger.error(get_logger_header()+'Failed to download new image from download service')
    return False

def get_local_version():

    default_version = ''
    file_test =os.path.exists(VERSION_FILE_PATH)
    if (file_test == False) :
        logger.error(get_logger_header()+"Version file doesn't exists. Aborting agent upgrade!")
        return default_version
    try:
        f = open(VERSION_FILE_PATH, 'r')
        local_version = f.readline()
        if (local_version == '') :
            logger.error(get_logger_header()+"version is null. Aborting agent upgrade!")
            return default_version
        
        local_version = local_version.rstrip()
        logger.debug(get_logger_header()+"Local Version: %s", local_version)
        f.close()
        return local_version
    except:
        logger.exception(get_logger_header()+"Exception happen while reading version file. Returning default version %s", default_version)

    return default_version


def fetch_new_version():
    
	global NEW_VERSION
	#key = -1
        #no_of_retries = 0
        #key = get_encryption_key()	

        #while (key==-1 and no_of_retries < 10):
	   #time.sleep(RETRY_TIME) #Give DB time to initialise
           #key = get_encryption_key()
	   #no_of_retries = no_of_retries + 1

        #if (key == -1):
	    #logger.error(get_logger_header()+"Unable to fetch encryption key after 10 attempts. Aborting agent upgrade!") 
	    #return -1
	
	if 'url' not in AGENT_CONF_DICT.keys():
       	    logger.error(get_logger_header()+"url field missing in agent.conf")
       	    return -1 
        
	cloudurl = AGENT_CONF_DICT['url']
	if (cloudurl == None) :
            logger.error(get_logger_header()+"url field in agent.conf is empty")
            return -1 
        
	if 'customerid' not in AGENT_CONF_DICT.keys():
	    logger.error(get_logger_header()+"customerid field is missing in agent.conf")
	    return -1

	customerid = AGENT_CONF_DICT['customerid']
	if (customerid == None) :
            logger.error(get_logger_header()+"customerid field in agent.conf is empty")
            return -1
	
	if 'servicename' not in AGENT_CONF_DICT.keys():
            logger.error(get_logger_header()+"servicename field is missing in agent.conf")
            return -1

	servicename = AGENT_CONF_DICT['servicename']
	if (servicename == None) :
            logger.error(get_logger_header()+"servicename field in agent.conf is empty")
            return -1
	
	if 'instanceid' not in AGENT_CONF_DICT.keys():
       	    logger.error(get_logger_header()+"instanceid field is missing in agent.conf")
            return -1

	instanceid = AGENT_CONF_DICT['instanceid']
	if (instanceid == None) :
            logger.error(get_logger_header()+"instanceid field in agent.conf is empty")
            return -1

	#customerid = read_command_output("/mps/mpsutil -decrypt -str "+AGENT_CONF_DICT['customerid']+" -key "+key)
        #servicename = read_command_output("/mps/mpsutil -decrypt -str "+AGENT_CONF_DICT['servicename']+" -key "+key)
        #instanceid = read_command_output("/mps/mpsutil -decrypt -str "+AGENT_CONF_DICT['instanceid']+" -key "+key)	
		
	url = 'https://' + cloudurl + "/" + customerid + "/" + servicename + "/nitro/v1/config/mps"
	tmp_inp_file = TMP_DIR + "inp_comp_url_tmp"
	tmp_sha_file = TMP_DIR + "tmp_sha_output"
            
	f = open(tmp_inp_file, 'w')
	f.write(url)
	f.close()
	
	if not os.path.exists(TRUST_KEY_DIR):
            logger.error(get_logger_header()+"%s doesn't exist",TRUST_KEY_DIR)
            return -1

	read_command_output("openssl dgst -sha256 -sign " + TRUST_KEY_DIR + "private.pem -out "+ tmp_sha_file +" "+ tmp_inp_file);
	signature = read_command_output("openssl base64 -in "+tmp_sha_file)
	signature = signature.decode('utf-8').replace("\r\n","")
	signature = signature.replace("\n","")
                        
	if os.path.exists(tmp_inp_file):
            os.remove(tmp_inp_file)
	if os.path.exists(tmp_sha_file):
            os.remove(tmp_sha_file)
	token = signature + ";" + servicename + ";" + instanceid;
	service_token = base64.b64encode(token.encode('utf-8')).decode('utf-8');
	local_version = get_local_version()
	if local_version=='':
             return -1 	     
	rpt_sample_time = int(time.time())
	rpt_sample_time = str(rpt_sample_time)
	
	if not os.path.exists(CERT_BUNDLE_PATH):
	    logger.error(get_logger_header()+"%s doesn't exist", CERT_BUNDLE_PATH)
	    return -1
        
	method = 'GET'

	httpConnection=httplib2.Http(".cache",ca_certs=CERT_BUNDLE_PATH)
	headers_conn = {'Content-Type':'application/json'}
	headers_conn['Authorization'] = 'DNBUAuth service='+service_token
	if 'mgmt_tenant' in AGENT_CONF_DICT.keys():
            headers_conn['Cookie'] = MGMT_TENANT_COOKIE + ':"yes"'
		
	try:
            responseStatus, content = httpConnection.request(url, method, headers=headers_conn, body=payload)
            #responseStatus = requests.post(url, data=payload, headers=headers_conn, timeout=10, verify=False)
            if responseStatus['status'] == '200':
                contentDictionary = json.loads(content)
                if  contentDictionary['message'] == "Done":
                    resourceData=contentDictionary['mps']
                    for props in resourceData:
                        if('product_build_number' in props):
                            NEW_VERSION=props['product_build_number']
                            NEW_VERSION=NEW_VERSION.replace("\n","") 
                else:
                    logger.error (get_logger_header()+"Getting New version from MA service failed.Exiting!")
                    sys.exit(0)
            else:
	            logger.error(get_logger_header()+"Unable to get successful response from MA service. Exiting!")
	            return ' '
	except Exception as e:
            cloudServiceIsDownFooter = """----------------------------------------------------------------------------
    Unable to connect Mgmt-Service. Please try after some time.
    ----------------------------------------------------------------------------"""
            logger.exception (get_logger_header()+cloudServiceIsDownFooter)
            sys.exit(0)
    


#Reading agent.conf, if exists
#Fetch the new builds version number from MAS service
#Return: False if version number is empty or agent.conf not present (Agent not initialised)
#True if new version is available in mas service         
def probe():

    if not os.path.exists("/var/mastools/conf/agent.conf"):
        logger.error(get_logger_header()+'agent not initialised')
        return False 
    
    global CONTENT
    global AGENT_CONF_DICT 
    global NEW_VERSION
 
    with open("/var/mastools/conf/agent.conf", "r+") as agent_conf_file:
        CONTENT= agent_conf_file.read()
        agent_conf_file.close()
    
    AGENT_CONF_DICT = xmltodict.parse(CONTENT)['mps_agent']
    
    
    ###############################################
    #NEW_VERSION = Probe MAS service for new version 
    ###############################################
    fetch_new_version() 
    if (NEW_VERSION == ''):
        logger.error(get_logger_header()+'Unable to fetch new agent version from MA service')
        return False
    else: 
        logger.debug('%s MA service recommends agent to upgrade to %s version ', get_logger_header(),NEW_VERSION)
        return True  
    return True 



def verify_signature():

    global METADATA
    global AGENT_CONF_DICT
    global NEW_VERSION
    global ROOT_CERT_HASH

    if 'download_service_url' not in AGENT_CONF_DICT.keys():
        logger.error(get_logger_header()+"download url field missing in agent.conf")
        return ''

    #compare the version number in NEW_VERSION returned from MAS with current version number on agent (version returned by NEW_VERSION should be greater)
				
    current_version= read_command_output("cat /var/mastools/version.txt")
    cur_release,cur_build= current_version.decode('utf-8').split("-")
    new_release, new_build =  NEW_VERSION.split("-")
    NEW_VERSION=NEW_VERSION.replace("\n","")
    current_version=current_version.decode('utf-8').replace("\n","")
    new_build,new_build_version = new_build.split(".")
    cur_build,cur_build_version = cur_build.split(".")
    logger.debug(get_logger_header()+"Comparing agent local version " + current_version + " with recommended version " + NEW_VERSION)
    if( (float(new_release) < float(cur_release)) or ((float(new_release) == float(cur_release)) and (float(new_build) <= float(cur_build)) and (float(new_build_version) <= float(cur_build_version)) )):	
        logger.debug(get_logger_header()+"New version returned from MAS is older or same as current version on Agent.Aborting agent upgrade!")  
        return '' 	

    download_url = AGENT_CONF_DICT['download_service_url']
    if (download_url == '') :
        logger.error(get_logger_header()+"download_service_url field in agent.conf is empty")
        return ''

    # GENERATE hash value of cert_chain.pem here
    if not os.path.exists(CA_CERT_CHAIN):
        logger.error("%s %s doesn't exist.", get_logger_header(), CA_CERT_CHAIN)
        return ''
 
    with open(CA_CERT_CHAIN) as f:
            m  = hashlib.sha256()
            m.update(f.read().encode('utf-8'))
            sha = m.digest()
    ROOT_CERT_HASH = base64.b64encode(sha).decode('utf-8')

    metadata_path = "root/download/v1/public/software?product=mastools&build="+ROOT_CERT_HASH+"&model=metadata.pem"
    logger.debug(get_logger_header()+"Downloading signed metadata file")
    response= requests.get("https://"+download_url +"/"+ metadata_path, verify=CERT_BUNDLE_PATH, stream=True, timeout=60)
    with open(LATEST_IMAGE_PATH + "signed_metadata.pem", 'wb') as fw:
        for chunk in response.iter_content(chunk_size=1024):
            if chunk:
                fw.write(chunk)
    logger.debug(get_logger_header()+"Request completed, Content is written into the file: " + LATEST_IMAGE_PATH + "signed_metadata.pem")
    output= read_command_output('openssl cms -verify -in ' + LATEST_IMAGE_PATH + 'signed_metadata.pem -inform PEM -CAfile '+ CA_CERT_CHAIN)
    try:
        METADATA = json.loads(output)
        logger.debug(get_logger_header()+"Signature verification successful") 

        #compare the version number in metadata file with current version number on agent (version in metadata should be greater)

        if not os.path.exists(VERSION_FILE_PATH):
       	    logger.error(get_logger_header()+"%s doesn't exist.", VERSION_FILE_PATH)
       	    return ''			

        current_version= read_command_output("cat /var/mastools/version.txt")
        cur_release,cur_build= current_version.decode('utf-8').split("-")
        metadata_version= METADATA['VersionNumber']
        new_release, new_build =  metadata_version.split("-")
        metadata_version=metadata_version.replace("\n","")
        current_version=current_version.decode('utf-8').replace("\n","")
        new_build,new_build_version = new_build.split(".")
        cur_build,cur_build_version = cur_build.split(".")
        logger.debug("Comparing agent local version " + current_version + " with metadata version " + metadata_version)
        if( (float(new_release) < float(cur_release)) or ((float(new_release) == float(cur_release)) and (float(new_build) <= float(cur_build)) and (float(new_build_version) <= float(cur_build_version)) )): 
            logger.debug(get_logger_header()+"Downloaded version is older or same as current version")  
            return '' 
			
        is_success = download_image()
        if not is_success:
          return ''
        logger.debug(get_logger_header()+"Maintenance window is default.Upgrading Agent now!")
        return_value = upgrade_agent()     
        if not return_value:
            return ''               
        #return_value = get_maintenance_window()
        #if not return_value:
           #logger.error("Error occured while fetching maintenance window. Continue upgrade at as soon as build is available") 
        #DEFAULT_TIME = "IMMEDIATE"
        #if (UPGRADE_TIME.lower() == DEFAULT_TIME.lower()):
        #timestamp_local = str(datetime.datetime.now().strftime('%H:%M'))
        #timestamp_upgrade = UPGRADE_TIME 
        #t_local = datetime.datetime.strptime(timestamp_local, "%H:%M")
        #t_upgrade = datetime.datetime.strptime(timestamp_upgrade, "%H:%M")

        #logger.debug("Maintenance window local time %s upgrade time %s", t_local, t_upgrade)
	#if (t_upgrade == t_local):
	   #logger.debug("Maintenance window is reached. Upgrading agent now!")
           #return_value = upgrade_agent()
           #if not return_value:
               #return ''
	#if (t_upgrade < t_local):
	    #tmp_time = datetime.datetime.strptime("23:00", "%H:%M")
	    #td = tmp_time - (t_local - t_upgrade)
	    #sleep_time_secs = (td.hour * 60 * 60) + (td.minute * 60 )
	    #sleep_time_secs = 3600 + sleep_time_secs # Formula is 24 - (t_local - t_upgrade). Compensating for one missing hour
	    #logger.debug("Maintenance window on agent is passed! Waiting for %s secs to upgrade", sleep_time_secs)
	    #time.sleep(sleep_time_secs)
            #return_value = upgrade_agent()
            #if not return_value:
                #return '' 
	#else:
	    #td = t_upgrade - t_local
	    #sleep_time_secs = td.seconds #timedelta doesn't have hour and min. Only days and secs. days are 0 here
	    #logger.debug("Obtained Maintenance window. Agent will upgrade in %s secs", sleep_time_secs)
            #time.sleep(sleep_time_secs)
	    #return_value = upgrade_agent()
            #if not return_value:
                #return ''
		 
    except ValueError as e:
        logger.exception(get_logger_header()+"Signature verification failed")
        logger.error(get_logger_header()+"verification output is" + output) 
        return '' 
    

# main 
if __name__ == '__main__':
    os.system('mkdir -p ' + LATEST_IMAGE_PATH)
    os.system('mkdir -p ' + PREV_IMAGE_PATH)
    
    while True:
        flag = probe()
        if (flag):
            verify_signature()   
        logger.debug(get_logger_header()+"Sleeping for " + str(AGENT_POLL_TIME) +" secs")
        time.sleep(AGENT_POLL_TIME)



