#!/usr/local/bin/python

import sys
import time
import os
import xmltodict
import httplib2
import json
import errno
import subprocess
import optparse
import traceback
import shlex
#from apps.common.IPUtils  import IPUtils
import binascii
import base64
import string
import getpass
import pwd
import grp
import os.path
import shutil
import base64
import random
from xml.dom import minidom
import socket
import argparse
SVM_MPS_LIB = '/mps/lib'
if os.path.exists(SVM_MPS_LIB):
    import psycopg2

try:
    from mastools_reg import sign_request, is_python_2_6, auth_request_header, get_proxy_setting, get_mastools_proxy_httplib2
except:
    pass

import cloud_constants as const

if sys.version_info[0] < 3: 
    # Python 2
    import ConfigParser as configparser
    import StringIO as io
else:
    # Python 3
    import configparser

NS_CONFIG_FILE='/nsconfig/ns.conf'

MANAGED_DEVICE_URI='/nitro/v1/config/managed_device'
MANAGED_DEVICE_FILTER='?filter=ip_address:'
MANAGED_DEVICE_FILTER_INSTANCE='?filter=trust_id:'
SDX_MANAGED_DEVICE_URI='/nitro/v1/config/nssdx'
TRUST_KEY_DIR = '/var/mastools/trust/.ssh/'
TMP_DIR = '/var/tmp'

DEVICE_PARTITION_SEPERATOR = "-"

MASTOOL_CONN_STATUS_FILE = "/var/mastools/conn_status"
MASTOOL_BINARY = "/var/mastools/bin/mastools"
MASTOOL_MASTOOLSD = "/var/mastools/scripts/mastoolsd"
SVM_BASH = "/usr/bin/bash"
MASTOOLS_CHECK_PID_CMD = "pgrep -f "

MASTOOLS_STATUS_DISCONNECTED = "disconnected"
MASTOOLS_STATUS_CONNECTED = "connected"

MASTOOLS_CWS_SERVICENAME = 'netappliance'

SVM_DB_HOST = "localhost"
SVM_DB_PORT = "5454"
SVM_DB_NAME = "mpsdb"
SVM_DB_USER = "mpspostgres"
SVM_DB_SELECT_KEY_WORD = "select "
SVM_DB_FROM_KEY_WORD = " from "
SVM_DB_END = " ;"
SET_SDX_SCEHMA = "SET SCHEMA 'Owner';";
SVM_CHECK_IF_TABLE_EXISTS = "select exists( select * from information_schema.tables where table_name = '{}');"
BASE_PATH = "/var/mastools/scripts/"

STATE_TRUE_EXIT_CODE = 1
STATE_FALSE_EXIT_CODE = 2


EXIT_CODE_MASTOOLS_DISCONNECTED = 80
EXIT_CODE_MASTOOLS_CONNECTED = 81
MASTOOLS_STATUS_EXIT_CODE_MAP = {
    MASTOOLS_STATUS_CONNECTED : EXIT_CODE_MASTOOLS_CONNECTED,
    MASTOOLS_STATUS_DISCONNECTED : EXIT_CODE_MASTOOLS_DISCONNECTED,
}

#=================For setting up logging ==============================================================================================================
import logging
import logging.handlers

log_file_name_local = os.path.basename(__file__)
LOG_FILENAME = '/var/mastools/logs/' + log_file_name_local + '.log'
LOG_MAX_BYTE = 50*1024*1024
LOG_BACKUP_COUNT = 20

# Set up a specific logger with our desired output level
logger = logging.getLogger(__name__)
logger.setLevel(logging.DEBUG)

# Add the log message handler to the logger
logger_handler = logging.handlers.RotatingFileHandler(LOG_FILENAME, maxBytes=LOG_MAX_BYTE, backupCount=LOG_BACKUP_COUNT)
logger_fortmater = logging.Formatter(fmt='%(asctime)s:%(funcName)s:%(lineno)d: [%(levelname)s] %(message)s', datefmt="%Y-%m-%d %H:%M:%S")
logger_handler.setFormatter(logger_fortmater)
logger.addHandler(logger_handler)
#======================================================================================================================================================

MGMT_TENANT_COOKIE = '_MGMT_TENANT'
AGENT_CONFIG_FILE = '/var/mastools/conf/agent.conf'
AGENT_CONF_DICT= {}

CERT_BUNDLE_PATH='/var/mastools/cert/cacert.pem'

AUTO_REG_TABLE_NAME = "sdx_autoreg"
AUTO_REG_STATE_COLUMN_NAME = "autoreg"
CLI_BANNER_COLUMN_NAME = "is_banner_displayed"
AUTO_REG_DEFAULT_VALUE = "t"
CLI_BANNER_DEFAULT_VALUE = "f"
SDX_SYSTEM_SETTINGS_TABLE_NAME = "system_settings"
SDX_SECURE_ACCESS_COLUMN_NAME = "secure_access_only"

STATE_SUCCESS = 0
STATE_GENERIC_FAILURE = 1
STATE_DB_FAILURE = 2

MAX_DB_RETRY = 3
DB_RETRY_INTERVAL = 20

#needed vars to determine if we are running inside a cpx
OS_RELEASE_FILE = "/etc/os-release"
NSOSLX_STRING = "nsoslx"


def run_command(cmd):
    args = shlex.split(cmd.encode('ascii'))
    FNULL = open(os.devnull, 'w')
    subprocess.call(args, stdout=FNULL, stderr=subprocess.STDOUT)
    FNULL.close()


def read_command_output(cmd, cmd_str = None):
    try:
        args = shlex.split(cmd.encode('ascii'))
    except AttributeError as ae:
        args = shlex.split(cmd)
    if cmd_str:
        args.append(cmd_str.encode('ascii')) 
    FNULL = open(os.devnull, 'w')
    process = subprocess.Popen(args, stdout=subprocess.PIPE, stderr=FNULL)
    FNULL.close()
    output = process.communicate()
    return output[0]


def get_logger_header():
    if 'customerid' not in AGENT_CONF_DICT.keys():
        customerid = "none"
    else:
        customerid = AGENT_CONF_DICT['customerid']
    if 'instanceid' not in AGENT_CONF_DICT.keys():
        instanceid = "none"
    else:
        instanceid = AGENT_CONF_DICT['instanceid']
    logger_str = "[mastools_util_"+customerid+"_"+instanceid+"]: "
    return logger_str

def get_agent_conf():
    global AGENT_CONF_DICT
    with open(AGENT_CONFIG_FILE, "r+") as agent_conf_file:
        CONTENT= agent_conf_file.read()
        agent_conf_file.close()

    AGENT_CONF_DICT = xmltodict.parse(CONTENT)['mps_agent']
    return

def get_apigw_url():
    if 'url' not in AGENT_CONF_DICT.keys():
        apigw_url = "none"
    else:
        apigw_url = AGENT_CONF_DICT['url']
    return apigw_url

def get_customerid():
    if 'customerid' not in AGENT_CONF_DICT.keys():
        customer_id = "none"
    else:
        customer_id = AGENT_CONF_DICT['customerid']
    return customer_id

def get_instanceid():
    if 'instanceid' not in AGENT_CONF_DICT.keys():
        instance_id = "none"
    else:
        instance_id = AGENT_CONF_DICT['instanceid']
    return instance_id

def get_servicename():
    if 'servicename' not in AGENT_CONF_DICT.keys():
        service_name = "none"
    else:
        service_name = AGENT_CONF_DICT['servicename']
    return service_name

def get_download_service_url():
    if 'download_service_url' not in AGENT_CONF_DICT.keys():
        dwnld_sevice_url = "none"
    else:
        dwnld_sevice_url = AGENT_CONF_DICT['download_service_url']
    return dwnld_sevice_url

def get_is_mgmt_tenent():
    if 'mgmt_tenant' not in AGENT_CONF_DICT.keys():
        is_mgmt_tenant = "none"
    else:
        is_mgmt_tenant = AGENT_CONF_DICT['mgmt_tenant']
    return is_mgmt_tenant

def get_type():
    if 'type' not in AGENT_CONF_DICT.keys():
        type = "none"
    else:
        type = AGENT_CONF_DICT['type']
    return type

def is_sdx():
    if get_type() != 'none':
        return True
    return False

def get_adm_service_ep():
    apigw = get_apigw_url()
    if apigw == "none":
        logger.debug(get_logger_header()+"Could not get apigw url ")
        sys.exit(-1)
    if not is_python_2_6:         
        service_name = MASTOOLS_CWS_SERVICENAME
    customer_id = get_customerid()
    instance_id = get_instanceid()
    adm_service_ep = "https://" + apigw + "/" + get_customerid() + "/" + get_servicename()
    return adm_service_ep

def get_managed_device_url():
    managed_device_url = get_adm_service_ep() + MANAGED_DEVICE_URI;
    return managed_device_url

def get_remove_device_url():
    if is_sdx():
        managed_device_url = get_adm_service_ep() + SDX_MANAGED_DEVICE_URI;
    else:
        managed_device_url = get_adm_service_ep() + MANAGED_DEVICE_URI;
    return managed_device_url
   

def send_request(url, method, payload='', time_out=180,legatus = False):
    if not is_python_2_6:
        servicename = MASTOOLS_CWS_SERVICENAME
    instanceid = get_instanceid()
    is_mgmt_tenent = False
    is_mgmt_tenent_dev = False
    if get_is_mgmt_tenent() == 'yes':
        is_mgmt_tenent = True
    if get_is_mgmt_tenent() == 'dev':
        is_mgmt_tenent_dev = True
        
    service_token = sign_request(url, servicename, INSTANCE_ID)
    proxy_httplib2 = get_mastools_proxy_httplib2()            
    if time_out == 0:
        if proxy_httplib2:
            httpConnection=httplib2.Http(".cache",proxy_info=proxy_httplib2,ca_certs=CERT_BUNDLE_PATH)
        else:
            httpConnection=httplib2.Http(".cache",ca_certs=CERT_BUNDLE_PATH)
    else:
        if proxy_httplib2:
            httpConnection=httplib2.Http(".cache",proxy_info=proxy_httplib2,ca_certs=CERT_BUNDLE_PATH, timeout=time_out)
        else:
            httpConnection=httplib2.Http(".cache",ca_certs=CERT_BUNDLE_PATH, timeout=time_out)
    headers_conn = {'Content-Type':'application/json'}
    headers_conn['Authorization'] = auth_request_header+service_token
    logger.debug(get_logger_header()+url + ";method: " + method)
    if is_mgmt_tenent:
        headers_conn['Cookie'] = MGMT_TENANT_COOKIE + ':"yes"'
    if is_mgmt_tenent_dev:
        headers_conn['Cookie'] = MGMT_TENANT_COOKIE + ':"dev"'
    if legatus:
        legatus_cookie = LEGATUS_AGENT_REQ_COOKIE+'=true'
        if 'Cookie' in headers_conn:
            headers_conn['Cookie'] = legatus_cookie+';'+headers_conn['Cookie']
        else:
            headers_conn['Cookie'] = legatus_cookie
    try:
        if payload == '':
            responseStatus, content = httpConnection.request(url, method, headers=headers_conn)
        else:
            responseStatus, content = httpConnection.request(url, method, headers=headers_conn, body=payload)
        resp_str = 'responseStatus='+str(responseStatus)+' content='+content
        if not legatus:
            logger.debug(get_logger_header()+resp_str)
    except Exception as e:
        logger.debug(get_logger_header()+ repr(e))
        return repr(e)

    if not legatus:
        logger.debug(get_logger_header()+content)
    return content
    


def get_remove_device_list():
    remove_device_list = []
    managed_device_url = get_remove_device_url()
    try:
        managed_device_filter_url = managed_device_url + MANAGED_DEVICE_FILTER_INSTANCE + get_instanceid()
        contents = send_request(managed_device_filter_url, 'GET')
        resp_json = json.loads(contents)
        if not is_sdx():
            remove_device_list= resp_json["managed_device"]
        else:
            remove_device_list= resp_json["nssdx"]
    except Exception as e:
        logger.debug("Error in getting the prev device list, error: " + repr(e))
    return remove_device_list

def delete_device_list(remove_device_list):
    managed_device_url = get_managed_device_url()
    try:
        for device in remove_device_list:
            device_id = device["id"]
            device_ip = device["ip_address"]
            #if we get a device partition, skip it
            if DEVICE_PARTITION_SEPERATOR not in device_ip:
                delete_device_url = managed_device_url + "/" + device_id
                send_request(delete_device_url, "DELETE")
    except Exception as e:
        logger.debug(get_logger_header()+"could not delete prev device id " + device_id)

    return


def remove_device_from_service():

    try:
        get_agent_conf()
        remove_list = get_remove_device_list()
        delete_device_list(remove_list)
    except Exception as e:
        logger.debug("%s Exception occured in remove_device_from_service %s", get_logger_header(), repr(e))
        print("Exception occoured in remove_device_from_service:"+repr(e))
        sys.exit(-1)
    finally:
        run_command("rm -rf " + AGENT_CONFIG_FILE)
        mastools_stop_cmd = MASTOOL_MASTOOLSD +  ' restart'
        if is_sdx():
            run_command(SVM_BASH+''+mastools_stop_cmd)
        else:
            run_command(mastools_stop_cmd)


def get_mastools_conn_status():
    if check_mastools_bin_run():
        logger.debug("mastools binary is running, get status from conn file")
        status = get_status_from_conn_file()
    else:
        logger.debug("mastools binary is not running, status disconnected")
        status = MASTOOLS_STATUS_DISCONNECTED
    print (status)
    return MASTOOLS_STATUS_EXIT_CODE_MAP[status]

def check_mastools_bin_run():
    if read_command_output(MASTOOLS_CHECK_PID_CMD + MASTOOL_BINARY) != "":
        return True
    return False

def get_status_from_conn_file():
    status = MASTOOLS_STATUS_DISCONNECTED
    try:
        with open(MASTOOL_CONN_STATUS_FILE, 'r') as conn_file_hd:
            status = conn_file_hd.read()
    except Exception as e:
        logger.debug("could not open the conn file, status disconnected")
        status = MASTOOLS_STATUS_DISCONNECTED
    return status

def get_value_from_db_basic(table_name, value_name):
    ret_value = STATE_DB_FAILURE
    db_value = {}
    conn = None
    try:
        conn = psycopg2.connect(host=SVM_DB_HOST,port=SVM_DB_PORT, database=SVM_DB_NAME, user=SVM_DB_USER)
        if conn is None:
            logger.debug("Could not get the conn")
            return ret_value, db_value  
        cur = conn.cursor()
        
        set_role_schema_query=(SET_SDX_SCEHMA)

        select_query = SVM_DB_SELECT_KEY_WORD + value_name + SVM_DB_FROM_KEY_WORD + table_name + ';'
        query= set_role_schema_query + select_query
        cur.execute(query)
        db_value = cur.fetchone()
        cur.close()
        ret_value = STATE_SUCCESS 
    except psycopg2.Error as e:
        logger.debug("Error in get_value_from_db, error:"+repr(e))
        ret_value = STATE_DB_FAILURE 
    except Exception as e:
        logger.debug("Error in get_value_from_db, error:"+repr(e))
        ret_value = STATE_GENERIC_FAILURE
    finally:
        if conn is not None:
            conn.close()
    
    return ret_value, db_value

def get_value_from_db(table_name, value_name):
    retry_counter = 1 
    db_value = {}     
 
    while retry_counter <= MAX_DB_RETRY:
        ret_value, db_value = get_value_from_db_basic(table_name, value_name)
        if ret_value != STATE_DB_FAILURE:
            return db_value
        retry_counter += 1
        time.sleep(DB_RETRY_INTERVAL)
    return db_value



def state_to_exit_code(state):
    if state == 't':
        logger.debug("state return true")
        return STATE_TRUE_EXIT_CODE
    logger.debug("return false")
    return STATE_FALSE_EXIT_CODE

def get_auto_reg_state():
    logger.debug("In  get_auto_reg_state")
    db_auto_reg_value = get_value_from_db(AUTO_REG_TABLE_NAME, AUTO_REG_STATE_COLUMN_NAME)
    if db_auto_reg_value:
        logger.debug("db_auto_reg_value = "+ db_auto_reg_value[0])
        sys.exit(state_to_exit_code(db_auto_reg_value[0]))
    sys.exit(state_to_exit_code(AUTO_REG_DEFAULT_VALUE))

def get_cli_banner_state():
    logger.debug("In  get_cli_banner_state")
    db_cli_banne_value = get_value_from_db(AUTO_REG_TABLE_NAME, CLI_BANNER_COLUMN_NAME)
    if db_cli_banne_value:
        logger.debug("db_cli_banne_value = "+ db_cli_banne_value[0])
        sys.exit(state_to_exit_code(db_cli_banne_value[0]))
    sys.exit(state_to_exit_code(CLI_BANNER_DEFAULT_VALUE))

def check_if_svm_table_exists(table_name):
    logger.debug("In  check_if_svm_table_exists")
    table_exists = 'f'
    conn = None
    try:
        conn = psycopg2.connect(host=SVM_DB_HOST,port=SVM_DB_PORT, database=SVM_DB_NAME, user=SVM_DB_USER)
        if conn is None:
            logger.debug("Could not get the conn")
            return table_exists  
        cur = conn.cursor()
        query= SVM_CHECK_IF_TABLE_EXISTS.format(table_name)
        cur.execute(query)
        table_exists_db_ret = cur.fetchone()
        #table_exists_db_ret is (True,) or (False,)
        table_exists_bool = table_exists_db_ret[0]
        if table_exists_bool:
            table_exists = 't'
        cur.close()
    except psycopg2.Error as e:
        logger.debug("Error in check_if_svm_table_exists, error:"+repr(e))
    except Exception as e:
        logger.debug("Error in check_if_svm_table_exists, error:"+repr(e))
    finally:
        if conn is not None:
            conn.close()
    
    return table_exists

def if_auto_conn_db_exists():
    table_exists_value = check_if_svm_table_exists(AUTO_REG_TABLE_NAME)
    sys.exit(state_to_exit_code(table_exists_value))

def get_mastools_proxy_info():
    try:
        proxy_setting = get_proxy_setting()
        if proxy_setting and proxy_setting.ipaddress and proxy_setting.port:
            return proxy_setting.ipaddress+","+str(proxy_setting.port)
    except Exception as e:
        logger.debug("excpetion in get_mastools_proxy_ip, error:"+ repr(e)) 
    logger.debug("In get_mastools_proxy_ip:no proxy set")     
    return ""

def running_inside_cpx():
    try:
        if not os.path.exists(OS_RELEASE_FILE):
            return ""

        cmd = "grep -F "
        output = read_command_output(cmd + NSOSLX_STRING + " " + OS_RELEASE_FILE)
        return output
    except Exception as e:
        logger.error("Error while checking for CPX:"+ repr(e))

    return ""

def running_inside_unicon():
    try:
        if 'UNICON_PROVIDER_VERSION' in os.environ:
            return True

        return False
    except Exception as e:
        logger.error("Error while getting env vars: " + repr(e))
        return False

def is_platform_linux():
    unameStr = read_command_output("uname -a")
    from mastools_reg import is_python_2_6
    if not is_python_2_6:
        unameStr = unameStr.decode("utf-8")
    if 'linux' in unameStr.lower():
        return True
    return False
        
def get_sdx_secure_access():
    logger.debug("In  get_sdx_secure_access")
    db_sdx_secure_access_value = get_value_from_db(SDX_SYSTEM_SETTINGS_TABLE_NAME, SDX_SECURE_ACCESS_COLUMN_NAME)
    if db_sdx_secure_access_value:
        logger.debug("db_sdx_secure_access_value = "+ db_sdx_secure_access_value[0])
        return db_sdx_secure_access_value[0]
    return db_sdx_secure_access_value;

def checkCloudOption():
    if os.path.isfile(BASE_PATH + const.CLOUD_SERVICE_FILE):
        configReader = configparser.ConfigParser()
        if sys.version_info[0] < 3:
            configReader.readfp(io.StringIO(config_string))
        else:
            configReader.read(BASE_PATH + const.CLOUD_SERVICE_FILE)
        if 'region' in configReader.sections():
            if configReader['region']['cloudoption'] == const.JP_CLOUD_OPTION:
                return const.JP_NETWORK_TEST_EP
    return const.NETWORK_TEST_EP

def get_ns_version():
    try:
        # read ns.conf file and first line is the version
        with open(NS_CONFIG_FILE, 'r') as ns_conf_file:
            ns_conf_version = ns_conf_file.readline().strip()
            if ns_conf_version.startswith('#'):
                ns_conf_version = ns_conf_version[1:]
            return ns_conf_version
    except Exception as e:
        logger.error("Error while getting NS version: " + repr(e))
        return ""

if __name__ == "__main__":
    parser = argparse.ArgumentParser(description='mastools python util')
    parser.add_argument("-remove","--remove", help="de-registration",action="store_true")
    parser.add_argument("-status","--status", help="mastools ADM connection status",action="store_true")
    parser.add_argument("-get_auto_reg","--get_auto_reg", help="get auto registration state",action="store_true")
    parser.add_argument("-get_cli_banner","--get_cli_banner", help="get cli banner state",action="store_true")
    parser.add_argument("-is_auto_conn_db_exist","--is_auto_conn_db_exist", help="check if auto conn db exists",action="store_true")
    parser.add_argument("-get_proxy_info","--get_proxy_info", help="get proxy info",action="store_true")
    parser.add_argument("-get_sdx_secure_access","--get_sdx_secure_access", help="get sdx secure access info",action="store_true")

    args = parser.parse_args()
    exit_code = 0
    if args.remove:
        remove_device_from_service()
        print ("Done")
    elif args.status:
        exit_code = get_mastools_conn_status()
    elif args.get_auto_reg:
        exit_code = get_auto_reg_state()
    elif args.get_cli_banner:
        exit_code = get_cli_banner_state()
    elif args.is_auto_conn_db_exist:
        exit_code = if_auto_conn_db_exists()
    elif args.get_sdx_secure_access:
        exit_code = get_sdx_secure_access()
    elif args.get_proxy_info:
        try:
            sys.path.append('/var/mastools/scripts/admautoreg')
            from admautoreg.util_internal_reg import get_is_internal
            is_internal_ns = get_is_internal()
            if not is_internal_ns:
                exit_code = get_mastools_proxy_info()
        except Exception as e:
            exit_code = ""
            logger.error("Error while getting mastools proxy: " + repr(e))
    sys.exit(exit_code)
