#!/usr/bin/perl
use lib '/netscaler/portal/modules';
use XML::Simple;

my $varpath = "/var/netscaler";
my $EULA_path = "$varpath" . "/logon/themes/EULA/resources/";
my $tag = ":EULA_UPGRADE_LOG";
open STDOUT, '>>', '/var/log/portaltheme.log' or warn "EULA_UPGRADE_LOG: Failed to open eula log file";
open(STDERR, ">&STDOUT") or warn "EULA_UPGRADE_LOG: Failed to log errors";


my $ref = XML::Simple->new();
my $config = eval { $ref->XMLin("$EULA_path"."config.xml" ); };
my @languages = @{ $config->{SupportedLanguageList}->{Language} };

fix_custom_strings();
#Raw format for EULA xml file.Need to change only here if any node is added in future.
my $raw = <<EOF;
<Resources>
	<Partition id="custom_strings">
	</Partition>
	<Partition id="domain">
	</Partition>
</Resources>
EOF

#for each file listed in config.xml
foreach $lang (@languages) {
		# create new XML object
		my $xml2 = new XML::Simple(RootName => "Resources", XMLDecl => '<?xml version="1.0" encoding="utf-8"?>',KeyAttr => { Partition => 'id' });
		$xfile="$EULA_path"."$lang".".xml";
		if ( -f "$xfile") {
		#EULA present, have to take backup 
			my $xml  = XML::Simple->new(KeyAttr => { Partition => 'id' });
			my $file = eval{ $xml->XMLin($xfile, ForceArray=> 1); };
			if ($@){
				print scalar(localtime());
				print "$tag: An error occurred while parsing $xfile : $@ \n";
				exit 1;
			}
			my $eula;
			$eula = $file->{Partition}->{custom_strings};  
			
		# read XML file
			my $data2 = eval{ $xml2->XMLin($raw, ForceArray => 1); };
			if ($@){
				print scalar(localtime());
				print "$tag: An error occurred while trying to parse the raw format for EULA : $@ \n";
				exit 1;
			} 
			$data2->{Partition}->{custom_strings} = $eula ; #Merge EULA content
			my $edited_eula = eval{ $xml2->XMLout($data2, OutputFile => "$xfile"); };
			if ($@){
				print scalar(localtime());
				print "$tag: An error occurred while trying to write the merged EULA file $xfile : $@ \n";
				exit 1;
			}
		}
		else{ #create EULA template for each language
			my $data2 = eval{ $xml2->XMLin($raw, ForceArray => 1); };
			if ($@){
				print scalar(localtime());
				print "$tag: An error occurred while trying to parse the raw format for EULA : $@ \n";
				exit 1;
			} 
			my $actFile = "$xfile";
			my $new_eula = eval{ $xml2->XMLout($data2, OutputFile => "$actFile"); };
			if ($@){
				print scalar(localtime());
				print "$tag: An error occurred while trying to create the fresh EULA file $xfile : $@ \n";
				exit 1;
			}
		}
}
exit 0;
		
sub fix_custom_strings() {
	my @dirs = grep { -d } glob '/var/netscaler/logon/themes/*';
	my $themes_dir = "/var/netscaler/logon/themes";
	foreach $theme (@dirs) {
		if(($theme eq "$themes_dir/Default") || ($theme eq "$themes_dir/Greenbubble") || ($theme eq "$themes_dir/X1") || ($theme eq "$themes_dir/RfWebUI") || ($theme eq "$themes_dir/EULA")) {
			next;
		}
		foreach $lang (@languages) {
			if ((! -f "$theme/strings.$lang.js") && (! -l "$theme/strings.$lang.js")) {
				print scalar(localtime());
				print ("$tag: Did not find $theme/strings.$lang.js. Creating it\n");
				eval {symlink("/var/netscaler/logon/LogonPoint/custom/strings.$lang.js", "$theme/strings.$lang.js")};
				if ($@) {
					print scalar(localtime());
					print "$tag: Could not create symlink $theme/strings.$lang.js: $@\n";
				}
			}
			if((! -f "$theme/strings.$lang.json") || (! -s "$theme/strings.$lang.json")) {
				print scalar(localtime());
				print ("$tag: Did not find $theme/strings.$lang.json. Creating it\n");
				open(my $fh,">","$theme/strings.$lang.json") or do {
					print scalar(localtime());
					print ("$tag: Could not open $theme/strings.$lang.json for writing: $!\n");
				};
				eval { print $fh "{}"};
				if($@) {
					print scalar(localtime());
					print "$tag: Could not write into $theme/strings.$lang.json: $@\n";
					next;
				}
				close $fh;
			}
		}

	}
}

