# Copyright (C) 2018-2023. Cloud Software Group, Inc. All Rights Reserved. Confidential & Proprietary.

"""Logging levels as defined by libccauth."""


class LoggingLevel:
    """Logging level constants."""

    # Most verbose level, useful to debug an application.
    DEBUG = 0

    # Log informational messages.
    INFO = 1

    # Log potentially harmful situations.
    WARNING = 2

    # Log error messages.
    ERROR = 3

    # Disable logging.
    OFF = 0x100000

    @staticmethod
    def tostring(level):
        """Converts a logging level to its string representation.

        :param level:   the logging level to convert
        :returns:       the str representation matching the given logging level
        """
        if level == LoggingLevel.DEBUG: return 'DEBUG'
        if level == LoggingLevel.INFO: return 'INFO'
        if level == LoggingLevel.WARNING: return 'WARNING'
        if level == LoggingLevel.ERROR: return 'ERROR'
        if level == LoggingLevel.OFF: return 'OFF'

        raise ValueError('level')
