# Copyright (C) 2021-2023. Cloud Software Group, Inc. All Rights Reserved. Confidential & Proprietary.

"""Configuration options for requests and connections as defined in libccauth."""
from ccauth.util import AttributedObject


class CircuitBreakerRequirement(AttributedObject):
    """Circuit breaker requirements."""
    _attrs_ = [
        ('failure_threshold', int),
        ('success_threshold', int),
        ('reset_timeout', int)
    ]

    def __init__(self, **kwargs):
        self.failure_threshold = None
        self.success_threshold = None
        self.reset_timeout = None

        AttributedObject.__init__(self, **kwargs)
