# Copyright (C) 2018-2023. Cloud Software Group, Inc. All Rights Reserved. Confidential & Proprietary.

"""Configuration options for bearer token and service keys as defined in libccauth."""
from ccauth.util import AttributedObject


class BearerTokenRequirement(AttributedObject):
    """Bearer token requirements."""
    _attrs_ = [
        ('signing_algorithm', str),
        ('validate_lifetime', bool),
        ('clockskew', int)
    ]

    def __init__(self, **kwargs):
        self.signing_algorithm = None
        self.validate_lifetime = None
        self.clockskew = None

        AttributedObject.__init__(self, **kwargs)


class ServiceKeyRequirement(AttributedObject):
    """Service key requirements."""
    _attrs_ = [
        ('lifetime', int),
        ('clockskew', int)
    ]

    def __init__(self, **kwargs):
        self.lifetime = None
        self.clockskew = None

        AttributedObject.__init__(self, **kwargs)
