# Copyright (C) 2018-2023. Cloud Software Group, Inc. All Rights Reserved. Confidential & Proprietary.

from ccauth.util import asbytes
from .array import CCAuthArray
from ctypes import *


class CCAuthUserClaims(Structure):
    """Creates a struct mirroring ccauth_user_claims"""
    _fields_ = [
        ('oid', c_char_p),
        ('sid', c_char_p),
        ('upn', c_char_p),
        ('email', c_char_p),
        ('customers', c_void_p)
    ]


class CCAuthDirectoryClaims(Structure):
    """Creates a struct mirroring ccauth_directory_claims"""
    _fields_ = [
        ('forest', c_char_p),
        ('domain', c_char_p),
        ('identityprovider', c_char_p),
        ('tenant', c_char_p)
    ]


class CCAuthAdminClaims(Structure):
    """Creates a struct mirroring ccauth_admin_claims"""
    _fields_ = [
        ('groups', c_void_p)
    ]

    @staticmethod
    def _marshal(adminClaim):
        native = CCAuthAdminClaims()
        native.group = pointer(CCAuthArray._marshal(adminClaim.groups) if adminClaim.groups is not None else None)

class CCAuthValidationContext(Structure):
    """Creates a struct mirroring ccauth_validation_context"""
    _fields_ = [
        ('customer', c_char_p),
        ('allow_custom_admins', c_int),
        ('user_mode', c_int),
        ('fetch_user_claims', c_int),
        ('fetch_user_groups', c_int),
        ('skip_service_profile', c_int),
        ('caller_service_name', c_char_p),
        ('caller_service_instance', c_char_p),
        ('fetch_directory_claims', c_int),
        ('fetch_admin_claims', c_int),
        ('rbac_version', c_int)
    ]

    @staticmethod
    def _marshal(context):
        native = CCAuthValidationContext()

        native.customer = asbytes(context.customer_id)
        native.allow_custom_admins = -1
        native.user_mode = context.user_mode
        native.fetch_user_claims = 1 if context.fetch_user_claims is not None and context.fetch_user_claims else 0
        native.fetch_user_groups = 1 if context.fetch_user_groups is not None and context.fetch_user_groups else 0
        native.skip_service_profile = 1 if context.skip_service_profile is not None and context.skip_service_profile else 0
        native.caller_service_name = asbytes(context.caller_service_name) if context.caller_service_name is not None else None
        native.caller_service_instance = asbytes(context.caller_service_instance) if context.caller_service_instance is not None else None
        native.fetch_directory_claims = 1 if context.fetch_directory_claims is not None and context.fetch_directory_claims else 0
        native.fetch_admin_claims = 1 if context.fetch_admin_claims is not None and context.fetch_admin_claims else 0
        native.rbac_version = context.rbac_version if context.rbac_version is not None and context.rbac_version else 0

        if context.allow_custom_admins is not None:
            native.allow_custom_admins = 1 if context.allow_custom_admins else 0

        return native


class CCAuthIdentity(Structure):
    """Creates a struct mirroring ccauth_identity"""
    _fields_ = [
        ('code', c_int),
        ('customer', c_char_p),
        ('user_id', c_char_p),
        ('user_principal', c_char_p),
        ('user_name', c_char_p),
        ('sub', c_char_p),
        ('amr', c_void_p),
        ('admin_type', c_int),
        ('user_claims', c_void_p),
        ('directory_claims', c_void_p),
        ('user_groups', c_void_p),
        ('admin_claims', c_void_p),
        ('service_name', c_char_p),
        ('service_instance', c_char_p),
        ('service_profile', c_char_p),
        ('service_multitenant', c_int),
        ('bearer_token', c_char_p),
        ('service_key', c_char_p)
    ]
