# Copyright (C) 2018-2023. Cloud Software Group, Inc. All Rights Reserved. Confidential & Proprietary.

from ccauth.util import isempty, asbytes
from ctypes import *


class CCAuthTokenRequirement(Structure):
    """Creates a struct mirroring ccauth_bearertoken_requirement"""
    _fields_ = [
        ('signing_algorithm', c_char_p),
        ('validate_lifetime', c_int),
        ('clock_skew', c_int)
    ]

    @staticmethod
    def _marshal(req):
        native = CCAuthTokenRequirement()

        native.signing_algorithm = asbytes(req.signing_algorithm) if not isempty(req.signing_algorithm) else None
        native.validate_lifetime = (1 if req.validate_lifetime else 0) if req.validate_lifetime is not None else -1
        native.clock_skew = req.clockskew if req.clockskew is not None else -1
        return native


class CCAuthServiceKeyRequirement(Structure):
    """Creates a struct mirroring ccauth_servicekey_requirement"""
    _fields_ = [
        ('lifetime', c_int),
        ('clock_skew', c_int)
    ]

    @staticmethod
    def _marshal(req):
        native = CCAuthServiceKeyRequirement()

        native.lifetime = req.lifetime if req.lifetime is not None else -1
        native.clock_skew = req.clockskew if req.clockskew is not None else -1
        return native


class CCAuthServiceKey(Structure):
    """Creates a struct mirroring ccauth_service_key"""
    _fields_ = [
        ('algorithm', c_int),
        ('service_name', c_char_p),
        ('service_instance', c_char_p),
        ('signature', c_char_p),
        ('timestamp', c_double),
        ('nonce', c_char_p)
    ]
