# Copyright (C) 2020-2023. Cloud Software Group, Inc. All Rights Reserved. Confidential & Proprietary.


class RbacVersion:
    """RBAC versions as defined in libccauth."""
    DEFAULT = 0
    RBAC_V1 = 1
    RBAC_V2 = 2
    RBAC_AUTO = 3
    CURRENT = RBAC_V1
    LATEST = RBAC_V2

    @staticmethod
    def tostring(version):
        """Converts a RBAC version to its string representation.

        :param version:     the version to convert
        :returns:           the str representation matching the given version
        """
        if version == RbacVersion.DEFAULT: return 'DEFAULT'
        if version == RbacVersion.RBAC_V1: return 'RBAC_V1'
        if version == RbacVersion.RBAC_V2: return 'RBAC_V2'
        if version == RbacVersion.RBAC_AUTO: return 'RBAC_AUTO'
        if version == RbacVersion.CURRENT: return 'RBAC_V1'
        if version == RbacVersion.LATEST: return 'RBAC_V2'

        raise ValueError('version')