# Copyright Citrix Systems, Inc. All rights reserved.

"""Random number generator.

Create random string of a given bit size using the randstring function. It will
return a 2-character, hex encoded string representing the underlying random bits.
"""
import random

def randstring(bitsize):
	"""Returns a hex-encoded string contaning bitsize/8 random bytes.

	:param bitsize:	the bit size of the resulting string.
	:returns:       an hex-encoded string.
	"""
	bytesize = int(bitsize / 8)
	bytes = [random.randint(0, 255) for i in range(bytesize)]
	return ''.join("%0.2x" % x for x in bytes)
