<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
/*
| -------------------------------------------------------------------------
| URI ROUTING
| -------------------------------------------------------------------------
| This file lets you re-map URI requests to specific controller functions.
|
| Typically there is a one-to-one relationship between a URL string
| and its corresponding controller class/method. The segments in a
| URL normally follow this pattern:
|
|	example.com/class/method/id/
|
| In some instances, however, you may want to remap this relationship
| so that a different class/function is called than the one
| corresponding to the URL.
|
| Please see the user guide for complete details:
|
|	http://codeigniter.com/user_guide/general/routing.html
|
| -------------------------------------------------------------------------
| RESERVED ROUTES
| -------------------------------------------------------------------------
|
| There area two reserved routes:
|
|	$route['default_controller'] = 'welcome';
|
| This route indicates which controller class should be loaded if the
| URI contains no data. In the above example, the "welcome" class
| would be loaded.
|
|	$route['404_override'] = 'errors/page_missing';
|
| This route will tell the Router what URI segments to use if those provided
| in the URL cannot be matched to a valid route.
|
*/

$route['default_controller'] = "Login";
$route['404_override'] = '';

//Links handled by login controller
$route['login/do_login'] = "Login/do_login";
$route['login/banner'] = "Login/banner";
$route['login/change_password'] = "Login/change_password";
$route['login/loginview'] = "Login/loginview";

//Links handled by menu controller
$route['menu/gui'] = "Menu/configuration";
$route['menu/doc'] = "Menu/documentation";
$route['menu/dw'] = "Menu/downloads";
$route['menu/branding'] = "Menu/branding";
$route['menu/neoglobaldata'] = "Menu/neoglobaldata";
$route['menu/lo'] = "Menu/logout";
$route['menu/logout'] = "common/menu/logout_view";
$route['menu/er'] = "Menu/error";
$route['menu/csdx'] = "Menu/check_session_sdx";
$route['menu/ss'] = "Menu/setup_session";
$route['menu/impr_file'] = "Menu/import_file";

//Links handled by dashboard controller
$route['menu/st'] = "Dashboard/main";
$route['menu/stc'] = "Dashboard/content";
$route['menu/st\?(.+)'] = "Dashboard/main";
$route['menu/stc\?(.+)'] = "Dashboard/content";
$route['menu/cc'] = "Dashboard/clear_cached_result";
$route['menu/chart'] = "Dashboard/chart";
$route['menu/doop'] = "Dashboard/do_operation";
$route['menu/coc'] = "Dashboard/comparative_chart";
$route['menu/moncntrs'] = "Dashboard/counters_popup";
$route['menu/savec'] = "Dashboard/save_chart";
$route['menu/delc'] = "Dashboard/delete_chart";

//Links handled by reporting controller
$route['menu/rep'] = "Reporting/main";
$route['menu/rep\?(.+)'] = "Reporting/main";
$route['menu/repcontent'] = "Reporting/content";
$route['menu/repcontent\?(.+)'] = "Reporting/content";
$route['menu/cntrs'] = "Reporting/counters_popup";
$route['menu/allcntr'] = "Reporting/retrieve_all_counters";
$route['menu/git'] = "Reporting/image_toolbar";
$route['menu/saver'] = "Reporting/save_report";
$route['menu/delr'] = "Reporting/delete_report";
$route['menu/delrfs'] = "Reporting/delete_reports_folders";
$route['menu/checkr'] = "Reporting/check_report_exists";
$route['menu/rds'] = "Reporting/refresh_data_sources";
$route['menu/repchart'] = "Reporting/chart";
$route['menu/gim'] = "Reporting/image_map";
$route['menu/createfol'] = "Reporting/create_folder";
$route['menu/mcr'] = "Reporting/manage_custom_reports";
$route['menu/agc'] = "Reporting/apply_global_conf";
$route['menu/expr'] = "Reporting/export_reports";
$route['menu/impr'] = "Reporting/import_reports";

// Links handled by pcidss/pcidss controller
$route['pcidss/(.+)'] = "Pcidss/main";

//Links handled by neo/topn/agee/cb home - RDX based applications
$route['rapi/(.+)'] = "Rapi/main/$1";
$route['menu/neo'] = "Menu/neo";
$route['menu/neo\?(.+)'] = "Menu/neo";
$route['menu/topn\?(.+)'] = "Menu/topn";
$route['menu/agee\?(.+)'] = "Menu/agee";
$route['menu/cb\?(.+)'] = "Menu/cb";

//Links handled by authorizer controller
$route['help/:any'] = "Authorizer/help";
$route['menu/docs/pdf/:any'] = "Authorizer/other";
$route['menu/docs/snmp/HP-Openview/:any'] = "Authorizer/other";
$route['menu/docs/snmp/WhatsUpGold/:any'] = "Authorizer/other";
$route['menu/api/:any'] = "Authorizer/other";
$route['nitro.*.tgz'] = "Authorizer/other";
$route['msn/:any'] = "Authorizer/other";
$route['admin_ui/php/:any'] = "Authorizer/other";
$route['admin_ui/nitro_client/(.+)'] = "Menu/authorize_content";
$route['admin_ui/home/(.+)'] = "Menu/authorize_content";
$route['admin_ui/dashboard/(.+)'] = "Menu/authorize_content";
$route['admin_ui/neo/(.+)'] = "Menu/authorize_content";
$route['admin_ui/rdx/(.+)'] = "Menu/authorize_content";
$route['admin_ui/gui_v2/(.+)'] = "Menu/authorize_content";
$route['admin_ui/reporting/(.+)'] = "Menu/authorize_content";

/* End of file routes.php */
/* Location: ./application/config/routes.php */
