<?php if(!defined('BASEPATH')) exit('No direct script access allowed');

// TODO: Verify if any page requests come through this controller
require_once("abstract_controller.php");

class admin_ui extends abstract_controller
{
    function __construct()
    {
        parent::__construct();
        require_once(APPPATH."controllers/Nonce.php");
        $nonceClass = new nonce();
        $nonce = $nonceClass->setNewNonce();
        require_once(APPPATH."controllers/Utils.php");
        utils::set_content_security_policy_header();        
        $nonce = $_SERVER['nonce'];
    }

    private function show_documentation_404($document_file_name)
    {
        //Document names start with "NS/AGEE" and end with "pdf/html"
        if(!preg_match("/^(NS|AGEE).*(pdf|html)$/", $document_file_name))
            $this->show_404();

        $nonce = $_SERVER['nonce'];
        $file_names_to_keywords_map = array("AGEE_readme.html"      =>  "AGEE readme",
                                            "NS-LogMessages.html"   =>  "Log Message Reference",
                                            "NS-SNMPOIDs.html"      =>  "SNMP OID Reference",
                                            "NS-VPXGettingStarted-Guide.pdf"    =>  "NS VPX Getting Started Guide");
        if(isset($file_names_to_keywords_map[$document_file_name]))
            $document_file_name = $file_names_to_keywords_map[$document_file_name];

        $data = array("title"             =>  "Document not found",
                      "standalone"        =>  "YES",
                      "no_footer_link"    =>  true);
        print $this->load->view("common/header", $data, true);

?>
<div class="center_panel no_wrap_td" style="left: 21%">
The document is unavailable. To locate the document, you can search for the document<br>
on the NetScaler Knowledge Center at <a href="http://support.citrix.com/search/advanced?searchQuery=<?=$document_file_name?>" title="Click to search the document in Knowledge Center" target="SEARCH_PAGE" rel="noopener noreferrer">http://support.citrix.com/</a>, or you can download the<br>
full documentation set from My NetScaler.<br><br>
<b>To download the full documentation set</b><br>
1. Sign in to <a href="https://www.mycitrix.com" target="MY_CITRIX" rel="noopener noreferrer">http://mycitrix.com/</a>, and then click <b>Downloads</b>.<br>
2. In the <b>Search Downloads by Product list</b>, select <b>NetScaler ADC</b>.<br>
3. Under <b>Firmware</b>, click the release and build number that you want, and then click <b>Get Firmware</b>.<br>
4. Click <b>Show Documentation</b>, and then click <b>Get Documentation</b>.<br>
5. Copy the compressed file to the /var/netscaler/doc directory on the appliance.<br>
6. Extract the files by typing the following command at the shell prompt:<br>
&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<b>tar xvfpz ns-</b>&lt;releasenumber&gt;-&lt;buildnumber&gt;<b>-doc.tgz -C /var/netscaler/doc</b><br><br>
<font class="find_panel_reporting">If you have comments or feedback on this procedure, please email us at <a id="panel_reporting_link" href="mailto:nsdocs_feedback@citrix.com?subject=Feedback%20on%20documentation%20installation%20procedure">nsdocs_feedback@citrix.com</a></font>.
</div>
<script nonce="<?=$nonce?>" type="text/javascript">
    const panel_reporting_link = document.getElementById("panel_reporting_link");
    panel_reporting_link.addEventListener('click', function(event){
            cancel_onbeforeunload()      
    })
</script>
<?php
        print $this->load->view("common/footer", $data, true);
    }

    //Sends 404 - File not found response.
    private function show404()
    {
        if(preg_match("/\/support\/docs\/pdf\/(.*)/", $_SERVER["REQUEST_URI"], $matches))
        {
            $this->show_documentation_404($matches[1]);
            exit;
        }
        $this->show_404();
    }

    public function other()
    {
        // Get the absolute physical path of the file
        $pat = "/".addcslashes($_SERVER['DOCUMENT_ROOT'], "/")."/";
        $helpURL = preg_replace($pat, "", $_SERVER['PATH_TRANSLATED']);
        $file_ext = substr($helpURL, -3);
        $file_exte = substr($helpURL, -4);
        $is_pdf = $file_ext == "pdf";
        $is_tgz = $file_ext == "tgz";
        $is_msi = ($file_ext == "msi" || $file_ext == "exe");
        $is_mib = $file_ext == "mib";

        if($is_pdf || $is_tgz || $is_msi)
        {
            session_cache_limiter('must-revalidate');
        }

        if(!$this->start_session(true))
        {
            return;
        }

        if(!file_exists($helpURL) || !is_file($helpURL))
        {
            $this->show404();
            return;
        }

        if($is_pdf)
        {
            // Setting max age to 5 because on logout and directly pasting the URL in the same browser should not open the pdf
            $this->output->set_header("Cache-Control: max-age=5");
            $this->output->set_header("Content-type: application/pdf");
        }
        else if($file_ext == "htm" || $file_exte == "html")
        {
            $this->output->set_header("Content-type: text/html");
        }
        else if($is_tgz)
        {
            $this->output->set_header("Cache-Control: ");
            $this->output->set_header("Content-type: application/gzip");
            // Required for IE - http://support.microsoft.com/?id=260519
            $this->output->set_header("Content-disposition: attachment; filename=" . basename($helpURL));
            $this->output->set_header("Content-Length: " . filesize($helpURL));
        }
        else if($file_ext == "xml" || $file_exte == "wsdl")
        {
            $this->output->set_header("Content-type: text/xml");
        }
        else if($is_msi)
        {
            $this->output->set_header("Content-type: application/x-msdownload");
        }
        else if($is_mib)
        {
            $this->output->set_header("Cache-Control: ");
            $this->output->set_header("Content-type: text/plain");
            $this->output->set_header("Content-disposition: attachment; filename=" . basename($helpURL));
            $this->output->set_header("Content-Length: " . filesize($helpURL));
        }        
        else
        {
            $this->output->set_header("Content-type: text/plain");
        }

        // Read the file and serve the contents in one go.
        // Can use http_send_file() with added plugin to send file in chunks.
        $this->output->set_output(file_get_contents($helpURL));
    }

    public function help()
    {
        if(!$this->start_session(true))
            return;

        $url = "/var/netscaler" . preg_replace("/\?.*/", "", $_SERVER["REQUEST_URI"]);
        $url_query_params = explode("?", $url);

        if(is_array($url_query_params)) {
            $url =  $url_query_params[0]; // Ignore query params            
        }

        $extn = pathinfo($url, PATHINFO_EXTENSION); // Get file extension        

        if((file_exists($url) && is_file($url)) || (file_exists($url.".gz") && is_file($url.".gz")))
        {
            $content_type = "application/octet-stream"; 
            require_once(APPPATH . "controllers/Rapi_utils.php");
            $content_types_list = rapi_utils::get_mime_types(); 

            if (array_key_exists($extn, $content_types_list))  
            { 
                $content_type = $content_types_list[$extn]; 
            } 

            $this->output->set_header("Content-type: ".$content_type);

            if($extn == "pdf" || $extn == "gz")
            {
                session_cache_limiter('must-revalidate');
            }            

            if($extn == "pdf")
            {
                // Setting max age to 5 because on logout and directly pasting the URL in the same browser should not open the pdf
                $this->output->set_header("Cache-Control: max-age=5");
            }
            else if($extn == "gz")
            {
                $this->output->set_header("Cache-Control: ");
                $this->output->set_header("Content-disposition: attachment; filename=" . basename($url)); // Required for IE - http://support.microsoft.com/?id=260519
                $this->output->set_header("Content-Length: ".filesize($url));
            }

            // Read the file and serve the contents
            if(is_file($url.".gz"))
            {
                $this->output->set_header("Content-Encoding: gzip");
                $this->output->set_output(file_get_contents($url.".gz"));
            }
            else
            {
                $this->output->set_output(file_get_contents($url));
            }

            return;
        }
        else
        {
            $this->show404();
            return;            
        }
    }

    public function authorize_content()
    {
        error_log("at nam!!");
        if(!$this->start_session(true))
        {
            return;
        }

        // 1. Transform: Extract path from user input
        $request_path = parse_url($_SERVER["REQUEST_URI"], PHP_URL_PATH);
        if ($request_path === false) {
            $this->show404();
            return;
        }

        // 2. Normalize: Convert to consistent format
        $normalized_path = str_replace('\\', '/', $request_path);
        $normalized_path = preg_replace('/\/+/', '/', $normalized_path);
        $normalized_path = rtrim($normalized_path, '/');

        // 3. Sanitize: Ensure security constraints
        $base_dir = rtrim($_SERVER['DOCUMENT_ROOT'], '/') . '/';
        $url = $base_dir . ltrim($normalized_path, '/');

        $url_query_params = explode("?", $url);
        if(is_array($url_query_params)) {
            $url = $url_query_params[0];
        }

        $extn = pathinfo($url, PATHINFO_EXTENSION);

        if((file_exists($url) && is_file($url)) || (file_exists($url.".gz") && is_file($url.".gz")))
        {
            $content_type = "application/octet-stream"; 
            require_once(APPPATH . "controllers/Rapi_utils.php");
            $content_types_list = rapi_utils::get_mime_types(); 
            if (array_key_exists($extn, $content_types_list))  
            { 
                $content_type = $content_types_list[$extn]; 
            } 

            $this->output->set_header("Content-type: ".$content_type);

            require_once(APPPATH."controllers/Nonce.php");
            $nonceClass = new nonce();
            $nonce = $nonceClass->setNewNonce();
            require_once(APPPATH."controllers/Utils.php");
            $csp_header = utils::set_content_security_policy_header("DOCUMENTATION", true);
            $this->output->set_header("Content-Security-Policy: ".$csp_header);
            
            if($extn == "pdf" || $extn == "gz")
            {
                session_cache_limiter('must-revalidate');
            }            

            if($extn == "pdf")
            {
                // Setting max age to 5 because on logout and directly pasting the URL in the same browser should not open the pdf
                $this->output->set_header("Cache-Control: max-age=5");
            }
            else if($extn == "gz")
            {
                $this->output->set_header("Cache-Control: ");
                $this->output->set_header("Content-disposition: attachment; filename=" . basename($url)); // Required for IE - http://support.microsoft.com/?id=260519
                $this->output->set_header("Content-Length: ".filesize($url));
            }

            // Read the file and serve the contents
            if(is_file($url.".gz"))
            {
                # To handle the gz html files inside nitro_client folder - Open the file -> add nonce and serve the html.
                if (true && preg_match("/nitro_client\/.*\.html/", $url)) {
                    $search = array("/\{NONCE\}/");
                    $replace = array($nonce);
                    $nitro_html = gzdecode(file_get_contents($url.".gz"));
                    $nitro_html = preg_replace($search, $replace, $nitro_html);
                } else {
                    $nitro_html = file_get_contents($url.".gz");
                    $this->output->set_header("Content-Encoding: gzip");
                }

                $this->output->set_output($nitro_html);
            }
            else
            {
                $search = array("/\{NONCE\}/");
                $replace = array($nonce);
                $html_content = file_get_contents($url);
                $html_content = preg_replace($search, $replace, $html_content);

                $this->output->set_output($html_content);
            }

            return;
        }
        else
        {
            $this->show404();
            return;            
        }
    }    
}
?>
