<?php
class PostControllerConstructor extends abstract_controller
{
    public function checkRequest()
    {
        $CI = &get_instance();
        $router = $CI->router;
        $route = $CI->uri->uri_string();
        $controller = $router->class;
        $method = $router->method;

        if ($this->shouldValidate($route, $controller)) {
            
            // Check for SESSID cookie
            if (!isset($_COOKIE[session_name()])) {
                $this->destroy_session();
                exit($this->show_error_page("SESSION_CORRUPTED"));
            }
            // Check for invalid chars in cookie
            if (!preg_match('/^[a-f0-9]{32}$/', $_COOKIE[session_name()])) {
                self::delete_cookie(session_name());
                exit($this->show_error_page("SESSION_CORRUPTED"));
            }
        }
    }

    private function shouldValidate($routeParam, $controller)
    {
        // whitelist fns from auth check based on route
        switch ($routeParam) {
            # Add the routes that doesn't require authentication here. 
            case '':
            case 'login/do_login':
            case 'login/banner':
            case 'login/do_cert_login':
            case 'login/change_password':
            case 'login/loginview':
            case 'menu/er':
            case 'menu/ss':
                return false;

            default:
                break;
        }

        // whitelist fns from auth check based on controller
        switch ($controller) {
            case 'authorizer':
                return false;

            default:
                break;
        }

        return true;
    }
}
