<?php 
if(!defined("BASEPATH")) 
{
    exit("No direct script access allowed");
}

require_once("Abstract_model.php");
require_once($_SERVER["DOCUMENT_ROOT"] . "/admin_ui/nitro/nitro.php");

class nitro_model extends abstract_model
{
    function __construct()
    {
        parent::__construct();
    }
	
	function execute_login_command($cmd, $parameters)
    {
        global $g_session_started;
        $login_warning = "";

        if($cmd === "loginchallengeresponse")
        {
            $challengeresponse_sessionid = $parameters["sessionid"];
            $resp = $this->do_challenge_login($parameters);
        }
        else if($cmd === "loginnextfactorresponse")
        {
            $nextfactorresponse_sessionid = $parameters["sessionid"];
            $resp = $this->do_nextfactor_login($parameters);
        }        
        else
        {
            $resp = $this->do_login($parameters);
        }

        $this->result = $resp;

        if(isset($this->result["errorcode"]))
        {
            $this->result["rc"] = $this->result["errorcode"];
            unset($this->result["errorcode"]);
        }

        $return_value = $this->result["rc"];

        // Handle RPC node - default password warning message
        if($return_value == 1064 || $return_value == 407){
            $login_warning = $this->result["message"];
            $return_value = 0;
        }

        if($return_value == 0 || $return_value == 1034 || $return_value == 3816)
        {
            if(isset($_SERVER["HTTP_REFERER"]) && preg_match("/^https/", $_SERVER["HTTP_REFERER"]))
            {
                $params = session_get_cookie_params();
                session_set_cookie_params($params["lifetime"], $params["path"], $params["domain"], true);
            }
        
            if(!isset($_SESSION["NSAPI"]))
            {
                // If user is sending any SESSID while logging in, ignore that
                if(isset($_COOKIE[session_name()]))
                {
                    unset($_COOKIE[session_name()]);
                }

                session_start();

                $g_session_started = true;

                $_SESSION["NSAPI"] = $this->result["sessionid"];
            }

            if($return_value == 0 && isset($challengeresponse_sessionid) && $challengeresponse_sessionid != null)
            {
                if(isset($_COOKIE[session_name()]))
                {
                    unset($_COOKIE[session_name()]);
                }

                session_start();
                $g_session_started = true;
                $_SESSION["NSAPI"] = $challengeresponse_sessionid;
            }
            else if($return_value == 0 && isset($nextfactorresponse_sessionid) && $nextfactorresponse_sessionid != null)
            {
                if(isset($_COOKIE[session_name()]))
                {
                    unset($_COOKIE[session_name()]);
                }

                session_start();
                $g_session_started = true;
                $_SESSION["NSAPI"] = $nextfactorresponse_sessionid;
            }

            $_SESSION["NSAPI_DOMAIN"] = "";
            $_SESSION["NSAPI_PATH"] = "/";
            $_SESSION["login_warning"] = $login_warning;
        }   
		
        return $return_value;
    }
    
    function do_login($parameters)
    {
        try
        {
            // warning => "yes" is required for NITRO request to retreive warning messages
            $payload = json_encode(array("params" =>  array("warning" => "YES"), "login" => $parameters), JSON_FORCE_OBJECT);
            $resp = $this->execute_command("post", array("requestbody" =>  $payload, "method" => "POST"));

            return $this->result; 
        }
        catch(HttpException $ex)
        {
            return array("errorcode" => -1, "message" => "Unable to connect to applicance");
        }
    }
    
    function do_challenge_login($parameters)
    {
        try
        {
            // warning => "yes" is required for NITRO request to retreive warning messages
            $parameters["params"] = array("warning" => "YES");
            $payload = json_encode(array("loginchallengeresponse" => $parameters), JSON_FORCE_OBJECT);
            $resp = $this->execute_command("post", array("requestbody" =>  $payload, "method" => "POST"));

            return $this->result; 
        }
        catch (HttpException $ex)
        {
            return array("errorcode" => -1, "message" => "Unable to connect to applicance");
        }
    }

    function do_nextfactor_login($parameters)
    {
        try
        {
            // warning => "yes" is required for NITRO request to retreive warning messages
           $parameters["params"] = array("warning" => "YES");
           $payload = json_encode(array("loginnextfactorresponse" => $parameters), JSON_FORCE_OBJECT);
           $resp = $this->execute_command("post", array("requestbody" =>  $payload, "method" => "POST"));

           return $this->result; 
        }
        catch (HttpException $ex)
        {
            return array("errorcode" => -1, "message" => "Unable to connect to applicance");
        }
    }    
    
    function do_logout()
    {
        try
        {
            $payload = json_encode(array("sessionid" => $_SESSION["NSAPI"], "logout" => array()), JSON_FORCE_OBJECT);
            $resp = $this->execute_command("post", array("requestbody" =>  $payload, "method" => "POST"));

            return $this->result; 
        }
        catch (HttpException $ex)
        {
            return array("errorcode" => -1, "message" => "Unable to connect to applicance");
        }
        
        $return_value = $this->result["rc"];

        return $return_value;
    }
    
    protected function command_execution($command, $parameters, $use_api = true)
    {
        // Construct query params
        if($command == "logout")
        {
            $this->do_logout();

            return;
        }
        
        $query_params = "?view=detail";

        if(isset($_SESSION["NSAPI"]))
        {
            $query_params .= "&sessionid=" . urlencode($_SESSION["NSAPI"]);
        }

        if(!ns_empty($parameters))
        {
            $args = "";

            foreach($parameters as $key => $value)
            {
                if($key == NITRO_MODEL_COUNT_PARAM)
                {
                    $query_params .= "&count=" . $value;
                    continue;
                }

		        if($key == "requestbody")
                {
                    $query_params .= "&requestbody=" . $value;
                    continue;
                }

                if($key == "method")
                {
                    $query_params .= "&method=" . $value;
                    continue;
                }

	            if($key == "statbindings")
                {
                    $query_params .= "&statbindings=" . $value;
                    continue;   
                }
                
                /*
                if($key == "bindings" && $value == "1")
                {
                    $query_params .= "&rawdata=yes";
                    continue;
                }
                */
                
                $args .= (($args != "")? "," : "");
                $args .= $key . ":" . urlencode($value);
            }

            if($args != "")
            {
                $query_params .= "&args=" . $args;
            }
        }

        // Construct arguments
        $arg_list = array();

        if(preg_match("/^stat/", $command))
        {
            $arg_list[0] = "stat";
            $arg_list[1] = preg_replace("/^stat/", "", $command);
        }
        else if(preg_match("/^get/", $command))
        {
            $arg_list[0] = "config";
            $arg_list[1] = preg_replace("/^get/", "", $command);
        }
        else if(preg_match("/^post/", $command))
        {
            $arg_list[0] = "config";
            $arg_list[1] = preg_replace("/^post/", "", $command);
        }
        else 
        {
            return -1;
        }
	
        if (strpos($query_params, 'loginchallengeresponse') !== false)
        {
            $query_array = explode("&", $query_params);
            $request_body = "";
            for ($i = 0; $i < count($query_array); $i++)
            {
                if (strpos($query_array[$i], 'requestbody') !== false)
                {
                    $request_body = $query_array[$i];
                }
            }

            if ($request_body !== "")
            {
                $request_json = explode("=", $request_body);
                $request_array = json_decode($request_json[1], true);
                $request_login_challenge_response = $request_array["loginchallengeresponse"];
                $request_string = json_encode($request_login_challenge_response);
                $query_params = '?view=detail&requestbody=' . $request_string . '&method=POST';
            }
        }
        else if (strpos($query_params, 'loginnextfactorresponse') !== false)
        {
            $query_array = explode("&", $query_params);
            $request_body = "";
            for ($i = 0; $i < count($query_array); $i++)
            {
                if (strpos($query_array[$i], 'requestbody') !== false)
                {
                    $request_body = $query_array[$i];
                }
            }

            if ($request_body !== "")
            {
                $request_json = explode("=", $request_body);
                $request_array = json_decode($request_json[1], true);
                $request_login_nextfactor_response = $request_array["loginnextfactorresponse"];
                $request_string = json_encode($request_login_nextfactor_response);
                $query_params = '?view=detail&requestbody=' . $request_string . '&method=POST';
            }
        }

        // Execute command over NITRO
        $this->benchmark->mark("ns_nitro_start");

        if($this->is_onboard_api())
        {
            $nitro = new nitro();
            $nitro_return_value = $nitro->v1($arg_list[0], $arg_list[1] . $query_params);
        }
        else
        {
            $nitro_return_value = file_get_contents("http://" . $this->server_ip ."/nitro/v1/" . $arg_list[0] . "/" . $arg_list[1] . $query_params);
        }

        $this->benchmark->mark("ns_nitro_end");
        $elapsed_time = $this->benchmark->elapsed_time("ns_nitro_start", "ns_nitro_end");
        log_message("profile", $elapsed_time . " --> NITRO_EXECUTION_TIME " . $command);

        // Process result
        if(ns_empty($nitro_return_value) || $nitro_return_value === false || (!json_decode($nitro_return_value, true)))
        {
            $this->set_error_code();
            $this->set_error_message($command);
        }
        else
        {
            $this->result = json_decode($nitro_return_value, true);

            if(isset($this->result["errorcode"]))
            {
                $this->result["rc"] = $this->result["errorcode"];
                unset($this->result["errorcode"]);
            }
            
            $arg_list[1] = $this->get_command_with_correct_case($arg_list[1]);
            
            if(isset($this->result[$arg_list[1]]))
            {
                if(is_array($this->result[$arg_list[1]]) && isset($this->result[$arg_list[1]][0]))
                {
                    $this->result["List"] = $this->result[$arg_list[1]];
                }
                else
                {
                    $this->result["List"] = array($this->result[$arg_list[1]]);
                }

                unset($this->result[$arg_list[1]]);
            }
            else
            {
                $this->result["List"] = array();
            }
        }

        return $this->get_error_code();
    }

    // Similar to java/ns/comm/rm/NitroProcessor.java and based on usr.src/netscaler/config/nitro/nitroutil.c
    private function get_command_with_correct_case($command)
    {
        if($command == "interface")
        {
            $command = "Interface";
        }
        else if($command == "import")
        {
            $command = "Import";
        }
        else if($command == "internal")
        {
            $command = "Internal";
        }
        else if($command == "namespace")
        {
            $command = "Namespace";
        }
        else if($command == "operator")
        {
            $command = "Operator";
        }
        else if($command == "static")
        {
            $command = "Static";
        }
        else if($command == "string")
        {
            $command = "String";
        }
        
        return $command;
    }
}
?>
