<?php 
if (!defined("BASEPATH")) 
{
    exit("No direct script access allowed");
}

require_once(APPPATH . "views/common/view_utils.php");

if($is_ajax_request)
{
    header(XML_HEADER);
    print "<messages>\n";

    require_once("graphical_view.php");

    //TODO: Check if csp is needed for this
    $graphical_view = new graphical_view($_ns_stat_definitions, $cmds, AJAX_REQUEST, $comparative_chart);
    $graphical_view->render($results, true, true);

    print "</messages>\n";

    return;
}
$nonce = $_SERVER['nonce'];
$this->load->view("common/header");
?>
<style type="text/css">
.ns_body
{
    min-width: 330px !important;
}
.hide
{
    display: none;
}
.ns_content
{
    padding: 0px;
}
</style>
<script nonce="<?=$nonce?>" type="text/javascript" src="/admin_ui/common/js/jquery/jquery.min.js"></script>
<script nonce="<?=$nonce?>" type="text/javascript" src="/admin_ui/dashboard/js/dashboard.js"></script>
<script nonce="<?=$nonce?>" type="text/javascript" src="/admin_ui/dashboard/js/comparative_chart.js"></script>
<?php

if(!$popup_window)
{
    print "<div class=\"dashboard_block_title\" >";
    print "<div class=\"comparative_chart_select_div\" >";
    print "<select id=\"coc_combo\" class=\"header_select\">\n";
    print_combo($custom_chart->get_charts(), $name, $id);
    print_combo($comparative_chart_definitions->get_comparative_charts(), $name, $id);
    print "</select></div>";
    print "<div class = \"comparative_chart_popout\">";
    print "<a href=\"#noAnchor\" id=\"".$id."_graphs_open_in_new_window_href_".$name."\" class=\"comparative_chart\" title=\"Open in a new window, manage custom charts.\" aria-label=\"Open in a new window, manage custom charts.\">\n";
   
    print "<span class = \"dashboard_images popout_img pointer_cursor\" style= \"margin-bottom: -2px\"> </span>";
    print "<span class = \"hide\">Open in a new window, manage custom charts.</span>";
    print "</a></div>";
    print "</div>";
}
else
{
    print "<table class=\"inline_display dashboard_block_title\" role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\"><tr><td></td><td><select id=\"coc_combo\" class=\"coc_combo coc_combo_popup\">\n";
    print_combo($custom_chart->get_charts(), $name, $id);
    print_combo($comparative_chart_definitions->get_comparative_charts(), $name, $id);
    print "</select></td></tr></table>\n";
}

require_once(APPPATH."views/common/locale_utils.php");

print  "<script nonce=\"". $nonce ."\" type=\"text/javascript\">\n";
print "var grouping_separator = '" . locale_utils::get_grouping_separator() . "';\n";
print "var decimal_separator = '" . locale_utils::get_decimal_separator() . "';\n";
print "var popup_window = '" . $popup_window ."';\n";
print "var coc_id = '" . $id ."';\n";
print "var success_result = '" . SUCCESS_RESULT . "';\n";
print "var chart_already_exists_result = '" . CHART_ALREADY_EXISTS_RESULT . "';\n";
print "var chart_display_name = '" . ($custom ? $comparative_chart["name"] : "") . "';\n";
print "</script>\n";
?>
<script nonce="<?=$nonce?>">
// Dashboard -> small graphs header -> change value in dropdown 
const comparative_chart_select = document.querySelectorAll('select[id="coc_combo"]');
for (let i = 0; i < comparative_chart_select.length; i++) {
    let item = comparative_chart_select[i];
    item.addEventListener("change", function() {
        if(this.value) window.location.href = this.value;
    });
}
// Dashboard -> small graphs header -> change value in dropdown
const graphs_open_in_new_window_href = document.querySelectorAll('a[id*="_graphs_open_in_new_window_href_"]');
for (let i = 0; i < graphs_open_in_new_window_href.length; i++) {
    let item = graphs_open_in_new_window_href[i];
    let id = item.id.split("_graphs_open_in_new_window_href_")[0];
    let name = item.id.split("_graphs_open_in_new_window_href_")[1];

    item.addEventListener("click", function() {
        openwind('/menu/coc?id='+id+'&name='+name+'&popup=yes', 'COC_'+id);
    });
    item.addEventListener("keypress", function() {
        if (event.keyCode == 13) {
            openwind('/menu/coc?id='+id+'&name='+name+'&popup=yes', 'COC_'+id);
            event.preventDefault();
        }
    });
}
</script>
<?php
view_utils::print_auto_refresh_javascript(-1);

require_once("graphical_view.php");

$graphical_view = new graphical_view($_ns_stat_definitions, $cmds, PAGE_REQUEST, $comparative_chart);
$graphical_view->render($results, true, true, isset($counter_groups) ? $counter_groups : null, isset($counters) ? $counters : null, $custom);

function print_combo($nodes, $name, $id)
{
    foreach($nodes as $node)
    {
        $node_name = $node["name"];

        if(isset($node["nodes"]))
        {
            print "<option value=\"\" class=\"node\" disabled=\"disabled\">[$node_name]</option>\n";
            print_combo($node["nodes"], $name, $id);
        }
        else
        {
            $key = isset($node["key"]) ? $node["key"] : $node_name;
            print "<option " . ($name == $key ? "selected " : "") . "value=\"/menu/coc?id=$id&name=$key\">$node_name</option>\n";
        }
    }
}
?>
