<?php if(!defined("BASEPATH")) exit("No direct script access allowed");
require_once(APPPATH . "views/common/view_utils.php");

class counter_selector_view
{
    private $_ns_stat_definitions; //_ns_stat_definitions containing all stat command definitions
    private $group; //_ns_stat_definitions command object
    private $counter_groups;    //Array of "counter_group" objects
    private $counters;  //Array of all "counter" objects
    private $entities;  //Array of all "entity" names
    private $prefix;    //Prefix to be used in "id" of DOM elements
    private $graphical_view; //Set to true for graphical view, false for comparative & custom charts

    public function __construct($_ns_stat_definitions, $group, $counter_groups, $counters, $entities, $prefix, $graphical_view)
    {
        $this->_ns_stat_definitions = $_ns_stat_definitions;
        $this->group = $group;
        $this->counter_groups = $counter_groups;
        $this->counters = $counters;
        $this->entities = $entities;
        $this->prefix = $prefix;
        $this->graphical_view = $graphical_view;
    }

    //$sel_counter_names - array of selected counter names indexed by group name Ex: array("statns" => array("cpuusage"))
    //$sel_entities - array of selected entity names
    public function render($sel_counter_names = array(), $sel_entities = null)
    {
        global $g_argval;
        
        $nonce = $_SERVER['nonce'];

        $hide_entities_tab = !ns_empty($g_argval);
        $is_an_entity_based_group = view_utils::is_an_entity_based_function($this->group);
        $style_for_group_selection = $this->graphical_view ? "style=\"display: none\"" : "";

        print "<table id=\"" . $this->prefix . "_table\" role=\"presentation\">";
        print "<tr id=\"" . $this->prefix . "_counters_drag_handle\" class=\"draggable\">
                <td align=\"right\">
                    <img data-prefix=\"". $this->prefix ."\" id=\"close-button\" class=\"close-button\" src=\"/admin_ui/common/images/navigate_cross.png\" alt=\"Close\" title=\"Close\" align=\"right\" tabindex=\"0\">
                </td>
        </tr>";
        print "<tr $style_for_group_selection><td align=\"left\"><table class=\"negative_margin_left\" role=\"presentation\"><tr id=\"" . $this->prefix . "_groups_radio_row\"><td>Plot chart for</td><td>";

        print "<fieldset style=\"padding-left: 0px; padding-right: 0px; border: none;\">";
            print "<legend style=\"padding-left: 0px; padding-right: 0px; display: none;\">Global groups</legend>";    
            print "<input type=\"radio\" data-prefix=\"" . $this->prefix ."\" class=\"radio_groups_global\" id=\"" . $this->prefix . "_groups_global_radio\" name=\"" . $this->prefix . "_groups_radio\" value=\"global\" title=\"Click to view global groups\" ";
            
            if($is_an_entity_based_group)
            {
                print ">";
            }
            else
            {
                print "checked>";
            }
        print "</fieldset>";

        print "System global statistics ";

        print "<fieldset style=\"padding-left: 0px; padding-right: 0px; border: none;\">";
            print "<legend style=\"padding-left: 0px; padding-right: 0px; display: none;\">Entity based groups</legend>";   
            print "<input type=\"radio\"  data-prefix=\"" . $this->prefix . "\" class=\"groups-entity-radio\" id=\"" . $this->prefix . "_groups_entity_radio\" name=\"" . $this->prefix . "_groups_radio\" value=\"entity\" title=\"Click to view entity based groups\"";
        
            if(!$is_an_entity_based_group)
            {
                print ">";
            }
            else
            {
                print "checked>";
            }
        print "</fieldset>";

        print "System entities statistics </td></tr>";
        print "<tr id=\"" . $this->prefix . "_counters_group_global_row\" ";
        if($is_an_entity_based_group)
            print "style=\"display: none\">\n";
        else
            print ">\n";
        print "<td>Select group</td><td>";
        print "<select id=\"" . $this->prefix . "_group_global_combo\" data-prefix=\" . $this->prefix . \" class=\"group_combo\">\n";
        $ent_groups = array();
        $license_map = isset($_SESSION["licenseMap"]) ? $_SESSION["licenseMap"] : array();
        foreach($this->counter_groups as $group)
        {
            #If a feature doesn't require licensing, skip the license check
            $license = $group->get_license();
            if(!empty($license))
            {
                $licensed = 1;
                foreach($license as $lic)
                {
                    if(!isset($license_map[$lic]))
                    {
                        $licensed = 0;
                        break;
                    }
                }
                if(!$licensed)
                    continue;
            }
            $name = $group->get_name();
            if(view_utils::is_an_entity_based_function($name))
            {
                $ent_groups[] = $group;
                continue;
            }
            $descr = $group->get_descr();
            if($name != $this->group)
                print "<option value=\"$name\">$descr</option>\n";
            else
                print "<option selected value=\"$name\">$descr</option>\n";
        }
        print "</select>";
        print "</td></tr>";
        print "<tr id=\"" . $this->prefix . "_counters_group_entity_row\" ";
        if(!$is_an_entity_based_group)
            print "style=\"display: none\">\n";
        else
            print ">\n";
        print "<td>Select group</td><td>";
        print "<select id=\"" . $this->prefix . "_group_entity_combo\" data-prefix=\" . $this->prefix . \" class=\"group_combo\">\n";
        foreach($ent_groups as $group)
        {
            $name = $group->get_name();
            $descr = $group->get_descr();
            if ($name != $this->group)
                print "<option value=\"$name\">$descr</option>\n";
            else
                print "<option selected value=\"$name\">$descr</option>\n";
        }
        print "</select>";
        print "</td></tr></table></td></tr>";

        if($hide_entities_tab)
            print "<tr><td><table class=\"negative_margin_left\" role=\"presentation\"><tr><td>Entity name&nbsp;</td><td><input type=\"textfield\" value=\"$g_argval\" class=\"chart_name_input\" readonly/></td></tr></table></td></tr>";
        
        print "<tr><td align=\"left\" valign=\"top\" class=\"bottom_border\">";
        print "<div class=\"tab\" align=\"left\">";
        print "<span id=\"" . $this->prefix . "_tab_0\"  class=\"current_tab\" data-prefix=\"" . $this->prefix . "\">
            <a href=\"#noAnchor\" data-prefix=\"" . $this->prefix . "\" id=\"tab_anchor_counters\" class=\"tab_anchor_counters\">
                <span data-prefix=\"" . $this->prefix . "\">Counters</span>
            </a>
        </span>";
        
        if($is_an_entity_based_group && !$hide_entities_tab)
        {
            print "<span id=\"" . $this->prefix . "_tab_1\" data-prefix=\"" . $this->prefix . "\">
                    <a href=\"#noAnchor\" data-prefix=\"" . $this->prefix . "\" id=\"tab_anchor_entities\" class=\"tab_anchor_entities\">
                        <span data-prefix=\"" . $this->prefix . "\">Entities</span>
                    </a>
                </span>";
        }

        print "</div></td></tr>";
        print "<tr id=\"" . $this->prefix . "_counters_table_row\"><td align=\"left\" nowrap>";
        print "<table id=\"" . $this->prefix . "_counters_table\" role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\" class=\"full_width_table\">";
        print "<tr><td>";
        print "<table class=\"full_width_table\" role=\"presentation\" cellpadding=\"0\" cellspacing=\"0\"><tr><td>Available</td><td align=\"right\">";
        print "<img src=\"/admin_ui/common/images/view.png\" alt=\"Show search panel\" id=\"" . $this->prefix . "_cntrs_avail_list_find_img\" data-prefix=\"" . $this->prefix . "\" title=\"Show search panel\" class=\"pointer_cursor search_panel_icon_prefix\" tabindex=\"0\"></td></tr>";
        self::print_find_panel_for_list($this->prefix . "_cntrs_avail_list");
        print "</table>";
        print "<select id=\"" . $this->prefix . "_cntrs_avail_list\" data-prefix=\"" . $this->prefix . "\" size=\"10\" multiple class=\"counters_list_box counters_sel_list\">\n";

        $sel_counters = self::create_counters_objects($sel_counter_names);

        foreach($this->counters as $counter)
        {
            $counter_name = $counter->get_name();
            $counter_desc = $counter->get_descr();
            $counter_tooltip = $counter->get_tooltip();
            $counter_func = $counter->get_group();

            if(!view_utils::value_exists_in_array($sel_counters, $counter))
            {
                print "<option value=\"" . $counter_name . " " . $counter_func . "\" title=\"$counter_tooltip\">$counter_desc</option>\n";
            }
        }

        print "</select></td><td class=\"padding_right_left\">\n";

        print "<fieldset style=\"padding-left: 0px; padding-right: 0px; border: none;\">";
            print "<legend style=\"padding-left: 0px; padding-right: 0px; display: none;\">Move items</legend>";
            print "<input type=\"button\" data-prefix=\"" . $this->prefix . "\" id=\"" . $this->prefix . "_cntrs_move_right_button\" class=\"counters_move_button counters_move_right_button\"  value=\">\" disabled=\"true\"/><br>\n";
            print "<input type=\"button\" data-prefix=\"" . $this->prefix . "\" id=\"" . $this->prefix . "_cntrs_move_left_button\" class=\"counters_move_button counters_move_left_button\"  value=\"<\" disabled=\"true\"/><br>\n";
            print "<input type=\"button\" data-prefix=\"" . $this->prefix . "\" id=\"" . $this->prefix . "_cntrs_move_all_left_button\" class=\"counters_move_button counters_move_all_left_button\"  value=\"<<\"/>\n";
        print "</fieldset>";

        print "</td><td>Selected";
        print "<br><select id=\"" . $this->prefix . "_cntrs_sel_list\" size=\"10\" multiple class=\"counters_list_box counters_sel_list_right\" data-prefix=\"" . $this->prefix . "\">\n";
        foreach($sel_counters as $counter)
        {
            $counter_name = $counter->get_name();
            $counter_desc = $counter->get_descr();
            $counter_tooltip = $counter->get_tooltip();
            $counter_func = $counter->get_group();
            print "<option value=\"" . $counter_name . " " . $counter_func . "\" title=\"$counter_tooltip\">$counter_desc</option>\n";
        }
        print "</select></td></tr></table></td></tr>\n";
        $ents_avail_list_id = "";
        if($is_an_entity_based_group)
        {
            print "<tr id=\"" . $this->prefix . "_entities_table_row\" style=\"display: none\"><td align=\"left\" nowrap>";
            print "<table id=\"" . $this->prefix . "_entities_table\" cellpadding=\"0\" cellspacing=\"0\" role=\"presentation\" class=\"full_width_table\">";
            print "<tr><td><table class=\"full_width_table\"  cellpadding=0 cellspacing=0 role=\"presentation\"><tr><td>Available</td><td align=\"right\">";
            $ents_avail_list_id = $this->prefix . "_ents_avail_list";
            print "<img src=\"/admin_ui/common/images/view.png\" alt=\"Show search panel\" id=\"" . $ents_avail_list_id . "_find_img\" data-list-id=\"" . $ents_avail_list_id . "\" title=\"Show search panel\" class=\"pointer_cursor search_panel_icon\" tabindex=\"0\"></td></tr>";
            self::print_find_panel_for_list($ents_avail_list_id);
            print "</table>";
            print "<select id=\"$ents_avail_list_id\" size=\"10\" multiple class=\"counters_list_box entities_sel_list_left\" data-prefix=\"" . $this->prefix . "\">\n";
            if(!ns_empty($this->entities))
            {
                if(!isset($sel_entities))
                    $sel_entities = array();
                sort($this->entities);
                foreach($this->entities as $entity)
                {
                    if(!view_utils::value_exists_in_array($sel_entities, $entity))
                        print "<option value=\"$entity\" title=\"$entity\">$entity</option>\n";
                }
            }
            print "</select>";
            print "</td><td class=\"padding_right_left\">\n";

            print "<fieldset style=\"padding-left: 0px; padding-right: 0px; border: none;\">";
                print "<legend style=\"padding-left: 0px; padding-right: 0px; display: none;\">Move items</legend>";
                print "<input type=\"button\" id=\"" . $this->prefix . "_ents_move_right_button\" class=\"counters_move_button ents_move_right_button\"  data-prefix=\"" . $this->prefix . "\" value=\">\" disabled=\"true\"/><br>\n";
                print "<input type=\"button\" id=\"" . $this->prefix . "_ents_move_left_button\" class=\"counters_move_button ents_move_left_button\"  data-prefix=\"" . $this->prefix . "\" value=\"<\" disabled=\"true\"/><br>\n";
                print "<input type=\"button\" id=\"" . $this->prefix . "_ents_move_all_left_button\" class=\"counters_move_button ents_move_all_left_button\"  data-prefix=\"" . $this->prefix . "\" value=\"<<\"/>\n";
            print "</fieldset>";

            print "</td>
                <td>Selected
                    <br>
                    <select id=\"" . $this->prefix . "_ents_sel_list\" size=\"10\" multiple class=\"counters_list_box entities_sel_list\" data-prefix=\"" . $this->prefix . "\">\n";
            
            if(isset($sel_entities) && !ns_empty($this->entities))
            {
                foreach($sel_entities as $entity)
                {
                    if($sel_entity = view_utils::value_exists_in_array($this->entities, $entity))
                    {
                        print "<option value=\"$entity\" title=\"$entity\">$entity</option>\n";
                    }
                }
            }

            print "</select></td></tr></table></td></tr>\n";
        }
        print "<tr><td><table class=\"counters_popup_status\" cellpadding=\"0\" cellspacing=\"0\" role=\"presentation\"><tr><td id=\"" . $this->prefix . "_cntrs_status_cell\">";
        
        if(get_branding()->show_help())
        {
            print "<a href=\"#noAnchor\" class=\"dashboard-help-3\" title=\"Click to obtain help related to this popup\">
                <img id=\"help_image\" src=\"/admin_ui/common/images/help.png\" alt=\"Help\" border=\"0\">
            </a>&nbsp;";
            print "<a href=\"#noAnchor\" class=\"dashboard-help-3\" title=\"Click to obtain help related to this popup\">Help</a>&nbsp;";
        }

        print "</td><td align=\"right\" class=\"padding_top\">";

        print "<fieldset style=\"padding-left: 0px; padding-right: 0px; border: none;\">";
            print "<legend style=\"padding-left: 0px; padding-right: 0px; display: none;\">View chart</legend>";
            print "<input type=\"button\" id=\"view_chart_ok\" class=\"flat_button view_chart_ok\" value=\"OK\" data-ents-avail-list-id=\"" . $ents_avail_list_id . "\" data-prefix=\"" . $this->prefix . "\" title=\"Click to view chart\"/>&nbsp;&nbsp;";

            print "<input type=\"button\" id=\"view_chart_close\" class=\"flat_button view_chart_close\" value=\"Close\" data-prefix=\"" . $this->prefix . "\" title=\"Click to close\"/>";
        print "</fieldset>";

        print "</td></tr></table></td></tr>";
        print "</table>";
        print "<script  nonce=\"" . $nonce . "\" type=\"text/javascript\">\n";
        print "var prefix = '" . $this->prefix . "'";
        print "</script>\n";
        print "<script nonce=\"" . $nonce . "\" type='text/javascript'>


            /**
             * Ok, so we need to add event handlers using on as 
             * the counters view is re-rendered multiple times and only certain
             * HTML content is fetched from PHP to the browser for re-rendering.
             * This is to make sure the event handlers are registered for future DOM as well.
             */
            var counters_view = $('.counter_selector_popup'); 
            // TODO: Attach to even higher element after testing if necessary

            // close icon on the counters view
            counters_view.on('click', '.close-button', function(event){
                var prefix = event.currentTarget.getAttribute('data-prefix');
                    popup_hide(prefix+'_counters_div')
            });
            counters_view.on('keypress', '.close-button', function(event){
                var prefix = event.currentTarget.getAttribute('data-prefix');
                if(event.keyCode == 13) {
                    popup_hide(prefix+'_counters_div');
                    event.preventDefault();
                }
            });

            // Radio on the top of the counters view
            counters_view.on('click', '.groups-entity-radio', function(event){
                var prefix = event.currentTarget.getAttribute('data-prefix');
                group_radio_changed(prefix, this);
            });
            counters_view.on('keypress', '.groups-entity-radio', function(event){
                var prefix = event.currentTarget.getAttribute('data-prefix');
                    if(event.keyCode == 13) {
                        group_radio_changed(prefix, this);
                        event.preventDefault();
                    }
            });

            // Radio on the top of the counters view
            counters_view.on('click', '.radio_groups_global', function(event){
                var prefix = event.currentTarget.getAttribute('data-prefix');
                group_radio_changed(prefix, this);
            });
            counters_view.on('keypress', '.radio_groups_global', function(event){
                var prefix = event.currentTarget.getAttribute('data-prefix');
                if(event.keyCode == 13) {
                    group_radio_changed(prefix, this);
                    event.preventDefault();
                }
            });

            // Counters tab
            counters_view.on('click', '.tab_anchor_counters', function(event){
                var prefix = event.currentTarget.getAttribute('data-prefix');
                    switch_tab(prefix, 0);
            });
            counters_view.on('keypress', '.tab_anchor_counters', function(event){
                var prefix = event.currentTarget.getAttribute('data-prefix');
                if(event.keyCode == 13) {
                    switch_tab(prefix, 0)
                    event.preventDefault();
                }
            });

            // Entities tab
            counters_view.on('click', '.tab_anchor_entities', function(event){
                var prefix = event.currentTarget.getAttribute('data-prefix');
                switch_tab(prefix, 1);
            });
            counters_view.on('keypress', '.tab_anchor_entities', function(event){
                var prefix = event.currentTarget.getAttribute('data-prefix');
                if(event.keyCode == 13) {
                    switch_tab(prefix, 1)
                    event.preventDefault();
                }
            });

            // Move right button (>)
            counters_view.on('click', '.counters_move_right_button', function(event){
                var prefix = event.currentTarget.getAttribute('data-prefix');
                move_items(prefix, '_cntrs', true, false);
            });
            counters_view.on('keypress', '.counters_move_right_button', function(event){
                var prefix = event.currentTarget.getAttribute('data-prefix');
                if(event.keyCode == 13) {
                    move_items(prefix, '_cntrs', true, false);
                    event.preventDefault();
                }
            });

            // Move left button (<)
            counters_view.on('click', '.counters_move_left_button', function(event){
                var prefix = event.currentTarget.getAttribute('data-prefix');
                move_items(prefix, '_cntrs', false, false);
            });
            counters_view.on('keypress', '.counters_move_left_button', function(event){
                var prefix = event.currentTarget.getAttribute('data-prefix');
                if(event.keyCode == 13) {
                    move_items(prefix, '_cntrs', false, false);
                    event.preventDefault();
                }
            });

            // Move all left button (<<)
            counters_view.on('click', '.counters_move_all_left_button', function(event){
                var prefix = event.currentTarget.getAttribute('data-prefix');
                move_items(prefix, '_cntrs', false, true);
            });
            counters_view.on('keypress', '.counters_move_all_left_button', function(event){
                var prefix = event.currentTarget.getAttribute('data-prefix');
                if(event.keyCode == 13) {
                    move_items(prefix, '_cntrs', false, true);
                    event.preventDefault();
                }
            });

            // Move right button for entities(>)
            counters_view.on('click', '.ents_move_right_button', function(event){
                var prefix = event.currentTarget.getAttribute('data-prefix');
                move_items(prefix, '_ents', true, false);
            });
            counters_view.on('keypress', '.ents_move_right_button', function(event){
                var prefix = event.currentTarget.getAttribute('data-prefix');
                if(event.keyCode == 13) {
                    move_items(prefix, '_ents', true, false);
                    event.preventDefault();
                }
            });

            // Move left button for entities(<)
            counters_view.on('click', '.ents_move_left_button', function(event){
                var prefix = event.currentTarget.getAttribute('data-prefix');
                move_items(prefix, '_ents', false, false);
            });
            counters_view.on('keypress', '.ents_move_left_button', function(event){
                var prefix = event.currentTarget.getAttribute('data-prefix');
                if(event.keyCode == 13) {
                    move_items(prefix, '_ents', false, false);
                    event.preventDefault();
                }
            });

            // Move all left button for entities (<<)
            counters_view.on('click', '.ents_move_all_left_button', function(event){
                var prefix = event.currentTarget.getAttribute('data-prefix');
                move_items(prefix, '_ents', false, true);
            });
            counters_view.on('keypress', '.counters_move_all_left_button', function(event){
                var prefix = event.currentTarget.getAttribute('data-prefix');
                if(event.keyCode == 13) {
                    move_items(prefix, '_ents', false, true);
                    event.preventDefault();
                }
            });

            // Counters multi-select on the right
            counters_view.on('dblclick', '.entities_sel_list', function(event){
                var prefix = event.currentTarget.getAttribute('data-prefix');
                move_items(prefix, '_ents', false, false);
            });
            counters_view.on('keypress', '.entities_sel_list', function(event){
                var prefix = event.currentTarget.getAttribute('data-prefix');
                if(event.keyCode == 13) {
                    move_items(prefix, '_ents', false, false);
                    event.preventDefault();
                }
            });
            counters_view.on('change', '.entities_sel_list', function(event){
                var prefix = event.currentTarget.getAttribute('data-prefix');
                set_state(prefix+'_ents', this, false);
            });

            // Search icon
            counters_view.on('click', '.search_panel_icon', function(event){
                var list_id = event.currentTarget.getAttribute('data-list-id');
                show_hide_find_panel(list_id, true);
            });
            counters_view.on('keypress', '.search_panel_icon', function(event){
                var list_id = event.currentTarget.getAttribute('data-list-id');
                if(event.keyCode == 13) {
                    show_hide_find_panel(list_id, true);
                    event.preventDefault();
                }
            });


            // Search field on the top of counters
            counters_view.on('click', '.search_panel_icon_prefix', function(event){
                var prefix = event.currentTarget.getAttribute('data-prefix');
                show_hide_find_panel(prefix+'_cntrs_avail_list', true);
            });
            counters_view.on('keypress', '.search_panel_icon_prefix', function(event){
                var prefix = event.currentTarget.getAttribute('data-prefix');
                if(event.keyCode == 13) {
                    show_hide_find_panel(prefix+'_cntrs_avail_list', true);
                    event.preventDefault();
                }
            });

            // Help icon
            counters_view.on('click', '.dashboard-help-3', function(event){
                openwindow('/help/db/dashboard.htm#ns_html_dashboard_counters_entities_dialog_box_ref.html', 'Dashboard_Help3_" . $_SESSION["rand"] . "', 'Help', screen.width, screen.height);
            });
            counters_view.on('keypress', '.dashboard-help-3', function(event){
                if(event.keyCode == 13) {
                    openwindow('/help/db/dashboard.htm#ns_html_dashboard_counters_entities_dialog_box_ref.html', 'Dashboard_Help3_" . $_SESSION["rand"] . "', 'Help', screen.width, screen.height);
                    event.preventDefault();
                }
            });

            // dropdown with the group of counters
            counters_view.on('change', '.group_combo', function(event){
                var prefix = event.currentTarget.getAttribute('data-prefix');
                group_cmb_changed(prefix, this.value);
            });
            

            // Counters multi-select list
            counters_view.on('dblclick', '.counters_sel_list', function(event){
                var prefix = event.currentTarget.getAttribute('data-prefix');
                move_items(prefix, '_cntrs', true, false);
            });
            counters_view.on('keypress', '.counters_sel_list', function(event){
                var prefix = event.currentTarget.getAttribute('data-prefix');
                if(event.keyCode == 13) {
                    move_items(prefix, '_cntrs', true, false);
                    event.preventDefault();
                }
            });
            counters_view.on('change', '.counters_sel_list', function(event){
                var prefix = event.currentTarget.getAttribute('data-prefix');
                set_state(prefix+'_cntrs', this, true);
            });

            // Entities multi-select on the left
            counters_view.on('dblclick', '.entities_sel_list_left', function(event){
                var prefix = event.currentTarget.getAttribute('data-prefix');
                move_items(prefix, '_ents', true, false);
            });
            counters_view.on('keypress', '.entities_sel_list_left', function(event){
                var prefix = event.currentTarget.getAttribute('data-prefix');
                if(event.keyCode == 13) {
                    move_items(prefix, '_ents', true, false);
                    event.preventDefault();
                }
            });
            counters_view.on('change', '.entities_sel_list_left', function(event){
                var prefix = event.currentTarget.getAttribute('data-prefix');
                set_state(prefix+'_ents', this, true);
            });

            // Counters multi-select on the right
            counters_view.on('dblclick', '.counters_sel_list_right', function(event){
                var prefix = event.currentTarget.getAttribute('data-prefix');
                    move_items(prefix, '_cntrs', false, false);
            });
            counters_view.on('keypress', '.counters_sel_list_right', function(event){
                var prefix = event.currentTarget.getAttribute('data-prefix');
                    if(event.keyCode == 13) {
                        move_items(prefix, '_cntrs', false, false);
                        event.preventDefault();
                    }
            });
            counters_view.on('change', '.counters_sel_list_right', function(event){
                var prefix = event.currentTarget.getAttribute('data-prefix');
                set_state(prefix+'_cntrs', this, false);
            });


            // OK button on the counters view
            counters_view.on('click', '.view_chart_ok', function(event){
                var prefix = event.currentTarget.getAttribute('data-prefix');
                var ents_avail_list_id = event.currentTarget.getAttribute('data-ents-avail-list-id');
                hide_find_panel(prefix+'_cntrs_avail_list', true);
                hide_find_panel(ents_avail_list_id, true);
                popup_hide(prefix+'_counters_div', true);
                refresh_chart(prefix);
            });
            counters_view.on('keypress', '.view_chart_ok', function(event){
                var prefix = event.currentTarget.getAttribute('data-prefix');
                var ents_avail_list_id = event.currentTarget.getAttribute('data-ents-avail-list-id');
                if(event.keyCode == 13) {
                    hide_find_panel(prefix+'_cntrs_avail_list', true);
                    hide_find_panel(ents_avail_list_id, true);
                    popup_hide(prefix+'_counters_div', true);
                    refresh_chart(prefix);
                    event.preventDefault();
                }
            });

            // Close button on the counters view
            counters_view.on('click', '.view_chart_close', function(event){
                var prefix = event.currentTarget.getAttribute('data-prefix');
                popup_hide(prefix+'_counters_div');
            });
            counters_view.on('keypress', '.view_chart_close', function(event){
                var prefix = event.currentTarget.getAttribute('data-prefix');
                if(event.keyCode == 13) {
                    popup_hide(prefix+'_counters_div');
                    event.preventDefault();
                }
            });

            // find panel events for list
            counters_view.on('change', '.criterion_reporting', function(event){
                var list_id = event.currentTarget.getAttribute('data-list-id');
                filter_list(list_id);
            });
            counters_view.on('input', '.search_text_reporting', function(event){
                var list_id = event.currentTarget.getAttribute('data-list-id');
                return filter_list(list_id);
            });
            counters_view.on('propertychange', '.search_text_reporting', function(event){
                var list_id = event.currentTarget.getAttribute('data-list-id');
                return filter_list(list_id);
            });
            
        </script>";
    }

    private function create_counters_objects($func_cntrs)
    {
        $sel_counters = array();
        foreach($func_cntrs as $function => $cntrs)
        {
            $nsstat_cmd = $this->_ns_stat_definitions->get_command($function);
            $nsstat_cntrs = $nsstat_cmd["cntrs"];
            foreach($cntrs as $counter_name)
            {
                if(!isset($nsstat_cntrs[$counter_name]))
                {
                    $sel_counters[] = new counter($counter_name, $counter_name, $counter_name, $function);
                    continue;
                }
                $cntr = $nsstat_cntrs[$counter_name];
                $counter_desc = view_utils::get_counter_descr($cntr, $nsstat_cntrs);
                $counter_tooltip = isset($cntr["tooltip"]) ? $cntr["tooltip"] : $counter_desc;
                $sel_counters[] = new counter($counter_name, $counter_desc, $counter_tooltip, $function);
            }
        }

        return $sel_counters;
    }

    private static function print_find_panel_for_list($list_id)
    {
        print "<tr id=\"" . $list_id . "_find_row\" style=\"display: none\"><td class=\"find_panel_reporting\">";

        print "<fieldset style=\"padding-left: 0px; padding-right: 0px; border: none;\">";
            print "<legend style=\"padding-left: 0px; padding-right: 0px; display: none;\">Search criterion</legend>";
            print "Criterion <select id=\"" . $list_id . "_find_row_criterion\" title=\"Select the search criterion\" class=\"criterion_reporting\" data-list-id=\"" . $list_id . "\">";
            print "<option>contains</option>";
            print "<option>not contains</option>";
            print "<option>starts with</option>";
            print "<option>ends with</option>";
            print "</select>";
            print " Text <input type=\"textfield\" size=\"8\" maxlength=\"128\" id=\"" . $list_id . "_find_row_search_text\" title=\"Enter the search text (case insensitive)\" data-list-id=\"" . $list_id . "\" class=\"search_text_reporting\">";
        print "</fieldset>";

        print "</td>
            <td align=\"right\">
                <img src=\"/admin_ui/common/images/navigate_cross.png\" data-list-id=\"" . $list_id . "\" alt=\"Hide search panel\" title=\"Hide search panel\" class=\"pointer_cursor search_panel_icon\" tabindex=\"0\">";
        print "</td></tr>";
    }
}
?>
