<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
require_once(APPPATH."views/common/locale_utils.php");
$nonce = $_SERVER['nonce'];

$this->load->view("common/header");

$elements = $report['elements'];
$stime_default_value = report_definitions::get_report_stime($report);
$etime_default_value = report_definitions::get_report_etime($report);
$last_default_value = report_definitions::get_report_last($report);
$unit_default_value = report_definitions::get_report_unit($report);
$report_display_name = report_definitions::get_report_name($report);

$current_parent_node = isset($parent)? reporting_utils::sanitize_reporting_data("name", $parent):CUSTOM_REPORTS;
?>
<link rel="stylesheet" type="text/css" href="/admin_ui/common/css/calendar/calendar-win2k-cold-1.css">
<link rel="stylesheet" type="text/css" href="/admin_ui/common/css/yui/menu.css">
<link rel="stylesheet" type="text/css" href="/admin_ui/common/css/yui/ns/menu.css">
<link rel="stylesheet" type="text/css" href="/admin_ui/common/css/yui/button.css">
<link rel="stylesheet" type="text/css" href="/admin_ui/common/css/yui/ns/button.css">
<link rel="stylesheet" type="text/css" href="/admin_ui/common/css/yui/slider.css">
<link rel="stylesheet" type="text/css" href="/admin_ui/common/css/yui/ns/slider.css">

<script nonce="<?=$nonce?>" type="text/javascript" src="/admin_ui/common/js/calendar/calendar.js"></script>
<script nonce="<?=$nonce?>" type="text/javascript" src="/admin_ui/common/js/calendar/calendar-en.js"></script>
<script nonce="<?=$nonce?>" type="text/javascript" src="/admin_ui/common/js/calendar/calendar-setup.js"></script>

<script nonce="<?=$nonce?>" type="text/javascript" src="/admin_ui/common/js/jscolor/jscolor.js"></script>

<script nonce="<?=$nonce?>" type="text/javascript" src="/admin_ui/common/js/yui/yahoo-dom-event.js"></script>
<script nonce="<?=$nonce?>" type="text/javascript" src="/admin_ui/common/js/yui/container_core-min.js"></script>
<script nonce="<?=$nonce?>" type="text/javascript" src="/admin_ui/common/js/yui/menu-min.js"></script>
<script nonce="<?=$nonce?>" type="text/javascript" src="/admin_ui/common/js/yui/dragdrop-min.js"></script>
<script nonce="<?=$nonce?>" type="text/javascript" src="/admin_ui/common/js/yui/animation-min.js"></script>
<script nonce="<?=$nonce?>" type="text/javascript" src="/admin_ui/common/js/yui/slider-min.js"></script>
<script nonce="<?=$nonce?>" type="text/javascript" src="/admin_ui/common/js/yui/element-min.js"></script>
<script nonce="<?=$nonce?>" type="text/javascript" src="/admin_ui/common/js/yui/button-min.js"></script>

<script nonce="<?=$nonce?>" type="text/javascript" src="/admin_ui/common/js/ns/list.js"></script>
<script nonce="<?=$nonce?>" type="text/javascript" src="/admin_ui/common/js/ns/sort.js"></script>
<script nonce="<?=$nonce?>" type="text/javascript" src="/admin_ui/common/js/ns/table.js"></script>
<style type="text/css">
/*Overrides definitions in ui.css*/
.ns_body
{
    min-width: 749px !important;
}

.ns_content
{
    padding: 0px;
}

.loading_panel
{
    height: 200px;
}

.ns_wp_title td
{
    color: #003399;
}
.hide
{
    display: none;
}
</style>
<!--[if IE 6]>
<style type="text/css">
.ns_body
{
    width: expression(this.parentNode.clientWidth < 759 ? "749px" : "100%" );
}
</style>
<![endif]-->
<script nonce="<?=$nonce?>" type="text/javascript">
//Following variables are used in reporting.js
var ds = '<?= $ds?>';
var is_default_data_source = <?=$is_default_data_source ? "true" : "false"?>;
var unit = '<?=$unit_default_value?>';
var last_default_value = <?=LAST_DEFAULT_VALUE?>;
var last = <?=$last_default_value?>;
var stime = '<?=$stime_default_value?>';
var etime = '<?=$etime_default_value?>';
var use_start_end_time = (stime != "" && etime != "");
var orig_unit = unit;
var orig_last = last;
var orig_stime = stime;
var orig_etime = etime;
var orig_use_start_end_time = use_start_end_time;
var report_display_name = '<?=reporting_utils::sanitize_reporting_data("name", $report_display_name, "JS")?>';
var report_internal_name = '<?=reporting_utils::sanitize_reporting_data("name", $name, "JS")?>';
var custom = '<?=$custom?>';
var prompt_save_warning = '<?=isset($new)?>';
var is_vmpe_mode = <?=is_vmpe_mode()?>;
var current_parent_node = '<?=$current_parent_node?>';
var grouping_separator = '<?=locale_utils::get_grouping_separator()?>';

var hours_default_value = '<?=HOURS?>';
var days_default_value = '<?=DAYS?>';
var weeks_default_value = '<?=WEEKS?>';
var months_default_value = '<?=MONTHS?>';
var years_default_value = '<?=YEARS?>';
var cpu_core_default_value = '<?=CPU_CORE?>';
var graph_type_default_value = '<?=LINE_GRAPH?>';
var max_no_of_data_sets = <?=MAX_NO_OF_DATA_SETS?>;
var max_no_of_charts_per_report = <?=MAX_NO_OF_CHARTS_PER_REPORT?>;
var success_result = '<?=SUCCESS_RESULT?>';
var ACTIVE_ENTITY = <?=ACTIVE_ENTITY?>;
var INACTIVE_ENTITY = <?=INACTIVE_ENTITY?>;
var DELETED_ENTITY = <?=DELETED_ENTITY?>;
var CUSTOM_REPORTS = '<?=CUSTOM_REPORTS?>';
</script>
<script nonce="<?=$nonce?>" type="text/javascript" src="/admin_ui/common/js/ns/tree.js"></script>
<?php
require_once(APPPATH . "views/common/view_utils.php");
view_utils::print_counter_tooltip_popup();
?>
<script nonce="<?=$nonce?>" type="text/javascript" src="/admin_ui/reporting/js/reporting.js"></script>
<script nonce="<?=$nonce?>" type="text/javascript" src="/admin_ui/reporting/js/reporting_chart_utils.js"></script>
<script nonce="<?=$nonce?>" type="text/javascript" src="/admin_ui/reporting/js/reporting_customization.js"></script>
<?php
if(!$is_default_data_source)
    print "<script nonce='".$nonce."' type=\"text/javascript\" src=\"/admin_ui/reporting/js/reporting_debug.js\"></script>\n";
?>

<div id="custom_reports_tree_nodes_div" class="popup custom_reports_parent_node tree_nodes_div"></div>

<script nonce="<?=$nonce?>" type='text/javascript'>
// Custom reports in folder selection screen
var cr_folders_selection = $('.custom_reports_parent_node');
cr_folders_selection.on('click', '.cr_folders_selection', function(event){
    var prefix = event.currentTarget.getAttribute('id-for-separate-tree');
    select_tree_node(prefix);
});
cr_folders_selection.on('keypress', '.cr_folders_selection', function(event){
    var prefix = event.currentTarget.getAttribute('id-for-separate-tree');
    if(event.keyCode == 13) {
        select_tree_node(prefix);
        event.preventDefault();
    }
});
// Selecting main nodes in folder selection screen
var folders_selection_main_nodes = $('.custom_reports_parent_node');
folders_selection_main_nodes.on('click', '.folders_selection_main_nodes', function(event){
    var prefix = event.currentTarget.getAttribute('node-name');
    select_tree_node(prefix);
});
folders_selection_main_nodes.on('keypress', '.folders_selection_main_nodes', function(event){
    var prefix = event.currentTarget.getAttribute('node-name');
    if(event.keyCode == 13) {
        select_tree_node(prefix);
        event.preventDefault();
    }
});
</script>

<div align="left" valign="middle" class="report_name">
<b>Report:</b> <?=reporting_utils::sanitize_reporting_data("name",$report_display_name)?>
</div>
<div class = "reporting_content_div">

<div id ="toolbar" class="full_width_table reporting_toolbar">
<div id ="left_reporting_toolbar" class="toolbar_cell">
<div class = "floated_ellipsed_divs" id= "duration_div" ><a href="#noAnchor" title="Click to select duration" aria-label="Click to select duratio"><span class="reporting_images duration_img pointer_cursor" title="Duration"/></span><span class="hide">Duration</span>Duration</a></div>
<div class = "floated_ellipsed_divs" id= "create_div" ><a href="#noAnchor" title="Click to create a new report" aria-label="Click to create a new report"><span id="create_report_span" class="reporting_images create_img pointer_cursor" title="Create"/></span><span class="hide">Click to create a new report</span>Create</a></div>
<?php
if($custom)    //show "save" only for custom report
{
?>
<div class = "floated_ellipsed_divs" id="save_report_div" style = "width:75px;"><a href="#noAnchor" title="Click to save the report" aria-label="Click to save the report"><span class="reporting_images save_img pointer_cursor" title="Save"/></span><span class="hide">save</span>Save</a></div>
<?php
}
?>
<div class = "floated_ellipsed_divs" id = "saveas_div"><a href="#noAnchor" title="Click to save the report in a different name" arial-label="Click to save the report in a different name"><span id="save_as_report_span" class= "reporting_images save_as_img pointer_cursor" title="Save As"/></span><span class="hide">Click to save the report in a different name</span>Save As</a></div>
<?php
if($custom)    //show "delete" only for custom report
{
    $li_style = "style=\"display: inline\"";
    if(isset($new)) //Create report request, don't show delete until report gets saved.
        $li_style = "style=\"display: none\"";
?>
<div class = "floated_ellipsed_divs" id="delete_div" <?=$li_style?> ><a href="#noAnchor" title="Click to delete the report" arial-label="Click to delete the report"><span class="reporting_images delete_img pointer_cursor" title="Delete"/></span><span class="hide">Click to delete the report</span>Delete</a></div>
<?php
}
?>

<div class = "floated_ellipsed_divs" id= "scroll_div" ><a href="#noAnchor" title="Click to select scroll mode. Click inside any of the charts and drag left or right to scroll" arial-label="Click to select scroll mode. Click inside any of the charts and drag left or right to scroll"><span class="reporting_images scroll_img pointer_cursor" title="Scroll" ></span><span class="hide">Click to select scroll mode. Click inside any of the charts and drag left or right to scroll</span>Scroll</a></div>
<div class = "floated_ellipsed_divs" id= "zoomin_div" ><a href="#noAnchor" title="Click to select zoom in mode. Click inside any of the charts to zoom in or click and drag to zoom in using a box" aria-label="Click to select zoom in mode. Click inside any of the charts to zoom in or click and drag to zoom in using a box"><span class="reporting_images zoomin_img pointer_cursor" title="Zoom In"></span><span class="hide">"Click to select zoom in mode. Click inside any of the charts to zoom in or click and drag to zoom in using a box</span>Zoom In</a></div>
<div class = "floated_ellipsed_divs" id= "zoomout_div"><a href="#noAnchor" title="Click to select zoom out mode. Click inside any of the charts to zoom out" aria-label="Click to select zoom out mode. Click inside any of the charts to zoom out"><span class="reporting_images zoomout_img pointer_cursor" title="Zoom Out"></span><span class="hide">Click to select zoom out mode. Click inside any of the charts to zoom out</span>Zoom Out</a></div>
<div class = "floated_ellipsed_divs" id = "reset_div" ><a href="#noAnchor" class="toolbar_last" title="Click to reset duration" aria-label="Click to reset duration"><span class="reporting_images reset_img pointer_cursor" title="Reset"></span><span class="hide">Click to reset duration</span>Reset</a></div>
</div>
<div id = "right_reporting_toolbar" class="toolbar_cell toolbar_cell_right" align="right">
<div class = "floated_ellipsed_divs" id = "right_reporting_toolbar_div" style = "width:90px;"><a href="#noAnchor" class="toolbar_last" title="Click to see settings" aria-label="Click to see settings" ><span id="settings_span" class="reporting_images setting_img pointer_cursor" title="Settings"/></span><span class="hide">Settings</span>Settings</a></div>
</div>
</div>

<div id ="popup_options">

<div id="settings_div" class="popup">
<table role="presentation">
<tr><td><b>Settings:</b></td><td align="right">
<img src="/admin_ui/common/images/navigate_cross.png" id="img_popup_hide" alt=Close"" title="Close" tabindex="0"></td></tr><tr><td>
Data Source</td><td><select id="data_source_combo" title="Select the data source" class="data_source_combo">
<?php
$sel_end_time = "";
$numcpus = 1;
foreach($data_sources as $data_source)
{
    $temp_ds = $data_source["name"];
    $title = $temp_ds . " \nLast update @ " . $data_source["end_time"];
    if($temp_ds == $ds)
    {
        $sel_end_time = $data_source["end_time"];
        $numcpus = $data_source["numcpus"];
        print "<option value=\"$temp_ds\" title=\"$title\" selected>$temp_ds</option>\n";
    }
    else
        print "<option value=\"$temp_ds\" title=\"$title\">$temp_ds</option>\n";
}
?>
</select>&nbsp;<a href="#noAnchor" id="refresh_data_source" aria-label="Refresh data source">
<span class = "dashboard_images refresh_img pointer_cursor" title="Refresh data sources"> </span>
<span class ="hide">Refresh data Resource"</span>
</a></td></tr>
<tr><td colspan="2" title="Select this to remember duration for which a chart is plotted."><input type="checkbox" id="sticky_time_ckb" <?=(isset($_COOKIE['stst']) && $_COOKIE['stst'] == "stst") ? "checked" : ""?>> Remember time selection for charts</td></tr>
<?php if(!isset($_SESSION['timezone_offset']) || $_SESSION['timezone_offset'] != 0)
{
?>
<tr><td colspan="2" title="Select this to use the time zone settings of NetScaler ADC appliance"><input type="checkbox" id="convert_time_ckb" <?=(isset($_COOKIE['uatz']) && $_COOKIE['uatz'] == "uatz") ? "checked" : ""?>> Use Appliance's time zone</td></tr>
<?php
}
?>
<tr>
    <td align="right" colspan="2" class="padding_top">

    <fieldset style="padding-left: 0px; padding-right: 0px; border: none;">
        <legend style="padding-left: 0px; padding-right: 0px; display: none;">Apply the changes</legend>
        <input type="button" id="btn_ok" class="flat_button" value="OK" title="Click to apply the changes"/>
        <input type="button" id="btn_close" class="flat_button" value="Close" title="Click to close"/>
    </fieldset>

    </td>
</tr>
</table>
</div>

<div id="save_as_report_div" class="popup">
    <table role="presentation">
        <tr>
            <td>
                <b>Save as:</b>
            </td>
            <td align="right">
                <img src="/admin_ui/common/images/navigate_cross.png" id="save_as_report_div_img" alt="Close" title="Close" tabindex="0">
            </td>
        </tr>
        <tr>
            <td>
                Report Name
            </td>
            <td>
                <fieldset style="padding-left: 0px; padding-right: 0px; border: none;">
                    <legend style="padding-left: 0px; padding-right: 0px; display: none;">Enter name of the report</legend>
                    <input type="textfield" id="report_new_name_tf" size="22" maxlength="<?=MAX_NO_OF_CHARS_IN_REPORT_NAME?>" value="" title="Enter name of the report"/>
                </fieldset>
            </td>
        </tr>
        <tr>
            <td>Save in</td>
            <td>
                <fieldset style="padding-left: 0px; padding-right: 0px; border: none;">
                    <legend style="padding-left: 0px; padding-right: 0px; display: none;">Choose folder</legend>     
                    <input type="textfield" id="save_in_tf" size="14" maxlength="<?=MAX_NO_OF_CHARS_IN_REPORT_NAME?>" title="Click to choose folder" value="<?=$current_parent_node?>" readonly/>&nbsp;<img src="/admin_ui/common/images/down.png" alt="Show folders" title="Show folders" class="pointer_cursor" tabindex="0" ><span id="custom_reports_tree_nodes_save_span">&nbsp;</span><img id="custom_reports_tree_nodes_save_img" src="/admin_ui/common/images/folder_add.png" alt="Add folder" title="Add folder" class="pointer_cursor" tabindex="0">
                </fieldset>

                <span id="add_folder_save_span">&nbsp;</span>
            </td>
        </tr>
        <tr>
            <td align="right" colspan="2">

                <fieldset style="padding-left: 0px; padding-right: 0px; border: none;">
                    <legend style="padding-left: 0px; padding-right: 0px; display: none;">Save the report in the specified name</legend>
                    <input type="button" id="btn_save_report" class="flat_button" value="OK" title="Click to save the report in the specified name"/>
                    <input type="button" id="btn_close_popup" class="flat_button" value="Close" title="Click to close"/>
                </fieldset>

            </td>
        </tr>
    </table>
</div>

<div id="create_report_div" class="popup"><table role="presentation"><tr><td><b>Create:</b></td><td align="right">
<img src="/admin_ui/common/images/navigate_cross.png" id="img_hide_report" alt="Close" title="Close" tabindex="0"></td></tr><tr><td>
Report Name</td>
<td>
    <fieldset style="padding-left: 0px; padding-right: 0px; border: none;">
        <legend style="padding-left: 0px; padding-right: 0px; display: none;">Enter name of the report</legend>    
        <input type="textfield" id="report_name_tf" size="22" maxlength="<?=MAX_NO_OF_CHARS_IN_REPORT_NAME?>" value="" title="Enter name of the report"/>
    </fieldset>        
</td>
</tr><tr>
<tr>
    <td>Create in</td>
    <td>
        <fieldset style="padding-left: 0px; padding-right: 0px; border: none;">
            <legend style="padding-left: 0px; padding-right: 0px; display: none;">Choose folder</legend>        
            <input type="textfield" id="create_in_tf" size="14" maxlength="<?=MAX_NO_OF_CHARS_IN_REPORT_NAME?>" title="Click to choose folder" value="<?=$current_parent_node?>" readonly/>&nbsp;
        </fieldset>

        <img src="/admin_ui/common/images/down.png" id="custom_reports_tree_nodes_create_img" alt="Show folders" title="Show folders" class="pointer_cursor" tabindex="0">
        <span id="custom_reports_tree_nodes_create_span">&nbsp;</span>
        <img src="/admin_ui/common/images/folder_add.png" id="add_folder_create_img" alt="Add folder" title="Add folder" class="pointer_cursor" tabindex="0">
        <span id="add_folder_create_span">&nbsp;</span>
    </td>
</tr>
<tr><td align="right" colspan="2">

<fieldset style="padding-left: 0px; padding-right: 0px; border: none;">
    <legend style="padding-left: 0px; padding-right: 0px; display: none;">Create a new report</legend>
    <input type="button" id="btn_create_report" class="flat_button" value="OK"/>
    <input type="button" id="btn_hide_popup" class="flat_button" value="Close"/>
</fieldset>

</td></tr></table></div>


<div id="add_folder_div" class="popup"><table role="presentation"><tr><td><b>Add Folder:</b></td><td align="right">
<img src="/admin_ui/common/images/navigate_cross.png" alt="Close" id="img_hide_add_folder_div" title="Close" tabindex="0"></td></tr><tr><td>
Folder Name</td><td><input type="textfield" id="folder_name_tf" size="18" maxlength="<?=MAX_NO_OF_CHARS_IN_REPORT_NAME?>" value="" title="Enter name of the folder"/></td>
</tr><tr>
<tr>
    <td>Create in</td>
    <td>
        <fieldset style="padding-left: 0px; padding-right: 0px; border: none;">
            <legend style="padding-left: 0px; padding-right: 0px; display: none;">Choose folder</legend>           
            <input type="textfield" id="create_in_folder_tf" size="14" maxlength="<?=MAX_NO_OF_CHARS_IN_REPORT_NAME?>" title="Click to choose folder" value="<?=$current_parent_node?>" readonly/>&nbsp;
        </fieldset>

        <img src="/admin_ui/common/images/down.png" id="img_show_hide_custom_reports_tree_nodes" alt="Show folders" title="Show folders" class="pointer_cursor" tabindex="0">
        <span id="custom_reports_tree_nodes_create_folder_span">&nbsp;</span>
    </td>
</tr>
<tr>
<td align="right" colspan="2">

<fieldset style="padding-left: 0px; padding-right: 0px; border: none;">
    <legend style="padding-left: 0px; padding-right: 0px; display: none;">Create a new folder</legend>
    <input type="button" id="btn_create_newFolder" class="flat_button" value="OK" title="Click to create a new folder"/>
    <input type="button" id="btn_close_newFolder" class="flat_button" value="Close" title="Click to close"/>
</fieldset>

</td></tr></table></div>

<div id="custom_time_div" class="popup"><table role="presentation">
<tr>
    <td colspan="2"><b>Duration:</b></td>
    <td align="right">
        <img src="/admin_ui/common/images/navigate_cross.png" id="hide_custom_time_div" alt="Close" title="Close" tabindex="0">
    </td>
</tr>
<tr>
    <td>
        From time
    </td>
<td>
    <fieldset style="padding-left: 0px; padding-right: 0px; border: none;">
        <legend style="padding-left: 0px; padding-right: 0px; display: none;">Enter time</legend>
        <input type="textfield" id="from_time_tf" size="17" maxlength="16" value="<?=$stime_default_value?>" title="Enter time (mm-dd-yyyy hh:mm)"/>
    </fieldset>
</td>
<td>
<a href="#"><img src="/admin_ui/common/images/calendar.png" id="from_time_img" border="0" alt="Show calendar" title="Show calendar"></a></td></tr><tr>
<script nonce="<?=$nonce?>" language="Javascript">
Calendar.setup({
inputField     :    "from_time_tf",   // id of the input field
ifFormat       :    "%m-%d-%Y %H:%M", // format of the input field
showsTime      :    true,
button         :    "from_time_img",  // trigger for the calendar (button ID)
timeFormat     :    "24",
step           :    1,
align          :    "Bl",             // alignment (defaults to "Bl")
singleClick    :    true
});
Calendar.prototype.isShowPopup = true;
</script>
</td></tr>
<tr>
    <td>To time</td>
    <td>
        <fieldset style="padding-left: 0px; padding-right: 0px; border: none;">
            <legend style="padding-left: 0px; padding-right: 0px; display: none;">Enter time</legend>    
            <input type="textfield" id="to_time_tf" size="17" maxlength="16" value="<?=$etime_default_value?>" title="Enter time (mm-dd-yyyy hh:mm)"/>
        </fieldset>
    </td>
<td>
<a href="#"><img src="/admin_ui/common/images/calendar.png" id="to_time_img" border="0" alt="Show calendar" title="Show calendar"></a></td></tr><tr>
<script nonce="<?=$nonce?>" language="Javascript">
Calendar.setup({
inputField     :    "to_time_tf",     // id of the input field
ifFormat       :    "%m-%d-%Y %H:%M", // format of the input field
showsTime      :    true,
button         :    "to_time_img",    // trigger for the calendar (button ID)
timeFormat     :    "24",
step           :    1,
align          :    "Bl",             // alignment (defaults to "Bl")
singleClick    :    true
});
Calendar.prototype.isShowPopup = true;
</script>
</td></tr>
<tr><td colspan="3"><hr></td></tr>
<tr title="Last update time"><td colspan="3">Last update @ <div id="ds_end_time_cell" class="inline_display"><?=$sel_end_time?></div></td></tr>
<tr><td align="right" colspan="3">

<fieldset style="padding-left: 0px; padding-right: 0px; border: none;">
    <legend style="padding-left: 0px; padding-right: 0px; display: none;">View report for the specified duration</legend>
    <input type="button" id="btn_view_report_for_duration" class="flat_button" value="OK" title="Click to view report for the specified duration"/>
    <input type="button" id="btn_popup_hide" class="flat_button" value="Close" title="Click to close"/>
</fieldset>

</td></tr></table>
</div>

</div>

<div class= "reporting_content_outer">
<div class = "report_options toolbar_cell">

<div id = "now_duration" class = "floated_ellipsed_divs" style = "width: 40%;"> Duration : <div id="now_showing_div" class="inline_display" title="Use the above links to change duration">
<?php
// Reverse functionality of set_unit() in reporting.js
function get_now_showing_text($last, $unit)
{
    if($last == 7 && $unit == DAYS)
    {
        $last = 1;
        $unit = WEEKS;
    }
    else if($last == 12 && $unit == MONTHS)
    {
        $last = 1;
        $unit = YEARS;
    }
    if($last == 1)
        return preg_replace("/s$/", "", $unit);
    return $last . " " . $unit;
}

if($stime_default_value != "" && $etime_default_value != "")
    print $stime_default_value . " to " . $etime_default_value;
else
    print "Last " . get_now_showing_text($last_default_value, $unit_default_value);
print "</div>";
if(!$is_default_data_source)
    print "&nbsp;[Data source: $ds]\n";
?>
</div>

<div id = "top_right_links_div">
<?php
$tabular_view_title = $is_tabular_view ? "Switch to graphical view" : "Switch to tabular view";
$tabular_view_text = $is_tabular_view ? "Graphical View" : "Tabular View";
$tabular_view_class = $is_tabular_view ? "dashboard_images graph_img pointer_cursor" : "dashboard_images table_img pointer_cursor";
?>

<div class = "floated_ellipsed_divs" style = "width: 130px;">
<a href="#noAnchor" id="switch_view_href" title="<?=$tabular_view_title?>">
<div id ="switch_view_div" class = "<?=$tabular_view_class?>"></div><?=$tabular_view_text?> </a>
</div>
    

<?php
if(!$is_default_data_source) ////Ideally, should be for imported data sources alone
{
    $show_events = !(isset($_COOKIE['hideevt']) && $_COOKIE['hideevt'] == "hideevt");
    $show_events_title = $show_events ? "Click to hide events on chart" : "Click to show events on chart";
    $show_events_text = $show_events ? "Hide events" : "Show events";
    $show_events_div_style = $is_tabular_view ? "style=\"width: 100px;display: none;\"" : "style = \"width: 100px;\"";
?>
    <div class = "floated_ellipsed_divs" id="show_events_div" <?=$show_events_div_style?>>
    <a href="#noAnchor" id="show_events_href" title="<?=$show_events_title?>">
    <div id = "show_events_href_img" class = "reporting_images events_img pointer_cursor"> </div> <?=$show_events_text?> </a></div>

<?php
}
?>

 <div class = "floated_ellipsed_divs" style = "width: 74px;">
 <a href="#noAnchor" id="link_print_report" title="Click to print the report">
 <div class = "reporting_images print_img pointer_cursor"> </div>Print </a></div>


<?php
$is_default_group = (isset($_COOKIE['drep']) && $_COOKIE['drep'] == $name);
$default_group_title = $is_default_group ? "Remove as default group" : "Set as default group";
$default_group_class = $is_default_group ? "dashboard_images remove_default pointer_cursor" : "dashboard_images set_default pointer_cursor";
?>
<div class = "floated_ellipsed_divs" style = "width: 130px;">
<a href="#noAnchor" id="set_as_default_href" title="<?=$default_group_title?>">
<div  id = "set_as_default_image" class = "<?=$default_group_class?>"></div>Default Report </a>
</div>


<?php if(!$internal) //Ideally should be for all imported data sources which don't need Refresh
{
?>
    <div class = "floated_ellipsed_divs" style = "width: 80px;">
    <a href="#noAnchor" id="link_refresh_all_elements" title="Click to refresh all report elements">
    <div class = "dashboard_images refresh_img pointer_cursor"> </div>Refresh</a></div>
<?php
}
?>
</div>
<div id="close_print_view_div" style="display: none">
    <a href="#noAnchor" id="see_normal_view" style = "color: #5b5e62" title="Click to see the normal view">Close</a>
</div>


</div>
</div>

<?php
print "<div><table id=\"images_table\" align=\"center\" class=\"full_width_table\" cellspacing=\"0\" role=\"presentation\">";
reporting_utils::print_images($elements, $entities, $errors, $cores, $ds, $numcpus, $last_default_value, $unit_default_value, $stime_default_value, $etime_default_value, $groups, $counters, $internal, $is_tabular_view);
print "</table></div>";
$images_count = count($elements);
print "\n<script nonce='".$nonce."' language=\"Javascript\">";
print "\nvar numcpus = $numcpus;";
print "\nvar img_count = $images_count;";
print "\nvar new_image_index = " . ($images_count + 1) . ";";
print "\nvar chart_metrics = new Array();";
print "\nvar chart_properties = new Array();";
print "\nvar img_types = new Array();";
foreach($elements as $image)
    print "\nimg_types['img_" . $image['id'] . "'] = '" . report_definitions::get_report_element_graph_type($image) . "';";
reporting_customization::print_global_conf();
print "\n</script>";
?>
<script nonce="<?=$nonce?>" type="text/javascript">
// Handle the events from reporting_customizations here
// Customize close button - img
var customize_div_close_icon = document.querySelectorAll('img[id*="_customize_div_close_icon"]');
for (var i = 0; i < customize_div_close_icon.length; i++) {
    var currentId = customize_div_close_icon[i].id;
    customize_div_close_icon[i].addEventListener("click", function() {
        popup_hide(currentId.substring(0, currentId.indexOf("_close_icon")));
    });
    customize_div_close_icon[i].addEventListener("keypress", function() {
        if (event.keyCode == 13) {
            popup_hide(currentId.substring(0, currentId.indexOf("_close_icon")));
            event.preventDefault();
        }
    });
}
// Customize tabs
var customize_tabs = document.querySelectorAll('span[id*="_customize_tab"]');
for (var i = 0; i < customize_tabs.length; i++) {
    let currentId = customize_tabs[i].id;
    let params = currentId.split("_customize_tab_");
    customize_tabs[i].addEventListener("click", function() {
        switch_customize_tab(params[0], params[1]);
    });
    customize_tabs[i].addEventListener("keypress", function() {
        if (event.keyCode == 13) {
            switch_customize_tab(params[0], params[1]);
            event.preventDefault();
        }
    });
}
// Customize -> selection logic from left list - chart
var customize_chart_list = document.querySelectorAll('select[id*="_customize_chart_list"]');
for (var i = 0; i < customize_chart_list.length; i++) {
    let currentId = customize_chart_list[i].id;
    let params = currentId.split("_customize_chart_list");
    customize_chart_list[i].addEventListener("change", function() {
        customize_chart_list_changed(params[0], this.value);
    });
}
// Customize -> plot area tab left options logic
var customize_plot_area_list = document.querySelectorAll('select[id*="_customize_plot_area_list"]');
for (var i = 0; i < customize_plot_area_list.length; i++) {
    let currentId = customize_plot_area_list[i].id;
    let params = currentId.split("_customize_plot_area_list");
    customize_plot_area_list[i].addEventListener("change", function() {
        customize_plot_area_list_changed(params[0], this.value);
    });
}
// Customize -> Data Set -> Select Data Set -> dropdown
var customize_data_set_dropdown = document.querySelectorAll('select[id*="_customize_data_set_list"]');
for (var i = 0; i < customize_data_set_dropdown.length; i++) {
    let currentId = customize_data_set_dropdown[i].id;
    let params = currentId.split("_customize_data_set_list");
    customize_data_set_dropdown[i].addEventListener("change", function() {
        customize_data_set_list_changed(params[0], this);
    });
}
// Customize -> Data Set tab -> Left list ==> after selecting from the dropdown
var customize_data_set_list = document.querySelectorAll('select[class*="_customize_data_set_list_left_panel_"]');
for (var i = 0; i < customize_data_set_list.length; i++) {
    let curClass = customize_data_set_list[i].className;
    let params = curClass.split("_customize_data_set_list_left_panel_");
    customize_data_set_list[i].addEventListener("change", function() {
        customize_data_set_property_list_changed(params[0], params[1],this.value);
    });
}
// Customize -> Apply Globally
var customize_apply_globally_div = document.querySelectorAll('div[id*="_customize_apply_globally_div"]');
for (var i = 0; i < customize_apply_globally_div.length; i++) {
    let fullId = customize_apply_globally_div[i].id;
    let img_id = fullId.split("_customize_apply_globally_div")[0];

    // handle Apply globally
    let firstATag = customize_apply_globally_div[i].getElementsByTagName('a')[0];
    firstATag.addEventListener("click", function() {
        apply_remove_globally(img_id, true);
    });
    firstATag.addEventListener("keypress", function() {
        if (event.keyCode == 13) {
            apply_remove_globally(img_id, true);
            event.preventDefault();
        }
    });
    // handle remove globally
    let secondATag = customize_apply_globally_div[i].getElementsByTagName('a')[1];
    secondATag.addEventListener("click", function() {
        apply_remove_globally(img_id, false);
    });
    secondATag.addEventListener("keypress", function() {
        if (event.keyCode == 13) {
            apply_remove_globally(img_id, false);
            event.preventDefault();
        }
    });
}
// Customize -> Buttons -> [Apply, Ok, Close]
var customize_action_buttons = document.querySelectorAll('input[id*="_customize_action_button_"]');
for (var i = 0; i < customize_action_buttons.length; i++) {
    let fullId = customize_action_buttons[i].id;
    let img_id = fullId.split("_customize_action_button_")[0];
    let action = fullId.split("_customize_action_button_")[1];
    let curButton = customize_action_buttons[i];

    curButton.addEventListener("click", function() {
        if(action === "apply"){
            on_customize_ok_clicked(img_id, false);
        }
        if(action === "ok"){
            on_customize_ok_clicked(img_id, true);
        }
        if(action === "close"){
            popup_hide(img_id+"_customize_div")
        }
    });
    curButton.addEventListener("keypress", function() {
        if (event.keyCode == 13) {
            if(action === "apply"){
                on_customize_ok_clicked(img_id, false);
            }
            if(action === "ok"){
                on_customize_ok_clicked(img_id, true);
            }
            if(action === "close"){
                popup_hide(img_id+"_customize_div")
            }
            event.preventDefault();
        }
    });
}
// Customize -> Background Colour Effects -> [Gradient, Modulation, None]
var customize_bg_color_effect_radio = document.querySelectorAll('input[name*="_customize_bg_color_effect_radio"]');
for (var i = 0; i < customize_bg_color_effect_radio.length; i++) {
    let fullId = customize_bg_color_effect_radio[i].name;
    let img_id = fullId.split("_customize_bg_color_effect_radio")[0];
    let radioItem = customize_bg_color_effect_radio[i];

    radioItem.addEventListener("click", function() {
        bg_color_effect_radio_changed(img_id, this);
    });
    radioItem.addEventListener("keypress", function() {
        if (event.keyCode == 13) {
            bg_color_effect_radio_changed(img_id, this);
            event.preventDefault();
        }
    });
}
// Customize -> Text Colour Effects -> [Gradient, Modulation, None]
var customize_text_font_color_cell = document.querySelectorAll('input[name*="_customize_text_font_color_effect_radio"]');
for (var i = 0; i < customize_text_font_color_cell.length; i++) {
    let radioItem = customize_text_font_color_cell[i];
    let tagName = radioItem.name;
    let img_id = tagName.split("_customize_text_font_color_effect_radio")[0];

    radioItem.addEventListener("click", function() {
        text_font_color_effect_radio_changed(img_id, this);
    });
    radioItem.addEventListener("keypress", function() {
        if (event.keyCode == 13) {
            text_font_color_effect_radio_changed(img_id, this);
            event.preventDefault();
        }
    });
}
// Customize -> Plot Types -> Plots array
var customize_plot_type_table = document.querySelectorAll('table[id*="_plot_type_table"]');
for (var k = 0; k < customize_plot_type_table.length; k++) {
    let img_id = customize_plot_type_table[k].id.split("_plot_type_table")[0];
    let table = document.getElementById(img_id + "_plot_type_table");

    for(var i = 0; i < table.rows.length; i++) {
        for(var j = 0; j < table.rows[i].cells.length; j++){
            let curPlot = table.rows[i].cells[j];
            let curATag = curPlot.getElementsByTagName('a')[0];
            
            curATag.addEventListener("click", function() {
                select_plot_type(img_id, this.parentNode);
            });
            curATag.addEventListener("keypress", function() {
                if (event.keyCode == 13) {
                    select_plot_type(img_id, this.parentNode);
                    event.preventDefault();
                }
            });
        }
    }
}
// Customize -> Left y-axis
var customize_left_y_axis_scale_radio = document.querySelectorAll('input[name*="_customize_left_y_axis_scale_radio"]');
for (var i = 0; i < customize_left_y_axis_scale_radio.length; i++) {
    let radioItem = customize_left_y_axis_scale_radio[i];
    let tagName = radioItem.name;
    let img_id = tagName.split("_customize_left_y_axis_scale_radio")[0];

    radioItem.addEventListener("click", function() {
        left_y_axis_scale_radio_changed(img_id, this);
    });
    radioItem.addEventListener("keypress", function() {
        if (event.keyCode == 13) {
            left_y_axis_scale_radio_changed(img_id, this);
            event.preventDefault();
        }
    });
}
// // Customize -> right y-axis
var customize_right_y_axis_scale_radio = document.querySelectorAll('input[name*="_customize_right_y_axis_scale_radio"]');
for (var i = 0; i < customize_right_y_axis_scale_radio.length; i++) {
    let radioItem = customize_right_y_axis_scale_radio[i];
    let tagName = radioItem.name;
    let img_id = tagName.split("_customize_right_y_axis_scale_radio")[0];

    radioItem.addEventListener("click", function() {
        right_y_axis_scale_radio_changed(img_id, this);
    });
    radioItem.addEventListener("keypress", function() {
        if (event.keyCode == 13) {
            right_y_axis_scale_radio_changed(img_id, this);
            event.preventDefault();
        }
    });
}
// Customize -> Plot -> Background Colour Effects -> [Gradient, Modulation, None]
var customize_plot_edge_color_effect_radio = document.querySelectorAll('input[name*="_customize_plot_edge_color_effect_radio"]');
for (var i = 0; i < customize_plot_edge_color_effect_radio.length; i++) {
    let img_id = customize_plot_edge_color_effect_radio[i].name.split("_customize_plot_edge_color_effect_radio")[0];
    let radioItem = customize_plot_edge_color_effect_radio[i];

    radioItem.addEventListener("click", function() {
        plot_edge_color_effect_radio_changed(img_id, this);
    });
    radioItem.addEventListener("keypress", function() {
        if (event.keyCode == 13) {
            plot_edge_color_effect_radio_changed(img_id, this);
            event.preventDefault();
        }
    });
}
// Customize -> Plot -> H-grid
var customize_h_grid_radio = document.querySelectorAll('input[name*="_customize_h_grid_radio"]');
for (var i = 0; i < customize_h_grid_radio.length; i++) {
    let img_id = customize_h_grid_radio[i].name.split("_customize_h_grid_radio")[0];
    let radioItem = customize_h_grid_radio[i];

    radioItem.addEventListener("click", function() {
        h_grid_radio_changed(img_id, this);
    });
    radioItem.addEventListener("keypress", function() {
        if (event.keyCode == 13) {
            h_grid_radio_changed(img_id, this);
            event.preventDefault();
        }
    });
}
// Customize -> Plot -> H-grid -> Background Colour Effects -> [Gradient, Modulation, None]
var customize_h_grid_color_effect_radio = document.querySelectorAll('input[name*="_customize_h_grid_color_effect_radio"]');
for (var i = 0; i < customize_h_grid_color_effect_radio.length; i++) {
    let img_id = customize_h_grid_color_effect_radio[i].name.split("_customize_h_grid_color_effect_radio")[0];
    let radioItem = customize_h_grid_color_effect_radio[i];

    radioItem.addEventListener("click", function() {
        h_grid_color_effect_radio_changed(img_id, this, true);
    });
    radioItem.addEventListener("keypress", function() {
        if (event.keyCode == 13) {
            h_grid_color_effect_radio_changed(img_id, this, true);
            event.preventDefault();
        }
    });
}
// Customize -> Plot -> V-grid
var customize_v_grid_radio = document.querySelectorAll('input[name*="_customize_v_grid_radio"]');
for (var i = 0; i < customize_v_grid_radio.length; i++) {
    let img_id = customize_v_grid_radio[i].name.split("_customize_v_grid_radio")[0];
    let radioItem = customize_v_grid_radio[i];

    radioItem.addEventListener("click", function() {
        v_grid_radio_changed(img_id, this);
    });
    radioItem.addEventListener("keypress", function() {
        if (event.keyCode == 13) {
            v_grid_radio_changed(img_id, this);
            event.preventDefault();
        }
    });
}
// Customize -> Plot -> V-grid -> Background Colour Effects -> [Gradient, Modulation, None]
var customize_v_grid_color_effect_radio = document.querySelectorAll('input[name*="_customize_v_grid_color_effect_radio"]');
for (var i = 0; i < customize_v_grid_color_effect_radio.length; i++) {
    let img_id = customize_v_grid_color_effect_radio[i].name.split("_customize_v_grid_color_effect_radio")[0];
    let radioItem = customize_v_grid_color_effect_radio[i];

    radioItem.addEventListener("click", function() {
        v_grid_color_effect_radio_changed(img_id, this, true);
    });
    radioItem.addEventListener("keypress", function() {
        if (event.keyCode == 13) {
            v_grid_color_effect_radio_changed(img_id, this, true);
            event.preventDefault();
        }
    });
}
// Customize -> Data Set -> color -> Background Colour Effects -> [Gradient, Modulation, None]
var customize_data_set_color = document.querySelectorAll('input[name*="_customize_data_set_color_"][name*="_effect_radio"]');
for (var i = 0; i < customize_data_set_color.length; i++) {
    let parms = customize_data_set_color[i].name.split("_customize_data_set_color_");
    let img_id = parms[0];
    let dataSetIndex = parms[1].split("_effect_radio")[0];
    let radioItem = customize_data_set_color[i];

    radioItem.addEventListener("click", function() {
        data_set_color_effect_radio_changed(img_id, dataSetIndex, this);
    });
    radioItem.addEventListener("keypress", function() {
        if (event.keyCode == 13) {
            data_set_color_effect_radio_changed(img_id, dataSetIndex, this);
            event.preventDefault();
        }
    });
}
// Customize -> Data  -> Plots array
var customize_data_set_plot_type = document.querySelectorAll('table[id*="_data_set_plot_type_"][id*="_table"]');
for (var k = 0; k < customize_data_set_plot_type.length; k++) {
    let parms = customize_data_set_plot_type[k].id.split("_data_set_plot_type_");
    let img_id = parms[0];
    let dataSetIndex = parms[1].split("_table")[0];
    let table = document.getElementById(img_id + "_data_set_plot_type_" + dataSetIndex + "_table");

    for(var i = 0; i < table.rows.length; i++) {
        for(var j = 0; j < table.rows[i].cells.length; j++){
            let curPlot = table.rows[i].cells[j];
            let curATag = curPlot.getElementsByTagName('a')[0];
            
            curATag.addEventListener("click", function() {
                select_data_set_plot_type(img_id, dataSetIndex, this.parentNode);
            });
            curATag.addEventListener("keypress", function() {
                if (event.keyCode == 13) {
                    select_data_set_plot_type(img_id, dataSetIndex, this.parentNode);
                    event.preventDefault();
                }
            });
        }
    }
}
</script>
<span id="events_on_chart_span" class="events_on_chart_span"></span>
<div id="events_on_chart_div" class="popup events_on_chart_div">
    <table class="full_width_table" role="presentation">
        <tr>
            <td><b>Events:</b></td>
            <td align="right"><img src="/admin_ui/common/images/navigate_cross.png" id="img_popup_hide_div" alt="Close" title="Close" tabindex="0"></td>
        </tr>
    </table>
    <div class="events_text_on_chart_div">
    <table class="full_width_table" role="presentation">
        <tr>
            <td id="events_text_on_chart_cell" nowrap>
            </td>
        </tr>
    </table>
    </div>
</div>
<div id="draw_rect_div" class="draw_rect_div"></div>
<div id="duration_menu_div" class="yui-skin-sam"></div>

</div>

</div>
<!-- Script to replace events from reporting_content -->
<script  nonce="<?=$_SERVER['nonce']?>" type="text/javascript">
    var duration_div = document.querySelector("#duration_div > a");
    if(duration_div){
        duration_div.addEventListener('keypress', function(event){
            if (event.key === 'Enter') {
                event.preventDefault();
                show_duration_menu();
            }
        })
        duration_div.addEventListener('click', function(event){
            show_duration_menu();
        })
    }

    var create_div = document.querySelector("#create_div > a");
    if(create_div){
        create_div.addEventListener('keypress', function(event){
            if (event.key === 'Enter') {
                event.preventDefault();
                popup_show();
            }
        })
        create_div.addEventListener('click', function(event){
            popup_show('create_report_div', 'create_report_span', 0, 19)
        })
    }

    var save_report_div = document.querySelector("#save_report_div > a");
    if(save_report_div){
        save_report_div.addEventListener('keypress', function(event){
            if (event.key === 'Enter') {
                event.preventDefault();
                save_report();
            }
        })
        save_report_div.addEventListener('click', function(event){
            save_report()
        })
    }

    var saveas_div = document.querySelector("#saveas_div > a");
    if(saveas_div){
        saveas_div.addEventListener('keypress', function(event){
            if (event.key === 'Enter') {
                event.preventDefault();
                popup_show('save_as_report_div', 'save_as_report_span', 0, 19)        
            }
        })
        saveas_div.addEventListener('click', function(event){
            popup_show('save_as_report_div', 'save_as_report_span', 0, 19)
        })
    }

    var delete_div = document.querySelector("#delete_div > a");
    if(delete_div){
        delete_div.addEventListener('keypress', function(event){
            if (event.key === 'Enter') {
                event.preventDefault();
                delete_report()        
            }
        })
        delete_div.addEventListener('click', function(event){
            delete_report()
        })
    }

    var scroll_div = document.querySelector("#scroll_div > a");
    if(scroll_div){
        scroll_div.addEventListener('keypress', function(event){
            if (event.key === 'Enter') {
                event.preventDefault();
                set_zoom_state(NORMAL_STATE)        
            }
        })
        scroll_div.addEventListener('click', function(event){
            set_zoom_state(NORMAL_STATE)
        })
    }

    var zoomin_div = document.querySelector("#zoomin_div > a");
    if(zoomin_div){
        zoomin_div.addEventListener('keypress', function(event){
            if (event.key === 'Enter') {
                event.preventDefault();
                set_zoom_state(ZOOM_IN_STATE)        
            }
        })
        zoomin_div.addEventListener('click', function(event){
            set_zoom_state(ZOOM_IN_STATE)
        })
    }

    var zoomout_div = document.querySelector("#zoomout_div > a");
    if(zoomout_div){
        zoomout_div.addEventListener('keypress', function(event){
            if (event.key === 'Enter') {
                event.preventDefault();
                set_zoom_state(ZOOM_OUT_STATE)        
            }
        })
        zoomout_div.addEventListener('click', function(event){
            set_zoom_state(ZOOM_OUT_STATE)
        })
    }

    var reset_div = document.querySelector("#reset_div > a");
    if(reset_div){
        reset_div.addEventListener('keypress', function(event){
            if (event.key === 'Enter') {
                event.preventDefault();
                reset_duration()        
            }
        })
        reset_div.addEventListener('click', function(event){
            reset_duration()
        })
    }

    var right_reporting_toolbar_div = document.querySelector("#right_reporting_toolbar_div > a");
    if(right_reporting_toolbar_div){
        right_reporting_toolbar_div.addEventListener('keypress', function(event){
            if (event.key === 'Enter') {
                event.preventDefault();
                popup_show('settings_div', 'settings_span', 0, 19)        
            }
        })
        right_reporting_toolbar_div.addEventListener('click', function(event){
            popup_show('settings_div', 'settings_span', 0, 19)
        })
    }

    var img_popup_hide = document.getElementById("img_popup_hide");
    if(img_popup_hide){
        img_popup_hide.addEventListener('keypress', function(event){
            if (event.key === 'Enter') {
                event.preventDefault()
                popup_hide('settings_div')        
            }
        })
        img_popup_hide.addEventListener('click', function(event){
            popup_hide('settings_div')
        })
    }

    var refresh_data_source = document.getElementById("refresh_data_source");
    if(refresh_data_source){
        refresh_data_source.addEventListener('keypress', function(event){
            if (event.key === 'Enter') {
                event.preventDefault()
                refresh_data_sources()        
            }
        })
        refresh_data_source.addEventListener('click', function(event){
            refresh_data_sources()        
        })
    }

    var btn_ok = document.getElementById("btn_ok");
    if(btn_ok){
        btn_ok.addEventListener('keypress', function(event){
            if (event.key === 'Enter') {
                event.preventDefault()
                settings_ok_clicked()        
            }
        })
        btn_ok.addEventListener('click', function(event){
            settings_ok_clicked()    
        })
    }

    var btn_close = document.getElementById("btn_close");
    if(btn_close){
        btn_close.addEventListener('keypress', function(event){
            if (event.key === 'Enter') {
                event.preventDefault()
                popup_hide('settings_div')             
            }
        })
        btn_close.addEventListener('click', function(event){
            popup_hide('settings_div')         
        })
    }

    var save_as_report_div_img = document.getElementById("save_as_report_div_img");
    if(save_as_report_div_img){
        save_as_report_div_img.addEventListener('keypress', function(event){
            if (event.key === 'Enter') {
                event.preventDefault()
                popup_hide('save_as_report_div')        
            }
        })
        save_as_report_div_img.addEventListener('click', function(event){
            popup_hide('save_as_report_div')        
        })
    }

    var report_new_name_tf = document.getElementById("report_new_name_tf");//not working  
    if(report_new_name_tf){
        report_new_name_tf.addEventListener('keypress', function(event){
            if (event.key === 'Enter') {
                return key_pressed(event, save_as_report, word_check)        
            }
        })
    }

    var save_in_tf = document.getElementById("save_in_tf");
    if(save_in_tf){
        save_in_tf.addEventListener('keypress', function(event){
            if (event.key === 'Enter') {
                event.preventDefault()
                show_hide_custom_reports_tree_nodes('custom_reports_tree_nodes_save_span')        
            }
        })
        save_in_tf.addEventListener('click', function(event){
            show_hide_custom_reports_tree_nodes('custom_reports_tree_nodes_save_span')    
        })
    }
    
    var custom_reports_tree_nodes_save_img = document.getElementById("custom_reports_tree_nodes_save_img");
    if(custom_reports_tree_nodes_save_img){
        custom_reports_tree_nodes_save_img.addEventListener('keypress', function(event){
            if (event.key === 'Enter') {
                event.preventDefault()
                show_hide_add_node_div('add_folder_save_span')      
            }
        })
        custom_reports_tree_nodes_save_img.addEventListener('click', function(event){
            show_hide_add_node_div('add_folder_save_span')  
        })
    }

    var btn_save_report = document.getElementById("btn_save_report");
    if(btn_save_report){
        btn_save_report.addEventListener('keypress', function(event){
            if (event.key === 'Enter') {
                event.preventDefault()
                save_as_report()     
            }
        })
        btn_save_report.addEventListener('click', function(event){
            save_as_report()        
        })
    }

    var btn_close_popup = document.getElementById("btn_close_popup");
    if(btn_close_popup){
        btn_close_popup.addEventListener('keypress', function(event){
            if (event.key === 'Enter') {
                event.preventDefault()
                popup_hide('save_as_report_div')        
            }
        })
        btn_close_popup.addEventListener('click', function(event){
            popup_hide('save_as_report_div')        
        })
    }

    var img_hide_report = document.getElementById("img_hide_report");
    if(img_hide_report){
        img_hide_report.addEventListener('keypress', function(event){
            if (event.key === 'Enter') {
                event.preventDefault()
                popup_hide('create_report_div')        
            }
        })
        img_hide_report.addEventListener('click', function(event){
            popup_hide('create_report_div')
        })
    }

    var report_name_tf = document.getElementById("report_name_tf");
    if(report_name_tf){
        report_name_tf.addEventListener('keypress', function(event){
            if (event.key === 'Enter') {
                event.preventDefault()
                return key_pressed(event, create_report, word_check)        
            }
        })
    }

    var create_in_tf = document.getElementById("create_in_tf");
    if(create_in_tf){
        create_in_tf.addEventListener('keypress', function(event){
            if (event.key === 'Enter') {
                event.preventDefault()
                show_hide_custom_reports_tree_nodes('custom_reports_tree_nodes_create_span')        
            }
        })
    }

    var custom_reports_tree_nodes_create_img = document.getElementById("custom_reports_tree_nodes_create_img");
    if(custom_reports_tree_nodes_create_img){
        custom_reports_tree_nodes_create_img.addEventListener('keypress', function(event){
            if (event.key === 'Enter') {
                event.preventDefault()
                show_hide_custom_reports_tree_nodes('custom_reports_tree_nodes_create_span')        
            }
        })
        custom_reports_tree_nodes_create_img.addEventListener('click', function(event){
            show_hide_custom_reports_tree_nodes('custom_reports_tree_nodes_create_span')        
        })
    }

    var add_folder_create_img = document.getElementById("add_folder_create_img");
    if(add_folder_create_img){
        add_folder_create_img.addEventListener('keypress', function(event){
            if (event.key === 'Enter') {
                event.preventDefault()
                show_hide_add_node_div('add_folder_create_span')        
            }
        })
        add_folder_create_img.addEventListener('click', function(event){
            show_hide_add_node_div('add_folder_create_span')        
        })
    }

    var btn_create_report = document.getElementById("btn_create_report");
    if(btn_create_report){
        btn_create_report.addEventListener('keypress', function(event){
            if (event.key === 'Enter') {
                event.preventDefault()
                create_report()        
            }
        })
        btn_create_report.addEventListener('click', function(event){
            create_report()        
        })
    }

    var btn_hide_popup = document.getElementById("btn_hide_popup");
    if(btn_hide_popup){
        btn_hide_popup.addEventListener('keypress', function(event){
            if (event.key === 'Enter') {
                event.preventDefault()
                popup_hide('create_report_div')        
            }
        })
        btn_hide_popup.addEventListener('click', function(event){
            popup_hide('create_report_div')        
        })
    }

    var link_print_report = document.getElementById("link_print_report");
    if(link_print_report){
        link_print_report.addEventListener('keypress', function(event){
            if (event.key === 'Enter') {
                event.preventDefault()
                print_page()        
            }
        })
        link_print_report.addEventListener('click', function(event){
            print_page()        
        })
    }

    var set_as_default_href = document.getElementById("set_as_default_href");
    if(set_as_default_href){
        set_as_default_href.addEventListener('keypress', function(event){
            if (event.key === 'Enter') {
                event.preventDefault()
                set_as_default('drep', report_internal_name)        
            }
        })
        set_as_default_href.addEventListener('click', function(event){
            set_as_default('drep', report_internal_name)        
        })    
    }

    var link_refresh_all_elements = document.getElementById("link_refresh_all_elements");
    if(link_refresh_all_elements){
        link_refresh_all_elements.addEventListener('keypress', function(event){
            if (event.key === 'Enter') {
                event.preventDefault()
                refresh_all_images()
            }
        })
        link_refresh_all_elements.addEventListener('click', function(event){
            refresh_all_images()
        })
    }

    var see_normal_view = document.getElementById("see_normal_view");
    if(see_normal_view){
        see_normal_view.addEventListener('keypress', function(event){
            if (event.key === 'Enter') {
                event.preventDefault()
                print_page()
            }
        })
        see_normal_view.addEventListener('click', function(event){
            print_page()
        })
    }

    var img_popup_hide_div = document.getElementById("img_popup_hide_div");
    if(img_popup_hide_div){
        img_popup_hide_div.addEventListener('keypress', function(event){
            if (event.key === 'Enter') {
                event.preventDefault()
                popup_hide('events_on_chart_div')        
            }
        })
        img_popup_hide_div.addEventListener('click', function(event){
            popup_hide('events_on_chart_div')        
        })
    }

    var img_hide_add_folder_div = document.getElementById("img_hide_add_folder_div");
    if(img_hide_add_folder_div){
        img_hide_add_folder_div.addEventListener('keypress', function(event){
            if (event.key === 'Enter') {
                event.preventDefault()
                popup_hide('add_folder_div')        
            }
        })
        img_hide_add_folder_div.addEventListener('click', function(event){
            popup_hide('add_folder_div')        
        })
    }

    var folder_name_tf = document.getElementById("folder_name_tf");
    if(folder_name_tf){
        folder_name_tf.addEventListener('keypress', function(event){
            if (event.key === 'Enter') {
                event.preventDefault()
                return key_pressed(event, create_folder, word_check)        
            }
        })
    }

    var create_in_folder_tf = document.getElementById("create_in_folder_tf");
    if(create_in_folder_tf){
        create_in_folder_tf.addEventListener('keypress', function(event){
            if (event.key === 'Enter') {
                event.preventDefault()
                show_hide_custom_reports_tree_nodes('custom_reports_tree_nodes_create_folder_span')        
            }
        })
        create_in_folder_tf.addEventListener('click', function(event){
            show_hide_custom_reports_tree_nodes('custom_reports_tree_nodes_create_folder_span')        
        })
    }

    var img_show_hide_custom_reports_tree_nodes = document.getElementById("img_show_hide_custom_reports_tree_nodes");
    if(img_show_hide_custom_reports_tree_nodes){
        img_show_hide_custom_reports_tree_nodes.addEventListener('keypress', function(event){
            if (event.key === 'Enter') {
                event.preventDefault()
                show_hide_custom_reports_tree_nodes('custom_reports_tree_nodes_create_folder_span')        
            }
        })
        img_show_hide_custom_reports_tree_nodes.addEventListener('click', function(event){
            show_hide_custom_reports_tree_nodes('custom_reports_tree_nodes_create_folder_span')        
        })
    }

    var btn_create_newFolder = document.getElementById("btn_create_newFolder");
    if(btn_create_newFolder){
        btn_create_newFolder.addEventListener('keypress', function(event){
            if (event.key === 'Enter') {
                event.preventDefault()
                create_folder()        
            }
        })
        btn_create_newFolder.addEventListener('click', function(event){
            create_folder()        
        })
    }

    var btn_close_newFolder = document.getElementById("btn_close_newFolder");
    if(btn_close_newFolder){
        btn_close_newFolder.addEventListener('keypress', function(event){
            if (event.key === 'Enter') {
                event.preventDefault()
                popup_hide('add_folder_div')        
            }
        })
        btn_close_newFolder.addEventListener('click', function(event){
            popup_hide('add_folder_div')        
        })
    }

    var hide_custom_time_div = document.getElementById("hide_custom_time_div");
    if(hide_custom_time_div){
        hide_custom_time_div.addEventListener('keypress', function(event){
            if (event.key === 'Enter') {
                event.preventDefault()
                popup_hide('custom_time_div')        
            }
        })
        hide_custom_time_div.addEventListener('click', function(event){
            popup_hide('custom_time_div')        
        })
    }

    var from_time_tf = document.getElementById("from_time_tf");
    if(from_time_tf){
        from_time_tf.addEventListener('keypress', function(event){
            if (event.key === 'Enter') {
                event.preventDefault()
                return key_pressed(event, custom_time_ok_clicked)        
            }
        })
    }

    var to_time_tf = document.getElementById("to_time_tf");
    if(to_time_tf){
        to_time_tf.addEventListener('keypress', function(event){
            if (event.key === 'Enter') {
                event.preventDefault()
                return key_pressed(event, custom_time_ok_clicked)        
            }
        })
    }

    var btn_view_report_for_duration = document.getElementById("btn_view_report_for_duration");
    if(btn_view_report_for_duration){
        btn_view_report_for_duration.addEventListener('keypress', function(event){
            if (event.key === 'Enter') {
                event.preventDefault()
                custom_time_ok_clicked()        
            }
        })
        btn_view_report_for_duration.addEventListener('click', function(event){
            custom_time_ok_clicked()        
        })
    }

    var btn_popup_hide = document.getElementById("btn_popup_hide");
    if(btn_popup_hide){
        btn_popup_hide.addEventListener('keypress', function(event){
            if (event.key === 'Enter') {
                event.preventDefault()
                popup_hide('custom_time_div')        
            }
        })
        btn_popup_hide.addEventListener('click', function(event){
            popup_hide('custom_time_div')        
        })
    }

    var switch_view_href = document.getElementById("switch_view_href");
    if(switch_view_href){
        switch_view_href.addEventListener('keypress', function(event){
            if (event.key === 'Enter') {
                event.preventDefault()
                switch_view('trep', 'trep')        
            }
        })
        switch_view_href.addEventListener('click', function(event){
            switch_view('trep', 'trep')        
        })
    }

    var show_events_href = document.getElementById("show_events_href");
    if(show_events_href){
        show_events_href.addEventListener('keypress', function(event){
            if (event.key === 'Enter') {
                event.preventDefault()
                show_hide_events()        
            }
        })
        show_events_href.addEventListener('click', function(event){
            show_hide_events()        
        })
    }
</script>

<!-- Script to replace events from view-utils -->
<script  nonce="<?=$_SERVER['nonce']?>" type="text/javascript">    
    var txt_size_zoom_in = document.getElementById("txt_size_zoom_in");
    if(txt_size_zoom_in){
        txt_size_zoom_in.addEventListener('keypress', function(event){
            if (event.key === 'Enter') {
                event.preventDefault()
                hide_counter_tooltip()
            }
        })
        txt_size_zoom_in.addEventListener('click', function(event){
            hide_counter_tooltip()
        })
    }
</script>
