import json
import os
import sys

# File paths
global_conf_old = '/opt/Citrix/NSGClient/globalConfiguration.json.old'
global_conf = '/opt/Citrix/NSGClient/globalConfiguration.json'

# Load JSON data from new_global_conf_fh
try:
    with open(global_conf, 'r') as new_global_conf_fh:
        new_global_conf_fh_data = json.load(new_global_conf_fh)
        print(f"Loaded new global conf file")

except Exception as e:
    print(f"An error occurred in reading new global conf file: {e}")
    print(f"Continuing with installation")
    sys.exit(1)

# Try to load JSON data from old_global_conf_fh and update new_global_conf_fh_data
if os.path.exists(global_conf_old):
    try:
        with open(global_conf_old, 'r') as old_global_conf_fh:
            old_global_conf_fh_data = json.load(old_global_conf_fh)
            print(f"Loaded old global conf file")

    except Exception as e:
        print(f"An error occurred in reading old global conf file: {e}")
        print(f"Continuing with installation")
        sys.exit(1)
    
    # Update new_global_conf_fh_data with modified key-value pairs from old_global_conf_fh_data
    for key, value in old_global_conf_fh_data.items():
        if key in new_global_conf_fh_data and new_global_conf_fh_data[key] != value:
            new_global_conf_fh_data[key] = value
else:
    print(f"{global_conf_old} not found. Proceeding without updates.")

# Save the data back to new_global_conf_fh
with open(global_conf, 'w') as new_global_conf_fh:
    json.dump(new_global_conf_fh_data, new_global_conf_fh, indent=4)
